/* data-sink.c generated by valac 0.48.13, the Vala compiler
 * generated from data-sink.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#define SYNAPSE_TYPE_SEARCH_PROVIDER (synapse_search_provider_get_type ())
#define SYNAPSE_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProvider))
#define SYNAPSE_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER))
#define SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProviderIface))

typedef struct _SynapseSearchProvider SynapseSearchProvider;
typedef struct _SynapseSearchProviderIface SynapseSearchProviderIface;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT,
	SYNAPSE_MATCH_TYPE_INTERNET
} SynapseMatchType;

#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())
typedef void (*SynapsePluginRegisterFunc) (void);

#define SYNAPSE_TYPE_DATA_SINK (synapse_data_sink_get_type ())
#define SYNAPSE_DATA_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DATA_SINK, SynapseDataSink))
#define SYNAPSE_DATA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DATA_SINK, SynapseDataSinkClass))
#define SYNAPSE_IS_DATA_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DATA_SINK))
#define SYNAPSE_IS_DATA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DATA_SINK))
#define SYNAPSE_DATA_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DATA_SINK, SynapseDataSinkClass))

typedef struct _SynapseDataSink SynapseDataSink;
typedef struct _SynapseDataSinkClass SynapseDataSinkClass;
typedef struct _SynapseDataSinkPrivate SynapseDataSinkPrivate;

#define SYNAPSE_TYPE_CONFIG_OBJECT (synapse_config_object_get_type ())
#define SYNAPSE_CONFIG_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObject))
#define SYNAPSE_CONFIG_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObjectClass))
#define SYNAPSE_IS_CONFIG_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONFIG_OBJECT))
#define SYNAPSE_IS_CONFIG_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CONFIG_OBJECT))
#define SYNAPSE_CONFIG_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObjectClass))

typedef struct _SynapseConfigObject SynapseConfigObject;
typedef struct _SynapseConfigObjectClass SynapseConfigObjectClass;

#define SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION (synapse_data_sink_data_sink_configuration_get_type ())
#define SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration))
#define SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfigurationClass))
#define SYNAPSE_DATA_SINK_IS_DATA_SINK_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION))
#define SYNAPSE_DATA_SINK_IS_DATA_SINK_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION))
#define SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfigurationClass))

typedef struct _SynapseDataSinkDataSinkConfiguration SynapseDataSinkDataSinkConfiguration;
typedef struct _SynapseDataSinkDataSinkConfigurationClass SynapseDataSinkDataSinkConfigurationClass;

#define SYNAPSE_TYPE_ITEM_PROVIDER (synapse_item_provider_get_type ())
#define SYNAPSE_ITEM_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ITEM_PROVIDER, SynapseItemProvider))
#define SYNAPSE_IS_ITEM_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ITEM_PROVIDER))
#define SYNAPSE_ITEM_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ITEM_PROVIDER, SynapseItemProviderIface))

typedef struct _SynapseItemProvider SynapseItemProvider;
typedef struct _SynapseItemProviderIface SynapseItemProviderIface;

#define SYNAPSE_TYPE_ACTIVATABLE (synapse_activatable_get_type ())
#define SYNAPSE_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable))
#define SYNAPSE_IS_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTIVATABLE))
#define SYNAPSE_ACTIVATABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatableIface))

typedef struct _SynapseActivatable SynapseActivatable;
typedef struct _SynapseActivatableIface SynapseActivatableIface;

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())
typedef struct _SynapseQuery SynapseQuery;

#define SYNAPSE_TYPE_ACTION_PROVIDER (synapse_action_provider_get_type ())
#define SYNAPSE_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProvider))
#define SYNAPSE_IS_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER))
#define SYNAPSE_ACTION_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProviderIface))

typedef struct _SynapseActionProvider SynapseActionProvider;
typedef struct _SynapseActionProviderIface SynapseActionProviderIface;

#define SYNAPSE_TYPE_DBUS_SERVICE (synapse_dbus_service_get_type ())
#define SYNAPSE_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DBUS_SERVICE, SynapseDBusService))
#define SYNAPSE_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DBUS_SERVICE, SynapseDBusServiceClass))
#define SYNAPSE_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DBUS_SERVICE))
#define SYNAPSE_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DBUS_SERVICE))
#define SYNAPSE_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DBUS_SERVICE, SynapseDBusServiceClass))

typedef struct _SynapseDBusService SynapseDBusService;
typedef struct _SynapseDBusServiceClass SynapseDBusServiceClass;

#define SYNAPSE_TYPE_DESKTOP_FILE_SERVICE (synapse_desktop_file_service_get_type ())
#define SYNAPSE_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService))
#define SYNAPSE_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_DESKTOP_FILE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))

typedef struct _SynapseDesktopFileService SynapseDesktopFileService;
typedef struct _SynapseDesktopFileServiceClass SynapseDesktopFileServiceClass;

#define SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY (synapse_data_sink_plugin_registry_get_type ())
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistry))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistryClass))
#define SYNAPSE_DATA_SINK_IS_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_DATA_SINK_IS_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistryClass))

typedef struct _SynapseDataSinkPluginRegistry SynapseDataSinkPluginRegistry;
typedef struct _SynapseDataSinkPluginRegistryClass SynapseDataSinkPluginRegistryClass;

#define SYNAPSE_TYPE_RELEVANCY_SERVICE (synapse_relevancy_service_get_type ())
#define SYNAPSE_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyService))
#define SYNAPSE_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))
#define SYNAPSE_IS_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_IS_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_RELEVANCY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))

typedef struct _SynapseRelevancyService SynapseRelevancyService;
typedef struct _SynapseRelevancyServiceClass SynapseRelevancyServiceClass;

#define SYNAPSE_TYPE_VOLUME_SERVICE (synapse_volume_service_get_type ())
#define SYNAPSE_VOLUME_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeService))
#define SYNAPSE_VOLUME_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeServiceClass))
#define SYNAPSE_IS_VOLUME_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_VOLUME_SERVICE))
#define SYNAPSE_IS_VOLUME_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_VOLUME_SERVICE))
#define SYNAPSE_VOLUME_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeServiceClass))

typedef struct _SynapseVolumeService SynapseVolumeService;
typedef struct _SynapseVolumeServiceClass SynapseVolumeServiceClass;
enum  {
	SYNAPSE_DATA_SINK_0_PROPERTY,
	SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY,
	SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY,
	SYNAPSE_DATA_SINK_NUM_PROPERTIES
};
static GParamSpec* synapse_data_sink_properties[SYNAPSE_DATA_SINK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _SynapseDataSinkInitializeCachesData SynapseDataSinkInitializeCachesData;

#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO (synapse_data_sink_plugin_registry_plugin_info_get_type ())
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_PLUGIN_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO, SynapseDataSinkPluginRegistryPluginInfo))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_PLUGIN_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO, SynapseDataSinkPluginRegistryPluginInfoClass))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_IS_PLUGIN_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_IS_PLUGIN_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_PLUGIN_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO, SynapseDataSinkPluginRegistryPluginInfoClass))

typedef struct _SynapseDataSinkPluginRegistryPluginInfo SynapseDataSinkPluginRegistryPluginInfo;
typedef struct _SynapseDataSinkPluginRegistryPluginInfoClass SynapseDataSinkPluginRegistryPluginInfoClass;
typedef struct _SynapseDataSinkPluginRegistryPluginInfoPrivate SynapseDataSinkPluginRegistryPluginInfoPrivate;
#define _synapse_data_sink_plugin_registry_plugin_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_data_sink_plugin_registry_plugin_info_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))

#define SYNAPSE_TYPE_CONFIG_SERVICE (synapse_config_service_get_type ())
#define SYNAPSE_CONFIG_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigService))
#define SYNAPSE_CONFIG_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigServiceClass))
#define SYNAPSE_IS_CONFIG_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONFIG_SERVICE))
#define SYNAPSE_IS_CONFIG_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CONFIG_SERVICE))
#define SYNAPSE_CONFIG_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigServiceClass))

typedef struct _SynapseConfigService SynapseConfigService;
typedef struct _SynapseConfigServiceClass SynapseConfigServiceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_TYPE_DEFAULT_MATCH (synapse_default_match_get_type ())
#define SYNAPSE_DEFAULT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatch))
#define SYNAPSE_DEFAULT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatchClass))
#define SYNAPSE_IS_DEFAULT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DEFAULT_MATCH))
#define SYNAPSE_IS_DEFAULT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DEFAULT_MATCH))
#define SYNAPSE_DEFAULT_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatchClass))

typedef struct _SynapseDefaultMatch SynapseDefaultMatch;
typedef struct _SynapseDefaultMatchClass SynapseDefaultMatchClass;
typedef struct _SynapseDataSinkSearchData SynapseDataSinkSearchData;
typedef struct _SynapseDataSinkPluginRegistryPrivate SynapseDataSinkPluginRegistryPrivate;
enum  {
	SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_0_PROPERTY,
	SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_NUM_PROPERTIES
};
static GParamSpec* synapse_data_sink_plugin_registry_properties[SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_NUM_PROPERTIES];
typedef struct _SynapseDataSinkPluginRegistryParamSpecPluginInfo SynapseDataSinkPluginRegistryParamSpecPluginInfo;
typedef struct _SynapseConfigObjectPrivate SynapseConfigObjectPrivate;
typedef struct _SynapseDataSinkDataSinkConfigurationPrivate SynapseDataSinkDataSinkConfigurationPrivate;
enum  {
	SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_0_PROPERTY,
	SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY,
	SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_NUM_PROPERTIES
};
static GParamSpec* synapse_data_sink_data_sink_configuration_properties[SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_NUM_PROPERTIES];

#define SYNAPSE_TYPE_COMMON_ACTIONS (synapse_common_actions_get_type ())
#define SYNAPSE_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions))
#define SYNAPSE_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))
#define SYNAPSE_IS_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_IS_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_COMMON_ACTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))

typedef struct _SynapseCommonActions SynapseCommonActions;
typedef struct _SynapseCommonActionsClass SynapseCommonActionsClass;
enum  {
	SYNAPSE_DATA_SINK_PLUGIN_REGISTERED_SIGNAL,
	SYNAPSE_DATA_SINK_SEARCH_DONE_SIGNAL,
	SYNAPSE_DATA_SINK_NUM_SIGNALS
};
static guint synapse_data_sink_signals[SYNAPSE_DATA_SINK_NUM_SIGNALS] = {0};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseSearchProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseSearchProvider* self, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (SynapseSearchProvider* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseDataSink {
	GObject parent_instance;
	SynapseDataSinkPrivate * priv;
};

struct _SynapseDataSinkClass {
	GObjectClass parent_class;
};

struct _SynapseActivatableIface {
	GTypeInterface parent_iface;
	void (*activate) (SynapseActivatable* self);
	void (*deactivate) (SynapseActivatable* self);
	gboolean (*get_enabled) (SynapseActivatable* self);
	void (*set_enabled) (SynapseActivatable* self, gboolean value);
};

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

struct _SynapseItemProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseItemProvider* self, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	SynapseResultSet* (*search_finish) (SynapseItemProvider* self, GAsyncResult* _res_, GError** error);
	gboolean (*handles_query) (SynapseItemProvider* self, SynapseQuery* query);
	gboolean (*handles_empty_query) (SynapseItemProvider* self);
};

struct _SynapseActionProviderIface {
	GTypeInterface parent_iface;
	SynapseResultSet* (*find_for_match) (SynapseActionProvider* self, SynapseQuery* query, SynapseMatch* match);
	gboolean (*handles_unknown) (SynapseActionProvider* self);
};

struct _SynapseDataSinkPrivate {
	SynapseDataSinkDataSinkConfiguration* config;
	GeeSet* item_plugins;
	GeeSet* action_plugins;
	guint query_id;
	SynapseDBusService* dbus_name_cache;
	SynapseDesktopFileService* desktop_file_service;
	SynapseDataSinkPluginRegistry* registry;
	SynapseRelevancyService* relevancy_service;
	SynapseVolumeService* volume_service;
	GType* plugin_types;
	gint plugin_types_length1;
	gint _plugin_types_size_;
	gboolean _has_empty_handlers;
	gboolean _has_unknown_handlers;
	gboolean plugins_loaded;
};

struct _Block2Data {
	int _ref_count_;
	SynapseDataSink* self;
	gint initialized_components;
	gint NUM_COMPONENTS;
	gpointer _async_data_;
};

struct _SynapseDataSinkInitializeCachesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDataSink* self;
	Block2Data* _data2_;
	SynapseDBusService* _tmp0_;
	SynapseDBusService* _tmp1_;
	SynapseDesktopFileService* _tmp2_;
	SynapseDesktopFileService* _tmp3_;
	SynapseDesktopFileService* _tmp4_;
};

struct _SynapseDataSinkPluginRegistryPluginInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseDataSinkPluginRegistryPluginInfoPrivate * priv;
	GType plugin_type;
	gchar* title;
	gchar* description;
	gchar* icon_name;
	SynapsePluginRegisterFunc register_func;
	gboolean runnable;
	gchar* runnable_error;
};

struct _SynapseDataSinkPluginRegistryPluginInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseDataSinkPluginRegistryPluginInfo *self);
};

struct _Block3Data {
	int _ref_count_;
	SynapseDataSink* self;
	SynapseQuery q;
	GList* cancellables;
	SynapseResultSet* current_result_set;
	gint search_size;
	gboolean waiting;
	gpointer _async_data_;
};

struct _SynapseDataSinkSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDataSink* self;
	gchar* query;
	SynapseQueryFlags flags;
	SynapseResultSet* dest_result_set;
	GCancellable* cancellable;
	GeeList* result;
	Block3Data* _data3_;
	gboolean _tmp0_;
	GError* _tmp1_;
	guint _tmp2_;
	const gchar* _tmp3_;
	SynapseQueryFlags _tmp4_;
	gchar* query_stripped;
	gchar* _tmp5_;
	SynapseResultSet* _tmp6_;
	SynapseResultSet* _tmp7_;
	SynapseResultSet* _tmp8_;
	SynapseResultSet* _tmp9_;
	GeeSet* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeIterator* _data_plugin_it;
	GeeSet* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	SynapseItemProvider* data_plugin;
	GeeIterator* _tmp16_;
	gpointer _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	SynapseItemProvider* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	SynapseItemProvider* _tmp24_;
	SynapseItemProvider* _tmp25_;
	SynapseQuery _tmp26_;
	gboolean skip;
	gint _tmp27_;
	GCancellable* c;
	GCancellable* _tmp28_;
	GCancellable* _tmp29_;
	GCancellable* _tmp30_;
	GCancellable* _tmp31_;
	GCancellable* _tmp32_;
	SynapseItemProvider* _tmp33_;
	SynapseQuery _tmp34_;
	gboolean _tmp35_;
	GError* _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	const gchar* _tmp39_;
	SynapseDefaultMatch* unknown_match;
	SynapseDefaultMatch* _tmp40_;
	gboolean add_to_rs;
	gboolean _tmp41_;
	GeeList* unknown_match_actions;
	SynapseDefaultMatch* _tmp42_;
	GeeList* _tmp43_;
	GeeList* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	SynapseResultSet* _tmp47_;
	SynapseDefaultMatch* _tmp48_;
	SynapseResultSet* _tmp49_;
	GeeList* _tmp50_;
	GError* _inner_error0_;
};

struct _SynapseDataSinkPluginRegistry {
	GObject parent_instance;
	SynapseDataSinkPluginRegistryPrivate * priv;
};

struct _SynapseDataSinkPluginRegistryClass {
	GObjectClass parent_class;
};

struct _SynapseDataSinkPluginRegistryPrivate {
	GeeList* plugins;
};

struct _SynapseDataSinkPluginRegistryParamSpecPluginInfo {
	GParamSpec parent_instance;
};

struct _SynapseConfigObject {
	GObject parent_instance;
	SynapseConfigObjectPrivate * priv;
};

struct _SynapseConfigObjectClass {
	GObjectClass parent_class;
};

struct _SynapseDataSinkDataSinkConfiguration {
	SynapseConfigObject parent_instance;
	SynapseDataSinkDataSinkConfigurationPrivate * priv;
};

struct _SynapseDataSinkDataSinkConfigurationClass {
	SynapseConfigObjectClass parent_class;
};

struct _SynapseDataSinkDataSinkConfigurationPrivate {
	gchar** _disabled_plugins;
	gint _disabled_plugins_length1;
	gint __disabled_plugins_size_;
};

static gint SynapseDataSink_private_offset;
static gpointer synapse_data_sink_parent_class = NULL;
static gint SynapseDataSinkPluginRegistry_private_offset;
static gpointer synapse_data_sink_plugin_registry_parent_class = NULL;
extern SynapseDataSinkPluginRegistry* synapse_data_sink_plugin_registry_instance;
SynapseDataSinkPluginRegistry* synapse_data_sink_plugin_registry_instance = NULL;
static gpointer synapse_data_sink_plugin_registry_plugin_info_parent_class = NULL;
static gint SynapseDataSinkDataSinkConfiguration_private_offset;
static gpointer synapse_data_sink_data_sink_configuration_parent_class = NULL;
static SynapseSearchProviderIface * synapse_data_sink_synapse_search_provider_parent_iface = NULL;

GQuark synapse_search_error_quark (void);
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_result_set_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseResultSet, g_object_unref)
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_search_provider_get_type (void) G_GNUC_CONST;
void synapse_search_provider_search (SynapseSearchProvider* self,
                                     const gchar* query,
                                     SynapseQueryFlags flags,
                                     SynapseResultSet* dest_result_set,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
GeeList* synapse_search_provider_search_finish (SynapseSearchProvider* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static GType synapse_search_provider_get_type_once (void);
GType synapse_data_sink_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDataSink, g_object_unref)
GType synapse_config_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseConfigObject, g_object_unref)
static GType synapse_data_sink_data_sink_configuration_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDataSinkDataSinkConfiguration, g_object_unref)
GType synapse_activatable_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self,
                         SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
GType synapse_item_provider_get_type (void) G_GNUC_CONST;
GType synapse_action_provider_get_type (void) G_GNUC_CONST;
GType synapse_dbus_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDBusService, g_object_unref)
GType synapse_desktop_file_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFileService, g_object_unref)
GType synapse_data_sink_plugin_registry_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDataSinkPluginRegistry, g_object_unref)
GType synapse_relevancy_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseRelevancyService, g_object_unref)
GType synapse_volume_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseVolumeService, g_object_unref)
void synapse_utils_logger_debug (GObject* obj,
                                 const gchar* format,
                                 ...);
SynapseDataSink* synapse_data_sink_new (void);
SynapseDataSink* synapse_data_sink_construct (GType object_type);
static void synapse_data_sink_initialize_caches_data_free (gpointer _data);
static void synapse_data_sink_initialize_caches (SynapseDataSink* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void synapse_data_sink_initialize_caches_finish (SynapseDataSink* self,
                                                 GAsyncResult* _res_);
static gboolean synapse_data_sink_initialize_caches_co (SynapseDataSinkInitializeCachesData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _synapse_data_sink_initialize_caches_co_gsource_func (gpointer self);
SynapseDBusService* synapse_dbus_service_get_default (void);
void synapse_dbus_service_initialize (SynapseDBusService* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
void synapse_dbus_service_initialize_finish (SynapseDBusService* self,
                                             GAsyncResult* _res_);
static void __lambda11_ (Block2Data* _data2_);
static void ___lambda11__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
SynapseDesktopFileService* synapse_desktop_file_service_get_default (void);
static void synapse_data_sink_check_plugins (SynapseDataSink* self);
static void _synapse_data_sink_check_plugins_synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                                gpointer self);
void synapse_desktop_file_service_initialize (SynapseDesktopFileService* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
void synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self,
                                                     GAsyncResult* _res_);
static void __lambda12_ (Block2Data* _data2_);
static void ___lambda12__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean __lambda13_ (SynapseDataSink* self);
static void synapse_data_sink_load_plugins (SynapseDataSink* self);
static gboolean ___lambda13__gsource_func (gpointer self);
gpointer synapse_data_sink_plugin_registry_plugin_info_ref (gpointer instance);
void synapse_data_sink_plugin_registry_plugin_info_unref (gpointer instance);
GParamSpec* synapse_data_sink_plugin_registry_param_spec_plugin_info (const gchar* name,
                                                                      const gchar* nick,
                                                                      const gchar* blurb,
                                                                      GType object_type,
                                                                      GParamFlags flags);
void synapse_data_sink_plugin_registry_value_set_plugin_info (GValue* value,
                                                              gpointer v_object);
void synapse_data_sink_plugin_registry_value_take_plugin_info (GValue* value,
                                                               gpointer v_object);
gpointer synapse_data_sink_plugin_registry_value_get_plugin_info (const GValue* value);
GType synapse_data_sink_plugin_registry_plugin_info_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDataSinkPluginRegistryPluginInfo, synapse_data_sink_plugin_registry_plugin_info_unref)
GeeList* synapse_data_sink_plugin_registry_get_plugins (SynapseDataSinkPluginRegistry* self);
static void _vala_array_add1 (SynapsePluginRegisterFunc* * array,
                       gint* length,
                       gint* size,
                       SynapsePluginRegisterFunc value);
void synapse_data_sink_register_plugin (SynapseDataSink* self,
                                        GObject* plugin);
gboolean synapse_data_sink_get_has_unknown_handlers (SynapseDataSink* self);
gboolean synapse_action_provider_handles_unknown (SynapseActionProvider* self);
void synapse_data_sink_set_has_unknown_handlers (SynapseDataSink* self,
                                                 gboolean value);
gboolean synapse_data_sink_get_has_empty_handlers (SynapseDataSink* self);
gboolean synapse_item_provider_handles_empty_query (SynapseItemProvider* self);
void synapse_data_sink_set_has_empty_handlers (SynapseDataSink* self,
                                               gboolean value);
static void synapse_data_sink_update_has_unknown_handlers (SynapseDataSink* self);
gboolean synapse_activatable_get_enabled (SynapseActivatable* self);
static void synapse_data_sink_update_has_empty_handlers (SynapseDataSink* self);
static GObject* synapse_data_sink_create_plugin (SynapseDataSink* self,
                                          GType t);
SynapseDataSinkPluginRegistryPluginInfo* synapse_data_sink_plugin_registry_get_plugin_info_for_type (SynapseDataSinkPluginRegistry* self,
                                                                                                     GType plugin_type);
static gboolean synapse_data_sink_data_sink_configuration_is_plugin_enabled (SynapseDataSinkDataSinkConfiguration* self,
                                                                      GType t);
void synapse_activatable_activate (SynapseActivatable* self);
void synapse_data_sink_register_static_plugin (SynapseDataSink* self,
                                               GType plugin_type);
static gboolean _vala_g_type_array_contains (GType * stack,
                                      gint stack_length,
                                      const GType needle);
static void _vala_array_add2 (GType* * array,
                       gint* length,
                       gint* size,
                       GType value);
GObject* synapse_data_sink_get_plugin (SynapseDataSink* self,
                                       const gchar* name);
gboolean synapse_data_sink_is_plugin_enabled (SynapseDataSink* self,
                                              GType plugin_type);
void synapse_data_sink_set_plugin_enabled (SynapseDataSink* self,
                                           GType plugin_type,
                                           gboolean enabled);
static void synapse_data_sink_data_sink_configuration_set_plugin_enabled (SynapseDataSinkDataSinkConfiguration* self,
                                                                   GType t,
                                                                   gboolean enabled);
GType synapse_config_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseConfigService, g_object_unref)
SynapseConfigService* synapse_config_service_get_default (void);
void synapse_config_service_set_config (SynapseConfigService* self,
                                        const gchar* group,
                                        const gchar* key,
                                        SynapseConfigObject* cfg_obj);
void synapse_activatable_set_enabled (SynapseActivatable* self,
                                      gboolean value);
void synapse_activatable_deactivate (SynapseActivatable* self);
static void synapse_data_sink_real_search_data_free (gpointer _data);
static void synapse_data_sink_real_search (SynapseSearchProvider* base,
                                    const gchar* query,
                                    SynapseQueryFlags flags,
                                    SynapseResultSet* dest_result_set,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static gboolean synapse_data_sink_real_search_co (SynapseDataSinkSearchData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void block3_data_unref (void * _userdata_);
static gboolean _synapse_data_sink_real_search_co_gsource_func (gpointer self);
void synapse_query_init (SynapseQuery *self,
                         guint query_id,
                         const gchar* query,
                         SynapseQueryFlags flags,
                         guint num_results);
SynapseResultSet* synapse_result_set_new (void);
SynapseResultSet* synapse_result_set_construct (GType object_type);
gboolean synapse_item_provider_handles_query (SynapseItemProvider* self,
                                              SynapseQuery* query);
void synapse_item_provider_search (SynapseItemProvider* self,
                                   SynapseQuery* query,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
SynapseResultSet* synapse_item_provider_search_finish (SynapseItemProvider* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void ____lambda14_ (Block3Data* _data3_,
                    GObject* src_obj,
                    GAsyncResult* res);
void synapse_result_set_add_all (SynapseResultSet* self,
                                 SynapseResultSet* rs);
static void _____lambda14__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void ___lambda15_ (Block3Data* _data3_);
static void ____lambda15__gfunc (gconstpointer data,
                          gpointer self);
GType synapse_default_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDefaultMatch, g_object_unref)
SynapseDefaultMatch* synapse_default_match_new (const gchar* query_string);
SynapseDefaultMatch* synapse_default_match_construct (GType object_type,
                                                      const gchar* query_string);
GeeList* synapse_data_sink_find_actions_for_unknown_match (SynapseDataSink* self,
                                                           SynapseMatch* match,
                                                           SynapseQueryFlags flags);
void synapse_result_set_add (SynapseResultSet* self,
                             SynapseMatch* match,
                             gint relevancy);
GeeList* synapse_result_set_get_sorted_list (SynapseResultSet* self);
SynapseResultSet* synapse_action_provider_find_for_match (SynapseActionProvider* self,
                                                          SynapseQuery* query,
                                                          SynapseMatch* match);
GeeList* synapse_data_sink_find_actions_for_match (SynapseDataSink* self,
                                                   SynapseMatch* match,
                                                   const gchar* query,
                                                   SynapseQueryFlags flags);
static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
SynapseDataSinkPluginRegistry* synapse_data_sink_plugin_registry_get_default (void);
SynapseDataSinkPluginRegistry* synapse_data_sink_plugin_registry_new (void);
SynapseDataSinkPluginRegistry* synapse_data_sink_plugin_registry_construct (GType object_type);
void synapse_data_sink_plugin_registry_register_plugin (SynapseDataSinkPluginRegistry* self,
                                                        GType plugin_type,
                                                        const gchar* title,
                                                        const gchar* description,
                                                        const gchar* icon_name,
                                                        SynapsePluginRegisterFunc reg_func,
                                                        gboolean runnable,
                                                        const gchar* runnable_error);
SynapseDataSinkPluginRegistryPluginInfo* synapse_data_sink_plugin_registry_plugin_info_new (GType type,
                                                                                            const gchar* title,
                                                                                            const gchar* desc,
                                                                                            const gchar* icon_name,
                                                                                            SynapsePluginRegisterFunc reg_func,
                                                                                            gboolean runnable,
                                                                                            const gchar* runnable_error);
SynapseDataSinkPluginRegistryPluginInfo* synapse_data_sink_plugin_registry_plugin_info_construct (GType object_type,
                                                                                                  GType type,
                                                                                                  const gchar* title,
                                                                                                  const gchar* desc,
                                                                                                  const gchar* icon_name,
                                                                                                  SynapsePluginRegisterFunc reg_func,
                                                                                                  gboolean runnable,
                                                                                                  const gchar* runnable_error);
static void synapse_data_sink_plugin_registry_plugin_info_finalize (SynapseDataSinkPluginRegistryPluginInfo * obj);
static GType synapse_data_sink_plugin_registry_plugin_info_get_type_once (void);
static GObject * synapse_data_sink_plugin_registry_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void synapse_data_sink_plugin_registry_finalize (GObject * obj);
static GType synapse_data_sink_plugin_registry_get_type_once (void);
static void synapse_data_sink_data_sink_configuration_enable_plugin (SynapseDataSinkDataSinkConfiguration* self,
                                                              const gchar* name);
static void synapse_data_sink_data_sink_configuration_disable_plugin (SynapseDataSinkDataSinkConfiguration* self,
                                                               const gchar* name);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gint stack_length,
                                      const gchar* needle);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static SynapseDataSinkDataSinkConfiguration* synapse_data_sink_data_sink_configuration_new (void);
static SynapseDataSinkDataSinkConfiguration* synapse_data_sink_data_sink_configuration_construct (GType object_type);
SynapseConfigObject* synapse_config_object_construct (GType object_type);
static gchar** synapse_data_sink_data_sink_configuration_get_disabled_plugins (SynapseDataSinkDataSinkConfiguration* self,
                                                                        gint* result_length1);
static void synapse_data_sink_data_sink_configuration_set_disabled_plugins (SynapseDataSinkDataSinkConfiguration* self,
                                                                     gchar** value,
                                                                     gint value_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gint length);
static void synapse_data_sink_data_sink_configuration_finalize (GObject * obj);
static GType synapse_data_sink_data_sink_configuration_get_type_once (void);
static void _vala_synapse_data_sink_data_sink_configuration_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec);
static void _vala_synapse_data_sink_data_sink_configuration_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec);
static GObject * synapse_data_sink_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
SynapseConfigObject* synapse_config_service_get_config (SynapseConfigService* self,
                                                        const gchar* group,
                                                        const gchar* key,
                                                        GType config_type);
SynapseRelevancyService* synapse_relevancy_service_get_default (void);
SynapseVolumeService* synapse_volume_service_get_default (void);
GType synapse_common_actions_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActions, g_object_unref)
static void synapse_data_sink_finalize (GObject * obj);
static GType synapse_data_sink_get_type_once (void);
static void _vala_synapse_data_sink_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_synapse_data_sink_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

GQuark
synapse_search_error_quark (void)
{
#line 28 "../lib/synapse-core/config-service.vala"
	return g_quark_from_static_string ("synapse-search-error-quark");
#line 864 "data-sink.c"
}

void
synapse_search_provider_search (SynapseSearchProvider* self,
                                const gchar* query,
                                SynapseQueryFlags flags,
                                SynapseResultSet* dest_result_set,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
#line 29 "../lib/synapse-core/data-sink.vala"
	SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE (self)->search (self, query, flags, dest_result_set, cancellable, _callback_, _user_data_);
#line 878 "data-sink.c"
}

GeeList*
synapse_search_provider_search_finish (SynapseSearchProvider* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
#line 29 "../lib/synapse-core/data-sink.vala"
	return SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE (self)->search_finish (self, _res_, error);
#line 888 "data-sink.c"
}

static void
synapse_search_provider_default_init (SynapseSearchProviderIface * iface,
                                      gpointer iface_data)
{
}

static GType
synapse_search_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseSearchProviderIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_search_provider_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_search_provider_type_id;
	synapse_search_provider_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseSearchProvider", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_search_provider_type_id, G_TYPE_OBJECT);
	return synapse_search_provider_type_id;
}

GType
synapse_search_provider_get_type (void)
{
	static volatile gsize synapse_search_provider_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_search_provider_type_id__volatile)) {
		GType synapse_search_provider_type_id;
		synapse_search_provider_type_id = synapse_search_provider_get_type_once ();
		g_once_init_leave (&synapse_search_provider_type_id__volatile, synapse_search_provider_type_id);
	}
	return synapse_search_provider_type_id__volatile;
}

static inline gpointer
synapse_data_sink_get_instance_private (SynapseDataSink* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDataSink_private_offset);
}

SynapseDataSink*
synapse_data_sink_construct (GType object_type)
{
	SynapseDataSink * self = NULL;
#line 162 "../lib/synapse-core/data-sink.vala"
	self = (SynapseDataSink*) g_object_new (object_type, NULL);
#line 162 "../lib/synapse-core/data-sink.vala"
	return self;
#line 933 "data-sink.c"
}

SynapseDataSink*
synapse_data_sink_new (void)
{
#line 162 "../lib/synapse-core/data-sink.vala"
	return synapse_data_sink_construct (SYNAPSE_TYPE_DATA_SINK);
#line 941 "data-sink.c"
}

static void
synapse_data_sink_initialize_caches_data_free (gpointer _data)
{
	SynapseDataSinkInitializeCachesData* _data_;
	_data_ = _data;
#line 40 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_data_->self);
#line 40 "../lib/synapse-core/data-sink.vala"
	g_slice_free (SynapseDataSinkInitializeCachesData, _data_);
#line 953 "data-sink.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 40 "../lib/synapse-core/data-sink.vala"
	return self ? g_object_ref (self) : NULL;
#line 961 "data-sink.c"
}

static void
synapse_data_sink_initialize_caches (SynapseDataSink* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	SynapseDataSinkInitializeCachesData* _data_;
	SynapseDataSink* _tmp0_;
#line 40 "../lib/synapse-core/data-sink.vala"
	_data_ = g_slice_new0 (SynapseDataSinkInitializeCachesData);
#line 40 "../lib/synapse-core/data-sink.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 40 "../lib/synapse-core/data-sink.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_data_sink_initialize_caches_data_free);
#line 40 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 40 "../lib/synapse-core/data-sink.vala"
	_data_->self = _tmp0_;
#line 40 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_initialize_caches_co (_data_);
#line 983 "data-sink.c"
}

static void
synapse_data_sink_initialize_caches_finish (SynapseDataSink* self,
                                            GAsyncResult* _res_)
{
	SynapseDataSinkInitializeCachesData* _data_;
#line 40 "../lib/synapse-core/data-sink.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 993 "data-sink.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 200 "../lib/synapse-core/data-sink.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 200 "../lib/synapse-core/data-sink.vala"
	return _data2_;
#line 1003 "data-sink.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 200 "../lib/synapse-core/data-sink.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1013 "data-sink.c"
		SynapseDataSink* self;
#line 200 "../lib/synapse-core/data-sink.vala"
		self = _data2_->self;
#line 200 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (self);
#line 200 "../lib/synapse-core/data-sink.vala"
		g_slice_free (Block2Data, _data2_);
#line 1021 "data-sink.c"
	}
}

static gboolean
_synapse_data_sink_initialize_caches_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_data_sink_initialize_caches_co (self);
#line 201 "../lib/synapse-core/data-sink.vala"
	return result;
#line 1032 "data-sink.c"
}

static void
__lambda11_ (Block2Data* _data2_)
{
	SynapseDataSink* self;
	gint _tmp0_;
#line 208 "../lib/synapse-core/data-sink.vala"
	self = _data2_->self;
#line 209 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = _data2_->initialized_components;
#line 209 "../lib/synapse-core/data-sink.vala"
	_data2_->initialized_components = _tmp0_ + 1;
#line 210 "../lib/synapse-core/data-sink.vala"
	if (_data2_->initialized_components >= _data2_->NUM_COMPONENTS) {
#line 211 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_initialize_caches_co (_data2_->_async_data_);
#line 1050 "data-sink.c"
	}
}

static void
___lambda11__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 208 "../lib/synapse-core/data-sink.vala"
	__lambda11_ (self);
#line 208 "../lib/synapse-core/data-sink.vala"
	block2_data_unref (self);
#line 1063 "data-sink.c"
}

static void
_synapse_data_sink_check_plugins_synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                           gpointer self)
{
#line 216 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_check_plugins ((SynapseDataSink*) self);
#line 1072 "data-sink.c"
}

static void
__lambda12_ (Block2Data* _data2_)
{
	SynapseDataSink* self;
	gint _tmp0_;
#line 217 "../lib/synapse-core/data-sink.vala"
	self = _data2_->self;
#line 218 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = _data2_->initialized_components;
#line 218 "../lib/synapse-core/data-sink.vala"
	_data2_->initialized_components = _tmp0_ + 1;
#line 219 "../lib/synapse-core/data-sink.vala"
	if (_data2_->initialized_components >= _data2_->NUM_COMPONENTS) {
#line 220 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_initialize_caches_co (_data2_->_async_data_);
#line 1090 "data-sink.c"
	}
}

static void
___lambda12__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 217 "../lib/synapse-core/data-sink.vala"
	__lambda12_ (self);
#line 217 "../lib/synapse-core/data-sink.vala"
	block2_data_unref (self);
#line 1103 "data-sink.c"
}

static gboolean
__lambda13_ (SynapseDataSink* self)
{
	gboolean result = FALSE;
#line 226 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_load_plugins (self);
#line 226 "../lib/synapse-core/data-sink.vala"
	result = FALSE;
#line 226 "../lib/synapse-core/data-sink.vala"
	return result;
#line 1116 "data-sink.c"
}

static gboolean
___lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda13_ ((SynapseDataSink*) self);
#line 226 "../lib/synapse-core/data-sink.vala"
	return result;
#line 1126 "data-sink.c"
}

static gboolean
synapse_data_sink_initialize_caches_co (SynapseDataSinkInitializeCachesData* _data_)
{
#line 200 "../lib/synapse-core/data-sink.vala"
	switch (_data_->_state_) {
#line 200 "../lib/synapse-core/data-sink.vala"
		case 0:
#line 1136 "data-sink.c"
		goto _state_0;
#line 200 "../lib/synapse-core/data-sink.vala"
		case 1:
#line 1140 "data-sink.c"
		goto _state_1;
#line 200 "../lib/synapse-core/data-sink.vala"
		case 2:
#line 1144 "data-sink.c"
		goto _state_2;
		default:
#line 200 "../lib/synapse-core/data-sink.vala"
		g_assert_not_reached ();
#line 1149 "data-sink.c"
	}
	_state_0:
#line 200 "../lib/synapse-core/data-sink.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 200 "../lib/synapse-core/data-sink.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 200 "../lib/synapse-core/data-sink.vala"
	_data_->_data2_->self = g_object_ref (_data_->self);
#line 200 "../lib/synapse-core/data-sink.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 201 "../lib/synapse-core/data-sink.vala"
	g_idle_add_full (G_PRIORITY_LOW, _synapse_data_sink_initialize_caches_co_gsource_func, _data_, NULL);
#line 202 "../lib/synapse-core/data-sink.vala"
	_data_->_state_ = 1;
#line 202 "../lib/synapse-core/data-sink.vala"
	return FALSE;
#line 1166 "data-sink.c"
	_state_1:
	;
#line 204 "../lib/synapse-core/data-sink.vala"
	_data_->_data2_->initialized_components = 0;
#line 205 "../lib/synapse-core/data-sink.vala"
	_data_->_data2_->NUM_COMPONENTS = 2;
#line 207 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp0_ = synapse_dbus_service_get_default ();
#line 207 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_data_->self->priv->dbus_name_cache);
#line 207 "../lib/synapse-core/data-sink.vala"
	_data_->self->priv->dbus_name_cache = _data_->_tmp0_;
#line 208 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp1_ = _data_->self->priv->dbus_name_cache;
#line 208 "../lib/synapse-core/data-sink.vala"
	synapse_dbus_service_initialize (_data_->_tmp1_, ___lambda11__gasync_ready_callback, block2_data_ref (_data_->_data2_));
#line 215 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp2_ = synapse_desktop_file_service_get_default ();
#line 215 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_data_->self->priv->desktop_file_service);
#line 215 "../lib/synapse-core/data-sink.vala"
	_data_->self->priv->desktop_file_service = _data_->_tmp2_;
#line 216 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp3_ = _data_->self->priv->desktop_file_service;
#line 216 "../lib/synapse-core/data-sink.vala"
	g_signal_connect_object (_data_->_tmp3_, "reload-done", (GCallback) _synapse_data_sink_check_plugins_synapse_desktop_file_service_reload_done, _data_->self, 0);
#line 217 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp4_ = _data_->self->priv->desktop_file_service;
#line 217 "../lib/synapse-core/data-sink.vala"
	synapse_desktop_file_service_initialize (_data_->_tmp4_, ___lambda12__gasync_ready_callback, block2_data_ref (_data_->_data2_));
#line 224 "../lib/synapse-core/data-sink.vala"
	_data_->_state_ = 2;
#line 224 "../lib/synapse-core/data-sink.vala"
	return FALSE;
#line 1201 "data-sink.c"
	_state_2:
	;
#line 226 "../lib/synapse-core/data-sink.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda13__gsource_func, g_object_ref (_data_->self), g_object_unref);
#line 200 "../lib/synapse-core/data-sink.vala"
	block2_data_unref (_data_->_data2_);
#line 200 "../lib/synapse-core/data-sink.vala"
	_data_->_data2_ = NULL;
#line 200 "../lib/synapse-core/data-sink.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 200 "../lib/synapse-core/data-sink.vala"
	if (_data_->_state_ != 0) {
#line 200 "../lib/synapse-core/data-sink.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 200 "../lib/synapse-core/data-sink.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1218 "data-sink.c"
		}
	}
#line 200 "../lib/synapse-core/data-sink.vala"
	g_object_unref (_data_->_async_result);
#line 200 "../lib/synapse-core/data-sink.vala"
	return FALSE;
#line 1225 "data-sink.c"
}

static void
_vala_array_add1 (SynapsePluginRegisterFunc* * array,
                  gint* length,
                  gint* size,
                  SynapsePluginRegisterFunc value)
{
#line 232 "../lib/synapse-core/data-sink.vala"
	if ((*length) == (*size)) {
#line 232 "../lib/synapse-core/data-sink.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 232 "../lib/synapse-core/data-sink.vala"
		*array = g_renew (SynapsePluginRegisterFunc, *array, *size);
#line 1240 "data-sink.c"
	}
#line 232 "../lib/synapse-core/data-sink.vala"
	(*array)[(*length)++] = value;
#line 1244 "data-sink.c"
}

static void
synapse_data_sink_check_plugins (SynapseDataSink* self)
{
	SynapsePluginRegisterFunc* reg_funcs = NULL;
	SynapsePluginRegisterFunc* _tmp0_;
	gint reg_funcs_length1;
	gint _reg_funcs_size_;
	SynapsePluginRegisterFunc* _tmp12_;
	gint _tmp12__length1;
#line 229 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 230 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = g_new0 (SynapsePluginRegisterFunc, 0);
#line 230 "../lib/synapse-core/data-sink.vala"
	reg_funcs = _tmp0_;
#line 230 "../lib/synapse-core/data-sink.vala"
	reg_funcs_length1 = 0;
#line 230 "../lib/synapse-core/data-sink.vala"
	_reg_funcs_size_ = reg_funcs_length1;
#line 1266 "data-sink.c"
	{
		GeeList* _pi_list = NULL;
		SynapseDataSinkPluginRegistry* _tmp1_;
		GeeList* _tmp2_;
		gint _pi_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pi_index = 0;
#line 231 "../lib/synapse-core/data-sink.vala"
		_tmp1_ = self->priv->registry;
#line 231 "../lib/synapse-core/data-sink.vala"
		_tmp2_ = synapse_data_sink_plugin_registry_get_plugins (_tmp1_);
#line 231 "../lib/synapse-core/data-sink.vala"
		_pi_list = _tmp2_;
#line 231 "../lib/synapse-core/data-sink.vala"
		_tmp3_ = _pi_list;
#line 231 "../lib/synapse-core/data-sink.vala"
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 231 "../lib/synapse-core/data-sink.vala"
		_tmp5_ = _tmp4_;
#line 231 "../lib/synapse-core/data-sink.vala"
		_pi_size = _tmp5_;
#line 231 "../lib/synapse-core/data-sink.vala"
		_pi_index = -1;
#line 231 "../lib/synapse-core/data-sink.vala"
		while (TRUE) {
#line 1294 "data-sink.c"
			gint _tmp6_;
			gint _tmp7_;
			SynapseDataSinkPluginRegistryPluginInfo* pi = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			SynapseDataSinkPluginRegistryPluginInfo* _tmp10_;
			SynapsePluginRegisterFunc _tmp11_;
#line 231 "../lib/synapse-core/data-sink.vala"
			_pi_index = _pi_index + 1;
#line 231 "../lib/synapse-core/data-sink.vala"
			_tmp6_ = _pi_index;
#line 231 "../lib/synapse-core/data-sink.vala"
			_tmp7_ = _pi_size;
#line 231 "../lib/synapse-core/data-sink.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 231 "../lib/synapse-core/data-sink.vala"
				break;
#line 1312 "data-sink.c"
			}
#line 231 "../lib/synapse-core/data-sink.vala"
			_tmp8_ = _pi_list;
#line 231 "../lib/synapse-core/data-sink.vala"
			_tmp9_ = gee_list_get (_tmp8_, _pi_index);
#line 231 "../lib/synapse-core/data-sink.vala"
			pi = (SynapseDataSinkPluginRegistryPluginInfo*) _tmp9_;
#line 232 "../lib/synapse-core/data-sink.vala"
			_tmp10_ = pi;
#line 232 "../lib/synapse-core/data-sink.vala"
			_tmp11_ = _tmp10_->register_func;
#line 232 "../lib/synapse-core/data-sink.vala"
			_vala_array_add1 (&reg_funcs, &reg_funcs_length1, &_reg_funcs_size_, _tmp11_);
#line 231 "../lib/synapse-core/data-sink.vala"
			_synapse_data_sink_plugin_registry_plugin_info_unref0 (pi);
#line 1328 "data-sink.c"
		}
#line 231 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_pi_list);
#line 1332 "data-sink.c"
	}
#line 235 "../lib/synapse-core/data-sink.vala"
	_tmp12_ = reg_funcs;
#line 235 "../lib/synapse-core/data-sink.vala"
	_tmp12__length1 = reg_funcs_length1;
#line 1338 "data-sink.c"
	{
		SynapsePluginRegisterFunc* func_collection = NULL;
		gint func_collection_length1 = 0;
		gint _func_collection_size_ = 0;
		gint func_it = 0;
#line 235 "../lib/synapse-core/data-sink.vala"
		func_collection = _tmp12_;
#line 235 "../lib/synapse-core/data-sink.vala"
		func_collection_length1 = _tmp12__length1;
#line 235 "../lib/synapse-core/data-sink.vala"
		for (func_it = 0; func_it < func_collection_length1; func_it = func_it + 1) {
#line 1350 "data-sink.c"
			SynapsePluginRegisterFunc func = NULL;
#line 235 "../lib/synapse-core/data-sink.vala"
			func = func_collection[func_it];
#line 1354 "data-sink.c"
			{
				SynapsePluginRegisterFunc _tmp13_;
#line 236 "../lib/synapse-core/data-sink.vala"
				_tmp13_ = func;
#line 236 "../lib/synapse-core/data-sink.vala"
				_tmp13_ ();
#line 1361 "data-sink.c"
			}
		}
	}
#line 229 "../lib/synapse-core/data-sink.vala"
	reg_funcs = (g_free (reg_funcs), NULL);
#line 1367 "data-sink.c"
}

void
synapse_data_sink_register_plugin (SynapseDataSink* self,
                                   GObject* plugin)
{
#line 247 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 247 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (plugin != NULL);
#line 248 "../lib/synapse-core/data-sink.vala"
	if (SYNAPSE_IS_ACTION_PROVIDER (plugin)) {
#line 1380 "data-sink.c"
		SynapseActionProvider* action_plugin = NULL;
		SynapseActionProvider* _tmp0_;
		GeeSet* _tmp1_;
		SynapseActionProvider* _tmp2_;
		gboolean _tmp3_;
		SynapseActionProvider* _tmp4_;
#line 249 "../lib/synapse-core/data-sink.vala"
		_tmp0_ = _g_object_ref0 (SYNAPSE_IS_ACTION_PROVIDER (plugin) ? ((SynapseActionProvider*) plugin) : NULL);
#line 249 "../lib/synapse-core/data-sink.vala"
		action_plugin = _tmp0_;
#line 250 "../lib/synapse-core/data-sink.vala"
		_tmp1_ = self->priv->action_plugins;
#line 250 "../lib/synapse-core/data-sink.vala"
		_tmp2_ = action_plugin;
#line 250 "../lib/synapse-core/data-sink.vala"
		gee_collection_add ((GeeCollection*) _tmp1_, _tmp2_);
#line 251 "../lib/synapse-core/data-sink.vala"
		_tmp3_ = self->priv->_has_unknown_handlers;
#line 251 "../lib/synapse-core/data-sink.vala"
		_tmp4_ = action_plugin;
#line 251 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_set_has_unknown_handlers (self, _tmp3_ | synapse_action_provider_handles_unknown (_tmp4_));
#line 248 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (action_plugin);
#line 1405 "data-sink.c"
	}
#line 253 "../lib/synapse-core/data-sink.vala"
	if (SYNAPSE_IS_ITEM_PROVIDER (plugin)) {
#line 1409 "data-sink.c"
		SynapseItemProvider* item_plugin = NULL;
		SynapseItemProvider* _tmp5_;
		GeeSet* _tmp6_;
		SynapseItemProvider* _tmp7_;
		gboolean _tmp8_;
		SynapseItemProvider* _tmp9_;
#line 254 "../lib/synapse-core/data-sink.vala"
		_tmp5_ = _g_object_ref0 (SYNAPSE_IS_ITEM_PROVIDER (plugin) ? ((SynapseItemProvider*) plugin) : NULL);
#line 254 "../lib/synapse-core/data-sink.vala"
		item_plugin = _tmp5_;
#line 255 "../lib/synapse-core/data-sink.vala"
		_tmp6_ = self->priv->item_plugins;
#line 255 "../lib/synapse-core/data-sink.vala"
		_tmp7_ = item_plugin;
#line 255 "../lib/synapse-core/data-sink.vala"
		gee_collection_add ((GeeCollection*) _tmp6_, _tmp7_);
#line 256 "../lib/synapse-core/data-sink.vala"
		_tmp8_ = self->priv->_has_empty_handlers;
#line 256 "../lib/synapse-core/data-sink.vala"
		_tmp9_ = item_plugin;
#line 256 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_set_has_empty_handlers (self, _tmp8_ | synapse_item_provider_handles_empty_query (_tmp9_));
#line 253 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (item_plugin);
#line 1434 "data-sink.c"
	}
#line 259 "../lib/synapse-core/data-sink.vala"
	g_signal_emit (self, synapse_data_sink_signals[SYNAPSE_DATA_SINK_PLUGIN_REGISTERED_SIGNAL], 0, plugin);
#line 1438 "data-sink.c"
}

static void
synapse_data_sink_update_has_unknown_handlers (SynapseDataSink* self)
{
	gboolean tmp = FALSE;
#line 262 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 263 "../lib/synapse-core/data-sink.vala"
	tmp = FALSE;
#line 1449 "data-sink.c"
	{
		GeeIterator* _action_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 264 "../lib/synapse-core/data-sink.vala"
		_tmp0_ = self->priv->action_plugins;
#line 264 "../lib/synapse-core/data-sink.vala"
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 264 "../lib/synapse-core/data-sink.vala"
		_action_it = _tmp1_;
#line 264 "../lib/synapse-core/data-sink.vala"
		while (TRUE) {
#line 1462 "data-sink.c"
			GeeIterator* _tmp2_;
			SynapseActionProvider* action = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			gboolean _tmp5_ = FALSE;
			SynapseActionProvider* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
#line 264 "../lib/synapse-core/data-sink.vala"
			_tmp2_ = _action_it;
#line 264 "../lib/synapse-core/data-sink.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 264 "../lib/synapse-core/data-sink.vala"
				break;
#line 1477 "data-sink.c"
			}
#line 264 "../lib/synapse-core/data-sink.vala"
			_tmp3_ = _action_it;
#line 264 "../lib/synapse-core/data-sink.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 264 "../lib/synapse-core/data-sink.vala"
			action = (SynapseActionProvider*) _tmp4_;
#line 265 "../lib/synapse-core/data-sink.vala"
			_tmp6_ = action;
#line 265 "../lib/synapse-core/data-sink.vala"
			_tmp7_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp6_);
#line 265 "../lib/synapse-core/data-sink.vala"
			_tmp8_ = _tmp7_;
#line 265 "../lib/synapse-core/data-sink.vala"
			if (_tmp8_) {
#line 1493 "data-sink.c"
				SynapseActionProvider* _tmp9_;
#line 265 "../lib/synapse-core/data-sink.vala"
				_tmp9_ = action;
#line 265 "../lib/synapse-core/data-sink.vala"
				_tmp5_ = synapse_action_provider_handles_unknown (_tmp9_);
#line 1499 "data-sink.c"
			} else {
#line 265 "../lib/synapse-core/data-sink.vala"
				_tmp5_ = FALSE;
#line 1503 "data-sink.c"
			}
#line 265 "../lib/synapse-core/data-sink.vala"
			if (_tmp5_) {
#line 266 "../lib/synapse-core/data-sink.vala"
				tmp = TRUE;
#line 267 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (action);
#line 267 "../lib/synapse-core/data-sink.vala"
				break;
#line 1513 "data-sink.c"
			}
#line 264 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (action);
#line 1517 "data-sink.c"
		}
#line 264 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_action_it);
#line 1521 "data-sink.c"
	}
#line 270 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_set_has_unknown_handlers (self, tmp);
#line 1525 "data-sink.c"
}

static void
synapse_data_sink_update_has_empty_handlers (SynapseDataSink* self)
{
	gboolean tmp = FALSE;
#line 273 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 274 "../lib/synapse-core/data-sink.vala"
	tmp = FALSE;
#line 1536 "data-sink.c"
	{
		GeeIterator* _item_plugin_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 275 "../lib/synapse-core/data-sink.vala"
		_tmp0_ = self->priv->item_plugins;
#line 275 "../lib/synapse-core/data-sink.vala"
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 275 "../lib/synapse-core/data-sink.vala"
		_item_plugin_it = _tmp1_;
#line 275 "../lib/synapse-core/data-sink.vala"
		while (TRUE) {
#line 1549 "data-sink.c"
			GeeIterator* _tmp2_;
			SynapseItemProvider* item_plugin = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			gboolean _tmp5_ = FALSE;
			SynapseItemProvider* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
#line 275 "../lib/synapse-core/data-sink.vala"
			_tmp2_ = _item_plugin_it;
#line 275 "../lib/synapse-core/data-sink.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 275 "../lib/synapse-core/data-sink.vala"
				break;
#line 1564 "data-sink.c"
			}
#line 275 "../lib/synapse-core/data-sink.vala"
			_tmp3_ = _item_plugin_it;
#line 275 "../lib/synapse-core/data-sink.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 275 "../lib/synapse-core/data-sink.vala"
			item_plugin = (SynapseItemProvider*) _tmp4_;
#line 276 "../lib/synapse-core/data-sink.vala"
			_tmp6_ = item_plugin;
#line 276 "../lib/synapse-core/data-sink.vala"
			_tmp7_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp6_);
#line 276 "../lib/synapse-core/data-sink.vala"
			_tmp8_ = _tmp7_;
#line 276 "../lib/synapse-core/data-sink.vala"
			if (_tmp8_) {
#line 1580 "data-sink.c"
				SynapseItemProvider* _tmp9_;
#line 276 "../lib/synapse-core/data-sink.vala"
				_tmp9_ = item_plugin;
#line 276 "../lib/synapse-core/data-sink.vala"
				_tmp5_ = synapse_item_provider_handles_empty_query (_tmp9_);
#line 1586 "data-sink.c"
			} else {
#line 276 "../lib/synapse-core/data-sink.vala"
				_tmp5_ = FALSE;
#line 1590 "data-sink.c"
			}
#line 276 "../lib/synapse-core/data-sink.vala"
			if (_tmp5_) {
#line 277 "../lib/synapse-core/data-sink.vala"
				tmp = TRUE;
#line 278 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (item_plugin);
#line 278 "../lib/synapse-core/data-sink.vala"
				break;
#line 1600 "data-sink.c"
			}
#line 275 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (item_plugin);
#line 1604 "data-sink.c"
		}
#line 275 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_item_plugin_it);
#line 1608 "data-sink.c"
	}
#line 281 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_set_has_empty_handlers (self, tmp);
#line 1612 "data-sink.c"
}

static GObject*
synapse_data_sink_create_plugin (SynapseDataSink* self,
                                 GType t)
{
	GObjectClass* obj_class = NULL;
	GTypeClass* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GObjectClass* _tmp2_;
	GObject* result = NULL;
#line 284 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 285 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = g_type_class_ref (t);
#line 285 "../lib/synapse-core/data-sink.vala"
	obj_class = (GObjectClass*) _tmp0_;
#line 286 "../lib/synapse-core/data-sink.vala"
	_tmp2_ = obj_class;
#line 286 "../lib/synapse-core/data-sink.vala"
	if (_tmp2_ != NULL) {
#line 1634 "data-sink.c"
		GObjectClass* _tmp3_;
		GParamSpec* _tmp4_;
#line 286 "../lib/synapse-core/data-sink.vala"
		_tmp3_ = obj_class;
#line 286 "../lib/synapse-core/data-sink.vala"
		_tmp4_ = g_object_class_find_property (_tmp3_, "data-sink");
#line 286 "../lib/synapse-core/data-sink.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 1643 "data-sink.c"
	} else {
#line 286 "../lib/synapse-core/data-sink.vala"
		_tmp1_ = FALSE;
#line 1647 "data-sink.c"
	}
#line 287 "../lib/synapse-core/data-sink.vala"
	if (_tmp1_) {
#line 1651 "data-sink.c"
		GObject* _tmp5_;
		GObject* _tmp6_;
#line 287 "../lib/synapse-core/data-sink.vala"
		_tmp5_ = g_object_new (t, "data-sink", self, NULL, NULL);
#line 287 "../lib/synapse-core/data-sink.vala"
		_tmp6_ = G_IS_INITIALLY_UNOWNED (_tmp5_) ? g_object_ref_sink (_tmp5_) : _tmp5_;
#line 287 "../lib/synapse-core/data-sink.vala"
		result = _tmp6_;
#line 287 "../lib/synapse-core/data-sink.vala"
		_g_type_class_unref0 (obj_class);
#line 287 "../lib/synapse-core/data-sink.vala"
		return result;
#line 1664 "data-sink.c"
	} else {
		GObject* _tmp7_;
		GObject* _tmp8_;
#line 289 "../lib/synapse-core/data-sink.vala"
		_tmp7_ = g_object_new (t, NULL, NULL);
#line 289 "../lib/synapse-core/data-sink.vala"
		_tmp8_ = G_IS_INITIALLY_UNOWNED (_tmp7_) ? g_object_ref_sink (_tmp7_) : _tmp7_;
#line 289 "../lib/synapse-core/data-sink.vala"
		result = _tmp8_;
#line 289 "../lib/synapse-core/data-sink.vala"
		_g_type_class_unref0 (obj_class);
#line 289 "../lib/synapse-core/data-sink.vala"
		return result;
#line 1678 "data-sink.c"
	}
#line 287 "../lib/synapse-core/data-sink.vala"
	_g_type_class_unref0 (obj_class);
#line 1682 "data-sink.c"
}

static void
synapse_data_sink_load_plugins (SynapseDataSink* self)
{
	GType* _tmp0_;
	gint _tmp0__length1;
#line 293 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 295 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = self->priv->plugin_types;
#line 295 "../lib/synapse-core/data-sink.vala"
	_tmp0__length1 = self->priv->plugin_types_length1;
#line 1696 "data-sink.c"
	{
		GType* t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
#line 295 "../lib/synapse-core/data-sink.vala"
		t_collection = _tmp0_;
#line 295 "../lib/synapse-core/data-sink.vala"
		t_collection_length1 = _tmp0__length1;
#line 295 "../lib/synapse-core/data-sink.vala"
		for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
#line 1708 "data-sink.c"
			GType t = 0UL;
#line 295 "../lib/synapse-core/data-sink.vala"
			t = t_collection[t_it];
#line 1712 "data-sink.c"
			{
				GTypeClass* _tmp1_;
				GTypeClass* _tmp2_;
				SynapseDataSinkPluginRegistryPluginInfo* info = NULL;
				SynapseDataSinkPluginRegistry* _tmp3_;
				SynapseDataSinkPluginRegistryPluginInfo* _tmp4_;
				gboolean _tmp5_ = FALSE;
				SynapseDataSinkPluginRegistryPluginInfo* _tmp6_;
				gboolean skip = FALSE;
				gboolean _tmp8_ = FALSE;
				SynapseDataSinkDataSinkConfiguration* _tmp9_;
#line 296 "../lib/synapse-core/data-sink.vala"
				_tmp1_ = g_type_class_ref (t);
#line 296 "../lib/synapse-core/data-sink.vala"
				_tmp2_ = _tmp1_;
#line 296 "../lib/synapse-core/data-sink.vala"
				_g_type_class_unref0 (_tmp2_);
#line 297 "../lib/synapse-core/data-sink.vala"
				_tmp3_ = self->priv->registry;
#line 297 "../lib/synapse-core/data-sink.vala"
				_tmp4_ = synapse_data_sink_plugin_registry_get_plugin_info_for_type (_tmp3_, t);
#line 297 "../lib/synapse-core/data-sink.vala"
				info = _tmp4_;
#line 298 "../lib/synapse-core/data-sink.vala"
				_tmp6_ = info;
#line 298 "../lib/synapse-core/data-sink.vala"
				if (_tmp6_ != NULL) {
#line 1740 "data-sink.c"
					SynapseDataSinkPluginRegistryPluginInfo* _tmp7_;
#line 298 "../lib/synapse-core/data-sink.vala"
					_tmp7_ = info;
#line 298 "../lib/synapse-core/data-sink.vala"
					_tmp5_ = _tmp7_->runnable == FALSE;
#line 1746 "data-sink.c"
				} else {
#line 298 "../lib/synapse-core/data-sink.vala"
					_tmp5_ = FALSE;
#line 1750 "data-sink.c"
				}
#line 298 "../lib/synapse-core/data-sink.vala"
				skip = _tmp5_;
#line 299 "../lib/synapse-core/data-sink.vala"
				_tmp9_ = self->priv->config;
#line 299 "../lib/synapse-core/data-sink.vala"
				if (synapse_data_sink_data_sink_configuration_is_plugin_enabled (_tmp9_, t)) {
#line 299 "../lib/synapse-core/data-sink.vala"
					_tmp8_ = !skip;
#line 1760 "data-sink.c"
				} else {
#line 299 "../lib/synapse-core/data-sink.vala"
					_tmp8_ = FALSE;
#line 1764 "data-sink.c"
				}
#line 299 "../lib/synapse-core/data-sink.vala"
				if (_tmp8_) {
#line 1768 "data-sink.c"
					GObject* plugin = NULL;
					GObject* _tmp10_;
					GObject* _tmp11_;
					GObject* _tmp12_;
#line 300 "../lib/synapse-core/data-sink.vala"
					_tmp10_ = synapse_data_sink_create_plugin (self, t);
#line 300 "../lib/synapse-core/data-sink.vala"
					plugin = _tmp10_;
#line 301 "../lib/synapse-core/data-sink.vala"
					_tmp11_ = plugin;
#line 301 "../lib/synapse-core/data-sink.vala"
					synapse_data_sink_register_plugin (self, _tmp11_);
#line 302 "../lib/synapse-core/data-sink.vala"
					_tmp12_ = plugin;
#line 302 "../lib/synapse-core/data-sink.vala"
					synapse_activatable_activate (SYNAPSE_IS_ACTIVATABLE (_tmp12_) ? ((SynapseActivatable*) _tmp12_) : NULL);
#line 299 "../lib/synapse-core/data-sink.vala"
					_g_object_unref0 (plugin);
#line 1787 "data-sink.c"
				}
#line 295 "../lib/synapse-core/data-sink.vala"
				_synapse_data_sink_plugin_registry_plugin_info_unref0 (info);
#line 1791 "data-sink.c"
			}
		}
	}
#line 306 "../lib/synapse-core/data-sink.vala"
	self->priv->plugins_loaded = TRUE;
#line 1797 "data-sink.c"
}

static gboolean
_vala_g_type_array_contains (GType * stack,
                             gint stack_length,
                             const GType needle)
{
	gint i;
#line 312 "../lib/synapse-core/data-sink.vala"
	for (i = 0; i < stack_length; i++) {
#line 312 "../lib/synapse-core/data-sink.vala"
		if (needle == stack[i]) {
#line 312 "../lib/synapse-core/data-sink.vala"
			return TRUE;
#line 1812 "data-sink.c"
		}
	}
#line 312 "../lib/synapse-core/data-sink.vala"
	return FALSE;
#line 1817 "data-sink.c"
}

static void
_vala_array_add2 (GType* * array,
                  gint* length,
                  gint* size,
                  GType value)
{
#line 315 "../lib/synapse-core/data-sink.vala"
	if ((*length) == (*size)) {
#line 315 "../lib/synapse-core/data-sink.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 315 "../lib/synapse-core/data-sink.vala"
		*array = g_renew (GType, *array, *size);
#line 1832 "data-sink.c"
	}
#line 315 "../lib/synapse-core/data-sink.vala"
	(*array)[(*length)++] = value;
#line 1836 "data-sink.c"
}

void
synapse_data_sink_register_static_plugin (SynapseDataSink* self,
                                          GType plugin_type)
{
	GType* _tmp0_;
	gint _tmp0__length1;
#line 311 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 312 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = self->priv->plugin_types;
#line 312 "../lib/synapse-core/data-sink.vala"
	_tmp0__length1 = self->priv->plugin_types_length1;
#line 312 "../lib/synapse-core/data-sink.vala"
	if (_vala_g_type_array_contains (_tmp0_, _tmp0__length1, plugin_type)) {
#line 313 "../lib/synapse-core/data-sink.vala"
		return;
#line 1855 "data-sink.c"
	}
#line 315 "../lib/synapse-core/data-sink.vala"
	_vala_array_add2 (&self->priv->plugin_types, &self->priv->plugin_types_length1, &self->priv->_plugin_types_size_, plugin_type);
#line 1859 "data-sink.c"
}

GObject*
synapse_data_sink_get_plugin (SynapseDataSink* self,
                              const gchar* name)
{
	GObject* _result_ = NULL;
	GObject* _tmp8_;
	GObject* result = NULL;
#line 318 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 318 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 319 "../lib/synapse-core/data-sink.vala"
	_result_ = NULL;
#line 1875 "data-sink.c"
	{
		GeeIterator* _plugin_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 321 "../lib/synapse-core/data-sink.vala"
		_tmp0_ = self->priv->item_plugins;
#line 321 "../lib/synapse-core/data-sink.vala"
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 321 "../lib/synapse-core/data-sink.vala"
		_plugin_it = _tmp1_;
#line 321 "../lib/synapse-core/data-sink.vala"
		while (TRUE) {
#line 1888 "data-sink.c"
			GeeIterator* _tmp2_;
			SynapseItemProvider* plugin = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SynapseItemProvider* _tmp5_;
			const gchar* _tmp6_;
#line 321 "../lib/synapse-core/data-sink.vala"
			_tmp2_ = _plugin_it;
#line 321 "../lib/synapse-core/data-sink.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 321 "../lib/synapse-core/data-sink.vala"
				break;
#line 1901 "data-sink.c"
			}
#line 321 "../lib/synapse-core/data-sink.vala"
			_tmp3_ = _plugin_it;
#line 321 "../lib/synapse-core/data-sink.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 321 "../lib/synapse-core/data-sink.vala"
			plugin = (SynapseItemProvider*) _tmp4_;
#line 322 "../lib/synapse-core/data-sink.vala"
			_tmp5_ = plugin;
#line 322 "../lib/synapse-core/data-sink.vala"
			_tmp6_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) _tmp5_));
#line 322 "../lib/synapse-core/data-sink.vala"
			if (g_strcmp0 (_tmp6_, name) == 0) {
#line 1915 "data-sink.c"
				SynapseItemProvider* _tmp7_;
#line 323 "../lib/synapse-core/data-sink.vala"
				_tmp7_ = plugin;
#line 323 "../lib/synapse-core/data-sink.vala"
				_result_ = (GObject*) _tmp7_;
#line 324 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (plugin);
#line 324 "../lib/synapse-core/data-sink.vala"
				break;
#line 1925 "data-sink.c"
			}
#line 321 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (plugin);
#line 1929 "data-sink.c"
		}
#line 321 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_plugin_it);
#line 1933 "data-sink.c"
	}
#line 328 "../lib/synapse-core/data-sink.vala"
	_tmp8_ = _result_;
#line 328 "../lib/synapse-core/data-sink.vala"
	result = _tmp8_;
#line 328 "../lib/synapse-core/data-sink.vala"
	return result;
#line 1941 "data-sink.c"
}

gboolean
synapse_data_sink_is_plugin_enabled (SynapseDataSink* self,
                                     GType plugin_type)
{
	gboolean result = FALSE;
#line 331 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1951 "data-sink.c"
	{
		GeeIterator* _plugin_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 332 "../lib/synapse-core/data-sink.vala"
		_tmp0_ = self->priv->item_plugins;
#line 332 "../lib/synapse-core/data-sink.vala"
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 332 "../lib/synapse-core/data-sink.vala"
		_plugin_it = _tmp1_;
#line 332 "../lib/synapse-core/data-sink.vala"
		while (TRUE) {
#line 1964 "data-sink.c"
			GeeIterator* _tmp2_;
			SynapseItemProvider* plugin = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SynapseItemProvider* _tmp5_;
#line 332 "../lib/synapse-core/data-sink.vala"
			_tmp2_ = _plugin_it;
#line 332 "../lib/synapse-core/data-sink.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 332 "../lib/synapse-core/data-sink.vala"
				break;
#line 1976 "data-sink.c"
			}
#line 332 "../lib/synapse-core/data-sink.vala"
			_tmp3_ = _plugin_it;
#line 332 "../lib/synapse-core/data-sink.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 332 "../lib/synapse-core/data-sink.vala"
			plugin = (SynapseItemProvider*) _tmp4_;
#line 333 "../lib/synapse-core/data-sink.vala"
			_tmp5_ = plugin;
#line 333 "../lib/synapse-core/data-sink.vala"
			if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp5_) == plugin_type) {
#line 1988 "data-sink.c"
				SynapseItemProvider* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
#line 334 "../lib/synapse-core/data-sink.vala"
				_tmp6_ = plugin;
#line 334 "../lib/synapse-core/data-sink.vala"
				_tmp7_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp6_);
#line 334 "../lib/synapse-core/data-sink.vala"
				_tmp8_ = _tmp7_;
#line 334 "../lib/synapse-core/data-sink.vala"
				result = _tmp8_;
#line 334 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (plugin);
#line 334 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (_plugin_it);
#line 334 "../lib/synapse-core/data-sink.vala"
				return result;
#line 2006 "data-sink.c"
			}
#line 332 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (plugin);
#line 2010 "data-sink.c"
		}
#line 332 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_plugin_it);
#line 2014 "data-sink.c"
	}
	{
		GeeIterator* _action_it = NULL;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_;
#line 338 "../lib/synapse-core/data-sink.vala"
		_tmp9_ = self->priv->action_plugins;
#line 338 "../lib/synapse-core/data-sink.vala"
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
#line 338 "../lib/synapse-core/data-sink.vala"
		_action_it = _tmp10_;
#line 338 "../lib/synapse-core/data-sink.vala"
		while (TRUE) {
#line 2028 "data-sink.c"
			GeeIterator* _tmp11_;
			SynapseActionProvider* action = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			SynapseActionProvider* _tmp14_;
#line 338 "../lib/synapse-core/data-sink.vala"
			_tmp11_ = _action_it;
#line 338 "../lib/synapse-core/data-sink.vala"
			if (!gee_iterator_next (_tmp11_)) {
#line 338 "../lib/synapse-core/data-sink.vala"
				break;
#line 2040 "data-sink.c"
			}
#line 338 "../lib/synapse-core/data-sink.vala"
			_tmp12_ = _action_it;
#line 338 "../lib/synapse-core/data-sink.vala"
			_tmp13_ = gee_iterator_get (_tmp12_);
#line 338 "../lib/synapse-core/data-sink.vala"
			action = (SynapseActionProvider*) _tmp13_;
#line 339 "../lib/synapse-core/data-sink.vala"
			_tmp14_ = action;
#line 339 "../lib/synapse-core/data-sink.vala"
			if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp14_) == plugin_type) {
#line 2052 "data-sink.c"
				SynapseActionProvider* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
#line 340 "../lib/synapse-core/data-sink.vala"
				_tmp15_ = action;
#line 340 "../lib/synapse-core/data-sink.vala"
				_tmp16_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp15_);
#line 340 "../lib/synapse-core/data-sink.vala"
				_tmp17_ = _tmp16_;
#line 340 "../lib/synapse-core/data-sink.vala"
				result = _tmp17_;
#line 340 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (action);
#line 340 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (_action_it);
#line 340 "../lib/synapse-core/data-sink.vala"
				return result;
#line 2070 "data-sink.c"
			}
#line 338 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (action);
#line 2074 "data-sink.c"
		}
#line 338 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_action_it);
#line 2078 "data-sink.c"
	}
#line 344 "../lib/synapse-core/data-sink.vala"
	result = FALSE;
#line 344 "../lib/synapse-core/data-sink.vala"
	return result;
#line 2084 "data-sink.c"
}

void
synapse_data_sink_set_plugin_enabled (SynapseDataSink* self,
                                      GType plugin_type,
                                      gboolean enabled)
{
	SynapseDataSinkDataSinkConfiguration* _tmp0_;
	SynapseConfigService* _tmp1_;
	SynapseConfigService* _tmp2_;
	SynapseDataSinkDataSinkConfiguration* _tmp3_;
#line 347 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 349 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = self->priv->config;
#line 349 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_data_sink_configuration_set_plugin_enabled (_tmp0_, plugin_type, enabled);
#line 350 "../lib/synapse-core/data-sink.vala"
	_tmp1_ = synapse_config_service_get_default ();
#line 350 "../lib/synapse-core/data-sink.vala"
	_tmp2_ = _tmp1_;
#line 350 "../lib/synapse-core/data-sink.vala"
	_tmp3_ = self->priv->config;
#line 350 "../lib/synapse-core/data-sink.vala"
	synapse_config_service_set_config (_tmp2_, "data-sink", "global", (SynapseConfigObject*) _tmp3_);
#line 350 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_tmp2_);
#line 2112 "data-sink.c"
	{
		GeeIterator* _plugin_it = NULL;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
#line 352 "../lib/synapse-core/data-sink.vala"
		_tmp4_ = self->priv->item_plugins;
#line 352 "../lib/synapse-core/data-sink.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 352 "../lib/synapse-core/data-sink.vala"
		_plugin_it = _tmp5_;
#line 352 "../lib/synapse-core/data-sink.vala"
		while (TRUE) {
#line 2125 "data-sink.c"
			GeeIterator* _tmp6_;
			SynapseItemProvider* plugin = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			SynapseItemProvider* _tmp9_;
#line 352 "../lib/synapse-core/data-sink.vala"
			_tmp6_ = _plugin_it;
#line 352 "../lib/synapse-core/data-sink.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 352 "../lib/synapse-core/data-sink.vala"
				break;
#line 2137 "data-sink.c"
			}
#line 352 "../lib/synapse-core/data-sink.vala"
			_tmp7_ = _plugin_it;
#line 352 "../lib/synapse-core/data-sink.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 352 "../lib/synapse-core/data-sink.vala"
			plugin = (SynapseItemProvider*) _tmp8_;
#line 353 "../lib/synapse-core/data-sink.vala"
			_tmp9_ = plugin;
#line 353 "../lib/synapse-core/data-sink.vala"
			if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp9_) == plugin_type) {
#line 2149 "data-sink.c"
				SynapseItemProvider* _tmp10_;
#line 354 "../lib/synapse-core/data-sink.vala"
				_tmp10_ = plugin;
#line 354 "../lib/synapse-core/data-sink.vala"
				synapse_activatable_set_enabled ((SynapseActivatable*) _tmp10_, enabled);
#line 355 "../lib/synapse-core/data-sink.vala"
				if (enabled) {
#line 2157 "data-sink.c"
					SynapseItemProvider* _tmp11_;
#line 356 "../lib/synapse-core/data-sink.vala"
					_tmp11_ = plugin;
#line 356 "../lib/synapse-core/data-sink.vala"
					synapse_activatable_activate ((SynapseActivatable*) _tmp11_);
#line 2163 "data-sink.c"
				} else {
					SynapseItemProvider* _tmp12_;
#line 358 "../lib/synapse-core/data-sink.vala"
					_tmp12_ = plugin;
#line 358 "../lib/synapse-core/data-sink.vala"
					synapse_activatable_deactivate ((SynapseActivatable*) _tmp12_);
#line 2170 "data-sink.c"
				}
#line 360 "../lib/synapse-core/data-sink.vala"
				synapse_data_sink_update_has_empty_handlers (self);
#line 362 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (plugin);
#line 362 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (_plugin_it);
#line 362 "../lib/synapse-core/data-sink.vala"
				return;
#line 2180 "data-sink.c"
			}
#line 352 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (plugin);
#line 2184 "data-sink.c"
		}
#line 352 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_plugin_it);
#line 2188 "data-sink.c"
	}
	{
		GeeIterator* _action_it = NULL;
		GeeSet* _tmp13_;
		GeeIterator* _tmp14_;
#line 366 "../lib/synapse-core/data-sink.vala"
		_tmp13_ = self->priv->action_plugins;
#line 366 "../lib/synapse-core/data-sink.vala"
		_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
#line 366 "../lib/synapse-core/data-sink.vala"
		_action_it = _tmp14_;
#line 366 "../lib/synapse-core/data-sink.vala"
		while (TRUE) {
#line 2202 "data-sink.c"
			GeeIterator* _tmp15_;
			SynapseActionProvider* action = NULL;
			GeeIterator* _tmp16_;
			gpointer _tmp17_;
			SynapseActionProvider* _tmp18_;
#line 366 "../lib/synapse-core/data-sink.vala"
			_tmp15_ = _action_it;
#line 366 "../lib/synapse-core/data-sink.vala"
			if (!gee_iterator_next (_tmp15_)) {
#line 366 "../lib/synapse-core/data-sink.vala"
				break;
#line 2214 "data-sink.c"
			}
#line 366 "../lib/synapse-core/data-sink.vala"
			_tmp16_ = _action_it;
#line 366 "../lib/synapse-core/data-sink.vala"
			_tmp17_ = gee_iterator_get (_tmp16_);
#line 366 "../lib/synapse-core/data-sink.vala"
			action = (SynapseActionProvider*) _tmp17_;
#line 367 "../lib/synapse-core/data-sink.vala"
			_tmp18_ = action;
#line 367 "../lib/synapse-core/data-sink.vala"
			if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp18_) == plugin_type) {
#line 2226 "data-sink.c"
				SynapseActionProvider* _tmp19_;
#line 368 "../lib/synapse-core/data-sink.vala"
				_tmp19_ = action;
#line 368 "../lib/synapse-core/data-sink.vala"
				synapse_activatable_set_enabled ((SynapseActivatable*) _tmp19_, enabled);
#line 369 "../lib/synapse-core/data-sink.vala"
				if (enabled) {
#line 2234 "data-sink.c"
					SynapseActionProvider* _tmp20_;
#line 370 "../lib/synapse-core/data-sink.vala"
					_tmp20_ = action;
#line 370 "../lib/synapse-core/data-sink.vala"
					synapse_activatable_activate ((SynapseActivatable*) _tmp20_);
#line 2240 "data-sink.c"
				} else {
					SynapseActionProvider* _tmp21_;
#line 372 "../lib/synapse-core/data-sink.vala"
					_tmp21_ = action;
#line 372 "../lib/synapse-core/data-sink.vala"
					synapse_activatable_deactivate ((SynapseActivatable*) _tmp21_);
#line 2247 "data-sink.c"
				}
#line 374 "../lib/synapse-core/data-sink.vala"
				synapse_data_sink_update_has_unknown_handlers (self);
#line 376 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (action);
#line 376 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (_action_it);
#line 376 "../lib/synapse-core/data-sink.vala"
				return;
#line 2257 "data-sink.c"
			}
#line 366 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (action);
#line 2261 "data-sink.c"
		}
#line 366 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_action_it);
#line 2265 "data-sink.c"
	}
#line 381 "../lib/synapse-core/data-sink.vala"
	if (enabled) {
#line 2269 "data-sink.c"
		GObject* new_instance = NULL;
		GObject* _tmp22_;
		GObject* _tmp23_;
		GObject* _tmp24_;
#line 382 "../lib/synapse-core/data-sink.vala"
		_tmp22_ = synapse_data_sink_create_plugin (self, plugin_type);
#line 382 "../lib/synapse-core/data-sink.vala"
		new_instance = _tmp22_;
#line 383 "../lib/synapse-core/data-sink.vala"
		_tmp23_ = new_instance;
#line 383 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_register_plugin (self, _tmp23_);
#line 384 "../lib/synapse-core/data-sink.vala"
		_tmp24_ = new_instance;
#line 384 "../lib/synapse-core/data-sink.vala"
		synapse_activatable_activate (SYNAPSE_IS_ACTIVATABLE (_tmp24_) ? ((SynapseActivatable*) _tmp24_) : NULL);
#line 381 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (new_instance);
#line 2288 "data-sink.c"
	}
}

static void
synapse_data_sink_real_search_data_free (gpointer _data)
{
	SynapseDataSinkSearchData* _data_;
	_data_ = _data;
#line 286 "../lib/synapse-core/data-sink.vala"
	_g_free0 (_data_->query);
#line 286 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_data_->dest_result_set);
#line 286 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_data_->cancellable);
#line 286 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_data_->result);
#line 286 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_data_->self);
#line 286 "../lib/synapse-core/data-sink.vala"
	g_slice_free (SynapseDataSinkSearchData, _data_);
#line 2309 "data-sink.c"
}

static void
synapse_data_sink_real_search (SynapseSearchProvider* base,
                               const gchar* query,
                               SynapseQueryFlags flags,
                               SynapseResultSet* dest_result_set,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	SynapseDataSink * self;
	SynapseDataSinkSearchData* _data_;
	SynapseDataSink* _tmp0_;
	gchar* _tmp1_;
	SynapseResultSet* _tmp2_;
	GCancellable* _tmp3_;
#line 286 "../lib/synapse-core/data-sink.vala"
	self = (SynapseDataSink*) base;
#line 286 "../lib/synapse-core/data-sink.vala"
	_data_ = g_slice_new0 (SynapseDataSinkSearchData);
#line 286 "../lib/synapse-core/data-sink.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 286 "../lib/synapse-core/data-sink.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_data_sink_real_search_data_free);
#line 286 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 286 "../lib/synapse-core/data-sink.vala"
	_data_->self = _tmp0_;
#line 286 "../lib/synapse-core/data-sink.vala"
	_tmp1_ = g_strdup (query);
#line 286 "../lib/synapse-core/data-sink.vala"
	_g_free0 (_data_->query);
#line 286 "../lib/synapse-core/data-sink.vala"
	_data_->query = _tmp1_;
#line 286 "../lib/synapse-core/data-sink.vala"
	_data_->flags = flags;
#line 286 "../lib/synapse-core/data-sink.vala"
	_tmp2_ = _g_object_ref0 (dest_result_set);
#line 286 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_data_->dest_result_set);
#line 286 "../lib/synapse-core/data-sink.vala"
	_data_->dest_result_set = _tmp2_;
#line 286 "../lib/synapse-core/data-sink.vala"
	_tmp3_ = _g_object_ref0 (cancellable);
#line 286 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_data_->cancellable);
#line 286 "../lib/synapse-core/data-sink.vala"
	_data_->cancellable = _tmp3_;
#line 286 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_real_search_co (_data_);
#line 2361 "data-sink.c"
}

static GeeList*
synapse_data_sink_search_finish (SynapseSearchProvider* base,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	GeeList* result;
	SynapseDataSinkSearchData* _data_;
#line 286 "../lib/synapse-core/data-sink.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 286 "../lib/synapse-core/data-sink.vala"
	if (NULL == _data_) {
#line 286 "../lib/synapse-core/data-sink.vala"
		return NULL;
#line 2377 "data-sink.c"
	}
#line 286 "../lib/synapse-core/data-sink.vala"
	result = _data_->result;
#line 286 "../lib/synapse-core/data-sink.vala"
	_data_->result = NULL;
#line 286 "../lib/synapse-core/data-sink.vala"
	return result;
#line 2385 "data-sink.c"
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 391 "../lib/synapse-core/data-sink.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 391 "../lib/synapse-core/data-sink.vala"
	return _data3_;
#line 2395 "data-sink.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 391 "../lib/synapse-core/data-sink.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2403 "data-sink.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 391 "../lib/synapse-core/data-sink.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 2411 "data-sink.c"
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 391 "../lib/synapse-core/data-sink.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 2421 "data-sink.c"
		SynapseDataSink* self;
#line 391 "../lib/synapse-core/data-sink.vala"
		self = _data3_->self;
#line 391 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_data3_->current_result_set);
#line 391 "../lib/synapse-core/data-sink.vala"
		(_data3_->cancellables == NULL) ? NULL : (_data3_->cancellables = (_g_list_free__g_object_unref0_ (_data3_->cancellables), NULL));
#line 391 "../lib/synapse-core/data-sink.vala"
		synapse_query_destroy (&_data3_->q);
#line 391 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (self);
#line 391 "../lib/synapse-core/data-sink.vala"
		g_slice_free (Block3Data, _data3_);
#line 2435 "data-sink.c"
	}
}

static gboolean
_synapse_data_sink_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_data_sink_real_search_co (self);
#line 394 "../lib/synapse-core/data-sink.vala"
	return result;
#line 2446 "data-sink.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1359 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1360 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1360 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1361 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1362 "glib-2.0.vapi"
	result = _result_;
#line 1362 "glib-2.0.vapi"
	return result;
#line 2467 "data-sink.c"
}

static void
____lambda14_ (Block3Data* _data3_,
               GObject* src_obj,
               GAsyncResult* res)
{
	SynapseDataSink* self;
	SynapseItemProvider* plugin = NULL;
	SynapseItemProvider* _tmp0_;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	GError* _inner_error0_ = NULL;
#line 424 "../lib/synapse-core/data-sink.vala"
	self = _data3_->self;
#line 424 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (res != NULL);
#line 425 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = _g_object_ref0 (SYNAPSE_IS_ITEM_PROVIDER (src_obj) ? ((SynapseItemProvider*) src_obj) : NULL);
#line 425 "../lib/synapse-core/data-sink.vala"
	plugin = _tmp0_;
#line 2489 "data-sink.c"
	{
		SynapseResultSet* results = NULL;
		SynapseResultSet* _tmp1_;
		const gchar* _tmp2_;
		SynapseQuery _tmp3_;
		SynapseResultSet* _tmp4_;
#line 427 "../lib/synapse-core/data-sink.vala"
		_tmp1_ = synapse_item_provider_search_finish (plugin, res, &_inner_error0_);
#line 427 "../lib/synapse-core/data-sink.vala"
		results = _tmp1_;
#line 427 "../lib/synapse-core/data-sink.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 427 "../lib/synapse-core/data-sink.vala"
			if (_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 2504 "data-sink.c"
				goto __catch0_synapse_search_error;
			}
#line 427 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (plugin);
#line 427 "../lib/synapse-core/data-sink.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 427 "../lib/synapse-core/data-sink.vala"
			g_clear_error (&_inner_error0_);
#line 427 "../lib/synapse-core/data-sink.vala"
			return;
#line 2515 "data-sink.c"
		}
#line 428 "../lib/synapse-core/data-sink.vala"
		_tmp2_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) plugin));
#line 428 "../lib/synapse-core/data-sink.vala"
		_tmp3_ = _data3_->q;
#line 428 "../lib/synapse-core/data-sink.vala"
		g_signal_emit (self, synapse_data_sink_signals[SYNAPSE_DATA_SINK_SEARCH_DONE_SIGNAL], g_quark_from_string (_tmp2_), results, _tmp3_.query_id);
#line 429 "../lib/synapse-core/data-sink.vala"
		_tmp4_ = _data3_->current_result_set;
#line 429 "../lib/synapse-core/data-sink.vala"
		synapse_result_set_add_all (_tmp4_, results);
#line 426 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (results);
#line 2529 "data-sink.c"
	}
	goto __finally0;
	__catch0_synapse_search_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 426 "../lib/synapse-core/data-sink.vala"
		err = _inner_error0_;
#line 426 "../lib/synapse-core/data-sink.vala"
		_inner_error0_ = NULL;
#line 431 "../lib/synapse-core/data-sink.vala"
		_tmp5_ = err;
#line 431 "../lib/synapse-core/data-sink.vala"
		if (!g_error_matches (_tmp5_, SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED)) {
#line 2544 "data-sink.c"
			const gchar* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
#line 432 "../lib/synapse-core/data-sink.vala"
			_tmp6_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) plugin));
#line 432 "../lib/synapse-core/data-sink.vala"
			_tmp7_ = err;
#line 432 "../lib/synapse-core/data-sink.vala"
			_tmp8_ = _tmp7_->message;
#line 432 "../lib/synapse-core/data-sink.vala"
			g_warning ("data-sink.vala:432: %s returned error: %s", _tmp6_, _tmp8_);
#line 2556 "data-sink.c"
		}
#line 426 "../lib/synapse-core/data-sink.vala"
		_g_error_free0 (err);
#line 2560 "data-sink.c"
	}
	__finally0:
#line 426 "../lib/synapse-core/data-sink.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 426 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (plugin);
#line 426 "../lib/synapse-core/data-sink.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 426 "../lib/synapse-core/data-sink.vala"
		g_clear_error (&_inner_error0_);
#line 426 "../lib/synapse-core/data-sink.vala"
		return;
#line 2573 "data-sink.c"
	}
#line 437 "../lib/synapse-core/data-sink.vala"
	_data3_->search_size = _data3_->search_size - 1;
#line 437 "../lib/synapse-core/data-sink.vala"
	_tmp10_ = _data3_->search_size;
#line 437 "../lib/synapse-core/data-sink.vala"
	if (_tmp10_ == 0) {
#line 437 "../lib/synapse-core/data-sink.vala"
		_tmp9_ = _data3_->waiting;
#line 2583 "data-sink.c"
	} else {
#line 437 "../lib/synapse-core/data-sink.vala"
		_tmp9_ = FALSE;
#line 2587 "data-sink.c"
	}
#line 437 "../lib/synapse-core/data-sink.vala"
	if (_tmp9_) {
#line 438 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_real_search_co (_data3_->_async_data_);
#line 2593 "data-sink.c"
	}
#line 424 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (plugin);
#line 2597 "data-sink.c"
}

static void
_____lambda14__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
#line 424 "../lib/synapse-core/data-sink.vala"
	____lambda14_ (self, source_object, res);
#line 424 "../lib/synapse-core/data-sink.vala"
	block3_data_unref (self);
#line 2609 "data-sink.c"
}

static void
___lambda15_ (Block3Data* _data3_)
{
	SynapseDataSink* self;
	GList* _tmp0_;
#line 445 "../lib/synapse-core/data-sink.vala"
	self = _data3_->self;
#line 446 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = _data3_->cancellables;
#line 2621 "data-sink.c"
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
#line 446 "../lib/synapse-core/data-sink.vala"
		c_collection = _tmp0_;
#line 446 "../lib/synapse-core/data-sink.vala"
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
#line 2629 "data-sink.c"
			GCancellable* _tmp1_;
			GCancellable* c = NULL;
#line 446 "../lib/synapse-core/data-sink.vala"
			_tmp1_ = _g_object_ref0 ((GCancellable*) c_it->data);
#line 446 "../lib/synapse-core/data-sink.vala"
			c = _tmp1_;
#line 2636 "data-sink.c"
			{
				GCancellable* _tmp2_;
#line 447 "../lib/synapse-core/data-sink.vala"
				_tmp2_ = c;
#line 447 "../lib/synapse-core/data-sink.vala"
				g_cancellable_cancel (_tmp2_);
#line 446 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (c);
#line 2645 "data-sink.c"
			}
		}
	}
}

static void
____lambda15__gfunc (gconstpointer data,
                     gpointer self)
{
#line 445 "../lib/synapse-core/data-sink.vala"
	___lambda15_ (self);
#line 2657 "data-sink.c"
}

static gboolean
synapse_data_sink_real_search_co (SynapseDataSinkSearchData* _data_)
{
#line 391 "../lib/synapse-core/data-sink.vala"
	switch (_data_->_state_) {
#line 391 "../lib/synapse-core/data-sink.vala"
		case 0:
#line 2667 "data-sink.c"
		goto _state_0;
#line 391 "../lib/synapse-core/data-sink.vala"
		case 1:
#line 2671 "data-sink.c"
		goto _state_1;
#line 391 "../lib/synapse-core/data-sink.vala"
		case 2:
#line 2675 "data-sink.c"
		goto _state_2;
		default:
#line 391 "../lib/synapse-core/data-sink.vala"
		g_assert_not_reached ();
#line 2680 "data-sink.c"
	}
	_state_0:
#line 391 "../lib/synapse-core/data-sink.vala"
	_data_->_data3_ = g_slice_new0 (Block3Data);
#line 391 "../lib/synapse-core/data-sink.vala"
	_data_->_data3_->_ref_count_ = 1;
#line 391 "../lib/synapse-core/data-sink.vala"
	_data_->_data3_->self = g_object_ref (_data_->self);
#line 391 "../lib/synapse-core/data-sink.vala"
	_data_->_data3_->_async_data_ = _data_;
#line 393 "../lib/synapse-core/data-sink.vala"
	while (TRUE) {
#line 393 "../lib/synapse-core/data-sink.vala"
		if (!(!_data_->self->priv->plugins_loaded)) {
#line 393 "../lib/synapse-core/data-sink.vala"
			break;
#line 2697 "data-sink.c"
		}
#line 394 "../lib/synapse-core/data-sink.vala"
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _synapse_data_sink_real_search_co_gsource_func, _data_, NULL);
#line 395 "../lib/synapse-core/data-sink.vala"
		_data_->_state_ = 1;
#line 395 "../lib/synapse-core/data-sink.vala"
		return FALSE;
#line 2705 "data-sink.c"
		_state_1:
		;
#line 396 "../lib/synapse-core/data-sink.vala"
		if (_data_->cancellable != NULL) {
#line 396 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp0_ = g_cancellable_is_cancelled (_data_->cancellable);
#line 2712 "data-sink.c"
		} else {
#line 396 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp0_ = FALSE;
#line 2716 "data-sink.c"
		}
#line 396 "../lib/synapse-core/data-sink.vala"
		if (_data_->_tmp0_) {
#line 397 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp1_ = g_error_new_literal (SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED, "Cancelled");
#line 397 "../lib/synapse-core/data-sink.vala"
			_data_->_inner_error0_ = _data_->_tmp1_;
#line 397 "../lib/synapse-core/data-sink.vala"
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 397 "../lib/synapse-core/data-sink.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 397 "../lib/synapse-core/data-sink.vala"
				block3_data_unref (_data_->_data3_);
#line 397 "../lib/synapse-core/data-sink.vala"
				_data_->_data3_ = NULL;
#line 397 "../lib/synapse-core/data-sink.vala"
				g_object_unref (_data_->_async_result);
#line 397 "../lib/synapse-core/data-sink.vala"
				return FALSE;
#line 2736 "data-sink.c"
			} else {
#line 397 "../lib/synapse-core/data-sink.vala"
				block3_data_unref (_data_->_data3_);
#line 397 "../lib/synapse-core/data-sink.vala"
				_data_->_data3_ = NULL;
#line 397 "../lib/synapse-core/data-sink.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 397 "../lib/synapse-core/data-sink.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 397 "../lib/synapse-core/data-sink.vala"
				g_object_unref (_data_->_async_result);
#line 397 "../lib/synapse-core/data-sink.vala"
				return FALSE;
#line 2750 "data-sink.c"
			}
		}
	}
#line 401 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp2_ = _data_->self->priv->query_id;
#line 401 "../lib/synapse-core/data-sink.vala"
	_data_->self->priv->query_id = _data_->_tmp2_ + 1;
#line 401 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp3_ = _data_->query;
#line 401 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp4_ = _data_->flags;
#line 401 "../lib/synapse-core/data-sink.vala"
	synapse_query_init (&_data_->_data3_->q, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, (guint) 96);
#line 402 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp5_ = string_strip (_data_->query);
#line 402 "../lib/synapse-core/data-sink.vala"
	_data_->query_stripped = _data_->_tmp5_;
#line 404 "../lib/synapse-core/data-sink.vala"
	_data_->_data3_->cancellables = NULL;
#line 406 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp7_ = _g_object_ref0 (_data_->dest_result_set);
#line 406 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp6_ = _data_->_tmp7_;
#line 406 "../lib/synapse-core/data-sink.vala"
	if (_data_->_tmp6_ == NULL) {
#line 406 "../lib/synapse-core/data-sink.vala"
		_data_->_tmp8_ = synapse_result_set_new ();
#line 406 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_data_->_tmp6_);
#line 406 "../lib/synapse-core/data-sink.vala"
		_data_->_tmp6_ = _data_->_tmp8_;
#line 2782 "data-sink.c"
	}
#line 406 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp9_ = _data_->_tmp6_;
#line 406 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp6_ = NULL;
#line 406 "../lib/synapse-core/data-sink.vala"
	_data_->_data3_->current_result_set = _data_->_tmp9_;
#line 407 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp10_ = _data_->self->priv->item_plugins;
#line 407 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp11_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp10_);
#line 407 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp12_ = _data_->_tmp11_;
#line 407 "../lib/synapse-core/data-sink.vala"
	_data_->_data3_->search_size = _data_->_tmp12_;
#line 410 "../lib/synapse-core/data-sink.vala"
	_data_->_data3_->waiting = FALSE;
#line 2800 "data-sink.c"
	{
#line 412 "../lib/synapse-core/data-sink.vala"
		_data_->_tmp13_ = _data_->self->priv->item_plugins;
#line 412 "../lib/synapse-core/data-sink.vala"
		_data_->_tmp14_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp13_);
#line 412 "../lib/synapse-core/data-sink.vala"
		_data_->_data_plugin_it = _data_->_tmp14_;
#line 412 "../lib/synapse-core/data-sink.vala"
		while (TRUE) {
#line 412 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp15_ = _data_->_data_plugin_it;
#line 412 "../lib/synapse-core/data-sink.vala"
			if (!gee_iterator_next (_data_->_tmp15_)) {
#line 412 "../lib/synapse-core/data-sink.vala"
				break;
#line 2816 "data-sink.c"
			}
#line 412 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp16_ = _data_->_data_plugin_it;
#line 412 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp17_ = gee_iterator_get (_data_->_tmp16_);
#line 412 "../lib/synapse-core/data-sink.vala"
			_data_->data_plugin = (SynapseItemProvider*) _data_->_tmp17_;
#line 413 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp20_ = _data_->data_plugin;
#line 413 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp21_ = synapse_activatable_get_enabled ((SynapseActivatable*) _data_->_tmp20_);
#line 413 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp22_ = _data_->_tmp21_;
#line 413 "../lib/synapse-core/data-sink.vala"
			if (!_data_->_tmp22_) {
#line 413 "../lib/synapse-core/data-sink.vala"
				_data_->_tmp19_ = TRUE;
#line 2834 "data-sink.c"
			} else {
#line 413 "../lib/synapse-core/data-sink.vala"
				if (g_strcmp0 (_data_->query, "") == 0) {
#line 413 "../lib/synapse-core/data-sink.vala"
					_data_->_tmp24_ = _data_->data_plugin;
#line 413 "../lib/synapse-core/data-sink.vala"
					_data_->_tmp23_ = !synapse_item_provider_handles_empty_query (_data_->_tmp24_);
#line 2842 "data-sink.c"
				} else {
#line 413 "../lib/synapse-core/data-sink.vala"
					_data_->_tmp23_ = FALSE;
#line 2846 "data-sink.c"
				}
#line 413 "../lib/synapse-core/data-sink.vala"
				_data_->_tmp19_ = _data_->_tmp23_;
#line 2850 "data-sink.c"
			}
#line 413 "../lib/synapse-core/data-sink.vala"
			if (_data_->_tmp19_) {
#line 413 "../lib/synapse-core/data-sink.vala"
				_data_->_tmp18_ = TRUE;
#line 2856 "data-sink.c"
			} else {
#line 413 "../lib/synapse-core/data-sink.vala"
				_data_->_tmp25_ = _data_->data_plugin;
#line 413 "../lib/synapse-core/data-sink.vala"
				_data_->_tmp26_ = _data_->_data3_->q;
#line 413 "../lib/synapse-core/data-sink.vala"
				_data_->_tmp18_ = !synapse_item_provider_handles_query (_data_->_tmp25_, &_data_->_tmp26_);
#line 2864 "data-sink.c"
			}
#line 413 "../lib/synapse-core/data-sink.vala"
			_data_->skip = _data_->_tmp18_;
#line 414 "../lib/synapse-core/data-sink.vala"
			if (_data_->skip) {
#line 415 "../lib/synapse-core/data-sink.vala"
				_data_->_tmp27_ = _data_->_data3_->search_size;
#line 415 "../lib/synapse-core/data-sink.vala"
				_data_->_data3_->search_size = _data_->_tmp27_ - 1;
#line 416 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (_data_->data_plugin);
#line 416 "../lib/synapse-core/data-sink.vala"
				continue;
#line 2878 "data-sink.c"
			}
#line 420 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp28_ = g_cancellable_new ();
#line 420 "../lib/synapse-core/data-sink.vala"
			_data_->c = _data_->_tmp28_;
#line 421 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp29_ = _data_->c;
#line 421 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp30_ = _g_object_ref0 (_data_->_tmp29_);
#line 421 "../lib/synapse-core/data-sink.vala"
			_data_->_data3_->cancellables = g_list_prepend (_data_->_data3_->cancellables, _data_->_tmp30_);
#line 422 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp31_ = _data_->c;
#line 422 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp32_ = _g_object_ref0 (_data_->_tmp31_);
#line 422 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (_data_->_data3_->q.cancellable);
#line 422 "../lib/synapse-core/data-sink.vala"
			_data_->_data3_->q.cancellable = _data_->_tmp32_;
#line 424 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp33_ = _data_->data_plugin;
#line 424 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp34_ = _data_->_data3_->q;
#line 424 "../lib/synapse-core/data-sink.vala"
			synapse_item_provider_search (_data_->_tmp33_, &_data_->_tmp34_, _____lambda14__gasync_ready_callback, block3_data_ref (_data_->_data3_));
#line 412 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (_data_->c);
#line 412 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (_data_->data_plugin);
#line 2908 "data-sink.c"
		}
#line 412 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_data_->_data_plugin_it);
#line 2912 "data-sink.c"
	}
#line 442 "../lib/synapse-core/data-sink.vala"
	_data_->_data3_->cancellables = g_list_reverse (_data_->_data3_->cancellables);
#line 444 "../lib/synapse-core/data-sink.vala"
	if (_data_->cancellable != NULL) {
#line 445 "../lib/synapse-core/data-sink.vala"
		g_cancellable_connect (_data_->cancellable, (GCallback) ____lambda15__gfunc, block3_data_ref (_data_->_data3_), block3_data_unref);
#line 2920 "data-sink.c"
	}
#line 452 "../lib/synapse-core/data-sink.vala"
	_data_->_data3_->waiting = TRUE;
#line 453 "../lib/synapse-core/data-sink.vala"
	if (_data_->_data3_->search_size > 0) {
#line 454 "../lib/synapse-core/data-sink.vala"
		_data_->_state_ = 2;
#line 454 "../lib/synapse-core/data-sink.vala"
		return FALSE;
#line 2930 "data-sink.c"
		_state_2:
		;
	}
#line 457 "../lib/synapse-core/data-sink.vala"
	if (_data_->cancellable != NULL) {
#line 457 "../lib/synapse-core/data-sink.vala"
		_data_->_tmp35_ = g_cancellable_is_cancelled (_data_->cancellable);
#line 2938 "data-sink.c"
	} else {
#line 457 "../lib/synapse-core/data-sink.vala"
		_data_->_tmp35_ = FALSE;
#line 2942 "data-sink.c"
	}
#line 457 "../lib/synapse-core/data-sink.vala"
	if (_data_->_tmp35_) {
#line 458 "../lib/synapse-core/data-sink.vala"
		_data_->_tmp36_ = g_error_new_literal (SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED, "Cancelled");
#line 458 "../lib/synapse-core/data-sink.vala"
		_data_->_inner_error0_ = _data_->_tmp36_;
#line 458 "../lib/synapse-core/data-sink.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 458 "../lib/synapse-core/data-sink.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 458 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (_data_->_tmp6_);
#line 458 "../lib/synapse-core/data-sink.vala"
			_g_free0 (_data_->query_stripped);
#line 458 "../lib/synapse-core/data-sink.vala"
			block3_data_unref (_data_->_data3_);
#line 458 "../lib/synapse-core/data-sink.vala"
			_data_->_data3_ = NULL;
#line 458 "../lib/synapse-core/data-sink.vala"
			g_object_unref (_data_->_async_result);
#line 458 "../lib/synapse-core/data-sink.vala"
			return FALSE;
#line 2966 "data-sink.c"
		} else {
#line 458 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (_data_->_tmp6_);
#line 458 "../lib/synapse-core/data-sink.vala"
			_g_free0 (_data_->query_stripped);
#line 458 "../lib/synapse-core/data-sink.vala"
			block3_data_unref (_data_->_data3_);
#line 458 "../lib/synapse-core/data-sink.vala"
			_data_->_data3_ = NULL;
#line 458 "../lib/synapse-core/data-sink.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 458 "../lib/synapse-core/data-sink.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 458 "../lib/synapse-core/data-sink.vala"
			g_object_unref (_data_->_async_result);
#line 458 "../lib/synapse-core/data-sink.vala"
			return FALSE;
#line 2984 "data-sink.c"
		}
	}
#line 461 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp38_ = _data_->self->priv->_has_unknown_handlers;
#line 461 "../lib/synapse-core/data-sink.vala"
	if (_data_->_tmp38_) {
#line 461 "../lib/synapse-core/data-sink.vala"
		_data_->_tmp39_ = _data_->query_stripped;
#line 461 "../lib/synapse-core/data-sink.vala"
		_data_->_tmp37_ = g_strcmp0 (_data_->_tmp39_, "") != 0;
#line 2995 "data-sink.c"
	} else {
#line 461 "../lib/synapse-core/data-sink.vala"
		_data_->_tmp37_ = FALSE;
#line 2999 "data-sink.c"
	}
#line 461 "../lib/synapse-core/data-sink.vala"
	if (_data_->_tmp37_) {
#line 462 "../lib/synapse-core/data-sink.vala"
		_data_->_tmp40_ = synapse_default_match_new (_data_->query);
#line 462 "../lib/synapse-core/data-sink.vala"
		_data_->unknown_match = _data_->_tmp40_;
#line 463 "../lib/synapse-core/data-sink.vala"
		_data_->add_to_rs = FALSE;
#line 465 "../lib/synapse-core/data-sink.vala"
		if ((_data_->flags & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS) {
#line 465 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp41_ = TRUE;
#line 3013 "data-sink.c"
		} else {
#line 465 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp41_ = (_data_->flags & SYNAPSE_QUERY_FLAGS_TEXT) == SYNAPSE_QUERY_FLAGS_TEXT;
#line 3017 "data-sink.c"
		}
#line 465 "../lib/synapse-core/data-sink.vala"
		if (_data_->_tmp41_) {
#line 467 "../lib/synapse-core/data-sink.vala"
			_data_->add_to_rs = TRUE;
#line 3023 "data-sink.c"
		} else {
#line 470 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp42_ = _data_->unknown_match;
#line 470 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp43_ = synapse_data_sink_find_actions_for_unknown_match (_data_->self, (SynapseMatch*) _data_->_tmp42_, _data_->flags);
#line 470 "../lib/synapse-core/data-sink.vala"
			_data_->unknown_match_actions = _data_->_tmp43_;
#line 471 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp44_ = _data_->unknown_match_actions;
#line 471 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp45_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp44_);
#line 471 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp46_ = _data_->_tmp45_;
#line 471 "../lib/synapse-core/data-sink.vala"
			if (_data_->_tmp46_ > 0) {
#line 471 "../lib/synapse-core/data-sink.vala"
				_data_->add_to_rs = TRUE;
#line 3041 "data-sink.c"
			}
#line 465 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (_data_->unknown_match_actions);
#line 3045 "data-sink.c"
		}
#line 474 "../lib/synapse-core/data-sink.vala"
		if (_data_->add_to_rs) {
#line 474 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp47_ = _data_->_data3_->current_result_set;
#line 474 "../lib/synapse-core/data-sink.vala"
			_data_->_tmp48_ = _data_->unknown_match;
#line 474 "../lib/synapse-core/data-sink.vala"
			synapse_result_set_add (_data_->_tmp47_, (SynapseMatch*) _data_->_tmp48_, 0);
#line 3055 "data-sink.c"
		}
#line 461 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_data_->unknown_match);
#line 3059 "data-sink.c"
	}
#line 477 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp49_ = _data_->_data3_->current_result_set;
#line 477 "../lib/synapse-core/data-sink.vala"
	_data_->_tmp50_ = synapse_result_set_get_sorted_list (_data_->_tmp49_);
#line 477 "../lib/synapse-core/data-sink.vala"
	_data_->result = _data_->_tmp50_;
#line 477 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_data_->_tmp6_);
#line 477 "../lib/synapse-core/data-sink.vala"
	_g_free0 (_data_->query_stripped);
#line 477 "../lib/synapse-core/data-sink.vala"
	block3_data_unref (_data_->_data3_);
#line 477 "../lib/synapse-core/data-sink.vala"
	_data_->_data3_ = NULL;
#line 477 "../lib/synapse-core/data-sink.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 477 "../lib/synapse-core/data-sink.vala"
	if (_data_->_state_ != 0) {
#line 477 "../lib/synapse-core/data-sink.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 477 "../lib/synapse-core/data-sink.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3083 "data-sink.c"
		}
	}
#line 477 "../lib/synapse-core/data-sink.vala"
	g_object_unref (_data_->_async_result);
#line 477 "../lib/synapse-core/data-sink.vala"
	return FALSE;
#line 3090 "data-sink.c"
}

GeeList*
synapse_data_sink_find_actions_for_unknown_match (SynapseDataSink* self,
                                                  SynapseMatch* match,
                                                  SynapseQueryFlags flags)
{
	SynapseResultSet* rs = NULL;
	SynapseResultSet* _tmp0_;
	SynapseQuery q = {0};
	SynapseResultSet* _tmp14_;
	GeeList* _tmp15_;
	GeeList* result = NULL;
#line 480 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 480 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 481 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = synapse_result_set_new ();
#line 481 "../lib/synapse-core/data-sink.vala"
	rs = _tmp0_;
#line 482 "../lib/synapse-core/data-sink.vala"
	synapse_query_init (&q, (guint) 0, "", flags, (guint) 96);
#line 3114 "data-sink.c"
	{
		GeeIterator* _action_plugin_it = NULL;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
#line 484 "../lib/synapse-core/data-sink.vala"
		_tmp1_ = self->priv->action_plugins;
#line 484 "../lib/synapse-core/data-sink.vala"
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
#line 484 "../lib/synapse-core/data-sink.vala"
		_action_plugin_it = _tmp2_;
#line 484 "../lib/synapse-core/data-sink.vala"
		while (TRUE) {
#line 3127 "data-sink.c"
			GeeIterator* _tmp3_;
			SynapseActionProvider* action_plugin = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			SynapseActionProvider* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			SynapseActionProvider* _tmp9_;
			SynapseResultSet* _tmp10_;
			SynapseActionProvider* _tmp11_;
			SynapseResultSet* _tmp12_;
			SynapseResultSet* _tmp13_;
#line 484 "../lib/synapse-core/data-sink.vala"
			_tmp3_ = _action_plugin_it;
#line 484 "../lib/synapse-core/data-sink.vala"
			if (!gee_iterator_next (_tmp3_)) {
#line 484 "../lib/synapse-core/data-sink.vala"
				break;
#line 3146 "data-sink.c"
			}
#line 484 "../lib/synapse-core/data-sink.vala"
			_tmp4_ = _action_plugin_it;
#line 484 "../lib/synapse-core/data-sink.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 484 "../lib/synapse-core/data-sink.vala"
			action_plugin = (SynapseActionProvider*) _tmp5_;
#line 485 "../lib/synapse-core/data-sink.vala"
			_tmp6_ = action_plugin;
#line 485 "../lib/synapse-core/data-sink.vala"
			_tmp7_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp6_);
#line 485 "../lib/synapse-core/data-sink.vala"
			_tmp8_ = _tmp7_;
#line 485 "../lib/synapse-core/data-sink.vala"
			if (!_tmp8_) {
#line 486 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (action_plugin);
#line 486 "../lib/synapse-core/data-sink.vala"
				continue;
#line 3166 "data-sink.c"
			}
#line 488 "../lib/synapse-core/data-sink.vala"
			_tmp9_ = action_plugin;
#line 488 "../lib/synapse-core/data-sink.vala"
			if (!synapse_action_provider_handles_unknown (_tmp9_)) {
#line 489 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (action_plugin);
#line 489 "../lib/synapse-core/data-sink.vala"
				continue;
#line 3176 "data-sink.c"
			}
#line 491 "../lib/synapse-core/data-sink.vala"
			_tmp10_ = rs;
#line 491 "../lib/synapse-core/data-sink.vala"
			_tmp11_ = action_plugin;
#line 491 "../lib/synapse-core/data-sink.vala"
			_tmp12_ = synapse_action_provider_find_for_match (_tmp11_, &q, match);
#line 491 "../lib/synapse-core/data-sink.vala"
			_tmp13_ = _tmp12_;
#line 491 "../lib/synapse-core/data-sink.vala"
			synapse_result_set_add_all (_tmp10_, _tmp13_);
#line 491 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (_tmp13_);
#line 484 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (action_plugin);
#line 3192 "data-sink.c"
		}
#line 484 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_action_plugin_it);
#line 3196 "data-sink.c"
	}
#line 494 "../lib/synapse-core/data-sink.vala"
	_tmp14_ = rs;
#line 494 "../lib/synapse-core/data-sink.vala"
	_tmp15_ = synapse_result_set_get_sorted_list (_tmp14_);
#line 494 "../lib/synapse-core/data-sink.vala"
	result = _tmp15_;
#line 494 "../lib/synapse-core/data-sink.vala"
	synapse_query_destroy (&q);
#line 494 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (rs);
#line 494 "../lib/synapse-core/data-sink.vala"
	return result;
#line 3210 "data-sink.c"
}

GeeList*
synapse_data_sink_find_actions_for_match (SynapseDataSink* self,
                                          SynapseMatch* match,
                                          const gchar* query,
                                          SynapseQueryFlags flags)
{
	SynapseResultSet* rs = NULL;
	SynapseResultSet* _tmp0_;
	const gchar* _tmp1_ = NULL;
	SynapseQuery q = {0};
	SynapseResultSet* _tmp14_;
	GeeList* _tmp15_;
	GeeList* result = NULL;
#line 497 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 497 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 498 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = synapse_result_set_new ();
#line 498 "../lib/synapse-core/data-sink.vala"
	rs = _tmp0_;
#line 499 "../lib/synapse-core/data-sink.vala"
	_tmp1_ = query;
#line 499 "../lib/synapse-core/data-sink.vala"
	if (_tmp1_ == NULL) {
#line 499 "../lib/synapse-core/data-sink.vala"
		_tmp1_ = "";
#line 3240 "data-sink.c"
	}
#line 499 "../lib/synapse-core/data-sink.vala"
	synapse_query_init (&q, (guint) 0, _tmp1_, flags, (guint) 96);
#line 3244 "data-sink.c"
	{
		GeeIterator* _action_plugin_it = NULL;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
#line 501 "../lib/synapse-core/data-sink.vala"
		_tmp2_ = self->priv->action_plugins;
#line 501 "../lib/synapse-core/data-sink.vala"
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
#line 501 "../lib/synapse-core/data-sink.vala"
		_action_plugin_it = _tmp3_;
#line 501 "../lib/synapse-core/data-sink.vala"
		while (TRUE) {
#line 3257 "data-sink.c"
			GeeIterator* _tmp4_;
			SynapseActionProvider* action_plugin = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			SynapseActionProvider* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			SynapseResultSet* _tmp10_;
			SynapseActionProvider* _tmp11_;
			SynapseResultSet* _tmp12_;
			SynapseResultSet* _tmp13_;
#line 501 "../lib/synapse-core/data-sink.vala"
			_tmp4_ = _action_plugin_it;
#line 501 "../lib/synapse-core/data-sink.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 501 "../lib/synapse-core/data-sink.vala"
				break;
#line 3275 "data-sink.c"
			}
#line 501 "../lib/synapse-core/data-sink.vala"
			_tmp5_ = _action_plugin_it;
#line 501 "../lib/synapse-core/data-sink.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 501 "../lib/synapse-core/data-sink.vala"
			action_plugin = (SynapseActionProvider*) _tmp6_;
#line 502 "../lib/synapse-core/data-sink.vala"
			_tmp7_ = action_plugin;
#line 502 "../lib/synapse-core/data-sink.vala"
			_tmp8_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp7_);
#line 502 "../lib/synapse-core/data-sink.vala"
			_tmp9_ = _tmp8_;
#line 502 "../lib/synapse-core/data-sink.vala"
			if (!_tmp9_) {
#line 503 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (action_plugin);
#line 503 "../lib/synapse-core/data-sink.vala"
				continue;
#line 3295 "data-sink.c"
			}
#line 506 "../lib/synapse-core/data-sink.vala"
			_tmp10_ = rs;
#line 506 "../lib/synapse-core/data-sink.vala"
			_tmp11_ = action_plugin;
#line 506 "../lib/synapse-core/data-sink.vala"
			_tmp12_ = synapse_action_provider_find_for_match (_tmp11_, &q, match);
#line 506 "../lib/synapse-core/data-sink.vala"
			_tmp13_ = _tmp12_;
#line 506 "../lib/synapse-core/data-sink.vala"
			synapse_result_set_add_all (_tmp10_, _tmp13_);
#line 506 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (_tmp13_);
#line 501 "../lib/synapse-core/data-sink.vala"
			_g_object_unref0 (action_plugin);
#line 3311 "data-sink.c"
		}
#line 501 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_action_plugin_it);
#line 3315 "data-sink.c"
	}
#line 509 "../lib/synapse-core/data-sink.vala"
	_tmp14_ = rs;
#line 509 "../lib/synapse-core/data-sink.vala"
	_tmp15_ = synapse_result_set_get_sorted_list (_tmp14_);
#line 509 "../lib/synapse-core/data-sink.vala"
	result = _tmp15_;
#line 509 "../lib/synapse-core/data-sink.vala"
	synapse_query_destroy (&q);
#line 509 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (rs);
#line 509 "../lib/synapse-core/data-sink.vala"
	return result;
#line 3329 "data-sink.c"
}

gboolean
synapse_data_sink_get_has_empty_handlers (SynapseDataSink* self)
{
	gboolean result;
#line 240 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 240 "../lib/synapse-core/data-sink.vala"
	result = self->priv->_has_empty_handlers;
#line 240 "../lib/synapse-core/data-sink.vala"
	return result;
#line 3342 "data-sink.c"
}

void
synapse_data_sink_set_has_empty_handlers (SynapseDataSink* self,
                                          gboolean value)
{
	gboolean old_value;
#line 240 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 240 "../lib/synapse-core/data-sink.vala"
	old_value = synapse_data_sink_get_has_empty_handlers (self);
#line 240 "../lib/synapse-core/data-sink.vala"
	if (old_value != value) {
#line 240 "../lib/synapse-core/data-sink.vala"
		self->priv->_has_empty_handlers = value;
#line 240 "../lib/synapse-core/data-sink.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_data_sink_properties[SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY]);
#line 3360 "data-sink.c"
	}
}

gboolean
synapse_data_sink_get_has_unknown_handlers (SynapseDataSink* self)
{
	gboolean result;
#line 241 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 241 "../lib/synapse-core/data-sink.vala"
	result = self->priv->_has_unknown_handlers;
#line 241 "../lib/synapse-core/data-sink.vala"
	return result;
#line 3374 "data-sink.c"
}

void
synapse_data_sink_set_has_unknown_handlers (SynapseDataSink* self,
                                            gboolean value)
{
	gboolean old_value;
#line 241 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 241 "../lib/synapse-core/data-sink.vala"
	old_value = synapse_data_sink_get_has_unknown_handlers (self);
#line 241 "../lib/synapse-core/data-sink.vala"
	if (old_value != value) {
#line 241 "../lib/synapse-core/data-sink.vala"
		self->priv->_has_unknown_handlers = value;
#line 241 "../lib/synapse-core/data-sink.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_data_sink_properties[SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY]);
#line 3392 "data-sink.c"
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT) (gpointer data1, gpointer arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 286 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (n_param_values == 3);
#line 286 "../lib/synapse-core/data-sink.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 286 "../lib/synapse-core/data-sink.vala"
		data1 = closure->data;
#line 286 "../lib/synapse-core/data-sink.vala"
		data2 = param_values->data[0].v_pointer;
#line 3418 "data-sink.c"
	} else {
#line 286 "../lib/synapse-core/data-sink.vala"
		data1 = param_values->data[0].v_pointer;
#line 286 "../lib/synapse-core/data-sink.vala"
		data2 = closure->data;
#line 3424 "data-sink.c"
	}
#line 286 "../lib/synapse-core/data-sink.vala"
	callback = (GMarshalFunc_VOID__OBJECT_UINT) (marshal_data ? marshal_data : cc->callback);
#line 286 "../lib/synapse-core/data-sink.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), data2);
#line 3430 "data-sink.c"
}

static inline gpointer
synapse_data_sink_plugin_registry_get_instance_private (SynapseDataSinkPluginRegistry* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDataSinkPluginRegistry_private_offset);
}

SynapseDataSinkPluginRegistry*
synapse_data_sink_plugin_registry_get_default (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_ = NULL;
	SynapseDataSinkPluginRegistry* _tmp1_;
	SynapseDataSinkPluginRegistry* _tmp2_;
	SynapseDataSinkPluginRegistry* _tmp4_;
	SynapseDataSinkPluginRegistry* result = NULL;
#line 76 "../lib/synapse-core/data-sink.vala"
	_tmp1_ = synapse_data_sink_plugin_registry_instance;
#line 76 "../lib/synapse-core/data-sink.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 76 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = _tmp2_;
#line 76 "../lib/synapse-core/data-sink.vala"
	if (_tmp0_ == NULL) {
#line 3455 "data-sink.c"
		SynapseDataSinkPluginRegistry* _tmp3_;
#line 76 "../lib/synapse-core/data-sink.vala"
		_tmp3_ = synapse_data_sink_plugin_registry_new ();
#line 76 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_tmp0_);
#line 76 "../lib/synapse-core/data-sink.vala"
		_tmp0_ = _tmp3_;
#line 3463 "data-sink.c"
	}
#line 76 "../lib/synapse-core/data-sink.vala"
	_tmp4_ = _tmp0_;
#line 76 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = NULL;
#line 76 "../lib/synapse-core/data-sink.vala"
	result = _tmp4_;
#line 76 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (_tmp0_);
#line 76 "../lib/synapse-core/data-sink.vala"
	return result;
#line 3475 "data-sink.c"
}

void
synapse_data_sink_plugin_registry_register_plugin (SynapseDataSinkPluginRegistry* self,
                                                   GType plugin_type,
                                                   const gchar* title,
                                                   const gchar* description,
                                                   const gchar* icon_name,
                                                   SynapsePluginRegisterFunc reg_func,
                                                   gboolean runnable,
                                                   const gchar* runnable_error)
{
	gint index = 0;
	SynapseDataSinkPluginRegistryPluginInfo* p = NULL;
	SynapseDataSinkPluginRegistryPluginInfo* _tmp12_;
	GeeList* _tmp13_;
#line 79 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 79 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (title != NULL);
#line 79 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (description != NULL);
#line 79 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (icon_name != NULL);
#line 79 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (runnable_error != NULL);
#line 81 "../lib/synapse-core/data-sink.vala"
	index = -1;
#line 3504 "data-sink.c"
	{
		gint i = 0;
#line 82 "../lib/synapse-core/data-sink.vala"
		i = 0;
#line 3509 "data-sink.c"
		{
			gboolean _tmp0_ = FALSE;
#line 82 "../lib/synapse-core/data-sink.vala"
			_tmp0_ = TRUE;
#line 82 "../lib/synapse-core/data-sink.vala"
			while (TRUE) {
#line 3516 "data-sink.c"
				GeeList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GeeList* _tmp5_;
				gpointer _tmp6_;
				SynapseDataSinkPluginRegistryPluginInfo* _tmp7_;
				gboolean _tmp8_;
#line 82 "../lib/synapse-core/data-sink.vala"
				if (!_tmp0_) {
#line 3526 "data-sink.c"
					gint _tmp1_;
#line 82 "../lib/synapse-core/data-sink.vala"
					_tmp1_ = i;
#line 82 "../lib/synapse-core/data-sink.vala"
					i = _tmp1_ + 1;
#line 3532 "data-sink.c"
				}
#line 82 "../lib/synapse-core/data-sink.vala"
				_tmp0_ = FALSE;
#line 82 "../lib/synapse-core/data-sink.vala"
				_tmp2_ = self->priv->plugins;
#line 82 "../lib/synapse-core/data-sink.vala"
				_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 82 "../lib/synapse-core/data-sink.vala"
				_tmp4_ = _tmp3_;
#line 82 "../lib/synapse-core/data-sink.vala"
				if (!(i < _tmp4_)) {
#line 82 "../lib/synapse-core/data-sink.vala"
					break;
#line 3546 "data-sink.c"
				}
#line 83 "../lib/synapse-core/data-sink.vala"
				_tmp5_ = self->priv->plugins;
#line 83 "../lib/synapse-core/data-sink.vala"
				_tmp6_ = gee_list_get (_tmp5_, i);
#line 83 "../lib/synapse-core/data-sink.vala"
				_tmp7_ = (SynapseDataSinkPluginRegistryPluginInfo*) _tmp6_;
#line 83 "../lib/synapse-core/data-sink.vala"
				_tmp8_ = _tmp7_->plugin_type == plugin_type;
#line 83 "../lib/synapse-core/data-sink.vala"
				_synapse_data_sink_plugin_registry_plugin_info_unref0 (_tmp7_);
#line 83 "../lib/synapse-core/data-sink.vala"
				if (_tmp8_) {
#line 84 "../lib/synapse-core/data-sink.vala"
					index = i;
#line 85 "../lib/synapse-core/data-sink.vala"
					break;
#line 3564 "data-sink.c"
				}
			}
		}
	}
#line 88 "../lib/synapse-core/data-sink.vala"
	if (index >= 0) {
#line 3571 "data-sink.c"
		GeeList* _tmp9_;
		gpointer _tmp10_;
		SynapseDataSinkPluginRegistryPluginInfo* _tmp11_;
#line 89 "../lib/synapse-core/data-sink.vala"
		_tmp9_ = self->priv->plugins;
#line 89 "../lib/synapse-core/data-sink.vala"
		_tmp10_ = gee_list_remove_at (_tmp9_, index);
#line 89 "../lib/synapse-core/data-sink.vala"
		_tmp11_ = (SynapseDataSinkPluginRegistryPluginInfo*) _tmp10_;
#line 89 "../lib/synapse-core/data-sink.vala"
		_synapse_data_sink_plugin_registry_plugin_info_unref0 (_tmp11_);
#line 3583 "data-sink.c"
	}
#line 92 "../lib/synapse-core/data-sink.vala"
	_tmp12_ = synapse_data_sink_plugin_registry_plugin_info_new (plugin_type, title, description, icon_name, reg_func, runnable, runnable_error);
#line 92 "../lib/synapse-core/data-sink.vala"
	p = _tmp12_;
#line 93 "../lib/synapse-core/data-sink.vala"
	_tmp13_ = self->priv->plugins;
#line 93 "../lib/synapse-core/data-sink.vala"
	gee_collection_add ((GeeCollection*) _tmp13_, p);
#line 79 "../lib/synapse-core/data-sink.vala"
	_synapse_data_sink_plugin_registry_plugin_info_unref0 (p);
#line 3595 "data-sink.c"
}

GeeList*
synapse_data_sink_plugin_registry_get_plugins (SynapseDataSinkPluginRegistry* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result = NULL;
#line 96 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 97 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = self->priv->plugins;
#line 97 "../lib/synapse-core/data-sink.vala"
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
#line 97 "../lib/synapse-core/data-sink.vala"
	_tmp2_ = _tmp1_;
#line 97 "../lib/synapse-core/data-sink.vala"
	result = _tmp2_;
#line 97 "../lib/synapse-core/data-sink.vala"
	return result;
#line 3617 "data-sink.c"
}

SynapseDataSinkPluginRegistryPluginInfo*
synapse_data_sink_plugin_registry_get_plugin_info_for_type (SynapseDataSinkPluginRegistry* self,
                                                            GType plugin_type)
{
	SynapseDataSinkPluginRegistryPluginInfo* result = NULL;
#line 100 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 3627 "data-sink.c"
	{
		GeeList* _pi_list = NULL;
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		gint _pi_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pi_index = 0;
#line 101 "../lib/synapse-core/data-sink.vala"
		_tmp0_ = self->priv->plugins;
#line 101 "../lib/synapse-core/data-sink.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 101 "../lib/synapse-core/data-sink.vala"
		_pi_list = _tmp1_;
#line 101 "../lib/synapse-core/data-sink.vala"
		_tmp2_ = _pi_list;
#line 101 "../lib/synapse-core/data-sink.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 101 "../lib/synapse-core/data-sink.vala"
		_tmp4_ = _tmp3_;
#line 101 "../lib/synapse-core/data-sink.vala"
		_pi_size = _tmp4_;
#line 101 "../lib/synapse-core/data-sink.vala"
		_pi_index = -1;
#line 101 "../lib/synapse-core/data-sink.vala"
		while (TRUE) {
#line 3655 "data-sink.c"
			gint _tmp5_;
			gint _tmp6_;
			SynapseDataSinkPluginRegistryPluginInfo* pi = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			SynapseDataSinkPluginRegistryPluginInfo* _tmp9_;
#line 101 "../lib/synapse-core/data-sink.vala"
			_pi_index = _pi_index + 1;
#line 101 "../lib/synapse-core/data-sink.vala"
			_tmp5_ = _pi_index;
#line 101 "../lib/synapse-core/data-sink.vala"
			_tmp6_ = _pi_size;
#line 101 "../lib/synapse-core/data-sink.vala"
			if (!(_tmp5_ < _tmp6_)) {
#line 101 "../lib/synapse-core/data-sink.vala"
				break;
#line 3672 "data-sink.c"
			}
#line 101 "../lib/synapse-core/data-sink.vala"
			_tmp7_ = _pi_list;
#line 101 "../lib/synapse-core/data-sink.vala"
			_tmp8_ = gee_list_get (_tmp7_, _pi_index);
#line 101 "../lib/synapse-core/data-sink.vala"
			pi = (SynapseDataSinkPluginRegistryPluginInfo*) _tmp8_;
#line 102 "../lib/synapse-core/data-sink.vala"
			_tmp9_ = pi;
#line 102 "../lib/synapse-core/data-sink.vala"
			if (_tmp9_->plugin_type == plugin_type) {
#line 103 "../lib/synapse-core/data-sink.vala"
				result = pi;
#line 103 "../lib/synapse-core/data-sink.vala"
				_g_object_unref0 (_pi_list);
#line 103 "../lib/synapse-core/data-sink.vala"
				return result;
#line 3690 "data-sink.c"
			}
#line 101 "../lib/synapse-core/data-sink.vala"
			_synapse_data_sink_plugin_registry_plugin_info_unref0 (pi);
#line 3694 "data-sink.c"
		}
#line 101 "../lib/synapse-core/data-sink.vala"
		_g_object_unref0 (_pi_list);
#line 3698 "data-sink.c"
	}
#line 107 "../lib/synapse-core/data-sink.vala"
	result = NULL;
#line 107 "../lib/synapse-core/data-sink.vala"
	return result;
#line 3704 "data-sink.c"
}

SynapseDataSinkPluginRegistry*
synapse_data_sink_plugin_registry_construct (GType object_type)
{
	SynapseDataSinkPluginRegistry * self = NULL;
#line 41 "../lib/synapse-core/data-sink.vala"
	self = (SynapseDataSinkPluginRegistry*) g_object_new (object_type, NULL);
#line 41 "../lib/synapse-core/data-sink.vala"
	return self;
#line 3715 "data-sink.c"
}

SynapseDataSinkPluginRegistry*
synapse_data_sink_plugin_registry_new (void)
{
#line 41 "../lib/synapse-core/data-sink.vala"
	return synapse_data_sink_plugin_registry_construct (SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY);
#line 3723 "data-sink.c"
}

SynapseDataSinkPluginRegistryPluginInfo*
synapse_data_sink_plugin_registry_plugin_info_construct (GType object_type,
                                                         GType type,
                                                         const gchar* title,
                                                         const gchar* desc,
                                                         const gchar* icon_name,
                                                         SynapsePluginRegisterFunc reg_func,
                                                         gboolean runnable,
                                                         const gchar* runnable_error)
{
	SynapseDataSinkPluginRegistryPluginInfo* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 51 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 51 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (desc != NULL, NULL);
#line 51 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (icon_name != NULL, NULL);
#line 51 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (runnable_error != NULL, NULL);
#line 51 "../lib/synapse-core/data-sink.vala"
	self = (SynapseDataSinkPluginRegistryPluginInfo*) g_type_create_instance (object_type);
#line 52 "../lib/synapse-core/data-sink.vala"
	self->plugin_type = type;
#line 53 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = g_strdup (title);
#line 53 "../lib/synapse-core/data-sink.vala"
	_g_free0 (self->title);
#line 53 "../lib/synapse-core/data-sink.vala"
	self->title = _tmp0_;
#line 54 "../lib/synapse-core/data-sink.vala"
	_tmp1_ = g_strdup (desc);
#line 54 "../lib/synapse-core/data-sink.vala"
	_g_free0 (self->description);
#line 54 "../lib/synapse-core/data-sink.vala"
	self->description = _tmp1_;
#line 55 "../lib/synapse-core/data-sink.vala"
	_tmp2_ = g_strdup (icon_name);
#line 55 "../lib/synapse-core/data-sink.vala"
	_g_free0 (self->icon_name);
#line 55 "../lib/synapse-core/data-sink.vala"
	self->icon_name = _tmp2_;
#line 56 "../lib/synapse-core/data-sink.vala"
	self->register_func = reg_func;
#line 57 "../lib/synapse-core/data-sink.vala"
	self->runnable = runnable;
#line 58 "../lib/synapse-core/data-sink.vala"
	_tmp3_ = g_strdup (runnable_error);
#line 58 "../lib/synapse-core/data-sink.vala"
	_g_free0 (self->runnable_error);
#line 58 "../lib/synapse-core/data-sink.vala"
	self->runnable_error = _tmp3_;
#line 51 "../lib/synapse-core/data-sink.vala"
	return self;
#line 3783 "data-sink.c"
}

SynapseDataSinkPluginRegistryPluginInfo*
synapse_data_sink_plugin_registry_plugin_info_new (GType type,
                                                   const gchar* title,
                                                   const gchar* desc,
                                                   const gchar* icon_name,
                                                   SynapsePluginRegisterFunc reg_func,
                                                   gboolean runnable,
                                                   const gchar* runnable_error)
{
#line 51 "../lib/synapse-core/data-sink.vala"
	return synapse_data_sink_plugin_registry_plugin_info_construct (SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO, type, title, desc, icon_name, reg_func, runnable, runnable_error);
#line 3797 "data-sink.c"
}

static void
synapse_data_sink_plugin_registry_value_plugin_info_init (GValue* value)
{
#line 42 "../lib/synapse-core/data-sink.vala"
	value->data[0].v_pointer = NULL;
#line 3805 "data-sink.c"
}

static void
synapse_data_sink_plugin_registry_value_plugin_info_free_value (GValue* value)
{
#line 42 "../lib/synapse-core/data-sink.vala"
	if (value->data[0].v_pointer) {
#line 42 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_plugin_registry_plugin_info_unref (value->data[0].v_pointer);
#line 3815 "data-sink.c"
	}
}

static void
synapse_data_sink_plugin_registry_value_plugin_info_copy_value (const GValue* src_value,
                                                                GValue* dest_value)
{
#line 42 "../lib/synapse-core/data-sink.vala"
	if (src_value->data[0].v_pointer) {
#line 42 "../lib/synapse-core/data-sink.vala"
		dest_value->data[0].v_pointer = synapse_data_sink_plugin_registry_plugin_info_ref (src_value->data[0].v_pointer);
#line 3827 "data-sink.c"
	} else {
#line 42 "../lib/synapse-core/data-sink.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3831 "data-sink.c"
	}
}

static gpointer
synapse_data_sink_plugin_registry_value_plugin_info_peek_pointer (const GValue* value)
{
#line 42 "../lib/synapse-core/data-sink.vala"
	return value->data[0].v_pointer;
#line 3840 "data-sink.c"
}

static gchar*
synapse_data_sink_plugin_registry_value_plugin_info_collect_value (GValue* value,
                                                                   guint n_collect_values,
                                                                   GTypeCValue* collect_values,
                                                                   guint collect_flags)
{
#line 42 "../lib/synapse-core/data-sink.vala"
	if (collect_values[0].v_pointer) {
#line 3851 "data-sink.c"
		SynapseDataSinkPluginRegistryPluginInfo * object;
		object = collect_values[0].v_pointer;
#line 42 "../lib/synapse-core/data-sink.vala"
		if (object->parent_instance.g_class == NULL) {
#line 42 "../lib/synapse-core/data-sink.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3858 "data-sink.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 42 "../lib/synapse-core/data-sink.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3862 "data-sink.c"
		}
#line 42 "../lib/synapse-core/data-sink.vala"
		value->data[0].v_pointer = synapse_data_sink_plugin_registry_plugin_info_ref (object);
#line 3866 "data-sink.c"
	} else {
#line 42 "../lib/synapse-core/data-sink.vala"
		value->data[0].v_pointer = NULL;
#line 3870 "data-sink.c"
	}
#line 42 "../lib/synapse-core/data-sink.vala"
	return NULL;
#line 3874 "data-sink.c"
}

static gchar*
synapse_data_sink_plugin_registry_value_plugin_info_lcopy_value (const GValue* value,
                                                                 guint n_collect_values,
                                                                 GTypeCValue* collect_values,
                                                                 guint collect_flags)
{
	SynapseDataSinkPluginRegistryPluginInfo ** object_p;
	object_p = collect_values[0].v_pointer;
#line 42 "../lib/synapse-core/data-sink.vala"
	if (!object_p) {
#line 42 "../lib/synapse-core/data-sink.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3889 "data-sink.c"
	}
#line 42 "../lib/synapse-core/data-sink.vala"
	if (!value->data[0].v_pointer) {
#line 42 "../lib/synapse-core/data-sink.vala"
		*object_p = NULL;
#line 3895 "data-sink.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 42 "../lib/synapse-core/data-sink.vala"
		*object_p = value->data[0].v_pointer;
#line 3899 "data-sink.c"
	} else {
#line 42 "../lib/synapse-core/data-sink.vala"
		*object_p = synapse_data_sink_plugin_registry_plugin_info_ref (value->data[0].v_pointer);
#line 3903 "data-sink.c"
	}
#line 42 "../lib/synapse-core/data-sink.vala"
	return NULL;
#line 3907 "data-sink.c"
}

GParamSpec*
synapse_data_sink_plugin_registry_param_spec_plugin_info (const gchar* name,
                                                          const gchar* nick,
                                                          const gchar* blurb,
                                                          GType object_type,
                                                          GParamFlags flags)
{
	SynapseDataSinkPluginRegistryParamSpecPluginInfo* spec;
#line 42 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO), NULL);
#line 42 "../lib/synapse-core/data-sink.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 42 "../lib/synapse-core/data-sink.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 42 "../lib/synapse-core/data-sink.vala"
	return G_PARAM_SPEC (spec);
#line 3926 "data-sink.c"
}

gpointer
synapse_data_sink_plugin_registry_value_get_plugin_info (const GValue* value)
{
#line 42 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO), NULL);
#line 42 "../lib/synapse-core/data-sink.vala"
	return value->data[0].v_pointer;
#line 3936 "data-sink.c"
}

void
synapse_data_sink_plugin_registry_value_set_plugin_info (GValue* value,
                                                         gpointer v_object)
{
	SynapseDataSinkPluginRegistryPluginInfo * old;
#line 42 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO));
#line 42 "../lib/synapse-core/data-sink.vala"
	old = value->data[0].v_pointer;
#line 42 "../lib/synapse-core/data-sink.vala"
	if (v_object) {
#line 42 "../lib/synapse-core/data-sink.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO));
#line 42 "../lib/synapse-core/data-sink.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 42 "../lib/synapse-core/data-sink.vala"
		value->data[0].v_pointer = v_object;
#line 42 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_plugin_registry_plugin_info_ref (value->data[0].v_pointer);
#line 3958 "data-sink.c"
	} else {
#line 42 "../lib/synapse-core/data-sink.vala"
		value->data[0].v_pointer = NULL;
#line 3962 "data-sink.c"
	}
#line 42 "../lib/synapse-core/data-sink.vala"
	if (old) {
#line 42 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_plugin_registry_plugin_info_unref (old);
#line 3968 "data-sink.c"
	}
}

void
synapse_data_sink_plugin_registry_value_take_plugin_info (GValue* value,
                                                          gpointer v_object)
{
	SynapseDataSinkPluginRegistryPluginInfo * old;
#line 42 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO));
#line 42 "../lib/synapse-core/data-sink.vala"
	old = value->data[0].v_pointer;
#line 42 "../lib/synapse-core/data-sink.vala"
	if (v_object) {
#line 42 "../lib/synapse-core/data-sink.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO));
#line 42 "../lib/synapse-core/data-sink.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 42 "../lib/synapse-core/data-sink.vala"
		value->data[0].v_pointer = v_object;
#line 3989 "data-sink.c"
	} else {
#line 42 "../lib/synapse-core/data-sink.vala"
		value->data[0].v_pointer = NULL;
#line 3993 "data-sink.c"
	}
#line 42 "../lib/synapse-core/data-sink.vala"
	if (old) {
#line 42 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_plugin_registry_plugin_info_unref (old);
#line 3999 "data-sink.c"
	}
}

static void
synapse_data_sink_plugin_registry_plugin_info_class_init (SynapseDataSinkPluginRegistryPluginInfoClass * klass,
                                                          gpointer klass_data)
{
#line 42 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_plugin_registry_plugin_info_parent_class = g_type_class_peek_parent (klass);
#line 42 "../lib/synapse-core/data-sink.vala"
	((SynapseDataSinkPluginRegistryPluginInfoClass *) klass)->finalize = synapse_data_sink_plugin_registry_plugin_info_finalize;
#line 4011 "data-sink.c"
}

static void
synapse_data_sink_plugin_registry_plugin_info_instance_init (SynapseDataSinkPluginRegistryPluginInfo * self,
                                                             gpointer klass)
{
#line 42 "../lib/synapse-core/data-sink.vala"
	self->ref_count = 1;
#line 4020 "data-sink.c"
}

static void
synapse_data_sink_plugin_registry_plugin_info_finalize (SynapseDataSinkPluginRegistryPluginInfo * obj)
{
	SynapseDataSinkPluginRegistryPluginInfo * self;
#line 42 "../lib/synapse-core/data-sink.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO, SynapseDataSinkPluginRegistryPluginInfo);
#line 42 "../lib/synapse-core/data-sink.vala"
	g_signal_handlers_destroy (self);
#line 44 "../lib/synapse-core/data-sink.vala"
	_g_free0 (self->title);
#line 45 "../lib/synapse-core/data-sink.vala"
	_g_free0 (self->description);
#line 46 "../lib/synapse-core/data-sink.vala"
	_g_free0 (self->icon_name);
#line 49 "../lib/synapse-core/data-sink.vala"
	_g_free0 (self->runnable_error);
#line 4039 "data-sink.c"
}

static GType
synapse_data_sink_plugin_registry_plugin_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_data_sink_plugin_registry_value_plugin_info_init, synapse_data_sink_plugin_registry_value_plugin_info_free_value, synapse_data_sink_plugin_registry_value_plugin_info_copy_value, synapse_data_sink_plugin_registry_value_plugin_info_peek_pointer, "p", synapse_data_sink_plugin_registry_value_plugin_info_collect_value, "p", synapse_data_sink_plugin_registry_value_plugin_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDataSinkPluginRegistryPluginInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_data_sink_plugin_registry_plugin_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDataSinkPluginRegistryPluginInfo), 0, (GInstanceInitFunc) synapse_data_sink_plugin_registry_plugin_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_data_sink_plugin_registry_plugin_info_type_id;
	synapse_data_sink_plugin_registry_plugin_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseDataSinkPluginRegistryPluginInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return synapse_data_sink_plugin_registry_plugin_info_type_id;
}

GType
synapse_data_sink_plugin_registry_plugin_info_get_type (void)
{
	static volatile gsize synapse_data_sink_plugin_registry_plugin_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_data_sink_plugin_registry_plugin_info_type_id__volatile)) {
		GType synapse_data_sink_plugin_registry_plugin_info_type_id;
		synapse_data_sink_plugin_registry_plugin_info_type_id = synapse_data_sink_plugin_registry_plugin_info_get_type_once ();
		g_once_init_leave (&synapse_data_sink_plugin_registry_plugin_info_type_id__volatile, synapse_data_sink_plugin_registry_plugin_info_type_id);
	}
	return synapse_data_sink_plugin_registry_plugin_info_type_id__volatile;
}

gpointer
synapse_data_sink_plugin_registry_plugin_info_ref (gpointer instance)
{
	SynapseDataSinkPluginRegistryPluginInfo * self;
	self = instance;
#line 42 "../lib/synapse-core/data-sink.vala"
	g_atomic_int_inc (&self->ref_count);
#line 42 "../lib/synapse-core/data-sink.vala"
	return instance;
#line 4074 "data-sink.c"
}

void
synapse_data_sink_plugin_registry_plugin_info_unref (gpointer instance)
{
	SynapseDataSinkPluginRegistryPluginInfo * self;
	self = instance;
#line 42 "../lib/synapse-core/data-sink.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 42 "../lib/synapse-core/data-sink.vala"
		SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_PLUGIN_INFO_GET_CLASS (self)->finalize (self);
#line 42 "../lib/synapse-core/data-sink.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4088 "data-sink.c"
	}
}

static GObject *
synapse_data_sink_plugin_registry_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDataSinkPluginRegistry * self;
	GeeArrayList* _tmp0_;
#line 66 "../lib/synapse-core/data-sink.vala"
	parent_class = G_OBJECT_CLASS (synapse_data_sink_plugin_registry_parent_class);
#line 66 "../lib/synapse-core/data-sink.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 66 "../lib/synapse-core/data-sink.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistry);
#line 67 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_plugin_registry_instance = self;
#line 68 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = gee_array_list_new (SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO, (GBoxedCopyFunc) synapse_data_sink_plugin_registry_plugin_info_ref, (GDestroyNotify) synapse_data_sink_plugin_registry_plugin_info_unref, NULL, NULL, NULL);
#line 68 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->plugins);
#line 68 "../lib/synapse-core/data-sink.vala"
	self->priv->plugins = (GeeList*) _tmp0_;
#line 66 "../lib/synapse-core/data-sink.vala"
	return obj;
#line 4117 "data-sink.c"
}

static void
synapse_data_sink_plugin_registry_class_init (SynapseDataSinkPluginRegistryClass * klass,
                                              gpointer klass_data)
{
#line 41 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_plugin_registry_parent_class = g_type_class_peek_parent (klass);
#line 41 "../lib/synapse-core/data-sink.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDataSinkPluginRegistry_private_offset);
#line 41 "../lib/synapse-core/data-sink.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_data_sink_plugin_registry_constructor;
#line 41 "../lib/synapse-core/data-sink.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_data_sink_plugin_registry_finalize;
#line 4132 "data-sink.c"
}

static void
synapse_data_sink_plugin_registry_instance_init (SynapseDataSinkPluginRegistry * self,
                                                 gpointer klass)
{
#line 41 "../lib/synapse-core/data-sink.vala"
	self->priv = synapse_data_sink_plugin_registry_get_instance_private (self);
#line 4141 "data-sink.c"
}

static void
synapse_data_sink_plugin_registry_finalize (GObject * obj)
{
	SynapseDataSinkPluginRegistry * self;
#line 41 "../lib/synapse-core/data-sink.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistry);
#line 72 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_plugin_registry_instance = NULL;
#line 64 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->plugins);
#line 41 "../lib/synapse-core/data-sink.vala"
	G_OBJECT_CLASS (synapse_data_sink_plugin_registry_parent_class)->finalize (obj);
#line 4156 "data-sink.c"
}

static GType
synapse_data_sink_plugin_registry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDataSinkPluginRegistryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_data_sink_plugin_registry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDataSinkPluginRegistry), 0, (GInstanceInitFunc) synapse_data_sink_plugin_registry_instance_init, NULL };
	GType synapse_data_sink_plugin_registry_type_id;
	synapse_data_sink_plugin_registry_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDataSinkPluginRegistry", &g_define_type_info, 0);
	SynapseDataSinkPluginRegistry_private_offset = g_type_add_instance_private (synapse_data_sink_plugin_registry_type_id, sizeof (SynapseDataSinkPluginRegistryPrivate));
	return synapse_data_sink_plugin_registry_type_id;
}

GType
synapse_data_sink_plugin_registry_get_type (void)
{
	static volatile gsize synapse_data_sink_plugin_registry_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_data_sink_plugin_registry_type_id__volatile)) {
		GType synapse_data_sink_plugin_registry_type_id;
		synapse_data_sink_plugin_registry_type_id = synapse_data_sink_plugin_registry_get_type_once ();
		g_once_init_leave (&synapse_data_sink_plugin_registry_type_id__volatile, synapse_data_sink_plugin_registry_type_id);
	}
	return synapse_data_sink_plugin_registry_type_id__volatile;
}

static inline gpointer
synapse_data_sink_data_sink_configuration_get_instance_private (SynapseDataSinkDataSinkConfiguration* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDataSinkDataSinkConfiguration_private_offset);
}

static void
synapse_data_sink_data_sink_configuration_set_plugin_enabled (SynapseDataSinkDataSinkConfiguration* self,
                                                              GType t,
                                                              gboolean enabled)
{
#line 117 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 118 "../lib/synapse-core/data-sink.vala"
	if (enabled) {
#line 4196 "data-sink.c"
		const gchar* _tmp0_;
#line 119 "../lib/synapse-core/data-sink.vala"
		_tmp0_ = g_type_name (t);
#line 119 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_data_sink_configuration_enable_plugin (self, _tmp0_);
#line 4202 "data-sink.c"
	} else {
		const gchar* _tmp1_;
#line 121 "../lib/synapse-core/data-sink.vala"
		_tmp1_ = g_type_name (t);
#line 121 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_data_sink_configuration_disable_plugin (self, _tmp1_);
#line 4209 "data-sink.c"
	}
}

static gboolean
synapse_data_sink_data_sink_configuration_is_plugin_enabled (SynapseDataSinkDataSinkConfiguration* self,
                                                             GType t)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* plugin_name = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean result = FALSE;
#line 125 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 126 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = self->priv->_disabled_plugins;
#line 126 "../lib/synapse-core/data-sink.vala"
	_tmp0__length1 = self->priv->_disabled_plugins_length1;
#line 126 "../lib/synapse-core/data-sink.vala"
	if (_tmp0_ == NULL) {
#line 127 "../lib/synapse-core/data-sink.vala"
		result = TRUE;
#line 127 "../lib/synapse-core/data-sink.vala"
		return result;
#line 4236 "data-sink.c"
	}
#line 129 "../lib/synapse-core/data-sink.vala"
	_tmp1_ = g_type_name (t);
#line 129 "../lib/synapse-core/data-sink.vala"
	plugin_name = _tmp1_;
#line 130 "../lib/synapse-core/data-sink.vala"
	_tmp2_ = self->priv->_disabled_plugins;
#line 130 "../lib/synapse-core/data-sink.vala"
	_tmp2__length1 = self->priv->_disabled_plugins_length1;
#line 4246 "data-sink.c"
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
#line 130 "../lib/synapse-core/data-sink.vala"
		s_collection = _tmp2_;
#line 130 "../lib/synapse-core/data-sink.vala"
		s_collection_length1 = _tmp2__length1;
#line 130 "../lib/synapse-core/data-sink.vala"
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
#line 4258 "data-sink.c"
			gchar* _tmp3_;
			gchar* s = NULL;
#line 130 "../lib/synapse-core/data-sink.vala"
			_tmp3_ = g_strdup (s_collection[s_it]);
#line 130 "../lib/synapse-core/data-sink.vala"
			s = _tmp3_;
#line 4265 "data-sink.c"
			{
				const gchar* _tmp4_;
				const gchar* _tmp5_;
#line 131 "../lib/synapse-core/data-sink.vala"
				_tmp4_ = s;
#line 131 "../lib/synapse-core/data-sink.vala"
				_tmp5_ = plugin_name;
#line 131 "../lib/synapse-core/data-sink.vala"
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
#line 132 "../lib/synapse-core/data-sink.vala"
					result = FALSE;
#line 132 "../lib/synapse-core/data-sink.vala"
					_g_free0 (s);
#line 132 "../lib/synapse-core/data-sink.vala"
					return result;
#line 4281 "data-sink.c"
				}
#line 130 "../lib/synapse-core/data-sink.vala"
				_g_free0 (s);
#line 4285 "data-sink.c"
			}
		}
	}
#line 135 "../lib/synapse-core/data-sink.vala"
	result = TRUE;
#line 135 "../lib/synapse-core/data-sink.vala"
	return result;
#line 4293 "data-sink.c"
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gint stack_length,
                             const gchar* needle)
{
	gint i;
#line 142 "../lib/synapse-core/data-sink.vala"
	for (i = 0; i < stack_length; i++) {
#line 142 "../lib/synapse-core/data-sink.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 142 "../lib/synapse-core/data-sink.vala"
			return TRUE;
#line 4308 "data-sink.c"
		}
	}
#line 142 "../lib/synapse-core/data-sink.vala"
	return FALSE;
#line 4313 "data-sink.c"
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 149 "../lib/synapse-core/data-sink.vala"
	if ((*length) == (*size)) {
#line 149 "../lib/synapse-core/data-sink.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 149 "../lib/synapse-core/data-sink.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 4328 "data-sink.c"
	}
#line 149 "../lib/synapse-core/data-sink.vala"
	(*array)[(*length)++] = value;
#line 149 "../lib/synapse-core/data-sink.vala"
	(*array)[*length] = NULL;
#line 4334 "data-sink.c"
}

static void
synapse_data_sink_data_sink_configuration_enable_plugin (SynapseDataSinkDataSinkConfiguration* self,
                                                         const gchar* name)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** cpy = NULL;
	gchar** _tmp2_;
	gint cpy_length1;
	gint _cpy_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
#line 138 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 138 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (name != NULL);
#line 139 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = self->priv->_disabled_plugins;
#line 139 "../lib/synapse-core/data-sink.vala"
	_tmp0__length1 = self->priv->_disabled_plugins_length1;
#line 139 "../lib/synapse-core/data-sink.vala"
	if (_tmp0_ == NULL) {
#line 140 "../lib/synapse-core/data-sink.vala"
		return;
#line 4365 "data-sink.c"
	}
#line 142 "../lib/synapse-core/data-sink.vala"
	_tmp1_ = self->priv->_disabled_plugins;
#line 142 "../lib/synapse-core/data-sink.vala"
	_tmp1__length1 = self->priv->_disabled_plugins_length1;
#line 142 "../lib/synapse-core/data-sink.vala"
	if (!_vala_string_array_contains (_tmp1_, _tmp1__length1, name)) {
#line 143 "../lib/synapse-core/data-sink.vala"
		return;
#line 4375 "data-sink.c"
	}
#line 146 "../lib/synapse-core/data-sink.vala"
	_tmp2_ = g_new0 (gchar*, 0 + 1);
#line 146 "../lib/synapse-core/data-sink.vala"
	cpy = _tmp2_;
#line 146 "../lib/synapse-core/data-sink.vala"
	cpy_length1 = 0;
#line 146 "../lib/synapse-core/data-sink.vala"
	_cpy_size_ = cpy_length1;
#line 147 "../lib/synapse-core/data-sink.vala"
	_tmp3_ = self->priv->_disabled_plugins;
#line 147 "../lib/synapse-core/data-sink.vala"
	_tmp3__length1 = self->priv->_disabled_plugins_length1;
#line 4389 "data-sink.c"
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
#line 147 "../lib/synapse-core/data-sink.vala"
		s_collection = _tmp3_;
#line 147 "../lib/synapse-core/data-sink.vala"
		s_collection_length1 = _tmp3__length1;
#line 147 "../lib/synapse-core/data-sink.vala"
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
#line 4401 "data-sink.c"
			gchar* _tmp4_;
			gchar* s = NULL;
#line 147 "../lib/synapse-core/data-sink.vala"
			_tmp4_ = g_strdup (s_collection[s_it]);
#line 147 "../lib/synapse-core/data-sink.vala"
			s = _tmp4_;
#line 4408 "data-sink.c"
			{
				const gchar* _tmp5_;
#line 148 "../lib/synapse-core/data-sink.vala"
				_tmp5_ = s;
#line 148 "../lib/synapse-core/data-sink.vala"
				if (g_strcmp0 (_tmp5_, name) != 0) {
#line 4415 "data-sink.c"
					const gchar* _tmp6_;
					gchar* _tmp7_;
#line 149 "../lib/synapse-core/data-sink.vala"
					_tmp6_ = s;
#line 149 "../lib/synapse-core/data-sink.vala"
					_tmp7_ = g_strdup (_tmp6_);
#line 149 "../lib/synapse-core/data-sink.vala"
					_vala_array_add3 (&cpy, &cpy_length1, &_cpy_size_, _tmp7_);
#line 4424 "data-sink.c"
				}
#line 147 "../lib/synapse-core/data-sink.vala"
				_g_free0 (s);
#line 4428 "data-sink.c"
			}
		}
	}
#line 152 "../lib/synapse-core/data-sink.vala"
	_tmp8_ = cpy;
#line 152 "../lib/synapse-core/data-sink.vala"
	_tmp8__length1 = cpy_length1;
#line 152 "../lib/synapse-core/data-sink.vala"
	cpy = NULL;
#line 152 "../lib/synapse-core/data-sink.vala"
	cpy_length1 = 0;
#line 152 "../lib/synapse-core/data-sink.vala"
	self->priv->_disabled_plugins = (_vala_array_free (self->priv->_disabled_plugins, self->priv->_disabled_plugins_length1, (GDestroyNotify) g_free), NULL);
#line 152 "../lib/synapse-core/data-sink.vala"
	self->priv->_disabled_plugins = _tmp8_;
#line 152 "../lib/synapse-core/data-sink.vala"
	self->priv->_disabled_plugins_length1 = _tmp8__length1;
#line 152 "../lib/synapse-core/data-sink.vala"
	self->priv->__disabled_plugins_size_ = self->priv->_disabled_plugins_length1;
#line 138 "../lib/synapse-core/data-sink.vala"
	cpy = (_vala_array_free (cpy, cpy_length1, (GDestroyNotify) g_free), NULL);
#line 4450 "data-sink.c"
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 157 "../lib/synapse-core/data-sink.vala"
	if ((*length) == (*size)) {
#line 157 "../lib/synapse-core/data-sink.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 157 "../lib/synapse-core/data-sink.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 4465 "data-sink.c"
	}
#line 157 "../lib/synapse-core/data-sink.vala"
	(*array)[(*length)++] = value;
#line 157 "../lib/synapse-core/data-sink.vala"
	(*array)[*length] = NULL;
#line 4471 "data-sink.c"
}

static void
synapse_data_sink_data_sink_configuration_disable_plugin (SynapseDataSinkDataSinkConfiguration* self,
                                                          const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 155 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 155 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (name != NULL);
#line 156 "../lib/synapse-core/data-sink.vala"
	_tmp1_ = self->priv->_disabled_plugins;
#line 156 "../lib/synapse-core/data-sink.vala"
	_tmp1__length1 = self->priv->_disabled_plugins_length1;
#line 156 "../lib/synapse-core/data-sink.vala"
	if (_tmp1_ == NULL) {
#line 156 "../lib/synapse-core/data-sink.vala"
		_tmp0_ = TRUE;
#line 4493 "data-sink.c"
	} else {
		gchar** _tmp2_;
		gint _tmp2__length1;
#line 156 "../lib/synapse-core/data-sink.vala"
		_tmp2_ = self->priv->_disabled_plugins;
#line 156 "../lib/synapse-core/data-sink.vala"
		_tmp2__length1 = self->priv->_disabled_plugins_length1;
#line 156 "../lib/synapse-core/data-sink.vala"
		_tmp0_ = !_vala_string_array_contains (_tmp2_, _tmp2__length1, name);
#line 4503 "data-sink.c"
	}
#line 156 "../lib/synapse-core/data-sink.vala"
	if (_tmp0_) {
#line 4507 "data-sink.c"
		gchar* _tmp3_;
#line 157 "../lib/synapse-core/data-sink.vala"
		_tmp3_ = g_strdup (name);
#line 157 "../lib/synapse-core/data-sink.vala"
		_vala_array_add4 (&self->priv->_disabled_plugins, &self->priv->_disabled_plugins_length1, &self->priv->__disabled_plugins_size_, _tmp3_);
#line 4513 "data-sink.c"
	}
}

static SynapseDataSinkDataSinkConfiguration*
synapse_data_sink_data_sink_configuration_construct (GType object_type)
{
	SynapseDataSinkDataSinkConfiguration * self = NULL;
#line 111 "../lib/synapse-core/data-sink.vala"
	self = (SynapseDataSinkDataSinkConfiguration*) synapse_config_object_construct (object_type);
#line 111 "../lib/synapse-core/data-sink.vala"
	return self;
#line 4525 "data-sink.c"
}

static SynapseDataSinkDataSinkConfiguration*
synapse_data_sink_data_sink_configuration_new (void)
{
#line 111 "../lib/synapse-core/data-sink.vala"
	return synapse_data_sink_data_sink_configuration_construct (SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION);
#line 4533 "data-sink.c"
}

static gchar**
synapse_data_sink_data_sink_configuration_get_disabled_plugins (SynapseDataSinkDataSinkConfiguration* self,
                                                                gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 115 "../lib/synapse-core/data-sink.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 115 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = self->priv->_disabled_plugins;
#line 115 "../lib/synapse-core/data-sink.vala"
	_tmp0__length1 = self->priv->_disabled_plugins_length1;
#line 115 "../lib/synapse-core/data-sink.vala"
	_tmp1_ = _tmp0_;
#line 115 "../lib/synapse-core/data-sink.vala"
	_tmp1__length1 = _tmp0__length1;
#line 115 "../lib/synapse-core/data-sink.vala"
	if (result_length1) {
#line 115 "../lib/synapse-core/data-sink.vala"
		*result_length1 = _tmp1__length1;
#line 4559 "data-sink.c"
	}
#line 115 "../lib/synapse-core/data-sink.vala"
	result = _tmp1_;
#line 115 "../lib/synapse-core/data-sink.vala"
	return result;
#line 4565 "data-sink.c"
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gint length)
{
#line 115 "../lib/synapse-core/data-sink.vala"
	if (length >= 0) {
#line 4574 "data-sink.c"
		gchar** result;
		gint i;
#line 115 "../lib/synapse-core/data-sink.vala"
		result = g_new0 (gchar*, length + 1);
#line 115 "../lib/synapse-core/data-sink.vala"
		for (i = 0; i < length; i++) {
#line 4581 "data-sink.c"
			gchar* _tmp0_;
#line 115 "../lib/synapse-core/data-sink.vala"
			_tmp0_ = g_strdup (self[i]);
#line 115 "../lib/synapse-core/data-sink.vala"
			result[i] = _tmp0_;
#line 4587 "data-sink.c"
		}
#line 115 "../lib/synapse-core/data-sink.vala"
		return result;
#line 4591 "data-sink.c"
	}
#line 115 "../lib/synapse-core/data-sink.vala"
	return NULL;
#line 4595 "data-sink.c"
}

static void
synapse_data_sink_data_sink_configuration_set_disabled_plugins (SynapseDataSinkDataSinkConfiguration* self,
                                                                gchar** value,
                                                                gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
#line 115 "../lib/synapse-core/data-sink.vala"
	g_return_if_fail (self != NULL);
#line 115 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : ((gpointer) value);
#line 115 "../lib/synapse-core/data-sink.vala"
	_tmp0__length1 = value_length1;
#line 115 "../lib/synapse-core/data-sink.vala"
	self->priv->_disabled_plugins = (_vala_array_free (self->priv->_disabled_plugins, self->priv->_disabled_plugins_length1, (GDestroyNotify) g_free), NULL);
#line 115 "../lib/synapse-core/data-sink.vala"
	self->priv->_disabled_plugins = _tmp0_;
#line 115 "../lib/synapse-core/data-sink.vala"
	self->priv->_disabled_plugins_length1 = _tmp0__length1;
#line 115 "../lib/synapse-core/data-sink.vala"
	self->priv->__disabled_plugins_size_ = self->priv->_disabled_plugins_length1;
#line 115 "../lib/synapse-core/data-sink.vala"
	g_object_notify_by_pspec ((GObject *) self, synapse_data_sink_data_sink_configuration_properties[SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY]);
#line 4621 "data-sink.c"
}

static void
synapse_data_sink_data_sink_configuration_class_init (SynapseDataSinkDataSinkConfigurationClass * klass,
                                                      gpointer klass_data)
{
#line 111 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_data_sink_configuration_parent_class = g_type_class_peek_parent (klass);
#line 111 "../lib/synapse-core/data-sink.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDataSinkDataSinkConfiguration_private_offset);
#line 111 "../lib/synapse-core/data-sink.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_data_sink_data_sink_configuration_get_property;
#line 111 "../lib/synapse-core/data-sink.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_data_sink_data_sink_configuration_set_property;
#line 111 "../lib/synapse-core/data-sink.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_data_sink_data_sink_configuration_finalize;
#line 111 "../lib/synapse-core/data-sink.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY, synapse_data_sink_data_sink_configuration_properties[SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY] = g_param_spec_boxed ("disabled-plugins", "disabled-plugins", "disabled-plugins", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 4640 "data-sink.c"
}

static void
synapse_data_sink_data_sink_configuration_instance_init (SynapseDataSinkDataSinkConfiguration * self,
                                                         gpointer klass)
{
#line 111 "../lib/synapse-core/data-sink.vala"
	self->priv = synapse_data_sink_data_sink_configuration_get_instance_private (self);
#line 114 "../lib/synapse-core/data-sink.vala"
	self->priv->_disabled_plugins = NULL;
#line 114 "../lib/synapse-core/data-sink.vala"
	self->priv->_disabled_plugins_length1 = 0;
#line 114 "../lib/synapse-core/data-sink.vala"
	self->priv->__disabled_plugins_size_ = self->priv->_disabled_plugins_length1;
#line 4655 "data-sink.c"
}

static void
synapse_data_sink_data_sink_configuration_finalize (GObject * obj)
{
	SynapseDataSinkDataSinkConfiguration * self;
#line 111 "../lib/synapse-core/data-sink.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration);
#line 114 "../lib/synapse-core/data-sink.vala"
	self->priv->_disabled_plugins = (_vala_array_free (self->priv->_disabled_plugins, self->priv->_disabled_plugins_length1, (GDestroyNotify) g_free), NULL);
#line 111 "../lib/synapse-core/data-sink.vala"
	G_OBJECT_CLASS (synapse_data_sink_data_sink_configuration_parent_class)->finalize (obj);
#line 4668 "data-sink.c"
}

static GType
synapse_data_sink_data_sink_configuration_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDataSinkDataSinkConfigurationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_data_sink_data_sink_configuration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDataSinkDataSinkConfiguration), 0, (GInstanceInitFunc) synapse_data_sink_data_sink_configuration_instance_init, NULL };
	GType synapse_data_sink_data_sink_configuration_type_id;
	synapse_data_sink_data_sink_configuration_type_id = g_type_register_static (SYNAPSE_TYPE_CONFIG_OBJECT, "SynapseDataSinkDataSinkConfiguration", &g_define_type_info, 0);
	SynapseDataSinkDataSinkConfiguration_private_offset = g_type_add_instance_private (synapse_data_sink_data_sink_configuration_type_id, sizeof (SynapseDataSinkDataSinkConfigurationPrivate));
	return synapse_data_sink_data_sink_configuration_type_id;
}

static GType
synapse_data_sink_data_sink_configuration_get_type (void)
{
	static volatile gsize synapse_data_sink_data_sink_configuration_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_data_sink_data_sink_configuration_type_id__volatile)) {
		GType synapse_data_sink_data_sink_configuration_type_id;
		synapse_data_sink_data_sink_configuration_type_id = synapse_data_sink_data_sink_configuration_get_type_once ();
		g_once_init_leave (&synapse_data_sink_data_sink_configuration_type_id__volatile, synapse_data_sink_data_sink_configuration_type_id);
	}
	return synapse_data_sink_data_sink_configuration_type_id__volatile;
}

static void
_vala_synapse_data_sink_data_sink_configuration_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec)
{
	SynapseDataSinkDataSinkConfiguration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration);
#line 111 "../lib/synapse-core/data-sink.vala"
	switch (property_id) {
#line 111 "../lib/synapse-core/data-sink.vala"
		case SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY:
#line 4705 "data-sink.c"
		{
			int length;
#line 111 "../lib/synapse-core/data-sink.vala"
			g_value_set_boxed (value, synapse_data_sink_data_sink_configuration_get_disabled_plugins (self, &length));
#line 4710 "data-sink.c"
		}
#line 111 "../lib/synapse-core/data-sink.vala"
		break;
#line 4714 "data-sink.c"
		default:
#line 111 "../lib/synapse-core/data-sink.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 111 "../lib/synapse-core/data-sink.vala"
		break;
#line 4720 "data-sink.c"
	}
}

static void
_vala_synapse_data_sink_data_sink_configuration_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec)
{
	SynapseDataSinkDataSinkConfiguration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration);
#line 111 "../lib/synapse-core/data-sink.vala"
	switch (property_id) {
#line 111 "../lib/synapse-core/data-sink.vala"
		case SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY:
#line 4736 "data-sink.c"
		{
			gpointer boxed;
#line 111 "../lib/synapse-core/data-sink.vala"
			boxed = g_value_get_boxed (value);
#line 111 "../lib/synapse-core/data-sink.vala"
			synapse_data_sink_data_sink_configuration_set_disabled_plugins (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
#line 4743 "data-sink.c"
		}
#line 111 "../lib/synapse-core/data-sink.vala"
		break;
#line 4747 "data-sink.c"
		default:
#line 111 "../lib/synapse-core/data-sink.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 111 "../lib/synapse-core/data-sink.vala"
		break;
#line 4753 "data-sink.c"
	}
}

static GObject *
synapse_data_sink_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDataSink * self;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GType* _tmp2_;
	SynapseConfigService* cfg = NULL;
	SynapseConfigService* _tmp3_;
	SynapseConfigService* _tmp4_;
	SynapseConfigObject* _tmp5_;
	SynapseDataSinkPluginRegistry* _tmp6_;
	SynapseRelevancyService* _tmp7_;
	SynapseVolumeService* _tmp8_;
#line 181 "../lib/synapse-core/data-sink.vala"
	parent_class = G_OBJECT_CLASS (synapse_data_sink_parent_class);
#line 181 "../lib/synapse-core/data-sink.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 181 "../lib/synapse-core/data-sink.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DATA_SINK, SynapseDataSink);
#line 182 "../lib/synapse-core/data-sink.vala"
	_tmp0_ = gee_hash_set_new (SYNAPSE_TYPE_ITEM_PROVIDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 182 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->item_plugins);
#line 182 "../lib/synapse-core/data-sink.vala"
	self->priv->item_plugins = (GeeSet*) _tmp0_;
#line 183 "../lib/synapse-core/data-sink.vala"
	_tmp1_ = gee_hash_set_new (SYNAPSE_TYPE_ACTION_PROVIDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 183 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->action_plugins);
#line 183 "../lib/synapse-core/data-sink.vala"
	self->priv->action_plugins = (GeeSet*) _tmp1_;
#line 184 "../lib/synapse-core/data-sink.vala"
	_tmp2_ = g_new0 (GType, 0);
#line 184 "../lib/synapse-core/data-sink.vala"
	self->priv->plugin_types = (g_free (self->priv->plugin_types), NULL);
#line 184 "../lib/synapse-core/data-sink.vala"
	self->priv->plugin_types = _tmp2_;
#line 184 "../lib/synapse-core/data-sink.vala"
	self->priv->plugin_types_length1 = 0;
#line 184 "../lib/synapse-core/data-sink.vala"
	self->priv->_plugin_types_size_ = self->priv->plugin_types_length1;
#line 185 "../lib/synapse-core/data-sink.vala"
	self->priv->query_id = (guint) 0;
#line 187 "../lib/synapse-core/data-sink.vala"
	_tmp3_ = synapse_config_service_get_default ();
#line 187 "../lib/synapse-core/data-sink.vala"
	cfg = _tmp3_;
#line 188 "../lib/synapse-core/data-sink.vala"
	_tmp4_ = cfg;
#line 188 "../lib/synapse-core/data-sink.vala"
	_tmp5_ = synapse_config_service_get_config (_tmp4_, "data-sink", "global", SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION);
#line 188 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->config);
#line 188 "../lib/synapse-core/data-sink.vala"
	self->priv->config = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration);
#line 192 "../lib/synapse-core/data-sink.vala"
	_tmp6_ = synapse_data_sink_plugin_registry_get_default ();
#line 192 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->registry);
#line 192 "../lib/synapse-core/data-sink.vala"
	self->priv->registry = _tmp6_;
#line 193 "../lib/synapse-core/data-sink.vala"
	_tmp7_ = synapse_relevancy_service_get_default ();
#line 193 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->relevancy_service);
#line 193 "../lib/synapse-core/data-sink.vala"
	self->priv->relevancy_service = _tmp7_;
#line 194 "../lib/synapse-core/data-sink.vala"
	_tmp8_ = synapse_volume_service_get_default ();
#line 194 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->volume_service);
#line 194 "../lib/synapse-core/data-sink.vala"
	self->priv->volume_service = _tmp8_;
#line 196 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_initialize_caches (self, NULL, NULL);
#line 197 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_register_static_plugin (self, SYNAPSE_TYPE_COMMON_ACTIONS);
#line 181 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (cfg);
#line 181 "../lib/synapse-core/data-sink.vala"
	return obj;
#line 4843 "data-sink.c"
}

static void
synapse_data_sink_class_init (SynapseDataSinkClass * klass,
                              gpointer klass_data)
{
#line 40 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_parent_class = g_type_class_peek_parent (klass);
#line 40 "../lib/synapse-core/data-sink.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDataSink_private_offset);
#line 40 "../lib/synapse-core/data-sink.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_data_sink_get_property;
#line 40 "../lib/synapse-core/data-sink.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_data_sink_set_property;
#line 40 "../lib/synapse-core/data-sink.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_data_sink_constructor;
#line 40 "../lib/synapse-core/data-sink.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_data_sink_finalize;
#line 40 "../lib/synapse-core/data-sink.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY, synapse_data_sink_properties[SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY] = g_param_spec_boolean ("has-empty-handlers", "has-empty-handlers", "has-empty-handlers", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 40 "../lib/synapse-core/data-sink.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY, synapse_data_sink_properties[SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY] = g_param_spec_boolean ("has-unknown-handlers", "has-unknown-handlers", "has-unknown-handlers", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 40 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_signals[SYNAPSE_DATA_SINK_PLUGIN_REGISTERED_SIGNAL] = g_signal_new ("plugin-registered", SYNAPSE_TYPE_DATA_SINK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_OBJECT);
#line 40 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_signals[SYNAPSE_DATA_SINK_SEARCH_DONE_SIGNAL] = g_signal_new ("search-done", SYNAPSE_TYPE_DATA_SINK, G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT, G_TYPE_NONE, 2, SYNAPSE_TYPE_RESULT_SET, G_TYPE_UINT);
#line 4870 "data-sink.c"
}

static void
synapse_data_sink_synapse_search_provider_interface_init (SynapseSearchProviderIface * iface,
                                                          gpointer iface_data)
{
#line 286 "../lib/synapse-core/data-sink.vala"
	synapse_data_sink_synapse_search_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 286 "../lib/synapse-core/data-sink.vala"
	iface->search = (void (*) (SynapseSearchProvider*, const gchar*, SynapseQueryFlags, SynapseResultSet*, GCancellable*, GAsyncReadyCallback, gpointer)) synapse_data_sink_real_search;
#line 286 "../lib/synapse-core/data-sink.vala"
	iface->search_finish = (GeeList* (*) (SynapseSearchProvider*, GAsyncResult*, GError**)) synapse_data_sink_search_finish;
#line 4883 "data-sink.c"
}

static void
synapse_data_sink_instance_init (SynapseDataSink * self,
                                 gpointer klass)
{
#line 40 "../lib/synapse-core/data-sink.vala"
	self->priv = synapse_data_sink_get_instance_private (self);
#line 240 "../lib/synapse-core/data-sink.vala"
	self->priv->_has_empty_handlers = FALSE;
#line 241 "../lib/synapse-core/data-sink.vala"
	self->priv->_has_unknown_handlers = FALSE;
#line 243 "../lib/synapse-core/data-sink.vala"
	self->priv->plugins_loaded = FALSE;
#line 4898 "data-sink.c"
}

static void
synapse_data_sink_finalize (GObject * obj)
{
	SynapseDataSink * self;
#line 40 "../lib/synapse-core/data-sink.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DATA_SINK, SynapseDataSink);
#line 165 "../lib/synapse-core/data-sink.vala"
	synapse_utils_logger_debug ((GObject*) self, "data-sink.vala:165: DataSink died...", NULL);
#line 168 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->config);
#line 169 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->item_plugins);
#line 170 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->action_plugins);
#line 174 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->dbus_name_cache);
#line 175 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->desktop_file_service);
#line 176 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->registry);
#line 177 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->relevancy_service);
#line 178 "../lib/synapse-core/data-sink.vala"
	_g_object_unref0 (self->priv->volume_service);
#line 179 "../lib/synapse-core/data-sink.vala"
	self->priv->plugin_types = (g_free (self->priv->plugin_types), NULL);
#line 286 "../lib/synapse-core/data-sink.vala"
	G_OBJECT_CLASS (synapse_data_sink_parent_class)->finalize (obj);
#line 4929 "data-sink.c"
}

static GType
synapse_data_sink_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDataSinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_data_sink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDataSink), 0, (GInstanceInitFunc) synapse_data_sink_instance_init, NULL };
	static const GInterfaceInfo synapse_search_provider_info = { (GInterfaceInitFunc) synapse_data_sink_synapse_search_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_data_sink_type_id;
	synapse_data_sink_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDataSink", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_data_sink_type_id, SYNAPSE_TYPE_SEARCH_PROVIDER, &synapse_search_provider_info);
	SynapseDataSink_private_offset = g_type_add_instance_private (synapse_data_sink_type_id, sizeof (SynapseDataSinkPrivate));
	return synapse_data_sink_type_id;
}

GType
synapse_data_sink_get_type (void)
{
	static volatile gsize synapse_data_sink_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_data_sink_type_id__volatile)) {
		GType synapse_data_sink_type_id;
		synapse_data_sink_type_id = synapse_data_sink_get_type_once ();
		g_once_init_leave (&synapse_data_sink_type_id__volatile, synapse_data_sink_type_id);
	}
	return synapse_data_sink_type_id__volatile;
}

static void
_vala_synapse_data_sink_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	SynapseDataSink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DATA_SINK, SynapseDataSink);
#line 40 "../lib/synapse-core/data-sink.vala"
	switch (property_id) {
#line 40 "../lib/synapse-core/data-sink.vala"
		case SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY:
#line 40 "../lib/synapse-core/data-sink.vala"
		g_value_set_boolean (value, synapse_data_sink_get_has_empty_handlers (self));
#line 40 "../lib/synapse-core/data-sink.vala"
		break;
#line 40 "../lib/synapse-core/data-sink.vala"
		case SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY:
#line 40 "../lib/synapse-core/data-sink.vala"
		g_value_set_boolean (value, synapse_data_sink_get_has_unknown_handlers (self));
#line 40 "../lib/synapse-core/data-sink.vala"
		break;
#line 4978 "data-sink.c"
		default:
#line 40 "../lib/synapse-core/data-sink.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 40 "../lib/synapse-core/data-sink.vala"
		break;
#line 4984 "data-sink.c"
	}
}

static void
_vala_synapse_data_sink_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	SynapseDataSink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DATA_SINK, SynapseDataSink);
#line 40 "../lib/synapse-core/data-sink.vala"
	switch (property_id) {
#line 40 "../lib/synapse-core/data-sink.vala"
		case SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY:
#line 40 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_set_has_empty_handlers (self, g_value_get_boolean (value));
#line 40 "../lib/synapse-core/data-sink.vala"
		break;
#line 40 "../lib/synapse-core/data-sink.vala"
		case SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY:
#line 40 "../lib/synapse-core/data-sink.vala"
		synapse_data_sink_set_has_unknown_handlers (self, g_value_get_boolean (value));
#line 40 "../lib/synapse-core/data-sink.vala"
		break;
#line 5010 "data-sink.c"
		default:
#line 40 "../lib/synapse-core/data-sink.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 40 "../lib/synapse-core/data-sink.vala"
		break;
#line 5016 "data-sink.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 284 "../lib/synapse-core/data-sink.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 5027 "data-sink.c"
		gint i;
#line 284 "../lib/synapse-core/data-sink.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 284 "../lib/synapse-core/data-sink.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 284 "../lib/synapse-core/data-sink.vala"
				destroy_func (((gpointer*) array)[i]);
#line 5035 "data-sink.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 284 "../lib/synapse-core/data-sink.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 284 "../lib/synapse-core/data-sink.vala"
	g_free (array);
#line 5050 "data-sink.c"
}

