/* web-search.c generated by valac 0.48.13, the Vala compiler
 * generated from web-search.vala, do not modify */

/*
* Copyright (c) 2017 David Hewitt <davidmhewitt@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: David Hewitt <davidmhewitt@gmail.com>
*/

#include <glib-object.h>
#include "synapse-core.h"
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define SYNAPSE_TYPE_WEB_SEARCH_PLUGIN (synapse_web_search_plugin_get_type ())
#define SYNAPSE_WEB_SEARCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_WEB_SEARCH_PLUGIN, SynapseWebSearchPlugin))
#define SYNAPSE_WEB_SEARCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_WEB_SEARCH_PLUGIN, SynapseWebSearchPluginClass))
#define SYNAPSE_IS_WEB_SEARCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_WEB_SEARCH_PLUGIN))
#define SYNAPSE_IS_WEB_SEARCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_WEB_SEARCH_PLUGIN))
#define SYNAPSE_WEB_SEARCH_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_WEB_SEARCH_PLUGIN, SynapseWebSearchPluginClass))

typedef struct _SynapseWebSearchPlugin SynapseWebSearchPlugin;
typedef struct _SynapseWebSearchPluginClass SynapseWebSearchPluginClass;
typedef struct _SynapseWebSearchPluginPrivate SynapseWebSearchPluginPrivate;
enum  {
	SYNAPSE_WEB_SEARCH_PLUGIN_0_PROPERTY,
	SYNAPSE_WEB_SEARCH_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_WEB_SEARCH_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_web_search_plugin_properties[SYNAPSE_WEB_SEARCH_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_WEB_SEARCH_PLUGIN_TYPE_RESULT (synapse_web_search_plugin_result_get_type ())
#define SYNAPSE_WEB_SEARCH_PLUGIN_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_WEB_SEARCH_PLUGIN_TYPE_RESULT, SynapseWebSearchPluginResult))
#define SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_WEB_SEARCH_PLUGIN_TYPE_RESULT, SynapseWebSearchPluginResultClass))
#define SYNAPSE_WEB_SEARCH_PLUGIN_IS_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_WEB_SEARCH_PLUGIN_TYPE_RESULT))
#define SYNAPSE_WEB_SEARCH_PLUGIN_IS_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_WEB_SEARCH_PLUGIN_TYPE_RESULT))
#define SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_WEB_SEARCH_PLUGIN_TYPE_RESULT, SynapseWebSearchPluginResultClass))

typedef struct _SynapseWebSearchPluginResult SynapseWebSearchPluginResult;
typedef struct _SynapseWebSearchPluginResultClass SynapseWebSearchPluginResultClass;
typedef struct _SynapseWebSearchPluginSearchData SynapseWebSearchPluginSearchData;
typedef struct _SynapseWebSearchPluginResultPrivate SynapseWebSearchPluginResultPrivate;
enum  {
	SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_0_PROPERTY,
	SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_TITLE_PROPERTY,
	SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_DESCRIPTION_PROPERTY,
	SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_ICON_NAME_PROPERTY,
	SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_MATCH_TYPE_PROPERTY,
	SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_QUERY_TEMPLATE_PROPERTY,
	SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_NUM_PROPERTIES
};
static GParamSpec* synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SynapseWebSearchPlugin {
	GObject parent_instance;
	SynapseWebSearchPluginPrivate * priv;
};

struct _SynapseWebSearchPluginClass {
	GObjectClass parent_class;
};

struct _SynapseWebSearchPluginPrivate {
	gboolean _enabled;
};

struct _SynapseWebSearchPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseWebSearchPlugin* self;
	SynapseQuery query;
	SynapseResultSet* result;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp2_;
	SynapseWebSearchPluginResult* search_result;
	SynapseQuery _tmp3_;
	const gchar* _tmp4_;
	SynapseWebSearchPluginResult* _tmp5_;
	SynapseResultSet* _tmp6_;
	SynapseWebSearchPluginResult* _tmp7_;
};

struct _SynapseWebSearchPluginResult {
	GObject parent_instance;
	SynapseWebSearchPluginResultPrivate * priv;
};

struct _SynapseWebSearchPluginResultClass {
	GObjectClass parent_class;
};

struct _SynapseWebSearchPluginResultPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gchar* _query_template;
	gint _default_relevancy;
	GAppInfo* appinfo;
	gchar* search_term;
};

static gint SynapseWebSearchPlugin_private_offset;
static gpointer synapse_web_search_plugin_parent_class = NULL;
static gint SynapseWebSearchPluginResult_private_offset;
static gpointer synapse_web_search_plugin_result_parent_class = NULL;
static SynapseMatchIface * synapse_web_search_plugin_result_synapse_match_parent_iface = NULL;
static SynapseActivatableIface * synapse_web_search_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_web_search_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_web_search_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseWebSearchPlugin, g_object_unref)
static void synapse_web_search_plugin_real_activate (SynapseActivatable* base);
static void synapse_web_search_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_web_search_plugin_register_plugin (void);
static void _synapse_web_search_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_web_search_plugin_real_search_data_free (gpointer _data);
static void synapse_web_search_plugin_real_search (SynapseItemProvider* base,
                                            SynapseQuery* query,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean synapse_web_search_plugin_real_search_co (SynapseWebSearchPluginSearchData* _data_);
GType synapse_web_search_plugin_result_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseWebSearchPluginResult, g_object_unref)
SynapseWebSearchPluginResult* synapse_web_search_plugin_result_new (const gchar* search);
SynapseWebSearchPluginResult* synapse_web_search_plugin_result_construct (GType object_type,
                                                                          const gchar* search);
SynapseWebSearchPlugin* synapse_web_search_plugin_new (void);
SynapseWebSearchPlugin* synapse_web_search_plugin_construct (GType object_type);
static void synapse_web_search_plugin_result_real_execute (SynapseMatch* base,
                                                    SynapseMatch* match);
const gchar* synapse_web_search_plugin_result_get_query_template (SynapseWebSearchPluginResult* self);
void synapse_web_search_plugin_result_set_query_template (SynapseWebSearchPluginResult* self,
                                                          const gchar* value);
gint synapse_web_search_plugin_result_get_default_relevancy (SynapseWebSearchPluginResult* self);
void synapse_web_search_plugin_result_set_default_relevancy (SynapseWebSearchPluginResult* self,
                                                             gint value);
static void synapse_web_search_plugin_result_finalize (GObject * obj);
static GType synapse_web_search_plugin_result_get_type_once (void);
static void _vala_synapse_web_search_plugin_result_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_synapse_web_search_plugin_result_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static void synapse_web_search_plugin_finalize (GObject * obj);
static GType synapse_web_search_plugin_get_type_once (void);
static void _vala_synapse_web_search_plugin_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_synapse_web_search_plugin_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
synapse_web_search_plugin_get_instance_private (SynapseWebSearchPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseWebSearchPlugin_private_offset);
}

static void
synapse_web_search_plugin_real_activate (SynapseActivatable* base)
{
	SynapseWebSearchPlugin * self;
#line 28 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPlugin*) base;
#line 202 "web-search.c"
}

static void
synapse_web_search_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseWebSearchPlugin * self;
#line 30 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPlugin*) base;
#line 211 "web-search.c"
}

static void
_synapse_web_search_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 66 "../lib/synapse-plugins/web-search.vala"
	synapse_web_search_plugin_register_plugin ();
#line 219 "web-search.c"
}

static void
synapse_web_search_plugin_register_plugin (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDataSinkPluginRegistry* _tmp1_;
#line 66 "../lib/synapse-plugins/web-search.vala"
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
#line 66 "../lib/synapse-plugins/web-search.vala"
	_tmp1_ = _tmp0_;
#line 66 "../lib/synapse-plugins/web-search.vala"
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_WEB_SEARCH_PLUGIN, _ ("WebSearch"), _ ("Search the web for result"), "applications-internet", _synapse_web_search_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
#line 66 "../lib/synapse-plugins/web-search.vala"
	_g_object_unref0 (_tmp1_);
#line 235 "web-search.c"
}

static void
synapse_web_search_plugin_real_search_data_free (gpointer _data)
{
	SynapseWebSearchPluginSearchData* _data_;
	_data_ = _data;
#line 24 "../lib/synapse-plugins/web-search.vala"
	synapse_query_destroy (&_data_->query);
#line 24 "../lib/synapse-plugins/web-search.vala"
	_g_object_unref0 (_data_->result);
#line 24 "../lib/synapse-plugins/web-search.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../lib/synapse-plugins/web-search.vala"
	g_slice_free (SynapseWebSearchPluginSearchData, _data_);
#line 251 "web-search.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 24 "../lib/synapse-plugins/web-search.vala"
	return self ? g_object_ref (self) : NULL;
#line 259 "web-search.c"
}

static void
synapse_web_search_plugin_real_search (SynapseItemProvider* base,
                                       SynapseQuery* query,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	SynapseWebSearchPlugin * self;
	SynapseWebSearchPluginSearchData* _data_;
	SynapseWebSearchPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPlugin*) base;
#line 24 "../lib/synapse-plugins/web-search.vala"
	_data_ = g_slice_new0 (SynapseWebSearchPluginSearchData);
#line 24 "../lib/synapse-plugins/web-search.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "../lib/synapse-plugins/web-search.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_web_search_plugin_real_search_data_free);
#line 24 "../lib/synapse-plugins/web-search.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../lib/synapse-plugins/web-search.vala"
	_data_->self = _tmp0_;
#line 24 "../lib/synapse-plugins/web-search.vala"
	_tmp1_ = *query;
#line 24 "../lib/synapse-plugins/web-search.vala"
	_tmp2_ = _tmp1_;
#line 24 "../lib/synapse-plugins/web-search.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "../lib/synapse-plugins/web-search.vala"
	synapse_query_destroy (&_data_->query);
#line 24 "../lib/synapse-plugins/web-search.vala"
	_data_->query = _tmp3_;
#line 24 "../lib/synapse-plugins/web-search.vala"
	synapse_web_search_plugin_real_search_co (_data_);
#line 298 "web-search.c"
}

static SynapseResultSet*
synapse_web_search_plugin_search_finish (SynapseItemProvider* base,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	SynapseResultSet* result;
	SynapseWebSearchPluginSearchData* _data_;
#line 24 "../lib/synapse-plugins/web-search.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "../lib/synapse-plugins/web-search.vala"
	if (NULL == _data_) {
#line 24 "../lib/synapse-plugins/web-search.vala"
		return NULL;
#line 314 "web-search.c"
	}
#line 24 "../lib/synapse-plugins/web-search.vala"
	result = _data_->result;
#line 24 "../lib/synapse-plugins/web-search.vala"
	_data_->result = NULL;
#line 24 "../lib/synapse-plugins/web-search.vala"
	return result;
#line 322 "web-search.c"
}

static gboolean
synapse_web_search_plugin_real_search_co (SynapseWebSearchPluginSearchData* _data_)
{
#line 77 "../lib/synapse-plugins/web-search.vala"
	switch (_data_->_state_) {
#line 77 "../lib/synapse-plugins/web-search.vala"
		case 0:
#line 332 "web-search.c"
		goto _state_0;
		default:
#line 77 "../lib/synapse-plugins/web-search.vala"
		g_assert_not_reached ();
#line 337 "web-search.c"
	}
	_state_0:
#line 78 "../lib/synapse-plugins/web-search.vala"
	_data_->_tmp0_ = _data_->query;
#line 78 "../lib/synapse-plugins/web-search.vala"
	_data_->_tmp1_ = _data_->_tmp0_.query_type;
#line 78 "../lib/synapse-plugins/web-search.vala"
	if (_data_->_tmp1_ == SYNAPSE_QUERY_FLAGS_ACTIONS) {
#line 79 "../lib/synapse-plugins/web-search.vala"
		_data_->result = NULL;
#line 79 "../lib/synapse-plugins/web-search.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 79 "../lib/synapse-plugins/web-search.vala"
		if (_data_->_state_ != 0) {
#line 79 "../lib/synapse-plugins/web-search.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 79 "../lib/synapse-plugins/web-search.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 356 "web-search.c"
			}
		}
#line 79 "../lib/synapse-plugins/web-search.vala"
		g_object_unref (_data_->_async_result);
#line 79 "../lib/synapse-plugins/web-search.vala"
		return FALSE;
#line 363 "web-search.c"
	}
#line 81 "../lib/synapse-plugins/web-search.vala"
	_data_->_tmp2_ = synapse_result_set_new ();
#line 81 "../lib/synapse-plugins/web-search.vala"
	_data_->results = _data_->_tmp2_;
#line 82 "../lib/synapse-plugins/web-search.vala"
	_data_->_tmp3_ = _data_->query;
#line 82 "../lib/synapse-plugins/web-search.vala"
	_data_->_tmp4_ = _data_->_tmp3_.query_string;
#line 82 "../lib/synapse-plugins/web-search.vala"
	_data_->_tmp5_ = synapse_web_search_plugin_result_new (_data_->_tmp4_);
#line 82 "../lib/synapse-plugins/web-search.vala"
	_data_->search_result = _data_->_tmp5_;
#line 83 "../lib/synapse-plugins/web-search.vala"
	_data_->_tmp6_ = _data_->results;
#line 83 "../lib/synapse-plugins/web-search.vala"
	_data_->_tmp7_ = _data_->search_result;
#line 83 "../lib/synapse-plugins/web-search.vala"
	synapse_result_set_add (_data_->_tmp6_, (SynapseMatch*) _data_->_tmp7_, (gint) SYNAPSE_MATCH_SCORE_INCREMENT_MINOR);
#line 85 "../lib/synapse-plugins/web-search.vala"
	_data_->result = _data_->results;
#line 85 "../lib/synapse-plugins/web-search.vala"
	_g_object_unref0 (_data_->search_result);
#line 85 "../lib/synapse-plugins/web-search.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 85 "../lib/synapse-plugins/web-search.vala"
	if (_data_->_state_ != 0) {
#line 85 "../lib/synapse-plugins/web-search.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 85 "../lib/synapse-plugins/web-search.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 395 "web-search.c"
		}
	}
#line 85 "../lib/synapse-plugins/web-search.vala"
	g_object_unref (_data_->_async_result);
#line 85 "../lib/synapse-plugins/web-search.vala"
	return FALSE;
#line 402 "web-search.c"
}

SynapseWebSearchPlugin*
synapse_web_search_plugin_construct (GType object_type)
{
	SynapseWebSearchPlugin * self = NULL;
#line 24 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPlugin*) g_object_new (object_type, NULL);
#line 24 "../lib/synapse-plugins/web-search.vala"
	return self;
#line 413 "web-search.c"
}

SynapseWebSearchPlugin*
synapse_web_search_plugin_new (void)
{
#line 24 "../lib/synapse-plugins/web-search.vala"
	return synapse_web_search_plugin_construct (SYNAPSE_TYPE_WEB_SEARCH_PLUGIN);
#line 421 "web-search.c"
}

static gboolean
synapse_web_search_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseWebSearchPlugin* self;
#line 26 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPlugin*) base;
#line 26 "../lib/synapse-plugins/web-search.vala"
	result = self->priv->_enabled;
#line 26 "../lib/synapse-plugins/web-search.vala"
	return result;
#line 435 "web-search.c"
}

static void
synapse_web_search_plugin_real_set_enabled (SynapseActivatable* base,
                                            gboolean value)
{
	SynapseWebSearchPlugin* self;
	gboolean old_value;
#line 26 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPlugin*) base;
#line 26 "../lib/synapse-plugins/web-search.vala"
	old_value = synapse_web_search_plugin_real_get_enabled (base);
#line 26 "../lib/synapse-plugins/web-search.vala"
	if (old_value != value) {
#line 26 "../lib/synapse-plugins/web-search.vala"
		self->priv->_enabled = value;
#line 26 "../lib/synapse-plugins/web-search.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_web_search_plugin_properties[SYNAPSE_WEB_SEARCH_PLUGIN_ENABLED_PROPERTY]);
#line 454 "web-search.c"
	}
}

static inline gpointer
synapse_web_search_plugin_result_get_instance_private (SynapseWebSearchPluginResult* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseWebSearchPluginResult_private_offset);
}

SynapseWebSearchPluginResult*
synapse_web_search_plugin_result_construct (GType object_type,
                                            const gchar* search)
{
	SynapseWebSearchPluginResult * self = NULL;
	gchar* _tmp0_;
	gchar* _title = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _icon_name = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
#line 47 "../lib/synapse-plugins/web-search.vala"
	g_return_val_if_fail (search != NULL, NULL);
#line 47 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) g_object_new (object_type, NULL);
#line 48 "../lib/synapse-plugins/web-search.vala"
	_tmp0_ = g_strdup (search);
#line 48 "../lib/synapse-plugins/web-search.vala"
	_g_free0 (self->priv->search_term);
#line 48 "../lib/synapse-plugins/web-search.vala"
	self->priv->search_term = _tmp0_;
#line 50 "../lib/synapse-plugins/web-search.vala"
	_tmp1_ = self->priv->search_term;
#line 50 "../lib/synapse-plugins/web-search.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 50 "../lib/synapse-plugins/web-search.vala"
	_title = _tmp2_;
#line 51 "../lib/synapse-plugins/web-search.vala"
	_tmp3_ = g_strdup ("applications-internet");
#line 51 "../lib/synapse-plugins/web-search.vala"
	_icon_name = _tmp3_;
#line 53 "../lib/synapse-plugins/web-search.vala"
	synapse_match_set_title ((SynapseMatch*) self, _title);
#line 54 "../lib/synapse-plugins/web-search.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _icon_name);
#line 55 "../lib/synapse-plugins/web-search.vala"
	_tmp4_ = g_strconcat ("Search for: ", search, NULL);
#line 55 "../lib/synapse-plugins/web-search.vala"
	_tmp5_ = _tmp4_;
#line 55 "../lib/synapse-plugins/web-search.vala"
	synapse_match_set_description ((SynapseMatch*) self, _ (_tmp5_));
#line 55 "../lib/synapse-plugins/web-search.vala"
	_g_free0 (_tmp5_);
#line 56 "../lib/synapse-plugins/web-search.vala"
	synapse_match_set_has_thumbnail ((SynapseMatch*) self, TRUE);
#line 57 "../lib/synapse-plugins/web-search.vala"
	synapse_match_set_match_type ((SynapseMatch*) self, SYNAPSE_MATCH_TYPE_SEARCH);
#line 47 "../lib/synapse-plugins/web-search.vala"
	_g_free0 (_icon_name);
#line 47 "../lib/synapse-plugins/web-search.vala"
	_g_free0 (_title);
#line 47 "../lib/synapse-plugins/web-search.vala"
	return self;
#line 519 "web-search.c"
}

SynapseWebSearchPluginResult*
synapse_web_search_plugin_result_new (const gchar* search)
{
#line 47 "../lib/synapse-plugins/web-search.vala"
	return synapse_web_search_plugin_result_construct (SYNAPSE_WEB_SEARCH_PLUGIN_TYPE_RESULT, search);
#line 527 "web-search.c"
}

static void
synapse_web_search_plugin_result_real_execute (SynapseMatch* base,
                                               SynapseMatch* match)
{
	SynapseWebSearchPluginResult * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
#line 60 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) base;
#line 61 "../lib/synapse-plugins/web-search.vala"
	_tmp0_ = synapse_match_get_title ((SynapseMatch*) self);
#line 61 "../lib/synapse-plugins/web-search.vala"
	_tmp1_ = _tmp0_;
#line 61 "../lib/synapse-plugins/web-search.vala"
	_tmp2_ = g_strconcat ("https://www.ecosia.org/search?q=", _tmp1_, NULL);
#line 61 "../lib/synapse-plugins/web-search.vala"
	_tmp3_ = _tmp2_;
#line 61 "../lib/synapse-plugins/web-search.vala"
	g_app_info_launch_default_for_uri (_ (_tmp3_), NULL, &_inner_error0_);
#line 61 "../lib/synapse-plugins/web-search.vala"
	_g_free0 (_tmp3_);
#line 61 "../lib/synapse-plugins/web-search.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 61 "../lib/synapse-plugins/web-search.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 61 "../lib/synapse-plugins/web-search.vala"
		g_clear_error (&_inner_error0_);
#line 61 "../lib/synapse-plugins/web-search.vala"
		return;
#line 562 "web-search.c"
	}
}

static const gchar*
synapse_web_search_plugin_result_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseWebSearchPluginResult* self;
	const gchar* _tmp0_;
#line 34 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) base;
#line 34 "../lib/synapse-plugins/web-search.vala"
	_tmp0_ = self->priv->_title;
#line 34 "../lib/synapse-plugins/web-search.vala"
	result = _tmp0_;
#line 34 "../lib/synapse-plugins/web-search.vala"
	return result;
#line 580 "web-search.c"
}

static void
synapse_web_search_plugin_result_real_set_title (SynapseMatch* base,
                                                 const gchar* value)
{
	SynapseWebSearchPluginResult* self;
	gchar* old_value;
#line 34 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) base;
#line 34 "../lib/synapse-plugins/web-search.vala"
	old_value = synapse_web_search_plugin_result_real_get_title (base);
#line 34 "../lib/synapse-plugins/web-search.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 595 "web-search.c"
		gchar* _tmp0_;
#line 34 "../lib/synapse-plugins/web-search.vala"
		_tmp0_ = g_strdup (value);
#line 34 "../lib/synapse-plugins/web-search.vala"
		_g_free0 (self->priv->_title);
#line 34 "../lib/synapse-plugins/web-search.vala"
		self->priv->_title = _tmp0_;
#line 34 "../lib/synapse-plugins/web-search.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_TITLE_PROPERTY]);
#line 605 "web-search.c"
	}
}

static const gchar*
synapse_web_search_plugin_result_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseWebSearchPluginResult* self;
	const gchar* _tmp0_;
#line 35 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) base;
#line 35 "../lib/synapse-plugins/web-search.vala"
	_tmp0_ = self->priv->_description;
#line 35 "../lib/synapse-plugins/web-search.vala"
	result = _tmp0_;
#line 35 "../lib/synapse-plugins/web-search.vala"
	return result;
#line 623 "web-search.c"
}

static void
synapse_web_search_plugin_result_real_set_description (SynapseMatch* base,
                                                       const gchar* value)
{
	SynapseWebSearchPluginResult* self;
	gchar* old_value;
#line 35 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) base;
#line 35 "../lib/synapse-plugins/web-search.vala"
	old_value = synapse_web_search_plugin_result_real_get_description (base);
#line 35 "../lib/synapse-plugins/web-search.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 638 "web-search.c"
		gchar* _tmp0_;
#line 35 "../lib/synapse-plugins/web-search.vala"
		_tmp0_ = g_strdup (value);
#line 35 "../lib/synapse-plugins/web-search.vala"
		_g_free0 (self->priv->_description);
#line 35 "../lib/synapse-plugins/web-search.vala"
		self->priv->_description = _tmp0_;
#line 35 "../lib/synapse-plugins/web-search.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_DESCRIPTION_PROPERTY]);
#line 648 "web-search.c"
	}
}

static const gchar*
synapse_web_search_plugin_result_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseWebSearchPluginResult* self;
	const gchar* _tmp0_;
#line 36 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) base;
#line 36 "../lib/synapse-plugins/web-search.vala"
	_tmp0_ = self->priv->_icon_name;
#line 36 "../lib/synapse-plugins/web-search.vala"
	result = _tmp0_;
#line 36 "../lib/synapse-plugins/web-search.vala"
	return result;
#line 666 "web-search.c"
}

static void
synapse_web_search_plugin_result_real_set_icon_name (SynapseMatch* base,
                                                     const gchar* value)
{
	SynapseWebSearchPluginResult* self;
	gchar* old_value;
#line 36 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) base;
#line 36 "../lib/synapse-plugins/web-search.vala"
	old_value = synapse_web_search_plugin_result_real_get_icon_name (base);
#line 36 "../lib/synapse-plugins/web-search.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 681 "web-search.c"
		gchar* _tmp0_;
#line 36 "../lib/synapse-plugins/web-search.vala"
		_tmp0_ = g_strdup (value);
#line 36 "../lib/synapse-plugins/web-search.vala"
		_g_free0 (self->priv->_icon_name);
#line 36 "../lib/synapse-plugins/web-search.vala"
		self->priv->_icon_name = _tmp0_;
#line 36 "../lib/synapse-plugins/web-search.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_ICON_NAME_PROPERTY]);
#line 691 "web-search.c"
	}
}

static gboolean
synapse_web_search_plugin_result_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseWebSearchPluginResult* self;
#line 37 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) base;
#line 37 "../lib/synapse-plugins/web-search.vala"
	result = self->priv->_has_thumbnail;
#line 37 "../lib/synapse-plugins/web-search.vala"
	return result;
#line 706 "web-search.c"
}

static void
synapse_web_search_plugin_result_real_set_has_thumbnail (SynapseMatch* base,
                                                         gboolean value)
{
	SynapseWebSearchPluginResult* self;
	gboolean old_value;
#line 37 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) base;
#line 37 "../lib/synapse-plugins/web-search.vala"
	old_value = synapse_web_search_plugin_result_real_get_has_thumbnail (base);
#line 37 "../lib/synapse-plugins/web-search.vala"
	if (old_value != value) {
#line 37 "../lib/synapse-plugins/web-search.vala"
		self->priv->_has_thumbnail = value;
#line 37 "../lib/synapse-plugins/web-search.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY]);
#line 725 "web-search.c"
	}
}

static const gchar*
synapse_web_search_plugin_result_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseWebSearchPluginResult* self;
	const gchar* _tmp0_;
#line 38 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) base;
#line 38 "../lib/synapse-plugins/web-search.vala"
	_tmp0_ = self->priv->_thumbnail_path;
#line 38 "../lib/synapse-plugins/web-search.vala"
	result = _tmp0_;
#line 38 "../lib/synapse-plugins/web-search.vala"
	return result;
#line 743 "web-search.c"
}

static void
synapse_web_search_plugin_result_real_set_thumbnail_path (SynapseMatch* base,
                                                          const gchar* value)
{
	SynapseWebSearchPluginResult* self;
	gchar* old_value;
#line 38 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) base;
#line 38 "../lib/synapse-plugins/web-search.vala"
	old_value = synapse_web_search_plugin_result_real_get_thumbnail_path (base);
#line 38 "../lib/synapse-plugins/web-search.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 758 "web-search.c"
		gchar* _tmp0_;
#line 38 "../lib/synapse-plugins/web-search.vala"
		_tmp0_ = g_strdup (value);
#line 38 "../lib/synapse-plugins/web-search.vala"
		_g_free0 (self->priv->_thumbnail_path);
#line 38 "../lib/synapse-plugins/web-search.vala"
		self->priv->_thumbnail_path = _tmp0_;
#line 38 "../lib/synapse-plugins/web-search.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY]);
#line 768 "web-search.c"
	}
}

static SynapseMatchType
synapse_web_search_plugin_result_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseWebSearchPluginResult* self;
	SynapseMatchType _tmp0_;
#line 39 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) base;
#line 39 "../lib/synapse-plugins/web-search.vala"
	_tmp0_ = self->priv->_match_type;
#line 39 "../lib/synapse-plugins/web-search.vala"
	result = _tmp0_;
#line 39 "../lib/synapse-plugins/web-search.vala"
	return result;
#line 786 "web-search.c"
}

static void
synapse_web_search_plugin_result_real_set_match_type (SynapseMatch* base,
                                                      SynapseMatchType value)
{
	SynapseWebSearchPluginResult* self;
	SynapseMatchType old_value;
#line 39 "../lib/synapse-plugins/web-search.vala"
	self = (SynapseWebSearchPluginResult*) base;
#line 39 "../lib/synapse-plugins/web-search.vala"
	old_value = synapse_web_search_plugin_result_real_get_match_type (base);
#line 39 "../lib/synapse-plugins/web-search.vala"
	if (old_value != value) {
#line 39 "../lib/synapse-plugins/web-search.vala"
		self->priv->_match_type = value;
#line 39 "../lib/synapse-plugins/web-search.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_MATCH_TYPE_PROPERTY]);
#line 805 "web-search.c"
	}
}

const gchar*
synapse_web_search_plugin_result_get_query_template (SynapseWebSearchPluginResult* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 40 "../lib/synapse-plugins/web-search.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "../lib/synapse-plugins/web-search.vala"
	_tmp0_ = self->priv->_query_template;
#line 40 "../lib/synapse-plugins/web-search.vala"
	result = _tmp0_;
#line 40 "../lib/synapse-plugins/web-search.vala"
	return result;
#line 822 "web-search.c"
}

void
synapse_web_search_plugin_result_set_query_template (SynapseWebSearchPluginResult* self,
                                                     const gchar* value)
{
	gchar* old_value;
#line 40 "../lib/synapse-plugins/web-search.vala"
	g_return_if_fail (self != NULL);
#line 40 "../lib/synapse-plugins/web-search.vala"
	old_value = synapse_web_search_plugin_result_get_query_template (self);
#line 40 "../lib/synapse-plugins/web-search.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 836 "web-search.c"
		gchar* _tmp0_;
#line 40 "../lib/synapse-plugins/web-search.vala"
		_tmp0_ = g_strdup (value);
#line 40 "../lib/synapse-plugins/web-search.vala"
		_g_free0 (self->priv->_query_template);
#line 40 "../lib/synapse-plugins/web-search.vala"
		self->priv->_query_template = _tmp0_;
#line 40 "../lib/synapse-plugins/web-search.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_QUERY_TEMPLATE_PROPERTY]);
#line 846 "web-search.c"
	}
}

gint
synapse_web_search_plugin_result_get_default_relevancy (SynapseWebSearchPluginResult* self)
{
	gint result;
#line 42 "../lib/synapse-plugins/web-search.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 42 "../lib/synapse-plugins/web-search.vala"
	result = self->priv->_default_relevancy;
#line 42 "../lib/synapse-plugins/web-search.vala"
	return result;
#line 860 "web-search.c"
}

void
synapse_web_search_plugin_result_set_default_relevancy (SynapseWebSearchPluginResult* self,
                                                        gint value)
{
	gint old_value;
#line 42 "../lib/synapse-plugins/web-search.vala"
	g_return_if_fail (self != NULL);
#line 42 "../lib/synapse-plugins/web-search.vala"
	old_value = synapse_web_search_plugin_result_get_default_relevancy (self);
#line 42 "../lib/synapse-plugins/web-search.vala"
	if (old_value != value) {
#line 42 "../lib/synapse-plugins/web-search.vala"
		self->priv->_default_relevancy = value;
#line 42 "../lib/synapse-plugins/web-search.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY]);
#line 878 "web-search.c"
	}
}

static void
synapse_web_search_plugin_result_class_init (SynapseWebSearchPluginResultClass * klass,
                                             gpointer klass_data)
{
#line 32 "../lib/synapse-plugins/web-search.vala"
	synapse_web_search_plugin_result_parent_class = g_type_class_peek_parent (klass);
#line 32 "../lib/synapse-plugins/web-search.vala"
	g_type_class_adjust_private_offset (klass, &SynapseWebSearchPluginResult_private_offset);
#line 32 "../lib/synapse-plugins/web-search.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_web_search_plugin_result_get_property;
#line 32 "../lib/synapse-plugins/web-search.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_web_search_plugin_result_set_property;
#line 32 "../lib/synapse-plugins/web-search.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_web_search_plugin_result_finalize;
#line 32 "../lib/synapse-plugins/web-search.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_TITLE_PROPERTY, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 32 "../lib/synapse-plugins/web-search.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_DESCRIPTION_PROPERTY, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "../lib/synapse-plugins/web-search.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_ICON_NAME_PROPERTY, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 32 "../lib/synapse-plugins/web-search.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 32 "../lib/synapse-plugins/web-search.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 32 "../lib/synapse-plugins/web-search.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_MATCH_TYPE_PROPERTY, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 32 "../lib/synapse-plugins/web-search.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_QUERY_TEMPLATE_PROPERTY, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_QUERY_TEMPLATE_PROPERTY] = g_param_spec_string ("query-template", "query-template", "query-template", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 32 "../lib/synapse-plugins/web-search.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY, synapse_web_search_plugin_result_properties[SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 912 "web-search.c"
}

static void
synapse_web_search_plugin_result_synapse_match_interface_init (SynapseMatchIface * iface,
                                                               gpointer iface_data)
{
#line 32 "../lib/synapse-plugins/web-search.vala"
	synapse_web_search_plugin_result_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
#line 32 "../lib/synapse-plugins/web-search.vala"
	iface->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_web_search_plugin_result_real_execute;
#line 32 "../lib/synapse-plugins/web-search.vala"
	iface->get_title = synapse_web_search_plugin_result_real_get_title;
#line 32 "../lib/synapse-plugins/web-search.vala"
	iface->set_title = synapse_web_search_plugin_result_real_set_title;
#line 32 "../lib/synapse-plugins/web-search.vala"
	iface->get_description = synapse_web_search_plugin_result_real_get_description;
#line 32 "../lib/synapse-plugins/web-search.vala"
	iface->set_description = synapse_web_search_plugin_result_real_set_description;
#line 32 "../lib/synapse-plugins/web-search.vala"
	iface->get_icon_name = synapse_web_search_plugin_result_real_get_icon_name;
#line 32 "../lib/synapse-plugins/web-search.vala"
	iface->set_icon_name = synapse_web_search_plugin_result_real_set_icon_name;
#line 32 "../lib/synapse-plugins/web-search.vala"
	iface->get_has_thumbnail = synapse_web_search_plugin_result_real_get_has_thumbnail;
#line 32 "../lib/synapse-plugins/web-search.vala"
	iface->set_has_thumbnail = synapse_web_search_plugin_result_real_set_has_thumbnail;
#line 32 "../lib/synapse-plugins/web-search.vala"
	iface->get_thumbnail_path = synapse_web_search_plugin_result_real_get_thumbnail_path;
#line 32 "../lib/synapse-plugins/web-search.vala"
	iface->set_thumbnail_path = synapse_web_search_plugin_result_real_set_thumbnail_path;
#line 32 "../lib/synapse-plugins/web-search.vala"
	iface->get_match_type = synapse_web_search_plugin_result_real_get_match_type;
#line 32 "../lib/synapse-plugins/web-search.vala"
	iface->set_match_type = synapse_web_search_plugin_result_real_set_match_type;
#line 947 "web-search.c"
}

static void
synapse_web_search_plugin_result_instance_init (SynapseWebSearchPluginResult * self,
                                                gpointer klass)
{
#line 32 "../lib/synapse-plugins/web-search.vala"
	self->priv = synapse_web_search_plugin_result_get_instance_private (self);
#line 42 "../lib/synapse-plugins/web-search.vala"
	self->priv->_default_relevancy = 0;
#line 958 "web-search.c"
}

static void
synapse_web_search_plugin_result_finalize (GObject * obj)
{
	SynapseWebSearchPluginResult * self;
#line 32 "../lib/synapse-plugins/web-search.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_WEB_SEARCH_PLUGIN_TYPE_RESULT, SynapseWebSearchPluginResult);
#line 34 "../lib/synapse-plugins/web-search.vala"
	_g_free0 (self->priv->_title);
#line 35 "../lib/synapse-plugins/web-search.vala"
	_g_free0 (self->priv->_description);
#line 36 "../lib/synapse-plugins/web-search.vala"
	_g_free0 (self->priv->_icon_name);
#line 38 "../lib/synapse-plugins/web-search.vala"
	_g_free0 (self->priv->_thumbnail_path);
#line 40 "../lib/synapse-plugins/web-search.vala"
	_g_free0 (self->priv->_query_template);
#line 44 "../lib/synapse-plugins/web-search.vala"
	_g_object_unref0 (self->priv->appinfo);
#line 45 "../lib/synapse-plugins/web-search.vala"
	_g_free0 (self->priv->search_term);
#line 32 "../lib/synapse-plugins/web-search.vala"
	G_OBJECT_CLASS (synapse_web_search_plugin_result_parent_class)->finalize (obj);
#line 983 "web-search.c"
}

static GType
synapse_web_search_plugin_result_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseWebSearchPluginResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_web_search_plugin_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseWebSearchPluginResult), 0, (GInstanceInitFunc) synapse_web_search_plugin_result_instance_init, NULL };
	static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_web_search_plugin_result_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_web_search_plugin_result_type_id;
	synapse_web_search_plugin_result_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseWebSearchPluginResult", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_web_search_plugin_result_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
	SynapseWebSearchPluginResult_private_offset = g_type_add_instance_private (synapse_web_search_plugin_result_type_id, sizeof (SynapseWebSearchPluginResultPrivate));
	return synapse_web_search_plugin_result_type_id;
}

GType
synapse_web_search_plugin_result_get_type (void)
{
	static volatile gsize synapse_web_search_plugin_result_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_web_search_plugin_result_type_id__volatile)) {
		GType synapse_web_search_plugin_result_type_id;
		synapse_web_search_plugin_result_type_id = synapse_web_search_plugin_result_get_type_once ();
		g_once_init_leave (&synapse_web_search_plugin_result_type_id__volatile, synapse_web_search_plugin_result_type_id);
	}
	return synapse_web_search_plugin_result_type_id__volatile;
}

static void
_vala_synapse_web_search_plugin_result_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	SynapseWebSearchPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_WEB_SEARCH_PLUGIN_TYPE_RESULT, SynapseWebSearchPluginResult);
#line 32 "../lib/synapse-plugins/web-search.vala"
	switch (property_id) {
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_TITLE_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_DESCRIPTION_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_ICON_NAME_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_MATCH_TYPE_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_QUERY_TEMPLATE_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		g_value_set_string (value, synapse_web_search_plugin_result_get_query_template (self));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		g_value_set_int (value, synapse_web_search_plugin_result_get_default_relevancy (self));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 1068 "web-search.c"
		default:
#line 32 "../lib/synapse-plugins/web-search.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 1074 "web-search.c"
	}
}

static void
_vala_synapse_web_search_plugin_result_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	SynapseWebSearchPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_WEB_SEARCH_PLUGIN_TYPE_RESULT, SynapseWebSearchPluginResult);
#line 32 "../lib/synapse-plugins/web-search.vala"
	switch (property_id) {
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_TITLE_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_DESCRIPTION_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_ICON_NAME_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_MATCH_TYPE_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_QUERY_TEMPLATE_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		synapse_web_search_plugin_result_set_query_template (self, g_value_get_string (value));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 32 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
#line 32 "../lib/synapse-plugins/web-search.vala"
		synapse_web_search_plugin_result_set_default_relevancy (self, g_value_get_int (value));
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 1136 "web-search.c"
		default:
#line 32 "../lib/synapse-plugins/web-search.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "../lib/synapse-plugins/web-search.vala"
		break;
#line 1142 "web-search.c"
	}
}

static void
synapse_web_search_plugin_class_init (SynapseWebSearchPluginClass * klass,
                                      gpointer klass_data)
{
#line 24 "../lib/synapse-plugins/web-search.vala"
	synapse_web_search_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "../lib/synapse-plugins/web-search.vala"
	g_type_class_adjust_private_offset (klass, &SynapseWebSearchPlugin_private_offset);
#line 24 "../lib/synapse-plugins/web-search.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_web_search_plugin_get_property;
#line 24 "../lib/synapse-plugins/web-search.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_web_search_plugin_set_property;
#line 24 "../lib/synapse-plugins/web-search.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_web_search_plugin_finalize;
#line 24 "../lib/synapse-plugins/web-search.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_WEB_SEARCH_PLUGIN_ENABLED_PROPERTY, synapse_web_search_plugin_properties[SYNAPSE_WEB_SEARCH_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 74 "../lib/synapse-plugins/web-search.vala"
	synapse_web_search_plugin_register_plugin ();
#line 1164 "web-search.c"
}

static void
synapse_web_search_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                              gpointer iface_data)
{
#line 24 "../lib/synapse-plugins/web-search.vala"
	synapse_web_search_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../lib/synapse-plugins/web-search.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_web_search_plugin_real_activate;
#line 24 "../lib/synapse-plugins/web-search.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_web_search_plugin_real_deactivate;
#line 24 "../lib/synapse-plugins/web-search.vala"
	iface->get_enabled = synapse_web_search_plugin_real_get_enabled;
#line 24 "../lib/synapse-plugins/web-search.vala"
	iface->set_enabled = synapse_web_search_plugin_real_set_enabled;
#line 1181 "web-search.c"
}

static void
synapse_web_search_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                                gpointer iface_data)
{
#line 24 "../lib/synapse-plugins/web-search.vala"
	synapse_web_search_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../lib/synapse-plugins/web-search.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_web_search_plugin_real_search;
#line 24 "../lib/synapse-plugins/web-search.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_web_search_plugin_search_finish;
#line 1194 "web-search.c"
}

static void
synapse_web_search_plugin_instance_init (SynapseWebSearchPlugin * self,
                                         gpointer klass)
{
#line 24 "../lib/synapse-plugins/web-search.vala"
	self->priv = synapse_web_search_plugin_get_instance_private (self);
#line 26 "../lib/synapse-plugins/web-search.vala"
	self->priv->_enabled = TRUE;
#line 1205 "web-search.c"
}

static void
synapse_web_search_plugin_finalize (GObject * obj)
{
	SynapseWebSearchPlugin * self;
#line 24 "../lib/synapse-plugins/web-search.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_WEB_SEARCH_PLUGIN, SynapseWebSearchPlugin);
#line 24 "../lib/synapse-plugins/web-search.vala"
	G_OBJECT_CLASS (synapse_web_search_plugin_parent_class)->finalize (obj);
#line 1216 "web-search.c"
}

static GType
synapse_web_search_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseWebSearchPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_web_search_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseWebSearchPlugin), 0, (GInstanceInitFunc) synapse_web_search_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_web_search_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_web_search_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_web_search_plugin_type_id;
	synapse_web_search_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseWebSearchPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_web_search_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_web_search_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseWebSearchPlugin_private_offset = g_type_add_instance_private (synapse_web_search_plugin_type_id, sizeof (SynapseWebSearchPluginPrivate));
	return synapse_web_search_plugin_type_id;
}

GType
synapse_web_search_plugin_get_type (void)
{
	static volatile gsize synapse_web_search_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_web_search_plugin_type_id__volatile)) {
		GType synapse_web_search_plugin_type_id;
		synapse_web_search_plugin_type_id = synapse_web_search_plugin_get_type_once ();
		g_once_init_leave (&synapse_web_search_plugin_type_id__volatile, synapse_web_search_plugin_type_id);
	}
	return synapse_web_search_plugin_type_id__volatile;
}

static void
_vala_synapse_web_search_plugin_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SynapseWebSearchPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_WEB_SEARCH_PLUGIN, SynapseWebSearchPlugin);
#line 24 "../lib/synapse-plugins/web-search.vala"
	switch (property_id) {
#line 24 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_ENABLED_PROPERTY:
#line 24 "../lib/synapse-plugins/web-search.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "../lib/synapse-plugins/web-search.vala"
		break;
#line 1261 "web-search.c"
		default:
#line 24 "../lib/synapse-plugins/web-search.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../lib/synapse-plugins/web-search.vala"
		break;
#line 1267 "web-search.c"
	}
}

static void
_vala_synapse_web_search_plugin_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SynapseWebSearchPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_WEB_SEARCH_PLUGIN, SynapseWebSearchPlugin);
#line 24 "../lib/synapse-plugins/web-search.vala"
	switch (property_id) {
#line 24 "../lib/synapse-plugins/web-search.vala"
		case SYNAPSE_WEB_SEARCH_PLUGIN_ENABLED_PROPERTY:
#line 24 "../lib/synapse-plugins/web-search.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "../lib/synapse-plugins/web-search.vala"
		break;
#line 1287 "web-search.c"
		default:
#line 24 "../lib/synapse-plugins/web-search.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../lib/synapse-plugins/web-search.vala"
		break;
#line 1293 "web-search.c"
	}
}

