/* App.c generated by valac 0.48.13, the Vala compiler
 * generated from App.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/**/
/*  Copyright (C) 2011-2012 Giulio Collura*/
/*                2013-2014 Akshay Shekher*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include "synapse-core.h"
#include <gee.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gmenu-tree.h>
#include <gio/gdesktopappinfo.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#define LAUNCHER_BACKEND_TYPE_APP (launcher_backend_app_get_type ())
#define LAUNCHER_BACKEND_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_BACKEND_TYPE_APP, LauncherBackendApp))
#define LAUNCHER_BACKEND_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_BACKEND_TYPE_APP, LauncherBackendAppClass))
#define LAUNCHER_BACKEND_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_BACKEND_TYPE_APP))
#define LAUNCHER_BACKEND_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_BACKEND_TYPE_APP))
#define LAUNCHER_BACKEND_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_BACKEND_TYPE_APP, LauncherBackendAppClass))

typedef struct _LauncherBackendApp LauncherBackendApp;
typedef struct _LauncherBackendAppClass LauncherBackendAppClass;
typedef struct _LauncherBackendAppPrivate LauncherBackendAppPrivate;
typedef enum  {
	LAUNCHER_BACKEND_APP_APP_TYPE_APP,
	LAUNCHER_BACKEND_APP_APP_TYPE_COMMAND,
	LAUNCHER_BACKEND_APP_APP_TYPE_SYNAPSE
} LauncherBackendAppAppType;

#define LAUNCHER_BACKEND_APP_TYPE_APP_TYPE (launcher_backend_app_app_type_get_type ())
enum  {
	LAUNCHER_BACKEND_APP_0_PROPERTY,
	LAUNCHER_BACKEND_APP_NAME_PROPERTY,
	LAUNCHER_BACKEND_APP_DESCRIPTION_PROPERTY,
	LAUNCHER_BACKEND_APP_DESKTOP_ID_PROPERTY,
	LAUNCHER_BACKEND_APP_EXEC_PROPERTY,
	LAUNCHER_BACKEND_APP_ICON_NAME_PROPERTY,
	LAUNCHER_BACKEND_APP_KEYWORDS_PROPERTY,
	LAUNCHER_BACKEND_APP_ICON_PROPERTY,
	LAUNCHER_BACKEND_APP_POPULARITY_PROPERTY,
	LAUNCHER_BACKEND_APP_RELEVANCY_PROPERTY,
	LAUNCHER_BACKEND_APP_DESKTOP_PATH_PROPERTY,
	LAUNCHER_BACKEND_APP_CATEGORIES_PROPERTY,
	LAUNCHER_BACKEND_APP_GENERIC_NAME_PROPERTY,
	LAUNCHER_BACKEND_APP_APP_TYPE_PROPERTY,
	LAUNCHER_BACKEND_APP_MATCH_PROPERTY,
	LAUNCHER_BACKEND_APP_TARGET_PROPERTY,
	LAUNCHER_BACKEND_APP_ACTIONS_PROPERTY,
	LAUNCHER_BACKEND_APP_ACTIONS_MAP_PROPERTY,
	LAUNCHER_BACKEND_APP_NUM_PROPERTIES
};
static GParamSpec* launcher_backend_app_properties[LAUNCHER_BACKEND_APP_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define LAUNCHER_TYPE_SETTINGS (launcher_settings_get_type ())
#define LAUNCHER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_TYPE_SETTINGS, LauncherSettings))
#define LAUNCHER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_TYPE_SETTINGS, LauncherSettingsClass))
#define LAUNCHER_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_TYPE_SETTINGS))
#define LAUNCHER_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_TYPE_SETTINGS))
#define LAUNCHER_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_TYPE_SETTINGS, LauncherSettingsClass))

typedef struct _LauncherSettings LauncherSettings;
typedef struct _LauncherSettingsClass LauncherSettingsClass;
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD (launcher_backend_app_icon_load_fallback_method_get_type ())
#define LAUNCHER_BACKEND_APP_ICON_LOAD_FALLBACK_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD, LauncherBackendAppIconLoadFallbackMethod))
#define LAUNCHER_BACKEND_APP_ICON_LOAD_FALLBACK_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD, LauncherBackendAppIconLoadFallbackMethodClass))
#define LAUNCHER_BACKEND_APP_IS_ICON_LOAD_FALLBACK_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD))
#define LAUNCHER_BACKEND_APP_IS_ICON_LOAD_FALLBACK_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD))
#define LAUNCHER_BACKEND_APP_ICON_LOAD_FALLBACK_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD, LauncherBackendAppIconLoadFallbackMethodClass))

typedef struct _LauncherBackendAppIconLoadFallbackMethod LauncherBackendAppIconLoadFallbackMethod;
typedef struct _LauncherBackendAppIconLoadFallbackMethodClass LauncherBackendAppIconLoadFallbackMethodClass;
typedef void (*LauncherBackendAppIconLoadFallback) (gpointer user_data);
typedef struct _LauncherBackendAppIconLoadFallbackMethodPrivate LauncherBackendAppIconLoadFallbackMethodPrivate;
#define _launcher_backend_app_icon_load_fallback_method_unref0(var) ((var == NULL) ? NULL : (var = (launcher_backend_app_icon_load_fallback_method_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _LauncherBackendAppParamSpecIconLoadFallbackMethod LauncherBackendAppParamSpecIconLoadFallbackMethod;
enum  {
	LAUNCHER_BACKEND_APP_START_SEARCH_SIGNAL,
	LAUNCHER_BACKEND_APP_ICON_CHANGED_SIGNAL,
	LAUNCHER_BACKEND_APP_LAUNCHED_SIGNAL,
	LAUNCHER_BACKEND_APP_NUM_SIGNALS
};
static guint launcher_backend_app_signals[LAUNCHER_BACKEND_APP_NUM_SIGNALS] = {0};

typedef enum  {
	ICON_ERROR_NOT_FOUND
} IconError;
#define ICON_ERROR icon_error_quark ()
struct _LauncherBackendApp {
	GObject parent_instance;
	LauncherBackendAppPrivate * priv;
};

struct _LauncherBackendAppClass {
	GObjectClass parent_class;
};

struct _LauncherBackendAppPrivate {
	gchar* _name;
	gchar* _description;
	gchar* _desktop_id;
	gchar* _exec;
	gchar* _icon_name;
	gchar** _keywords;
	gint _keywords_length1;
	gint __keywords_size_;
	GdkPixbuf* _icon;
	gdouble _popularity;
	gdouble _relevancy;
	gchar* _desktop_path;
	gchar* _categories;
	gchar* _generic_name;
	LauncherBackendAppAppType _app_type;
	SynapseMatch* _match;
	SynapseMatch* _target;
	GeeArrayList* _actions;
	GeeHashMap* _actions_map;
	gboolean check_icon_again;
	GLoadableIcon* loadable_icon;
};

struct _Block2Data {
	int _ref_count_;
	LauncherBackendApp* self;
	GdkPixbuf* icon;
	GtkIconLookupFlags flags;
	gint size;
};

struct _LauncherBackendAppIconLoadFallbackMethod {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LauncherBackendAppIconLoadFallbackMethodPrivate * priv;
	LauncherBackendAppIconLoadFallback load_icon;
	gpointer load_icon_target;
};

struct _LauncherBackendAppIconLoadFallbackMethodClass {
	GTypeClass parent_class;
	void (*finalize) (LauncherBackendAppIconLoadFallbackMethod *self);
};

struct _LauncherBackendAppParamSpecIconLoadFallbackMethod {
	GParamSpec parent_instance;
};

static gint LauncherBackendApp_private_offset;
static gpointer launcher_backend_app_parent_class = NULL;
static gpointer launcher_backend_app_icon_load_fallback_method_parent_class = NULL;

GQuark icon_error_quark (void);
GType launcher_backend_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherBackendApp, g_object_unref)
GType launcher_backend_app_app_type_get_type (void) G_GNUC_CONST;
GtkIconTheme* launcher_launchy_get_icon_theme (void);
void launcher_backend_app_update_icon (LauncherBackendApp* self);
static void _launcher_backend_app_update_icon_gtk_icon_theme_changed (GtkIconTheme* _sender,
                                                               gpointer self);
#define LAUNCHER_BACKEND_APP_RECHECK_TIMEOUT 2
#define LAUNCHER_BACKEND_APP_DESKTOP_ACTION_KEY "Actions"
#define LAUNCHER_BACKEND_APP_DESKTOP_ACTION_GROUP_NAME "Desktop Action %s"
LauncherBackendApp* launcher_backend_app_new (GMenuTreeEntry* entry);
LauncherBackendApp* launcher_backend_app_construct (GType object_type,
                                                    GMenuTreeEntry* entry);
static void launcher_backend_app_set_app_type (LauncherBackendApp* self,
                                        LauncherBackendAppAppType value);
void launcher_backend_app_set_name (LauncherBackendApp* self,
                                    const gchar* value);
const gchar* launcher_backend_app_get_name (LauncherBackendApp* self);
static void launcher_backend_app_set_description (LauncherBackendApp* self,
                                           const gchar* value);
static void launcher_backend_app_set_exec (LauncherBackendApp* self,
                                    const gchar* value);
void launcher_backend_app_set_desktop_id (LauncherBackendApp* self,
                                          const gchar* value);
static void launcher_backend_app_set_desktop_path (LauncherBackendApp* self,
                                            const gchar* value);
static void launcher_backend_app_set_categories (LauncherBackendApp* self,
                                          const gchar* value);
static void launcher_backend_app_set_generic_name (LauncherBackendApp* self,
                                            const gchar* value);
static void launcher_backend_app_set_icon_name (LauncherBackendApp* self,
                                         const gchar* value);
GdkPixbuf* launcher_backend_app_get_loadable_icon (LauncherBackendApp* self);
static void launcher_backend_app_set_icon (LauncherBackendApp* self,
                                    GdkPixbuf* value);
GdkPixbuf* launcher_backend_app_get_icon (LauncherBackendApp* self);
LauncherBackendApp* launcher_backend_app_new_from_command (const gchar* command);
LauncherBackendApp* launcher_backend_app_construct_from_command (GType object_type,
                                                                 const gchar* command);
LauncherBackendApp* launcher_backend_app_new_from_synapse_match (SynapseMatch* match,
                                                                 SynapseMatch* target);
LauncherBackendApp* launcher_backend_app_construct_from_synapse_match (GType object_type,
                                                                       SynapseMatch* match,
                                                                       SynapseMatch* target);
static void launcher_backend_app_set_match (LauncherBackendApp* self,
                                     SynapseMatch* value);
static void launcher_backend_app_set_target (LauncherBackendApp* self,
                                      SynapseMatch* value);
GType launcher_settings_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherSettings, g_object_unref)
LauncherSettings* launcher_launchy_get_settings (void);
gint launcher_settings_get_icon_size (LauncherSettings* self);
GdkPixbuf* launcher_backend_app_load_icon (LauncherBackendApp* self,
                                           gint size);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
LauncherBackendAppAppType launcher_backend_app_get_app_type (LauncherBackendApp* self);
SynapseMatch* launcher_backend_app_get_match (LauncherBackendApp* self);
const gchar* launcher_backend_app_get_icon_name (LauncherBackendApp* self);
static gpointer launcher_backend_app_icon_load_fallback_method_ref (gpointer instance);
static void launcher_backend_app_icon_load_fallback_method_unref (gpointer instance);
static GParamSpec* launcher_backend_app_param_spec_icon_load_fallback_method (const gchar* name,
                                                                       const gchar* nick,
                                                                       const gchar* blurb,
                                                                       GType object_type,
                                                                       GParamFlags flags) G_GNUC_UNUSED;
static void launcher_backend_app_value_set_icon_load_fallback_method (GValue* value,
                                                               gpointer v_object) G_GNUC_UNUSED;
static void launcher_backend_app_value_take_icon_load_fallback_method (GValue* value,
                                                                gpointer v_object) G_GNUC_UNUSED;
static gpointer launcher_backend_app_value_get_icon_load_fallback_method (const GValue* value) G_GNUC_UNUSED;
static GType launcher_backend_app_icon_load_fallback_method_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherBackendAppIconLoadFallbackMethod, launcher_backend_app_icon_load_fallback_method_unref)
static void __lambda9_ (Block2Data* _data2_);
static void ___lambda9__launcher_backend_app_icon_load_fallback (gpointer self);
static LauncherBackendAppIconLoadFallbackMethod* launcher_backend_app_icon_load_fallback_method_new (LauncherBackendAppIconLoadFallback fallback,
                                                                                              gpointer fallback_target);
static LauncherBackendAppIconLoadFallbackMethod* launcher_backend_app_icon_load_fallback_method_construct (GType object_type,
                                                                                                    LauncherBackendAppIconLoadFallback fallback,
                                                                                                    gpointer fallback_target);
static void __lambda10_ (LauncherBackendApp* self);
static gboolean ___lambda11_ (LauncherBackendApp* self);
static gboolean ____lambda11__gsource_func (gpointer self);
static void ___lambda10__launcher_backend_app_icon_load_fallback (gpointer self);
static void __lambda12_ (Block2Data* _data2_);
static void ___lambda12__launcher_backend_app_icon_load_fallback (gpointer self);
static void __lambda13_ (Block2Data* _data2_);
static void ___lambda13__launcher_backend_app_icon_load_fallback (gpointer self);
static void __lambda14_ (Block2Data* _data2_);
static void ___lambda14__launcher_backend_app_icon_load_fallback (gpointer self);
static void __lambda15_ (Block2Data* _data2_);
static void ___lambda15__launcher_backend_app_icon_load_fallback (gpointer self);
gboolean launcher_backend_app_launch (LauncherBackendApp* self);
const gchar* launcher_backend_app_get_exec (LauncherBackendApp* self);
const gchar* launcher_backend_app_get_desktop_id (LauncherBackendApp* self);
SynapseMatch* launcher_backend_app_get_target (LauncherBackendApp* self);
GeeList* launcher_backend_synapse_search_find_actions_for_match (SynapseMatch* match);
void launcher_backend_app_init_actions (LauncherBackendApp* self,
                                        GError** error);
static void launcher_backend_app_set_actions (LauncherBackendApp* self,
                                       GeeArrayList* value);
static void launcher_backend_app_set_actions_map (LauncherBackendApp* self,
                                           GeeHashMap* value);
const gchar* launcher_backend_app_get_desktop_path (LauncherBackendApp* self);
GeeArrayList* launcher_backend_app_get_actions (LauncherBackendApp* self);
GeeHashMap* launcher_backend_app_get_actions_map (LauncherBackendApp* self);
const gchar* launcher_backend_app_get_description (LauncherBackendApp* self);
gchar** launcher_backend_app_get_keywords (LauncherBackendApp* self,
                                           gint* result_length1);
static void launcher_backend_app_set_keywords (LauncherBackendApp* self,
                                        gchar** value,
                                        gint value_length1);
static gchar** _vala_array_dup2 (gchar** self,
                          gint length);
gdouble launcher_backend_app_get_popularity (LauncherBackendApp* self);
void launcher_backend_app_set_popularity (LauncherBackendApp* self,
                                          gdouble value);
gdouble launcher_backend_app_get_relevancy (LauncherBackendApp* self);
void launcher_backend_app_set_relevancy (LauncherBackendApp* self,
                                         gdouble value);
const gchar* launcher_backend_app_get_categories (LauncherBackendApp* self);
const gchar* launcher_backend_app_get_generic_name (LauncherBackendApp* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void launcher_backend_app_icon_load_fallback_method_finalize (LauncherBackendAppIconLoadFallbackMethod * obj);
static GType launcher_backend_app_icon_load_fallback_method_get_type_once (void);
static void launcher_backend_app_finalize (GObject * obj);
static GType launcher_backend_app_get_type_once (void);
static void _vala_launcher_backend_app_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_launcher_backend_app_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* LAUNCHER_BACKEND_APP_SUPPORTED_GETTEXT_DOMAINS_KEYS[2] = {"X-Ubuntu-Gettext-Domain", "X-GNOME-Gettext-Domain"};

GQuark
icon_error_quark (void)
{
	return g_quark_from_static_string ("icon-error-quark");
}

static inline gpointer
launcher_backend_app_get_instance_private (LauncherBackendApp* self)
{
	return G_STRUCT_MEMBER_P (self, LauncherBackendApp_private_offset);
}

static void
_launcher_backend_app_update_icon_gtk_icon_theme_changed (GtkIconTheme* _sender,
                                                          gpointer self)
{
#line 134 "../src/Backend/App.vala"
	launcher_backend_app_update_icon ((LauncherBackendApp*) self);
#line 351 "App.c"
}

static GType
launcher_backend_app_app_type_get_type_once (void)
{
	static const GEnumValue values[] = {{LAUNCHER_BACKEND_APP_APP_TYPE_APP, "LAUNCHER_BACKEND_APP_APP_TYPE_APP", "app"}, {LAUNCHER_BACKEND_APP_APP_TYPE_COMMAND, "LAUNCHER_BACKEND_APP_APP_TYPE_COMMAND", "command"}, {LAUNCHER_BACKEND_APP_APP_TYPE_SYNAPSE, "LAUNCHER_BACKEND_APP_APP_TYPE_SYNAPSE", "synapse"}, {0, NULL, NULL}};
	GType launcher_backend_app_app_type_type_id;
	launcher_backend_app_app_type_type_id = g_enum_register_static ("LauncherBackendAppAppType", values);
	return launcher_backend_app_app_type_type_id;
}

GType
launcher_backend_app_app_type_get_type (void)
{
	static volatile gsize launcher_backend_app_app_type_type_id__volatile = 0;
	if (g_once_init_enter (&launcher_backend_app_app_type_type_id__volatile)) {
		GType launcher_backend_app_app_type_type_id;
		launcher_backend_app_app_type_type_id = launcher_backend_app_app_type_get_type_once ();
		g_once_init_leave (&launcher_backend_app_app_type_type_id__volatile, launcher_backend_app_app_type_type_id);
	}
	return launcher_backend_app_app_type_type_id__volatile;
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 93 "../src/Backend/App.vala"
	return self ? g_object_ref (self) : NULL;
#line 380 "App.c"
}

LauncherBackendApp*
launcher_backend_app_construct (GType object_type,
                                GMenuTreeEntry* entry)
{
	LauncherBackendApp * self = NULL;
	GDesktopAppInfo* info = NULL;
	GDesktopAppInfo* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	GDesktopAppInfo* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GDesktopAppInfo* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GDesktopAppInfo* _tmp17_;
	const gchar* _tmp18_;
	GDesktopAppInfo* _tmp19_;
	const gchar* _tmp20_;
	GDesktopAppInfo* _tmp21_;
	GIcon* _tmp22_;
	GdkPixbuf* _tmp37_;
#line 72 "../src/Backend/App.vala"
	g_return_val_if_fail (entry != NULL, NULL);
#line 72 "../src/Backend/App.vala"
	self = (LauncherBackendApp*) g_object_new (object_type, NULL);
#line 73 "../src/Backend/App.vala"
	launcher_backend_app_set_app_type (self, LAUNCHER_BACKEND_APP_APP_TYPE_APP);
#line 75 "../src/Backend/App.vala"
	_tmp0_ = gmenu_tree_entry_get_app_info (entry);
#line 75 "../src/Backend/App.vala"
	info = _tmp0_;
#line 76 "../src/Backend/App.vala"
	_tmp1_ = info;
#line 76 "../src/Backend/App.vala"
	_tmp2_ = g_app_info_get_display_name ((GAppInfo*) _tmp1_);
#line 76 "../src/Backend/App.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 76 "../src/Backend/App.vala"
	_tmp4_ = _tmp3_;
#line 76 "../src/Backend/App.vala"
	launcher_backend_app_set_name (self, _tmp4_);
#line 76 "../src/Backend/App.vala"
	_g_free0 (_tmp4_);
#line 77 "../src/Backend/App.vala"
	_tmp6_ = info;
#line 77 "../src/Backend/App.vala"
	_tmp7_ = g_app_info_get_description ((GAppInfo*) _tmp6_);
#line 77 "../src/Backend/App.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 77 "../src/Backend/App.vala"
	_tmp5_ = _tmp8_;
#line 77 "../src/Backend/App.vala"
	if (_tmp5_ == NULL) {
#line 443 "App.c"
		const gchar* _tmp9_;
		gchar* _tmp10_;
#line 77 "../src/Backend/App.vala"
		_tmp9_ = self->priv->_name;
#line 77 "../src/Backend/App.vala"
		_tmp10_ = g_strdup (_tmp9_);
#line 77 "../src/Backend/App.vala"
		_g_free0 (_tmp5_);
#line 77 "../src/Backend/App.vala"
		_tmp5_ = _tmp10_;
#line 454 "App.c"
	}
#line 77 "../src/Backend/App.vala"
	launcher_backend_app_set_description (self, _tmp5_);
#line 78 "../src/Backend/App.vala"
	_tmp11_ = info;
#line 78 "../src/Backend/App.vala"
	_tmp12_ = g_app_info_get_commandline ((GAppInfo*) _tmp11_);
#line 78 "../src/Backend/App.vala"
	_tmp13_ = g_strdup (_tmp12_);
#line 78 "../src/Backend/App.vala"
	_tmp14_ = _tmp13_;
#line 78 "../src/Backend/App.vala"
	launcher_backend_app_set_exec (self, _tmp14_);
#line 78 "../src/Backend/App.vala"
	_g_free0 (_tmp14_);
#line 79 "../src/Backend/App.vala"
	_tmp15_ = gmenu_tree_entry_get_desktop_file_id (entry);
#line 79 "../src/Backend/App.vala"
	launcher_backend_app_set_desktop_id (self, _tmp15_);
#line 80 "../src/Backend/App.vala"
	_tmp16_ = gmenu_tree_entry_get_desktop_file_path (entry);
#line 80 "../src/Backend/App.vala"
	launcher_backend_app_set_desktop_path (self, _tmp16_);
#line 81 "../src/Backend/App.vala"
	_tmp17_ = info;
#line 81 "../src/Backend/App.vala"
	_tmp18_ = g_desktop_app_info_get_categories (_tmp17_);
#line 81 "../src/Backend/App.vala"
	launcher_backend_app_set_categories (self, _tmp18_);
#line 82 "../src/Backend/App.vala"
	_tmp19_ = info;
#line 82 "../src/Backend/App.vala"
	_tmp20_ = g_desktop_app_info_get_generic_name (_tmp19_);
#line 82 "../src/Backend/App.vala"
	launcher_backend_app_set_generic_name (self, _tmp20_);
#line 90 "../src/Backend/App.vala"
	_tmp21_ = info;
#line 90 "../src/Backend/App.vala"
	_tmp22_ = g_app_info_get_icon ((GAppInfo*) _tmp21_);
#line 90 "../src/Backend/App.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, g_themed_icon_get_type ())) {
#line 496 "App.c"
		GDesktopAppInfo* _tmp23_;
		GIcon* _tmp24_;
		gchar** _tmp25_;
		gchar** _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
#line 91 "../src/Backend/App.vala"
		_tmp23_ = info;
#line 91 "../src/Backend/App.vala"
		_tmp24_ = g_app_info_get_icon ((GAppInfo*) _tmp23_);
#line 91 "../src/Backend/App.vala"
		_tmp26_ = _tmp25_ = g_themed_icon_get_names (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, g_themed_icon_get_type ()) ? ((GThemedIcon*) _tmp24_) : NULL);
#line 91 "../src/Backend/App.vala"
		_tmp27_ = _tmp26_[0];
#line 91 "../src/Backend/App.vala"
		_tmp28_ = g_strdup (_tmp27_);
#line 91 "../src/Backend/App.vala"
		_tmp29_ = _tmp28_;
#line 91 "../src/Backend/App.vala"
		launcher_backend_app_set_icon_name (self, _tmp29_);
#line 91 "../src/Backend/App.vala"
		_g_free0 (_tmp29_);
#line 520 "App.c"
	} else {
		GDesktopAppInfo* _tmp30_;
		GIcon* _tmp31_;
#line 92 "../src/Backend/App.vala"
		_tmp30_ = info;
#line 92 "../src/Backend/App.vala"
		_tmp31_ = g_app_info_get_icon ((GAppInfo*) _tmp30_);
#line 92 "../src/Backend/App.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, g_loadable_icon_get_type ())) {
#line 530 "App.c"
			GDesktopAppInfo* _tmp32_;
			GIcon* _tmp33_;
			GLoadableIcon* _tmp34_;
			GdkPixbuf* _tmp35_;
			GdkPixbuf* _tmp36_;
#line 93 "../src/Backend/App.vala"
			_tmp32_ = info;
#line 93 "../src/Backend/App.vala"
			_tmp33_ = g_app_info_get_icon ((GAppInfo*) _tmp32_);
#line 93 "../src/Backend/App.vala"
			_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, g_loadable_icon_get_type ()) ? ((GLoadableIcon*) _tmp33_) : NULL);
#line 93 "../src/Backend/App.vala"
			_g_object_unref0 (self->priv->loadable_icon);
#line 93 "../src/Backend/App.vala"
			self->priv->loadable_icon = _tmp34_;
#line 94 "../src/Backend/App.vala"
			_tmp35_ = launcher_backend_app_get_loadable_icon (self);
#line 94 "../src/Backend/App.vala"
			_tmp36_ = _tmp35_;
#line 94 "../src/Backend/App.vala"
			launcher_backend_app_set_icon (self, _tmp36_);
#line 94 "../src/Backend/App.vala"
			_g_object_unref0 (_tmp36_);
#line 554 "App.c"
		} else {
#line 96 "../src/Backend/App.vala"
			launcher_backend_app_set_icon_name (self, "application-default-icon");
#line 558 "App.c"
		}
	}
#line 98 "../src/Backend/App.vala"
	_tmp37_ = self->priv->_icon;
#line 98 "../src/Backend/App.vala"
	if (_tmp37_ == NULL) {
#line 565 "App.c"
		GtkIconTheme* _tmp38_;
		GtkIconTheme* _tmp39_;
#line 99 "../src/Backend/App.vala"
		launcher_backend_app_update_icon (self);
#line 101 "../src/Backend/App.vala"
		_tmp38_ = launcher_launchy_get_icon_theme ();
#line 101 "../src/Backend/App.vala"
		_tmp39_ = _tmp38_;
#line 101 "../src/Backend/App.vala"
		g_signal_connect_object (_tmp39_, "changed", (GCallback) _launcher_backend_app_update_icon_gtk_icon_theme_changed, self, 0);
#line 576 "App.c"
	}
#line 72 "../src/Backend/App.vala"
	_g_free0 (_tmp5_);
#line 72 "../src/Backend/App.vala"
	return self;
#line 582 "App.c"
}

LauncherBackendApp*
launcher_backend_app_new (GMenuTreeEntry* entry)
{
#line 72 "../src/Backend/App.vala"
	return launcher_backend_app_construct (LAUNCHER_BACKEND_TYPE_APP, entry);
#line 590 "App.c"
}

LauncherBackendApp*
launcher_backend_app_construct_from_command (GType object_type,
                                             const gchar* command)
{
	LauncherBackendApp * self = NULL;
#line 105 "../src/Backend/App.vala"
	g_return_val_if_fail (command != NULL, NULL);
#line 105 "../src/Backend/App.vala"
	self = (LauncherBackendApp*) g_object_new (object_type, NULL);
#line 106 "../src/Backend/App.vala"
	launcher_backend_app_set_app_type (self, LAUNCHER_BACKEND_APP_APP_TYPE_COMMAND);
#line 108 "../src/Backend/App.vala"
	launcher_backend_app_set_name (self, command);
#line 109 "../src/Backend/App.vala"
	launcher_backend_app_set_description (self, _ ("Run this command…"));
#line 110 "../src/Backend/App.vala"
	launcher_backend_app_set_exec (self, command);
#line 111 "../src/Backend/App.vala"
	launcher_backend_app_set_desktop_id (self, command);
#line 112 "../src/Backend/App.vala"
	launcher_backend_app_set_icon_name (self, "system-run");
#line 114 "../src/Backend/App.vala"
	launcher_backend_app_update_icon (self);
#line 105 "../src/Backend/App.vala"
	return self;
#line 618 "App.c"
}

LauncherBackendApp*
launcher_backend_app_new_from_command (const gchar* command)
{
#line 105 "../src/Backend/App.vala"
	return launcher_backend_app_construct_from_command (LAUNCHER_BACKEND_TYPE_APP, command);
#line 626 "App.c"
}

LauncherBackendApp*
launcher_backend_app_construct_from_synapse_match (GType object_type,
                                                   SynapseMatch* match,
                                                   SynapseMatch* target)
{
	LauncherBackendApp * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
#line 118 "../src/Backend/App.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 118 "../src/Backend/App.vala"
	self = (LauncherBackendApp*) g_object_new (object_type, NULL);
#line 120 "../src/Backend/App.vala"
	launcher_backend_app_set_app_type (self, LAUNCHER_BACKEND_APP_APP_TYPE_SYNAPSE);
#line 122 "../src/Backend/App.vala"
	_tmp0_ = synapse_match_get_title (match);
#line 122 "../src/Backend/App.vala"
	_tmp1_ = _tmp0_;
#line 122 "../src/Backend/App.vala"
	launcher_backend_app_set_name (self, _tmp1_);
#line 123 "../src/Backend/App.vala"
	_tmp2_ = synapse_match_get_description (match);
#line 123 "../src/Backend/App.vala"
	_tmp3_ = _tmp2_;
#line 123 "../src/Backend/App.vala"
	launcher_backend_app_set_description (self, _tmp3_);
#line 124 "../src/Backend/App.vala"
	_tmp4_ = synapse_match_get_icon_name (match);
#line 124 "../src/Backend/App.vala"
	_tmp5_ = _tmp4_;
#line 124 "../src/Backend/App.vala"
	launcher_backend_app_set_icon_name (self, _tmp5_);
#line 126 "../src/Backend/App.vala"
	launcher_backend_app_set_match (self, match);
#line 127 "../src/Backend/App.vala"
	launcher_backend_app_set_target (self, target);
#line 129 "../src/Backend/App.vala"
	launcher_backend_app_update_icon (self);
#line 118 "../src/Backend/App.vala"
	return self;
#line 673 "App.c"
}

LauncherBackendApp*
launcher_backend_app_new_from_synapse_match (SynapseMatch* match,
                                             SynapseMatch* target)
{
#line 118 "../src/Backend/App.vala"
	return launcher_backend_app_construct_from_synapse_match (LAUNCHER_BACKEND_TYPE_APP, match, target);
#line 682 "App.c"
}

void
launcher_backend_app_update_icon (LauncherBackendApp* self)
{
	LauncherSettings* _tmp0_;
	LauncherSettings* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
#line 137 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 138 "../src/Backend/App.vala"
	_tmp0_ = launcher_launchy_get_settings ();
#line 138 "../src/Backend/App.vala"
	_tmp1_ = _tmp0_;
#line 138 "../src/Backend/App.vala"
	_tmp2_ = launcher_settings_get_icon_size (_tmp1_);
#line 138 "../src/Backend/App.vala"
	_tmp3_ = _tmp2_;
#line 138 "../src/Backend/App.vala"
	if (_tmp3_ == 0) {
#line 704 "App.c"
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
#line 145 "../src/Backend/App.vala"
		_tmp4_ = launcher_backend_app_load_icon (self, 64);
#line 145 "../src/Backend/App.vala"
		_tmp5_ = _tmp4_;
#line 145 "../src/Backend/App.vala"
		launcher_backend_app_set_icon (self, _tmp5_);
#line 145 "../src/Backend/App.vala"
		_g_object_unref0 (_tmp5_);
#line 715 "App.c"
	} else {
		LauncherSettings* _tmp6_;
		LauncherSettings* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
#line 148 "../src/Backend/App.vala"
		_tmp6_ = launcher_launchy_get_settings ();
#line 148 "../src/Backend/App.vala"
		_tmp7_ = _tmp6_;
#line 148 "../src/Backend/App.vala"
		_tmp8_ = launcher_settings_get_icon_size (_tmp7_);
#line 148 "../src/Backend/App.vala"
		_tmp9_ = _tmp8_;
#line 148 "../src/Backend/App.vala"
		_tmp10_ = launcher_backend_app_load_icon (self, _tmp9_);
#line 148 "../src/Backend/App.vala"
		_tmp11_ = _tmp10_;
#line 148 "../src/Backend/App.vala"
		launcher_backend_app_set_icon (self, _tmp11_);
#line 148 "../src/Backend/App.vala"
		_g_object_unref0 (_tmp11_);
#line 739 "App.c"
	}
#line 151 "../src/Backend/App.vala"
	g_signal_emit (self, launcher_backend_app_signals[LAUNCHER_BACKEND_APP_ICON_CHANGED_SIGNAL], 0);
#line 743 "App.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 164 "../src/Backend/App.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 164 "../src/Backend/App.vala"
	return _data2_;
#line 753 "App.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 164 "../src/Backend/App.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 763 "App.c"
		LauncherBackendApp* self;
#line 164 "../src/Backend/App.vala"
		self = _data2_->self;
#line 164 "../src/Backend/App.vala"
		_g_object_unref0 (_data2_->icon);
#line 164 "../src/Backend/App.vala"
		_g_object_unref0 (self);
#line 164 "../src/Backend/App.vala"
		g_slice_free (Block2Data, _data2_);
#line 773 "App.c"
	}
}

static void
__lambda9_ (Block2Data* _data2_)
{
	LauncherBackendApp* self;
	GError* _inner_error0_ = NULL;
#line 200 "../src/Backend/App.vala"
	self = _data2_->self;
#line 784 "App.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		GtkIconTheme* _tmp1_;
		GtkIconTheme* _tmp2_;
		const gchar* _tmp3_;
		GtkIconLookupFlags _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
#line 202 "../src/Backend/App.vala"
		_tmp1_ = launcher_launchy_get_icon_theme ();
#line 202 "../src/Backend/App.vala"
		_tmp2_ = _tmp1_;
#line 202 "../src/Backend/App.vala"
		_tmp3_ = self->priv->_icon_name;
#line 202 "../src/Backend/App.vala"
		_tmp4_ = _data2_->flags;
#line 202 "../src/Backend/App.vala"
		_tmp5_ = gtk_icon_theme_load_icon (_tmp2_, _tmp3_, _data2_->size, _tmp4_, &_inner_error0_);
#line 202 "../src/Backend/App.vala"
		_tmp0_ = _tmp5_;
#line 202 "../src/Backend/App.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 807 "App.c"
			goto __catch0_g_error;
		}
#line 202 "../src/Backend/App.vala"
		_tmp6_ = _tmp0_;
#line 202 "../src/Backend/App.vala"
		_tmp0_ = NULL;
#line 202 "../src/Backend/App.vala"
		_g_object_unref0 (_data2_->icon);
#line 202 "../src/Backend/App.vala"
		_data2_->icon = _tmp6_;
#line 201 "../src/Backend/App.vala"
		_g_object_unref0 (_tmp0_);
#line 820 "App.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 201 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 204 "../src/Backend/App.vala"
		g_warning ("App.vala:204: Could not load icon. Falling back to method 2");
#line 829 "App.c"
	}
	__finally0:
#line 201 "../src/Backend/App.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 201 "../src/Backend/App.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 201 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 201 "../src/Backend/App.vala"
		return;
#line 840 "App.c"
	}
}

static void
___lambda9__launcher_backend_app_icon_load_fallback (gpointer self)
{
#line 199 "../src/Backend/App.vala"
	__lambda9_ (self);
#line 849 "App.c"
}

static gboolean
___lambda11_ (LauncherBackendApp* self)
{
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	gboolean result = FALSE;
#line 215 "../src/Backend/App.vala"
	_tmp0_ = launcher_launchy_get_icon_theme ();
#line 215 "../src/Backend/App.vala"
	_tmp1_ = _tmp0_;
#line 215 "../src/Backend/App.vala"
	gtk_icon_theme_rescan_if_needed (_tmp1_);
#line 216 "../src/Backend/App.vala"
	launcher_backend_app_update_icon (self);
#line 217 "../src/Backend/App.vala"
	result = FALSE;
#line 217 "../src/Backend/App.vala"
	return result;
#line 870 "App.c"
}

static gboolean
____lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda11_ ((LauncherBackendApp*) self);
#line 214 "../src/Backend/App.vala"
	return result;
#line 880 "App.c"
}

static void
__lambda10_ (LauncherBackendApp* self)
{
#line 210 "../src/Backend/App.vala"
	if (self->priv->check_icon_again) {
#line 212 "../src/Backend/App.vala"
		self->priv->check_icon_again = FALSE;
#line 214 "../src/Backend/App.vala"
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) LAUNCHER_BACKEND_APP_RECHECK_TIMEOUT, ____lambda11__gsource_func, g_object_ref (self), g_object_unref);
#line 892 "App.c"
	}
}

static void
___lambda10__launcher_backend_app_icon_load_fallback (gpointer self)
{
#line 199 "../src/Backend/App.vala"
	__lambda10_ ((LauncherBackendApp*) self);
#line 901 "App.c"
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
#line 1143 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1143 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1144 "glib-2.0.vapi"
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1144 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1146 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1146 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 925 "App.c"
		gchar* _tmp2_;
#line 1147 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1147 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1147 "glib-2.0.vapi"
		return result;
#line 933 "App.c"
	} else {
#line 1149 "glib-2.0.vapi"
		result = -1;
#line 1149 "glib-2.0.vapi"
		return result;
#line 939 "App.c"
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1481 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1481 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1481 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1482 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1483 "glib-2.0.vapi"
		start = string_length + start;
#line 967 "App.c"
	}
#line 1485 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1486 "glib-2.0.vapi"
		end = string_length + end;
#line 973 "App.c"
	}
#line 1488 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 979 "App.c"
	} else {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 983 "App.c"
	}
#line 1488 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1489 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 991 "App.c"
	} else {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 995 "App.c"
	}
#line 1489 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1490 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1491 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1491 "glib-2.0.vapi"
	result = _tmp4_;
#line 1491 "glib-2.0.vapi"
	return result;
#line 1007 "App.c"
}

static void
__lambda12_ (Block2Data* _data2_)
{
	LauncherBackendApp* self;
	GError* _inner_error0_ = NULL;
#line 222 "../src/Backend/App.vala"
	self = _data2_->self;
#line 1017 "App.c"
	{
		const gchar* _tmp0_;
#line 224 "../src/Backend/App.vala"
		_tmp0_ = self->priv->_icon_name;
#line 224 "../src/Backend/App.vala"
		if (string_last_index_of (_tmp0_, ".", 0) > 0) {
#line 1024 "App.c"
			gchar* name = NULL;
			const gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			GdkPixbuf* _tmp4_ = NULL;
			GtkIconTheme* _tmp5_;
			GtkIconTheme* _tmp6_;
			const gchar* _tmp7_;
			GtkIconLookupFlags _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
#line 225 "../src/Backend/App.vala"
			_tmp1_ = self->priv->_icon_name;
#line 225 "../src/Backend/App.vala"
			_tmp2_ = self->priv->_icon_name;
#line 225 "../src/Backend/App.vala"
			_tmp3_ = string_slice (_tmp1_, (glong) 0, (glong) string_last_index_of (_tmp2_, ".", 0));
#line 225 "../src/Backend/App.vala"
			name = _tmp3_;
#line 226 "../src/Backend/App.vala"
			_tmp5_ = launcher_launchy_get_icon_theme ();
#line 226 "../src/Backend/App.vala"
			_tmp6_ = _tmp5_;
#line 226 "../src/Backend/App.vala"
			_tmp7_ = name;
#line 226 "../src/Backend/App.vala"
			_tmp8_ = _data2_->flags;
#line 226 "../src/Backend/App.vala"
			_tmp9_ = gtk_icon_theme_load_icon (_tmp6_, _tmp7_, _data2_->size, _tmp8_, &_inner_error0_);
#line 226 "../src/Backend/App.vala"
			_tmp4_ = _tmp9_;
#line 226 "../src/Backend/App.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 226 "../src/Backend/App.vala"
				_g_free0 (name);
#line 1060 "App.c"
				goto __catch0_g_error;
			}
#line 226 "../src/Backend/App.vala"
			_tmp10_ = _tmp4_;
#line 226 "../src/Backend/App.vala"
			_tmp4_ = NULL;
#line 226 "../src/Backend/App.vala"
			_g_object_unref0 (_data2_->icon);
#line 226 "../src/Backend/App.vala"
			_data2_->icon = _tmp10_;
#line 224 "../src/Backend/App.vala"
			_g_object_unref0 (_tmp4_);
#line 224 "../src/Backend/App.vala"
			_g_free0 (name);
#line 1075 "App.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 223 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 229 "../src/Backend/App.vala"
		g_warning ("App.vala:229: Could not load icon. Falling back to method 3");
#line 1085 "App.c"
	}
	__finally0:
#line 223 "../src/Backend/App.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 223 "../src/Backend/App.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 223 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 223 "../src/Backend/App.vala"
		return;
#line 1096 "App.c"
	}
}

static void
___lambda12__launcher_backend_app_icon_load_fallback (gpointer self)
{
#line 199 "../src/Backend/App.vala"
	__lambda12_ (self);
#line 1105 "App.c"
}

static void
__lambda13_ (Block2Data* _data2_)
{
	LauncherBackendApp* self;
	GError* _inner_error0_ = NULL;
#line 233 "../src/Backend/App.vala"
	self = _data2_->self;
#line 1115 "App.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		const gchar* _tmp1_;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
#line 235 "../src/Backend/App.vala"
		_tmp1_ = self->priv->_icon_name;
#line 235 "../src/Backend/App.vala"
		_tmp2_ = gdk_pixbuf_new_from_file_at_scale (_tmp1_, _data2_->size, _data2_->size, FALSE, &_inner_error0_);
#line 235 "../src/Backend/App.vala"
		_tmp0_ = _tmp2_;
#line 235 "../src/Backend/App.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1129 "App.c"
			goto __catch0_g_error;
		}
#line 235 "../src/Backend/App.vala"
		_tmp3_ = _tmp0_;
#line 235 "../src/Backend/App.vala"
		_tmp0_ = NULL;
#line 235 "../src/Backend/App.vala"
		_g_object_unref0 (_data2_->icon);
#line 235 "../src/Backend/App.vala"
		_data2_->icon = _tmp3_;
#line 234 "../src/Backend/App.vala"
		_g_object_unref0 (_tmp0_);
#line 1142 "App.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 234 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 237 "../src/Backend/App.vala"
		g_warning ("App.vala:237: Could not load icon. Falling back to method 4");
#line 1151 "App.c"
	}
	__finally0:
#line 234 "../src/Backend/App.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 234 "../src/Backend/App.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 234 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 234 "../src/Backend/App.vala"
		return;
#line 1162 "App.c"
	}
}

static void
___lambda13__launcher_backend_app_icon_load_fallback (gpointer self)
{
#line 199 "../src/Backend/App.vala"
	__lambda13_ (self);
#line 1171 "App.c"
}

static void
__lambda14_ (Block2Data* _data2_)
{
	LauncherBackendApp* self;
	GError* _inner_error0_ = NULL;
#line 241 "../src/Backend/App.vala"
	self = _data2_->self;
#line 1181 "App.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		GtkIconTheme* _tmp1_;
		GtkIconTheme* _tmp2_;
		GtkIconLookupFlags _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
#line 243 "../src/Backend/App.vala"
		_tmp1_ = launcher_launchy_get_icon_theme ();
#line 243 "../src/Backend/App.vala"
		_tmp2_ = _tmp1_;
#line 243 "../src/Backend/App.vala"
		_tmp3_ = _data2_->flags;
#line 243 "../src/Backend/App.vala"
		_tmp4_ = gtk_icon_theme_load_icon (_tmp2_, "application-default-icon", _data2_->size, _tmp3_, &_inner_error0_);
#line 243 "../src/Backend/App.vala"
		_tmp0_ = _tmp4_;
#line 243 "../src/Backend/App.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1201 "App.c"
			goto __catch0_g_error;
		}
#line 243 "../src/Backend/App.vala"
		_tmp5_ = _tmp0_;
#line 243 "../src/Backend/App.vala"
		_tmp0_ = NULL;
#line 243 "../src/Backend/App.vala"
		_g_object_unref0 (_data2_->icon);
#line 243 "../src/Backend/App.vala"
		_data2_->icon = _tmp5_;
#line 242 "../src/Backend/App.vala"
		_g_object_unref0 (_tmp0_);
#line 1214 "App.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 242 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 245 "../src/Backend/App.vala"
		g_warning ("App.vala:245: Could not load icon. Falling back to method 5");
#line 1223 "App.c"
	}
	__finally0:
#line 242 "../src/Backend/App.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 242 "../src/Backend/App.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 242 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 242 "../src/Backend/App.vala"
		return;
#line 1234 "App.c"
	}
}

static void
___lambda14__launcher_backend_app_icon_load_fallback (gpointer self)
{
#line 199 "../src/Backend/App.vala"
	__lambda14_ (self);
#line 1243 "App.c"
}

static void
__lambda15_ (Block2Data* _data2_)
{
	LauncherBackendApp* self;
	GError* _inner_error0_ = NULL;
#line 249 "../src/Backend/App.vala"
	self = _data2_->self;
#line 1253 "App.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		GtkIconTheme* _tmp1_;
		GtkIconTheme* _tmp2_;
		GtkIconLookupFlags _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
#line 251 "../src/Backend/App.vala"
		_tmp1_ = launcher_launchy_get_icon_theme ();
#line 251 "../src/Backend/App.vala"
		_tmp2_ = _tmp1_;
#line 251 "../src/Backend/App.vala"
		_tmp3_ = _data2_->flags;
#line 251 "../src/Backend/App.vala"
		_tmp4_ = gtk_icon_theme_load_icon (_tmp2_, "image-missing", _data2_->size, _tmp3_, &_inner_error0_);
#line 251 "../src/Backend/App.vala"
		_tmp0_ = _tmp4_;
#line 251 "../src/Backend/App.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1273 "App.c"
			goto __catch0_g_error;
		}
#line 251 "../src/Backend/App.vala"
		_tmp5_ = _tmp0_;
#line 251 "../src/Backend/App.vala"
		_tmp0_ = NULL;
#line 251 "../src/Backend/App.vala"
		_g_object_unref0 (_data2_->icon);
#line 251 "../src/Backend/App.vala"
		_data2_->icon = _tmp5_;
#line 250 "../src/Backend/App.vala"
		_g_object_unref0 (_tmp0_);
#line 1286 "App.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 250 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 253 "../src/Backend/App.vala"
		g_error ("App.vala:253: Could not find a fallback icon to load");
#line 1295 "App.c"
	}
	__finally0:
#line 250 "../src/Backend/App.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 250 "../src/Backend/App.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 250 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 250 "../src/Backend/App.vala"
		return;
#line 1306 "App.c"
	}
}

static void
___lambda15__launcher_backend_app_icon_load_fallback (gpointer self)
{
#line 199 "../src/Backend/App.vala"
	__lambda15_ (self);
#line 1315 "App.c"
}

static gpointer
_launcher_backend_app_icon_load_fallback_method_ref0 (gpointer self)
{
#line 257 "../src/Backend/App.vala"
	return self ? launcher_backend_app_icon_load_fallback_method_ref (self) : NULL;
#line 1323 "App.c"
}

GdkPixbuf*
launcher_backend_app_load_icon (LauncherBackendApp* self,
                                gint size)
{
	Block2Data* _data2_;
	LauncherBackendAppAppType _tmp0_;
	GLoadableIcon* _tmp34_;
	LauncherBackendAppIconLoadFallbackMethod** fallbacks = NULL;
	LauncherBackendAppIconLoadFallbackMethod* _tmp36_;
	LauncherBackendAppIconLoadFallbackMethod* _tmp37_;
	LauncherBackendAppIconLoadFallbackMethod* _tmp38_;
	LauncherBackendAppIconLoadFallbackMethod* _tmp39_;
	LauncherBackendAppIconLoadFallbackMethod* _tmp40_;
	LauncherBackendAppIconLoadFallbackMethod* _tmp41_;
	LauncherBackendAppIconLoadFallbackMethod** _tmp42_;
	gint fallbacks_length1;
	gint _fallbacks_size_;
	LauncherBackendAppIconLoadFallbackMethod** _tmp43_;
	gint _tmp43__length1;
	GdkPixbuf* _tmp48_;
	GdkPixbuf* _tmp49_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result = NULL;
#line 164 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 164 "../src/Backend/App.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 164 "../src/Backend/App.vala"
	_data2_->_ref_count_ = 1;
#line 164 "../src/Backend/App.vala"
	_data2_->self = g_object_ref (self);
#line 164 "../src/Backend/App.vala"
	_data2_->size = size;
#line 165 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_app_type;
#line 165 "../src/Backend/App.vala"
	if (_tmp0_ == LAUNCHER_BACKEND_APP_APP_TYPE_SYNAPSE) {
#line 1363 "App.c"
		{
			gboolean _tmp1_ = FALSE;
			SynapseMatch* _tmp2_;
			SynapseMatchType _tmp3_;
			SynapseMatchType _tmp4_;
			GIcon* icon = NULL;
			const gchar* _tmp14_;
			GIcon* _tmp15_;
			GtkIconInfo* info = NULL;
			GtkIconTheme* _tmp16_;
			GIcon* _tmp17_;
			GtkIconInfo* _tmp18_;
			GtkIconInfo* _tmp19_;
			GdkPixbuf* _tmp21_ = NULL;
			GtkIconInfo* _tmp22_;
			GdkPixbuf* _tmp23_;
			GdkPixbuf* _tmp24_;
#line 169 "../src/Backend/App.vala"
			_tmp2_ = self->priv->_match;
#line 169 "../src/Backend/App.vala"
			_tmp3_ = synapse_match_get_match_type (_tmp2_);
#line 169 "../src/Backend/App.vala"
			_tmp4_ = _tmp3_;
#line 169 "../src/Backend/App.vala"
			if (_tmp4_ == SYNAPSE_MATCH_TYPE_CONTACT) {
#line 1389 "App.c"
				SynapseMatch* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
#line 169 "../src/Backend/App.vala"
				_tmp5_ = self->priv->_match;
#line 169 "../src/Backend/App.vala"
				_tmp6_ = synapse_match_get_has_thumbnail (_tmp5_);
#line 169 "../src/Backend/App.vala"
				_tmp7_ = _tmp6_;
#line 169 "../src/Backend/App.vala"
				_tmp1_ = _tmp7_;
#line 1401 "App.c"
			} else {
#line 169 "../src/Backend/App.vala"
				_tmp1_ = FALSE;
#line 1405 "App.c"
			}
#line 169 "../src/Backend/App.vala"
			if (_tmp1_) {
#line 1409 "App.c"
				GdkPixbuf* _tmp8_ = NULL;
				SynapseMatch* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				GdkPixbuf* _tmp12_;
				GdkPixbuf* _tmp13_;
#line 170 "../src/Backend/App.vala"
				_tmp9_ = self->priv->_match;
#line 170 "../src/Backend/App.vala"
				_tmp10_ = synapse_match_get_thumbnail_path (_tmp9_);
#line 170 "../src/Backend/App.vala"
				_tmp11_ = _tmp10_;
#line 170 "../src/Backend/App.vala"
				_tmp12_ = gdk_pixbuf_new_from_file_at_scale (_tmp11_, _data2_->size, _data2_->size, TRUE, &_inner_error0_);
#line 170 "../src/Backend/App.vala"
				_tmp8_ = _tmp12_;
#line 170 "../src/Backend/App.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1428 "App.c"
					goto __catch0_g_error;
				}
#line 170 "../src/Backend/App.vala"
				_tmp13_ = _tmp8_;
#line 170 "../src/Backend/App.vala"
				_tmp8_ = NULL;
#line 170 "../src/Backend/App.vala"
				result = _tmp13_;
#line 170 "../src/Backend/App.vala"
				_g_object_unref0 (_tmp8_);
#line 170 "../src/Backend/App.vala"
				block2_data_unref (_data2_);
#line 170 "../src/Backend/App.vala"
				_data2_ = NULL;
#line 170 "../src/Backend/App.vala"
				return result;
#line 1445 "App.c"
			}
#line 173 "../src/Backend/App.vala"
			_tmp14_ = self->priv->_icon_name;
#line 173 "../src/Backend/App.vala"
			_tmp15_ = g_icon_new_for_string (_tmp14_, &_inner_error0_);
#line 173 "../src/Backend/App.vala"
			icon = _tmp15_;
#line 173 "../src/Backend/App.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1455 "App.c"
				goto __catch0_g_error;
			}
#line 174 "../src/Backend/App.vala"
			_tmp16_ = gtk_icon_theme_get_default ();
#line 174 "../src/Backend/App.vala"
			_tmp17_ = icon;
#line 174 "../src/Backend/App.vala"
			_tmp18_ = gtk_icon_theme_lookup_by_gicon (_tmp16_, _tmp17_, _data2_->size, GTK_ICON_LOOKUP_FORCE_SIZE);
#line 174 "../src/Backend/App.vala"
			info = _tmp18_;
#line 177 "../src/Backend/App.vala"
			_tmp19_ = info;
#line 177 "../src/Backend/App.vala"
			if (_tmp19_ == NULL) {
#line 1470 "App.c"
				GError* _tmp20_;
#line 178 "../src/Backend/App.vala"
				_tmp20_ = g_error_new_literal (ICON_ERROR, ICON_ERROR_NOT_FOUND, "Not found");
#line 178 "../src/Backend/App.vala"
				_inner_error0_ = _tmp20_;
#line 178 "../src/Backend/App.vala"
				_g_object_unref0 (info);
#line 178 "../src/Backend/App.vala"
				_g_object_unref0 (icon);
#line 1480 "App.c"
				goto __catch0_g_error;
			}
#line 180 "../src/Backend/App.vala"
			_tmp22_ = info;
#line 180 "../src/Backend/App.vala"
			_tmp23_ = gtk_icon_info_load_icon (_tmp22_, &_inner_error0_);
#line 180 "../src/Backend/App.vala"
			_tmp21_ = _tmp23_;
#line 180 "../src/Backend/App.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 180 "../src/Backend/App.vala"
				_g_object_unref0 (info);
#line 180 "../src/Backend/App.vala"
				_g_object_unref0 (icon);
#line 1495 "App.c"
				goto __catch0_g_error;
			}
#line 180 "../src/Backend/App.vala"
			_tmp24_ = _tmp21_;
#line 180 "../src/Backend/App.vala"
			_tmp21_ = NULL;
#line 180 "../src/Backend/App.vala"
			result = _tmp24_;
#line 180 "../src/Backend/App.vala"
			_g_object_unref0 (_tmp21_);
#line 180 "../src/Backend/App.vala"
			_g_object_unref0 (info);
#line 180 "../src/Backend/App.vala"
			_g_object_unref0 (icon);
#line 180 "../src/Backend/App.vala"
			block2_data_unref (_data2_);
#line 180 "../src/Backend/App.vala"
			_data2_ = NULL;
#line 180 "../src/Backend/App.vala"
			return result;
#line 1516 "App.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp25_;
			const gchar* _tmp26_;
#line 166 "../src/Backend/App.vala"
			e = _inner_error0_;
#line 166 "../src/Backend/App.vala"
			_inner_error0_ = NULL;
#line 182 "../src/Backend/App.vala"
			_tmp25_ = e;
#line 182 "../src/Backend/App.vala"
			_tmp26_ = _tmp25_->message;
#line 182 "../src/Backend/App.vala"
			g_warning ("App.vala:182: Failed to load icon: %s\n", _tmp26_);
#line 166 "../src/Backend/App.vala"
			_g_error_free0 (e);
#line 1536 "App.c"
		}
		__finally0:
#line 166 "../src/Backend/App.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 166 "../src/Backend/App.vala"
			block2_data_unref (_data2_);
#line 166 "../src/Backend/App.vala"
			_data2_ = NULL;
#line 166 "../src/Backend/App.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 166 "../src/Backend/App.vala"
			g_clear_error (&_inner_error0_);
#line 166 "../src/Backend/App.vala"
			return NULL;
#line 1551 "App.c"
		}
		{
			GdkPixbuf* _tmp27_ = NULL;
			GtkIconTheme* _tmp28_;
			GtkIconTheme* _tmp29_;
			GdkPixbuf* _tmp30_;
			GdkPixbuf* _tmp31_;
#line 186 "../src/Backend/App.vala"
			_tmp28_ = launcher_launchy_get_icon_theme ();
#line 186 "../src/Backend/App.vala"
			_tmp29_ = _tmp28_;
#line 186 "../src/Backend/App.vala"
			_tmp30_ = gtk_icon_theme_load_icon (_tmp29_, "application-default-icon", _data2_->size, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error0_);
#line 186 "../src/Backend/App.vala"
			_tmp27_ = _tmp30_;
#line 186 "../src/Backend/App.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1569 "App.c"
				goto __catch1_g_error;
			}
#line 186 "../src/Backend/App.vala"
			_tmp31_ = _tmp27_;
#line 186 "../src/Backend/App.vala"
			_tmp27_ = NULL;
#line 186 "../src/Backend/App.vala"
			result = _tmp31_;
#line 186 "../src/Backend/App.vala"
			_g_object_unref0 (_tmp27_);
#line 186 "../src/Backend/App.vala"
			block2_data_unref (_data2_);
#line 186 "../src/Backend/App.vala"
			_data2_ = NULL;
#line 186 "../src/Backend/App.vala"
			return result;
#line 1586 "App.c"
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp32_;
			const gchar* _tmp33_;
#line 185 "../src/Backend/App.vala"
			e = _inner_error0_;
#line 185 "../src/Backend/App.vala"
			_inner_error0_ = NULL;
#line 189 "../src/Backend/App.vala"
			_tmp32_ = e;
#line 189 "../src/Backend/App.vala"
			_tmp33_ = _tmp32_->message;
#line 189 "../src/Backend/App.vala"
			g_critical ("App.vala:189: %s", _tmp33_);
#line 185 "../src/Backend/App.vala"
			_g_error_free0 (e);
#line 1606 "App.c"
		}
		__finally1:
#line 185 "../src/Backend/App.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 185 "../src/Backend/App.vala"
			block2_data_unref (_data2_);
#line 185 "../src/Backend/App.vala"
			_data2_ = NULL;
#line 185 "../src/Backend/App.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 185 "../src/Backend/App.vala"
			g_clear_error (&_inner_error0_);
#line 185 "../src/Backend/App.vala"
			return NULL;
#line 1621 "App.c"
		}
	}
#line 193 "../src/Backend/App.vala"
	_data2_->icon = NULL;
#line 194 "../src/Backend/App.vala"
	_data2_->flags = GTK_ICON_LOOKUP_FORCE_SIZE;
#line 196 "../src/Backend/App.vala"
	_tmp34_ = self->priv->loadable_icon;
#line 196 "../src/Backend/App.vala"
	if (_tmp34_ != NULL) {
#line 1632 "App.c"
		GdkPixbuf* _tmp35_;
#line 197 "../src/Backend/App.vala"
		_tmp35_ = launcher_backend_app_get_loadable_icon (self);
#line 197 "../src/Backend/App.vala"
		result = _tmp35_;
#line 197 "../src/Backend/App.vala"
		block2_data_unref (_data2_);
#line 197 "../src/Backend/App.vala"
		_data2_ = NULL;
#line 197 "../src/Backend/App.vala"
		return result;
#line 1644 "App.c"
	}
#line 199 "../src/Backend/App.vala"
	_tmp36_ = launcher_backend_app_icon_load_fallback_method_new (___lambda9__launcher_backend_app_icon_load_fallback, _data2_);
#line 199 "../src/Backend/App.vala"
	_tmp37_ = launcher_backend_app_icon_load_fallback_method_new (___lambda10__launcher_backend_app_icon_load_fallback, self);
#line 199 "../src/Backend/App.vala"
	_tmp38_ = launcher_backend_app_icon_load_fallback_method_new (___lambda12__launcher_backend_app_icon_load_fallback, _data2_);
#line 199 "../src/Backend/App.vala"
	_tmp39_ = launcher_backend_app_icon_load_fallback_method_new (___lambda13__launcher_backend_app_icon_load_fallback, _data2_);
#line 199 "../src/Backend/App.vala"
	_tmp40_ = launcher_backend_app_icon_load_fallback_method_new (___lambda14__launcher_backend_app_icon_load_fallback, _data2_);
#line 199 "../src/Backend/App.vala"
	_tmp41_ = launcher_backend_app_icon_load_fallback_method_new (___lambda15__launcher_backend_app_icon_load_fallback, _data2_);
#line 199 "../src/Backend/App.vala"
	_tmp42_ = g_new0 (LauncherBackendAppIconLoadFallbackMethod*, 6 + 1);
#line 199 "../src/Backend/App.vala"
	_tmp42_[0] = _tmp36_;
#line 199 "../src/Backend/App.vala"
	_tmp42_[1] = _tmp37_;
#line 199 "../src/Backend/App.vala"
	_tmp42_[2] = _tmp38_;
#line 199 "../src/Backend/App.vala"
	_tmp42_[3] = _tmp39_;
#line 199 "../src/Backend/App.vala"
	_tmp42_[4] = _tmp40_;
#line 199 "../src/Backend/App.vala"
	_tmp42_[5] = _tmp41_;
#line 199 "../src/Backend/App.vala"
	fallbacks = _tmp42_;
#line 199 "../src/Backend/App.vala"
	fallbacks_length1 = 6;
#line 199 "../src/Backend/App.vala"
	_fallbacks_size_ = fallbacks_length1;
#line 257 "../src/Backend/App.vala"
	_tmp43_ = fallbacks;
#line 257 "../src/Backend/App.vala"
	_tmp43__length1 = fallbacks_length1;
#line 1682 "App.c"
	{
		LauncherBackendAppIconLoadFallbackMethod** fallback_collection = NULL;
		gint fallback_collection_length1 = 0;
		gint _fallback_collection_size_ = 0;
		gint fallback_it = 0;
#line 257 "../src/Backend/App.vala"
		fallback_collection = _tmp43_;
#line 257 "../src/Backend/App.vala"
		fallback_collection_length1 = _tmp43__length1;
#line 257 "../src/Backend/App.vala"
		for (fallback_it = 0; fallback_it < fallback_collection_length1; fallback_it = fallback_it + 1) {
#line 1694 "App.c"
			LauncherBackendAppIconLoadFallbackMethod* _tmp44_;
			LauncherBackendAppIconLoadFallbackMethod* fallback = NULL;
#line 257 "../src/Backend/App.vala"
			_tmp44_ = _launcher_backend_app_icon_load_fallback_method_ref0 (fallback_collection[fallback_it]);
#line 257 "../src/Backend/App.vala"
			fallback = _tmp44_;
#line 1701 "App.c"
			{
				LauncherBackendAppIconLoadFallbackMethod* _tmp45_;
				LauncherBackendAppIconLoadFallback _tmp46_;
				gpointer _tmp46__target;
				GdkPixbuf* _tmp47_;
#line 258 "../src/Backend/App.vala"
				_tmp45_ = fallback;
#line 258 "../src/Backend/App.vala"
				_tmp46_ = _tmp45_->load_icon;
#line 258 "../src/Backend/App.vala"
				_tmp46__target = _tmp45_->load_icon_target;
#line 258 "../src/Backend/App.vala"
				_tmp46_ (_tmp46__target);
#line 259 "../src/Backend/App.vala"
				_tmp47_ = _data2_->icon;
#line 259 "../src/Backend/App.vala"
				if (_tmp47_ != NULL) {
#line 260 "../src/Backend/App.vala"
					_launcher_backend_app_icon_load_fallback_method_unref0 (fallback);
#line 260 "../src/Backend/App.vala"
					break;
#line 1723 "App.c"
				}
#line 257 "../src/Backend/App.vala"
				_launcher_backend_app_icon_load_fallback_method_unref0 (fallback);
#line 1727 "App.c"
			}
		}
	}
#line 263 "../src/Backend/App.vala"
	_tmp48_ = _data2_->icon;
#line 263 "../src/Backend/App.vala"
	_tmp49_ = _g_object_ref0 (_tmp48_);
#line 263 "../src/Backend/App.vala"
	result = _tmp49_;
#line 263 "../src/Backend/App.vala"
	fallbacks = (_vala_array_free (fallbacks, fallbacks_length1, (GDestroyNotify) launcher_backend_app_icon_load_fallback_method_unref), NULL);
#line 263 "../src/Backend/App.vala"
	block2_data_unref (_data2_);
#line 263 "../src/Backend/App.vala"
	_data2_ = NULL;
#line 263 "../src/Backend/App.vala"
	return result;
#line 1745 "App.c"
}

GdkPixbuf*
launcher_backend_app_get_loadable_icon (LauncherBackendApp* self)
{
	GdkPixbuf* tmp_loadable_icon = NULL;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result = NULL;
#line 266 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1756 "App.c"
	{
		GInputStream* icon_stream = NULL;
		GLoadableIcon* _tmp0_;
		GInputStream* _tmp1_;
		GdkPixbuf* _tmp2_ = NULL;
		GInputStream* _tmp3_;
		LauncherSettings* _tmp4_;
		LauncherSettings* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		LauncherSettings* _tmp8_;
		LauncherSettings* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_;
#line 269 "../src/Backend/App.vala"
		_tmp0_ = self->priv->loadable_icon;
#line 269 "../src/Backend/App.vala"
		_tmp1_ = g_loadable_icon_load (_tmp0_, 0, NULL, NULL, &_inner_error0_);
#line 269 "../src/Backend/App.vala"
		icon_stream = _tmp1_;
#line 269 "../src/Backend/App.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1781 "App.c"
			goto __catch0_g_error;
		}
#line 270 "../src/Backend/App.vala"
		_tmp3_ = icon_stream;
#line 270 "../src/Backend/App.vala"
		_tmp4_ = launcher_launchy_get_settings ();
#line 270 "../src/Backend/App.vala"
		_tmp5_ = _tmp4_;
#line 270 "../src/Backend/App.vala"
		_tmp6_ = launcher_settings_get_icon_size (_tmp5_);
#line 270 "../src/Backend/App.vala"
		_tmp7_ = _tmp6_;
#line 270 "../src/Backend/App.vala"
		_tmp8_ = launcher_launchy_get_settings ();
#line 270 "../src/Backend/App.vala"
		_tmp9_ = _tmp8_;
#line 270 "../src/Backend/App.vala"
		_tmp10_ = launcher_settings_get_icon_size (_tmp9_);
#line 270 "../src/Backend/App.vala"
		_tmp11_ = _tmp10_;
#line 270 "../src/Backend/App.vala"
		_tmp12_ = gdk_pixbuf_new_from_stream_at_scale (_tmp3_, _tmp7_, _tmp11_, TRUE, NULL, &_inner_error0_);
#line 270 "../src/Backend/App.vala"
		_tmp2_ = _tmp12_;
#line 270 "../src/Backend/App.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 270 "../src/Backend/App.vala"
			_g_object_unref0 (icon_stream);
#line 1810 "App.c"
			goto __catch0_g_error;
		}
#line 270 "../src/Backend/App.vala"
		_tmp13_ = _tmp2_;
#line 270 "../src/Backend/App.vala"
		_tmp2_ = NULL;
#line 270 "../src/Backend/App.vala"
		_g_object_unref0 (tmp_loadable_icon);
#line 270 "../src/Backend/App.vala"
		tmp_loadable_icon = _tmp13_;
#line 268 "../src/Backend/App.vala"
		_g_object_unref0 (_tmp2_);
#line 268 "../src/Backend/App.vala"
		_g_object_unref0 (icon_stream);
#line 1825 "App.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 268 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 273 "../src/Backend/App.vala"
		_g_object_unref0 (tmp_loadable_icon);
#line 273 "../src/Backend/App.vala"
		tmp_loadable_icon = NULL;
#line 1836 "App.c"
	}
	__finally0:
#line 268 "../src/Backend/App.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 268 "../src/Backend/App.vala"
		_g_object_unref0 (tmp_loadable_icon);
#line 268 "../src/Backend/App.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 268 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 268 "../src/Backend/App.vala"
		return NULL;
#line 1849 "App.c"
	}
#line 275 "../src/Backend/App.vala"
	result = tmp_loadable_icon;
#line 275 "../src/Backend/App.vala"
	return result;
#line 1855 "App.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1570 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1571 "glib-2.0.vapi"
	result = self;
#line 1571 "glib-2.0.vapi"
	return result;
#line 1868 "App.c"
}

gboolean
launcher_backend_app_launch (LauncherBackendApp* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 278 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1878 "App.c"
	{
		LauncherBackendAppAppType _tmp0_;
#line 280 "../src/Backend/App.vala"
		_tmp0_ = self->priv->_app_type;
#line 280 "../src/Backend/App.vala"
		switch (_tmp0_) {
#line 280 "../src/Backend/App.vala"
			case LAUNCHER_BACKEND_APP_APP_TYPE_COMMAND:
#line 1887 "App.c"
			{
				const gchar* _tmp1_;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				const gchar* _tmp5_;
#line 282 "../src/Backend/App.vala"
				_tmp1_ = self->priv->_name;
#line 282 "../src/Backend/App.vala"
				_tmp2_ = string_to_string (_tmp1_);
#line 282 "../src/Backend/App.vala"
				_tmp3_ = g_strconcat ("Launching command: ", _tmp2_, NULL);
#line 282 "../src/Backend/App.vala"
				_tmp4_ = _tmp3_;
#line 282 "../src/Backend/App.vala"
				g_debug ("App.vala:282: %s", _tmp4_);
#line 282 "../src/Backend/App.vala"
				_g_free0 (_tmp4_);
#line 283 "../src/Backend/App.vala"
				_tmp5_ = self->priv->_exec;
#line 283 "../src/Backend/App.vala"
				g_spawn_command_line_async (_tmp5_, &_inner_error0_);
#line 283 "../src/Backend/App.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1912 "App.c"
					goto __catch0_g_error;
				}
#line 284 "../src/Backend/App.vala"
				break;
#line 1917 "App.c"
			}
#line 280 "../src/Backend/App.vala"
			case LAUNCHER_BACKEND_APP_APP_TYPE_APP:
#line 1921 "App.c"
			{
				const gchar* _tmp6_;
				GDesktopAppInfo* _tmp7_;
				GDesktopAppInfo* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
#line 286 "../src/Backend/App.vala"
				g_signal_emit (self, launcher_backend_app_signals[LAUNCHER_BACKEND_APP_LAUNCHED_SIGNAL], 0, self);
#line 287 "../src/Backend/App.vala"
				_tmp6_ = self->priv->_desktop_id;
#line 287 "../src/Backend/App.vala"
				_tmp7_ = g_desktop_app_info_new (_tmp6_);
#line 287 "../src/Backend/App.vala"
				_tmp8_ = _tmp7_;
#line 287 "../src/Backend/App.vala"
				g_app_info_launch ((GAppInfo*) _tmp8_, NULL, NULL, &_inner_error0_);
#line 287 "../src/Backend/App.vala"
				_g_object_unref0 (_tmp8_);
#line 287 "../src/Backend/App.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1944 "App.c"
					goto __catch0_g_error;
				}
#line 288 "../src/Backend/App.vala"
				_tmp9_ = self->priv->_name;
#line 288 "../src/Backend/App.vala"
				_tmp10_ = string_to_string (_tmp9_);
#line 288 "../src/Backend/App.vala"
				_tmp11_ = g_strconcat ("Launching application: ", _tmp10_, NULL);
#line 288 "../src/Backend/App.vala"
				_tmp12_ = _tmp11_;
#line 288 "../src/Backend/App.vala"
				g_debug ("App.vala:288: %s", _tmp12_);
#line 288 "../src/Backend/App.vala"
				_g_free0 (_tmp12_);
#line 289 "../src/Backend/App.vala"
				break;
#line 1961 "App.c"
			}
#line 280 "../src/Backend/App.vala"
			case LAUNCHER_BACKEND_APP_APP_TYPE_SYNAPSE:
#line 1965 "App.c"
			{
				SynapseMatch* _tmp13_;
				SynapseMatchType _tmp14_;
				SynapseMatchType _tmp15_;
#line 291 "../src/Backend/App.vala"
				_tmp13_ = self->priv->_match;
#line 291 "../src/Backend/App.vala"
				_tmp14_ = synapse_match_get_match_type (_tmp13_);
#line 291 "../src/Backend/App.vala"
				_tmp15_ = _tmp14_;
#line 291 "../src/Backend/App.vala"
				if (_tmp15_ == SYNAPSE_MATCH_TYPE_SEARCH) {
#line 1978 "App.c"
					SynapseMatch* _tmp16_;
					SynapseMatch* _tmp17_;
#line 292 "../src/Backend/App.vala"
					_tmp16_ = self->priv->_match;
#line 292 "../src/Backend/App.vala"
					_tmp17_ = self->priv->_target;
#line 292 "../src/Backend/App.vala"
					g_signal_emit (self, launcher_backend_app_signals[LAUNCHER_BACKEND_APP_START_SEARCH_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, SYNAPSE_TYPE_SEARCH_MATCH) ? ((SynapseSearchMatch*) _tmp16_) : NULL, _tmp17_);
#line 293 "../src/Backend/App.vala"
					result = FALSE;
#line 293 "../src/Backend/App.vala"
					return result;
#line 1991 "App.c"
				} else {
					SynapseMatch* _tmp18_;
#line 295 "../src/Backend/App.vala"
					_tmp18_ = self->priv->_target;
#line 295 "../src/Backend/App.vala"
					if (_tmp18_ == NULL) {
#line 1998 "App.c"
						SynapseMatch* _tmp19_;
						GeeList* _tmp20_;
						GeeList* _tmp21_;
						gpointer _tmp22_;
						SynapseMatch* _tmp23_;
						SynapseMatch* _tmp24_;
#line 296 "../src/Backend/App.vala"
						_tmp19_ = self->priv->_match;
#line 296 "../src/Backend/App.vala"
						_tmp20_ = launcher_backend_synapse_search_find_actions_for_match (_tmp19_);
#line 296 "../src/Backend/App.vala"
						_tmp21_ = _tmp20_;
#line 296 "../src/Backend/App.vala"
						_tmp22_ = gee_list_get (_tmp21_, 0);
#line 296 "../src/Backend/App.vala"
						_tmp23_ = (SynapseMatch*) _tmp22_;
#line 296 "../src/Backend/App.vala"
						_tmp24_ = self->priv->_match;
#line 296 "../src/Backend/App.vala"
						synapse_match_execute_with_target (_tmp23_, _tmp24_, NULL);
#line 296 "../src/Backend/App.vala"
						_g_object_unref0 (_tmp23_);
#line 296 "../src/Backend/App.vala"
						_g_object_unref0 (_tmp21_);
#line 2023 "App.c"
					} else {
						SynapseMatch* _tmp25_;
						SynapseMatch* _tmp26_;
#line 298 "../src/Backend/App.vala"
						_tmp25_ = self->priv->_match;
#line 298 "../src/Backend/App.vala"
						_tmp26_ = self->priv->_target;
#line 298 "../src/Backend/App.vala"
						synapse_match_execute_with_target (_tmp25_, _tmp26_, NULL);
#line 2033 "App.c"
					}
				}
#line 300 "../src/Backend/App.vala"
				break;
#line 2038 "App.c"
			}
			default:
#line 280 "../src/Backend/App.vala"
			break;
#line 2043 "App.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp27_;
		const gchar* _tmp28_;
#line 279 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 303 "../src/Backend/App.vala"
		_tmp27_ = self->priv->_name;
#line 303 "../src/Backend/App.vala"
		_tmp28_ = self->priv->_exec;
#line 303 "../src/Backend/App.vala"
		g_warning ("App.vala:303: Failed to launch %s: %s", _tmp27_, _tmp28_);
#line 2059 "App.c"
	}
	__finally0:
#line 279 "../src/Backend/App.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2064 "App.c"
		gboolean _tmp29_ = FALSE;
#line 279 "../src/Backend/App.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 279 "../src/Backend/App.vala"
		g_clear_error (&_inner_error0_);
#line 279 "../src/Backend/App.vala"
		return _tmp29_;
#line 2072 "App.c"
	}
#line 306 "../src/Backend/App.vala"
	result = TRUE;
#line 306 "../src/Backend/App.vala"
	return result;
#line 2078 "App.c"
}

void
launcher_backend_app_init_actions (LauncherBackendApp* self,
                                   GError** error)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GKeyFile* file = NULL;
	gchar* textdomain = NULL;
	gboolean _tmp18_ = FALSE;
	GeeArrayList* _tmp19_;
	GError* _inner_error0_ = NULL;
#line 310 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 311 "../src/Backend/App.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 311 "../src/Backend/App.vala"
	_tmp1_ = _tmp0_;
#line 311 "../src/Backend/App.vala"
	launcher_backend_app_set_actions (self, _tmp1_);
#line 311 "../src/Backend/App.vala"
	_g_object_unref0 (_tmp1_);
#line 312 "../src/Backend/App.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 312 "../src/Backend/App.vala"
	_tmp3_ = _tmp2_;
#line 312 "../src/Backend/App.vala"
	launcher_backend_app_set_actions_map (self, _tmp3_);
#line 312 "../src/Backend/App.vala"
	_g_object_unref0 (_tmp3_);
#line 2112 "App.c"
	{
		GKeyFile* _tmp4_;
		GKeyFile* _tmp5_;
		const gchar* _tmp6_;
#line 318 "../src/Backend/App.vala"
		_tmp4_ = g_key_file_new ();
#line 318 "../src/Backend/App.vala"
		_g_key_file_unref0 (file);
#line 318 "../src/Backend/App.vala"
		file = _tmp4_;
#line 319 "../src/Backend/App.vala"
		_tmp5_ = file;
#line 319 "../src/Backend/App.vala"
		_tmp6_ = self->priv->_desktop_path;
#line 319 "../src/Backend/App.vala"
		g_key_file_load_from_file (_tmp5_, _tmp6_, 0, &_inner_error0_);
#line 319 "../src/Backend/App.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2131 "App.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 317 "../src/Backend/App.vala"
		e = _inner_error0_;
#line 317 "../src/Backend/App.vala"
		_inner_error0_ = NULL;
#line 321 "../src/Backend/App.vala"
		_tmp7_ = self->priv->_desktop_path;
#line 321 "../src/Backend/App.vala"
		_tmp8_ = e;
#line 321 "../src/Backend/App.vala"
		_tmp9_ = _tmp8_->message;
#line 321 "../src/Backend/App.vala"
		g_critical ("App.vala:321: %s: %s", _tmp7_, _tmp9_);
#line 317 "../src/Backend/App.vala"
		_g_error_free0 (e);
#line 2156 "App.c"
	}
	__finally0:
#line 317 "../src/Backend/App.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 317 "../src/Backend/App.vala"
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 317 "../src/Backend/App.vala"
			g_propagate_error (error, _inner_error0_);
#line 317 "../src/Backend/App.vala"
			_g_key_file_unref0 (file);
#line 317 "../src/Backend/App.vala"
			return;
#line 2169 "App.c"
		} else {
#line 317 "../src/Backend/App.vala"
			_g_key_file_unref0 (file);
#line 317 "../src/Backend/App.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 317 "../src/Backend/App.vala"
			g_clear_error (&_inner_error0_);
#line 317 "../src/Backend/App.vala"
			return;
#line 2179 "App.c"
		}
	}
#line 324 "../src/Backend/App.vala"
	textdomain = NULL;
#line 2184 "App.c"
	{
		const gchar** domain_key_collection = NULL;
		gint domain_key_collection_length1 = 0;
		gint _domain_key_collection_size_ = 0;
		gint domain_key_it = 0;
#line 325 "../src/Backend/App.vala"
		domain_key_collection = LAUNCHER_BACKEND_APP_SUPPORTED_GETTEXT_DOMAINS_KEYS;
#line 325 "../src/Backend/App.vala"
		domain_key_collection_length1 = G_N_ELEMENTS (LAUNCHER_BACKEND_APP_SUPPORTED_GETTEXT_DOMAINS_KEYS);
#line 325 "../src/Backend/App.vala"
		for (domain_key_it = 0; domain_key_it < domain_key_collection_length1; domain_key_it = domain_key_it + 1) {
#line 2196 "App.c"
			const gchar* domain_key = NULL;
#line 325 "../src/Backend/App.vala"
			domain_key = domain_key_collection[domain_key_it];
#line 2200 "App.c"
			{
				gboolean _tmp10_ = FALSE;
				GKeyFile* _tmp11_;
				const gchar* _tmp12_;
#line 326 "../src/Backend/App.vala"
				_tmp11_ = file;
#line 326 "../src/Backend/App.vala"
				_tmp12_ = domain_key;
#line 326 "../src/Backend/App.vala"
				_tmp10_ = g_key_file_has_key (_tmp11_, G_KEY_FILE_DESKTOP_GROUP, _tmp12_, &_inner_error0_);
#line 326 "../src/Backend/App.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 326 "../src/Backend/App.vala"
					if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 326 "../src/Backend/App.vala"
						g_propagate_error (error, _inner_error0_);
#line 326 "../src/Backend/App.vala"
						_g_free0 (textdomain);
#line 326 "../src/Backend/App.vala"
						_g_key_file_unref0 (file);
#line 326 "../src/Backend/App.vala"
						return;
#line 2223 "App.c"
					} else {
#line 326 "../src/Backend/App.vala"
						_g_free0 (textdomain);
#line 326 "../src/Backend/App.vala"
						_g_key_file_unref0 (file);
#line 326 "../src/Backend/App.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 326 "../src/Backend/App.vala"
						g_clear_error (&_inner_error0_);
#line 326 "../src/Backend/App.vala"
						return;
#line 2235 "App.c"
					}
				}
#line 326 "../src/Backend/App.vala"
				if (_tmp10_) {
#line 2240 "App.c"
					gchar* _tmp13_ = NULL;
					GKeyFile* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
#line 327 "../src/Backend/App.vala"
					_tmp14_ = file;
#line 327 "../src/Backend/App.vala"
					_tmp15_ = domain_key;
#line 327 "../src/Backend/App.vala"
					_tmp16_ = g_key_file_get_string (_tmp14_, G_KEY_FILE_DESKTOP_GROUP, _tmp15_, &_inner_error0_);
#line 327 "../src/Backend/App.vala"
					_tmp13_ = _tmp16_;
#line 327 "../src/Backend/App.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 327 "../src/Backend/App.vala"
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 327 "../src/Backend/App.vala"
							g_propagate_error (error, _inner_error0_);
#line 327 "../src/Backend/App.vala"
							_g_free0 (textdomain);
#line 327 "../src/Backend/App.vala"
							_g_key_file_unref0 (file);
#line 327 "../src/Backend/App.vala"
							return;
#line 2266 "App.c"
						} else {
#line 327 "../src/Backend/App.vala"
							_g_free0 (textdomain);
#line 327 "../src/Backend/App.vala"
							_g_key_file_unref0 (file);
#line 327 "../src/Backend/App.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 327 "../src/Backend/App.vala"
							g_clear_error (&_inner_error0_);
#line 327 "../src/Backend/App.vala"
							return;
#line 2278 "App.c"
						}
					}
#line 327 "../src/Backend/App.vala"
					_tmp17_ = _tmp13_;
#line 327 "../src/Backend/App.vala"
					_tmp13_ = NULL;
#line 327 "../src/Backend/App.vala"
					_g_free0 (textdomain);
#line 327 "../src/Backend/App.vala"
					textdomain = _tmp17_;
#line 328 "../src/Backend/App.vala"
					_g_free0 (_tmp13_);
#line 328 "../src/Backend/App.vala"
					break;
#line 2293 "App.c"
				}
			}
		}
	}
#line 330 "../src/Backend/App.vala"
	_tmp19_ = self->priv->_actions;
#line 330 "../src/Backend/App.vala"
	if (_tmp19_ != NULL) {
#line 2302 "App.c"
		GeeHashMap* _tmp20_;
#line 330 "../src/Backend/App.vala"
		_tmp20_ = self->priv->_actions_map;
#line 330 "../src/Backend/App.vala"
		_tmp18_ = _tmp20_ != NULL;
#line 2308 "App.c"
	} else {
#line 330 "../src/Backend/App.vala"
		_tmp18_ = FALSE;
#line 2312 "App.c"
	}
#line 330 "../src/Backend/App.vala"
	if (_tmp18_) {
#line 2316 "App.c"
		GeeArrayList* _tmp21_;
		GeeHashMap* _tmp22_;
		gchar** keys = NULL;
		gchar* _tmp23_;
		gchar** _tmp24_;
		gint keys_length1;
		gint _keys_size_;
		gchar** _tmp25_;
		gint _tmp25__length1;
#line 331 "../src/Backend/App.vala"
		_tmp21_ = self->priv->_actions;
#line 331 "../src/Backend/App.vala"
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp21_);
#line 332 "../src/Backend/App.vala"
		_tmp22_ = self->priv->_actions_map;
#line 332 "../src/Backend/App.vala"
		gee_abstract_map_clear ((GeeAbstractMap*) _tmp22_);
#line 333 "../src/Backend/App.vala"
		_tmp23_ = g_strdup (LAUNCHER_BACKEND_APP_DESKTOP_ACTION_KEY);
#line 333 "../src/Backend/App.vala"
		_tmp24_ = g_new0 (gchar*, 1 + 1);
#line 333 "../src/Backend/App.vala"
		_tmp24_[0] = _tmp23_;
#line 333 "../src/Backend/App.vala"
		keys = _tmp24_;
#line 333 "../src/Backend/App.vala"
		keys_length1 = 1;
#line 333 "../src/Backend/App.vala"
		_keys_size_ = keys_length1;
#line 335 "../src/Backend/App.vala"
		_tmp25_ = keys;
#line 335 "../src/Backend/App.vala"
		_tmp25__length1 = keys_length1;
#line 2350 "App.c"
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
#line 335 "../src/Backend/App.vala"
			key_collection = _tmp25_;
#line 335 "../src/Backend/App.vala"
			key_collection_length1 = _tmp25__length1;
#line 335 "../src/Backend/App.vala"
			for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
#line 2362 "App.c"
				gchar* _tmp26_;
				gchar* key = NULL;
#line 335 "../src/Backend/App.vala"
				_tmp26_ = g_strdup (key_collection[key_it]);
#line 335 "../src/Backend/App.vala"
				key = _tmp26_;
#line 2369 "App.c"
				{
					gboolean _tmp27_ = FALSE;
					GKeyFile* _tmp28_;
					const gchar* _tmp29_;
					gchar** _tmp30_ = NULL;
					GKeyFile* _tmp31_;
					const gchar* _tmp32_;
					gsize _tmp33_ = 0;
					gchar** _tmp34_;
					gint _tmp30__length1;
					gint __tmp30__size_;
#line 336 "../src/Backend/App.vala"
					_tmp28_ = file;
#line 336 "../src/Backend/App.vala"
					_tmp29_ = key;
#line 336 "../src/Backend/App.vala"
					_tmp27_ = g_key_file_has_key (_tmp28_, G_KEY_FILE_DESKTOP_GROUP, _tmp29_, &_inner_error0_);
#line 336 "../src/Backend/App.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 336 "../src/Backend/App.vala"
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 336 "../src/Backend/App.vala"
							g_propagate_error (error, _inner_error0_);
#line 336 "../src/Backend/App.vala"
							_g_free0 (key);
#line 336 "../src/Backend/App.vala"
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 336 "../src/Backend/App.vala"
							_g_free0 (textdomain);
#line 336 "../src/Backend/App.vala"
							_g_key_file_unref0 (file);
#line 336 "../src/Backend/App.vala"
							return;
#line 2403 "App.c"
						} else {
#line 336 "../src/Backend/App.vala"
							_g_free0 (key);
#line 336 "../src/Backend/App.vala"
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 336 "../src/Backend/App.vala"
							_g_free0 (textdomain);
#line 336 "../src/Backend/App.vala"
							_g_key_file_unref0 (file);
#line 336 "../src/Backend/App.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 336 "../src/Backend/App.vala"
							g_clear_error (&_inner_error0_);
#line 336 "../src/Backend/App.vala"
							return;
#line 2419 "App.c"
						}
					}
#line 336 "../src/Backend/App.vala"
					if (!_tmp27_) {
#line 337 "../src/Backend/App.vala"
						_g_free0 (key);
#line 337 "../src/Backend/App.vala"
						continue;
#line 2428 "App.c"
					}
#line 339 "../src/Backend/App.vala"
					_tmp31_ = file;
#line 339 "../src/Backend/App.vala"
					_tmp32_ = key;
#line 339 "../src/Backend/App.vala"
					_tmp34_ = g_key_file_get_string_list (_tmp31_, G_KEY_FILE_DESKTOP_GROUP, _tmp32_, &_tmp33_, &_inner_error0_);
#line 339 "../src/Backend/App.vala"
					_tmp30_ = _tmp34_;
#line 339 "../src/Backend/App.vala"
					_tmp30__length1 = _tmp33_;
#line 339 "../src/Backend/App.vala"
					__tmp30__size_ = _tmp30__length1;
#line 339 "../src/Backend/App.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 339 "../src/Backend/App.vala"
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 339 "../src/Backend/App.vala"
							g_propagate_error (error, _inner_error0_);
#line 339 "../src/Backend/App.vala"
							_g_free0 (key);
#line 339 "../src/Backend/App.vala"
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 339 "../src/Backend/App.vala"
							_g_free0 (textdomain);
#line 339 "../src/Backend/App.vala"
							_g_key_file_unref0 (file);
#line 339 "../src/Backend/App.vala"
							return;
#line 2458 "App.c"
						} else {
#line 339 "../src/Backend/App.vala"
							_g_free0 (key);
#line 339 "../src/Backend/App.vala"
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 339 "../src/Backend/App.vala"
							_g_free0 (textdomain);
#line 339 "../src/Backend/App.vala"
							_g_key_file_unref0 (file);
#line 339 "../src/Backend/App.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 339 "../src/Backend/App.vala"
							g_clear_error (&_inner_error0_);
#line 339 "../src/Backend/App.vala"
							return;
#line 2474 "App.c"
						}
					}
					{
						gchar** action_collection = NULL;
						gint action_collection_length1 = 0;
						gint _action_collection_size_ = 0;
						gint action_it = 0;
#line 339 "../src/Backend/App.vala"
						action_collection = _tmp30_;
#line 339 "../src/Backend/App.vala"
						action_collection_length1 = _tmp30__length1;
#line 339 "../src/Backend/App.vala"
						for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
#line 2488 "App.c"
							gchar* _tmp35_;
							gchar* action = NULL;
#line 339 "../src/Backend/App.vala"
							_tmp35_ = g_strdup (action_collection[action_it]);
#line 339 "../src/Backend/App.vala"
							action = _tmp35_;
#line 2495 "App.c"
							{
								gchar* group = NULL;
								const gchar* _tmp36_;
								gchar* _tmp37_;
								GKeyFile* _tmp38_;
								const gchar* _tmp39_;
								gboolean _tmp40_ = FALSE;
								GKeyFile* _tmp41_;
								const gchar* _tmp42_;
								gchar* action_name = NULL;
								GKeyFile* _tmp43_;
								const gchar* _tmp44_;
								gchar* _tmp45_;
								gchar* action_icon = NULL;
								gchar* _tmp46_;
								gboolean _tmp47_ = FALSE;
								GKeyFile* _tmp48_;
								const gchar* _tmp49_;
								gchar* action_exec = NULL;
								gchar* _tmp55_;
								gboolean _tmp56_ = FALSE;
								GKeyFile* _tmp57_;
								const gchar* _tmp58_;
								const gchar* _tmp64_;
								GeeArrayList* _tmp68_;
								const gchar* _tmp69_;
								GeeHashMap* _tmp70_;
								const gchar* _tmp71_;
								const gchar* _tmp72_;
								const gchar* _tmp73_;
								gchar* _tmp74_;
								gchar* _tmp75_;
#line 340 "../src/Backend/App.vala"
								_tmp36_ = action;
#line 340 "../src/Backend/App.vala"
								_tmp37_ = g_strdup_printf (LAUNCHER_BACKEND_APP_DESKTOP_ACTION_GROUP_NAME, _tmp36_);
#line 340 "../src/Backend/App.vala"
								group = _tmp37_;
#line 341 "../src/Backend/App.vala"
								_tmp38_ = file;
#line 341 "../src/Backend/App.vala"
								_tmp39_ = group;
#line 341 "../src/Backend/App.vala"
								if (!g_key_file_has_group (_tmp38_, _tmp39_)) {
#line 342 "../src/Backend/App.vala"
									_g_free0 (group);
#line 342 "../src/Backend/App.vala"
									_g_free0 (action);
#line 342 "../src/Backend/App.vala"
									continue;
#line 2546 "App.c"
								}
#line 346 "../src/Backend/App.vala"
								_tmp41_ = file;
#line 346 "../src/Backend/App.vala"
								_tmp42_ = group;
#line 346 "../src/Backend/App.vala"
								_tmp40_ = g_key_file_has_key (_tmp41_, _tmp42_, G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN, &_inner_error0_);
#line 346 "../src/Backend/App.vala"
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 346 "../src/Backend/App.vala"
									if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 346 "../src/Backend/App.vala"
										g_propagate_error (error, _inner_error0_);
#line 346 "../src/Backend/App.vala"
										_g_free0 (group);
#line 346 "../src/Backend/App.vala"
										_g_free0 (action);
#line 346 "../src/Backend/App.vala"
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 346 "../src/Backend/App.vala"
										_g_free0 (key);
#line 346 "../src/Backend/App.vala"
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 346 "../src/Backend/App.vala"
										_g_free0 (textdomain);
#line 346 "../src/Backend/App.vala"
										_g_key_file_unref0 (file);
#line 346 "../src/Backend/App.vala"
										return;
#line 2576 "App.c"
									} else {
#line 346 "../src/Backend/App.vala"
										_g_free0 (group);
#line 346 "../src/Backend/App.vala"
										_g_free0 (action);
#line 346 "../src/Backend/App.vala"
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 346 "../src/Backend/App.vala"
										_g_free0 (key);
#line 346 "../src/Backend/App.vala"
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 346 "../src/Backend/App.vala"
										_g_free0 (textdomain);
#line 346 "../src/Backend/App.vala"
										_g_key_file_unref0 (file);
#line 346 "../src/Backend/App.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 346 "../src/Backend/App.vala"
										g_clear_error (&_inner_error0_);
#line 346 "../src/Backend/App.vala"
										return;
#line 2598 "App.c"
									}
								}
#line 346 "../src/Backend/App.vala"
								if (_tmp40_) {
#line 347 "../src/Backend/App.vala"
									_g_free0 (group);
#line 347 "../src/Backend/App.vala"
									_g_free0 (action);
#line 347 "../src/Backend/App.vala"
									continue;
#line 2609 "App.c"
								}
#line 350 "../src/Backend/App.vala"
								_tmp43_ = file;
#line 350 "../src/Backend/App.vala"
								_tmp44_ = group;
#line 350 "../src/Backend/App.vala"
								_tmp45_ = g_key_file_get_locale_string (_tmp43_, _tmp44_, G_KEY_FILE_DESKTOP_KEY_NAME, NULL, &_inner_error0_);
#line 350 "../src/Backend/App.vala"
								action_name = _tmp45_;
#line 350 "../src/Backend/App.vala"
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 350 "../src/Backend/App.vala"
									if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 350 "../src/Backend/App.vala"
										g_propagate_error (error, _inner_error0_);
#line 350 "../src/Backend/App.vala"
										_g_free0 (group);
#line 350 "../src/Backend/App.vala"
										_g_free0 (action);
#line 350 "../src/Backend/App.vala"
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 350 "../src/Backend/App.vala"
										_g_free0 (key);
#line 350 "../src/Backend/App.vala"
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 350 "../src/Backend/App.vala"
										_g_free0 (textdomain);
#line 350 "../src/Backend/App.vala"
										_g_key_file_unref0 (file);
#line 350 "../src/Backend/App.vala"
										return;
#line 2641 "App.c"
									} else {
#line 350 "../src/Backend/App.vala"
										_g_free0 (group);
#line 350 "../src/Backend/App.vala"
										_g_free0 (action);
#line 350 "../src/Backend/App.vala"
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 350 "../src/Backend/App.vala"
										_g_free0 (key);
#line 350 "../src/Backend/App.vala"
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 350 "../src/Backend/App.vala"
										_g_free0 (textdomain);
#line 350 "../src/Backend/App.vala"
										_g_key_file_unref0 (file);
#line 350 "../src/Backend/App.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 350 "../src/Backend/App.vala"
										g_clear_error (&_inner_error0_);
#line 350 "../src/Backend/App.vala"
										return;
#line 2663 "App.c"
									}
								}
#line 352 "../src/Backend/App.vala"
								_tmp46_ = g_strdup ("");
#line 352 "../src/Backend/App.vala"
								action_icon = _tmp46_;
#line 353 "../src/Backend/App.vala"
								_tmp48_ = file;
#line 353 "../src/Backend/App.vala"
								_tmp49_ = group;
#line 353 "../src/Backend/App.vala"
								_tmp47_ = g_key_file_has_key (_tmp48_, _tmp49_, G_KEY_FILE_DESKTOP_KEY_ICON, &_inner_error0_);
#line 353 "../src/Backend/App.vala"
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 353 "../src/Backend/App.vala"
									if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 353 "../src/Backend/App.vala"
										g_propagate_error (error, _inner_error0_);
#line 353 "../src/Backend/App.vala"
										_g_free0 (action_icon);
#line 353 "../src/Backend/App.vala"
										_g_free0 (action_name);
#line 353 "../src/Backend/App.vala"
										_g_free0 (group);
#line 353 "../src/Backend/App.vala"
										_g_free0 (action);
#line 353 "../src/Backend/App.vala"
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 353 "../src/Backend/App.vala"
										_g_free0 (key);
#line 353 "../src/Backend/App.vala"
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 353 "../src/Backend/App.vala"
										_g_free0 (textdomain);
#line 353 "../src/Backend/App.vala"
										_g_key_file_unref0 (file);
#line 353 "../src/Backend/App.vala"
										return;
#line 2702 "App.c"
									} else {
#line 353 "../src/Backend/App.vala"
										_g_free0 (action_icon);
#line 353 "../src/Backend/App.vala"
										_g_free0 (action_name);
#line 353 "../src/Backend/App.vala"
										_g_free0 (group);
#line 353 "../src/Backend/App.vala"
										_g_free0 (action);
#line 353 "../src/Backend/App.vala"
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 353 "../src/Backend/App.vala"
										_g_free0 (key);
#line 353 "../src/Backend/App.vala"
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 353 "../src/Backend/App.vala"
										_g_free0 (textdomain);
#line 353 "../src/Backend/App.vala"
										_g_key_file_unref0 (file);
#line 353 "../src/Backend/App.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 353 "../src/Backend/App.vala"
										g_clear_error (&_inner_error0_);
#line 353 "../src/Backend/App.vala"
										return;
#line 2728 "App.c"
									}
								}
#line 353 "../src/Backend/App.vala"
								if (_tmp47_) {
#line 2733 "App.c"
									gchar* _tmp50_ = NULL;
									GKeyFile* _tmp51_;
									const gchar* _tmp52_;
									gchar* _tmp53_;
									gchar* _tmp54_;
#line 354 "../src/Backend/App.vala"
									_tmp51_ = file;
#line 354 "../src/Backend/App.vala"
									_tmp52_ = group;
#line 354 "../src/Backend/App.vala"
									_tmp53_ = g_key_file_get_locale_string (_tmp51_, _tmp52_, G_KEY_FILE_DESKTOP_KEY_ICON, NULL, &_inner_error0_);
#line 354 "../src/Backend/App.vala"
									_tmp50_ = _tmp53_;
#line 354 "../src/Backend/App.vala"
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 354 "../src/Backend/App.vala"
										if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 354 "../src/Backend/App.vala"
											g_propagate_error (error, _inner_error0_);
#line 354 "../src/Backend/App.vala"
											_g_free0 (action_icon);
#line 354 "../src/Backend/App.vala"
											_g_free0 (action_name);
#line 354 "../src/Backend/App.vala"
											_g_free0 (group);
#line 354 "../src/Backend/App.vala"
											_g_free0 (action);
#line 354 "../src/Backend/App.vala"
											_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 354 "../src/Backend/App.vala"
											_g_free0 (key);
#line 354 "../src/Backend/App.vala"
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 354 "../src/Backend/App.vala"
											_g_free0 (textdomain);
#line 354 "../src/Backend/App.vala"
											_g_key_file_unref0 (file);
#line 354 "../src/Backend/App.vala"
											return;
#line 2773 "App.c"
										} else {
#line 354 "../src/Backend/App.vala"
											_g_free0 (action_icon);
#line 354 "../src/Backend/App.vala"
											_g_free0 (action_name);
#line 354 "../src/Backend/App.vala"
											_g_free0 (group);
#line 354 "../src/Backend/App.vala"
											_g_free0 (action);
#line 354 "../src/Backend/App.vala"
											_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 354 "../src/Backend/App.vala"
											_g_free0 (key);
#line 354 "../src/Backend/App.vala"
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 354 "../src/Backend/App.vala"
											_g_free0 (textdomain);
#line 354 "../src/Backend/App.vala"
											_g_key_file_unref0 (file);
#line 354 "../src/Backend/App.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 354 "../src/Backend/App.vala"
											g_clear_error (&_inner_error0_);
#line 354 "../src/Backend/App.vala"
											return;
#line 2799 "App.c"
										}
									}
#line 354 "../src/Backend/App.vala"
									_tmp54_ = _tmp50_;
#line 354 "../src/Backend/App.vala"
									_tmp50_ = NULL;
#line 354 "../src/Backend/App.vala"
									_g_free0 (action_icon);
#line 354 "../src/Backend/App.vala"
									action_icon = _tmp54_;
#line 353 "../src/Backend/App.vala"
									_g_free0 (_tmp50_);
#line 2812 "App.c"
								}
#line 356 "../src/Backend/App.vala"
								_tmp55_ = g_strdup ("");
#line 356 "../src/Backend/App.vala"
								action_exec = _tmp55_;
#line 357 "../src/Backend/App.vala"
								_tmp57_ = file;
#line 357 "../src/Backend/App.vala"
								_tmp58_ = group;
#line 357 "../src/Backend/App.vala"
								_tmp56_ = g_key_file_has_key (_tmp57_, _tmp58_, G_KEY_FILE_DESKTOP_KEY_EXEC, &_inner_error0_);
#line 357 "../src/Backend/App.vala"
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 357 "../src/Backend/App.vala"
									if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 357 "../src/Backend/App.vala"
										g_propagate_error (error, _inner_error0_);
#line 357 "../src/Backend/App.vala"
										_g_free0 (action_exec);
#line 357 "../src/Backend/App.vala"
										_g_free0 (action_icon);
#line 357 "../src/Backend/App.vala"
										_g_free0 (action_name);
#line 357 "../src/Backend/App.vala"
										_g_free0 (group);
#line 357 "../src/Backend/App.vala"
										_g_free0 (action);
#line 357 "../src/Backend/App.vala"
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 357 "../src/Backend/App.vala"
										_g_free0 (key);
#line 357 "../src/Backend/App.vala"
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 357 "../src/Backend/App.vala"
										_g_free0 (textdomain);
#line 357 "../src/Backend/App.vala"
										_g_key_file_unref0 (file);
#line 357 "../src/Backend/App.vala"
										return;
#line 2852 "App.c"
									} else {
#line 357 "../src/Backend/App.vala"
										_g_free0 (action_exec);
#line 357 "../src/Backend/App.vala"
										_g_free0 (action_icon);
#line 357 "../src/Backend/App.vala"
										_g_free0 (action_name);
#line 357 "../src/Backend/App.vala"
										_g_free0 (group);
#line 357 "../src/Backend/App.vala"
										_g_free0 (action);
#line 357 "../src/Backend/App.vala"
										_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 357 "../src/Backend/App.vala"
										_g_free0 (key);
#line 357 "../src/Backend/App.vala"
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 357 "../src/Backend/App.vala"
										_g_free0 (textdomain);
#line 357 "../src/Backend/App.vala"
										_g_key_file_unref0 (file);
#line 357 "../src/Backend/App.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 357 "../src/Backend/App.vala"
										g_clear_error (&_inner_error0_);
#line 357 "../src/Backend/App.vala"
										return;
#line 2880 "App.c"
									}
								}
#line 357 "../src/Backend/App.vala"
								if (_tmp56_) {
#line 2885 "App.c"
									gchar* _tmp59_ = NULL;
									GKeyFile* _tmp60_;
									const gchar* _tmp61_;
									gchar* _tmp62_;
									gchar* _tmp63_;
#line 358 "../src/Backend/App.vala"
									_tmp60_ = file;
#line 358 "../src/Backend/App.vala"
									_tmp61_ = group;
#line 358 "../src/Backend/App.vala"
									_tmp62_ = g_key_file_get_string (_tmp60_, _tmp61_, G_KEY_FILE_DESKTOP_KEY_EXEC, &_inner_error0_);
#line 358 "../src/Backend/App.vala"
									_tmp59_ = _tmp62_;
#line 358 "../src/Backend/App.vala"
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 358 "../src/Backend/App.vala"
										if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 358 "../src/Backend/App.vala"
											g_propagate_error (error, _inner_error0_);
#line 358 "../src/Backend/App.vala"
											_g_free0 (action_exec);
#line 358 "../src/Backend/App.vala"
											_g_free0 (action_icon);
#line 358 "../src/Backend/App.vala"
											_g_free0 (action_name);
#line 358 "../src/Backend/App.vala"
											_g_free0 (group);
#line 358 "../src/Backend/App.vala"
											_g_free0 (action);
#line 358 "../src/Backend/App.vala"
											_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 358 "../src/Backend/App.vala"
											_g_free0 (key);
#line 358 "../src/Backend/App.vala"
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 358 "../src/Backend/App.vala"
											_g_free0 (textdomain);
#line 358 "../src/Backend/App.vala"
											_g_key_file_unref0 (file);
#line 358 "../src/Backend/App.vala"
											return;
#line 2927 "App.c"
										} else {
#line 358 "../src/Backend/App.vala"
											_g_free0 (action_exec);
#line 358 "../src/Backend/App.vala"
											_g_free0 (action_icon);
#line 358 "../src/Backend/App.vala"
											_g_free0 (action_name);
#line 358 "../src/Backend/App.vala"
											_g_free0 (group);
#line 358 "../src/Backend/App.vala"
											_g_free0 (action);
#line 358 "../src/Backend/App.vala"
											_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 358 "../src/Backend/App.vala"
											_g_free0 (key);
#line 358 "../src/Backend/App.vala"
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 358 "../src/Backend/App.vala"
											_g_free0 (textdomain);
#line 358 "../src/Backend/App.vala"
											_g_key_file_unref0 (file);
#line 358 "../src/Backend/App.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 358 "../src/Backend/App.vala"
											g_clear_error (&_inner_error0_);
#line 358 "../src/Backend/App.vala"
											return;
#line 2955 "App.c"
										}
									}
#line 358 "../src/Backend/App.vala"
									_tmp63_ = _tmp59_;
#line 358 "../src/Backend/App.vala"
									_tmp59_ = NULL;
#line 358 "../src/Backend/App.vala"
									_g_free0 (action_exec);
#line 358 "../src/Backend/App.vala"
									action_exec = _tmp63_;
#line 357 "../src/Backend/App.vala"
									_g_free0 (_tmp59_);
#line 2968 "App.c"
								}
#line 361 "../src/Backend/App.vala"
								_tmp64_ = textdomain;
#line 361 "../src/Backend/App.vala"
								if (_tmp64_ != NULL) {
#line 2974 "App.c"
									const gchar* _tmp65_;
									const gchar* _tmp66_;
									gchar* _tmp67_;
#line 362 "../src/Backend/App.vala"
									_tmp65_ = textdomain;
#line 362 "../src/Backend/App.vala"
									_tmp66_ = action_name;
#line 362 "../src/Backend/App.vala"
									_tmp67_ = g_strdup (g_dgettext (_tmp65_, _tmp66_));
#line 362 "../src/Backend/App.vala"
									_g_free0 (action_name);
#line 362 "../src/Backend/App.vala"
									action_name = _tmp67_;
#line 2988 "App.c"
								}
#line 364 "../src/Backend/App.vala"
								_tmp68_ = self->priv->_actions;
#line 364 "../src/Backend/App.vala"
								_tmp69_ = action_name;
#line 364 "../src/Backend/App.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp68_, _tmp69_);
#line 365 "../src/Backend/App.vala"
								_tmp70_ = self->priv->_actions_map;
#line 365 "../src/Backend/App.vala"
								_tmp71_ = action_name;
#line 365 "../src/Backend/App.vala"
								_tmp72_ = action_exec;
#line 365 "../src/Backend/App.vala"
								_tmp73_ = action_icon;
#line 365 "../src/Backend/App.vala"
								_tmp74_ = g_strdup_printf ("%s;;%s", _tmp72_, _tmp73_);
#line 365 "../src/Backend/App.vala"
								_tmp75_ = _tmp74_;
#line 365 "../src/Backend/App.vala"
								gee_abstract_map_set ((GeeAbstractMap*) _tmp70_, _tmp71_, _tmp75_);
#line 365 "../src/Backend/App.vala"
								_g_free0 (_tmp75_);
#line 339 "../src/Backend/App.vala"
								_g_free0 (action_exec);
#line 339 "../src/Backend/App.vala"
								_g_free0 (action_icon);
#line 339 "../src/Backend/App.vala"
								_g_free0 (action_name);
#line 339 "../src/Backend/App.vala"
								_g_free0 (group);
#line 339 "../src/Backend/App.vala"
								_g_free0 (action);
#line 3022 "App.c"
							}
						}
					}
#line 335 "../src/Backend/App.vala"
					_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 335 "../src/Backend/App.vala"
					_g_free0 (key);
#line 3030 "App.c"
				}
			}
		}
#line 330 "../src/Backend/App.vala"
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 3036 "App.c"
	}
#line 310 "../src/Backend/App.vala"
	_g_free0 (textdomain);
#line 310 "../src/Backend/App.vala"
	_g_key_file_unref0 (file);
#line 3042 "App.c"
}

const gchar*
launcher_backend_app_get_name (LauncherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 39 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_name;
#line 39 "../src/Backend/App.vala"
	result = _tmp0_;
#line 39 "../src/Backend/App.vala"
	return result;
#line 3058 "App.c"
}

void
launcher_backend_app_set_name (LauncherBackendApp* self,
                               const gchar* value)
{
	gchar* old_value;
#line 39 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 39 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_name (self);
#line 39 "../src/Backend/App.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3072 "App.c"
		gchar* _tmp0_;
#line 39 "../src/Backend/App.vala"
		_tmp0_ = g_strdup (value);
#line 39 "../src/Backend/App.vala"
		_g_free0 (self->priv->_name);
#line 39 "../src/Backend/App.vala"
		self->priv->_name = _tmp0_;
#line 39 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_NAME_PROPERTY]);
#line 3082 "App.c"
	}
}

const gchar*
launcher_backend_app_get_description (LauncherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 40 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_description;
#line 40 "../src/Backend/App.vala"
	result = _tmp0_;
#line 40 "../src/Backend/App.vala"
	return result;
#line 3099 "App.c"
}

static void
launcher_backend_app_set_description (LauncherBackendApp* self,
                                      const gchar* value)
{
	gchar* old_value;
#line 40 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 40 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_description (self);
#line 40 "../src/Backend/App.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3113 "App.c"
		gchar* _tmp0_;
#line 40 "../src/Backend/App.vala"
		_tmp0_ = g_strdup (value);
#line 40 "../src/Backend/App.vala"
		_g_free0 (self->priv->_description);
#line 40 "../src/Backend/App.vala"
		self->priv->_description = _tmp0_;
#line 40 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_DESCRIPTION_PROPERTY]);
#line 3123 "App.c"
	}
}

const gchar*
launcher_backend_app_get_desktop_id (LauncherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 41 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_desktop_id;
#line 41 "../src/Backend/App.vala"
	result = _tmp0_;
#line 41 "../src/Backend/App.vala"
	return result;
#line 3140 "App.c"
}

void
launcher_backend_app_set_desktop_id (LauncherBackendApp* self,
                                     const gchar* value)
{
	gchar* old_value;
#line 41 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 41 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_desktop_id (self);
#line 41 "../src/Backend/App.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3154 "App.c"
		gchar* _tmp0_;
#line 41 "../src/Backend/App.vala"
		_tmp0_ = g_strdup (value);
#line 41 "../src/Backend/App.vala"
		_g_free0 (self->priv->_desktop_id);
#line 41 "../src/Backend/App.vala"
		self->priv->_desktop_id = _tmp0_;
#line 41 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_DESKTOP_ID_PROPERTY]);
#line 3164 "App.c"
	}
}

const gchar*
launcher_backend_app_get_exec (LauncherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 42 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_exec;
#line 42 "../src/Backend/App.vala"
	result = _tmp0_;
#line 42 "../src/Backend/App.vala"
	return result;
#line 3181 "App.c"
}

static void
launcher_backend_app_set_exec (LauncherBackendApp* self,
                               const gchar* value)
{
	gchar* old_value;
#line 42 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 42 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_exec (self);
#line 42 "../src/Backend/App.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3195 "App.c"
		gchar* _tmp0_;
#line 42 "../src/Backend/App.vala"
		_tmp0_ = g_strdup (value);
#line 42 "../src/Backend/App.vala"
		_g_free0 (self->priv->_exec);
#line 42 "../src/Backend/App.vala"
		self->priv->_exec = _tmp0_;
#line 42 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_EXEC_PROPERTY]);
#line 3205 "App.c"
	}
}

const gchar*
launcher_backend_app_get_icon_name (LauncherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 43 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_icon_name;
#line 43 "../src/Backend/App.vala"
	result = _tmp0_;
#line 43 "../src/Backend/App.vala"
	return result;
#line 3222 "App.c"
}

static void
launcher_backend_app_set_icon_name (LauncherBackendApp* self,
                                    const gchar* value)
{
	gchar* old_value;
#line 43 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 43 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_icon_name (self);
#line 43 "../src/Backend/App.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3236 "App.c"
		gchar* _tmp0_;
#line 43 "../src/Backend/App.vala"
		_tmp0_ = g_strdup (value);
#line 43 "../src/Backend/App.vala"
		_g_free0 (self->priv->_icon_name);
#line 43 "../src/Backend/App.vala"
		self->priv->_icon_name = _tmp0_;
#line 43 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_ICON_NAME_PROPERTY]);
#line 3246 "App.c"
	}
}

gchar**
launcher_backend_app_get_keywords (LauncherBackendApp* self,
                                   gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 44 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_keywords;
#line 44 "../src/Backend/App.vala"
	_tmp0__length1 = self->priv->_keywords_length1;
#line 44 "../src/Backend/App.vala"
	_tmp1_ = _tmp0_;
#line 44 "../src/Backend/App.vala"
	_tmp1__length1 = _tmp0__length1;
#line 44 "../src/Backend/App.vala"
	if (result_length1) {
#line 44 "../src/Backend/App.vala"
		*result_length1 = _tmp1__length1;
#line 3273 "App.c"
	}
#line 44 "../src/Backend/App.vala"
	result = _tmp1_;
#line 44 "../src/Backend/App.vala"
	return result;
#line 3279 "App.c"
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gint length)
{
#line 44 "../src/Backend/App.vala"
	if (length >= 0) {
#line 3288 "App.c"
		gchar** result;
		gint i;
#line 44 "../src/Backend/App.vala"
		result = g_new0 (gchar*, length + 1);
#line 44 "../src/Backend/App.vala"
		for (i = 0; i < length; i++) {
#line 3295 "App.c"
			gchar* _tmp0_;
#line 44 "../src/Backend/App.vala"
			_tmp0_ = g_strdup (self[i]);
#line 44 "../src/Backend/App.vala"
			result[i] = _tmp0_;
#line 3301 "App.c"
		}
#line 44 "../src/Backend/App.vala"
		return result;
#line 3305 "App.c"
	}
#line 44 "../src/Backend/App.vala"
	return NULL;
#line 3309 "App.c"
}

static void
launcher_backend_app_set_keywords (LauncherBackendApp* self,
                                   gchar** value,
                                   gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
#line 44 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 44 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_keywords (self, &old_value_length);
#line 44 "../src/Backend/App.vala"
	if (old_value != value) {
#line 3325 "App.c"
		gchar** _tmp0_;
		gint _tmp0__length1;
#line 44 "../src/Backend/App.vala"
		_tmp0_ = (value != NULL) ? _vala_array_dup2 (value, value_length1) : ((gpointer) value);
#line 44 "../src/Backend/App.vala"
		_tmp0__length1 = value_length1;
#line 44 "../src/Backend/App.vala"
		self->priv->_keywords = (_vala_array_free (self->priv->_keywords, self->priv->_keywords_length1, (GDestroyNotify) g_free), NULL);
#line 44 "../src/Backend/App.vala"
		self->priv->_keywords = _tmp0_;
#line 44 "../src/Backend/App.vala"
		self->priv->_keywords_length1 = _tmp0__length1;
#line 44 "../src/Backend/App.vala"
		self->priv->__keywords_size_ = self->priv->_keywords_length1;
#line 44 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_KEYWORDS_PROPERTY]);
#line 3342 "App.c"
	}
}

GdkPixbuf*
launcher_backend_app_get_icon (LauncherBackendApp* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
#line 45 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_icon;
#line 45 "../src/Backend/App.vala"
	result = _tmp0_;
#line 45 "../src/Backend/App.vala"
	return result;
#line 3359 "App.c"
}

static void
launcher_backend_app_set_icon (LauncherBackendApp* self,
                               GdkPixbuf* value)
{
	GdkPixbuf* old_value;
#line 45 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 45 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_icon (self);
#line 45 "../src/Backend/App.vala"
	if (old_value != value) {
#line 3373 "App.c"
		GdkPixbuf* _tmp0_;
#line 45 "../src/Backend/App.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 45 "../src/Backend/App.vala"
		_g_object_unref0 (self->priv->_icon);
#line 45 "../src/Backend/App.vala"
		self->priv->_icon = _tmp0_;
#line 45 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_ICON_PROPERTY]);
#line 3383 "App.c"
	}
}

gdouble
launcher_backend_app_get_popularity (LauncherBackendApp* self)
{
	gdouble result;
#line 46 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 46 "../src/Backend/App.vala"
	result = self->priv->_popularity;
#line 46 "../src/Backend/App.vala"
	return result;
#line 3397 "App.c"
}

void
launcher_backend_app_set_popularity (LauncherBackendApp* self,
                                     gdouble value)
{
	gdouble old_value;
#line 46 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 46 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_popularity (self);
#line 46 "../src/Backend/App.vala"
	if (old_value != value) {
#line 46 "../src/Backend/App.vala"
		self->priv->_popularity = value;
#line 46 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_POPULARITY_PROPERTY]);
#line 3415 "App.c"
	}
}

gdouble
launcher_backend_app_get_relevancy (LauncherBackendApp* self)
{
	gdouble result;
#line 47 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 47 "../src/Backend/App.vala"
	result = self->priv->_relevancy;
#line 47 "../src/Backend/App.vala"
	return result;
#line 3429 "App.c"
}

void
launcher_backend_app_set_relevancy (LauncherBackendApp* self,
                                    gdouble value)
{
	gdouble old_value;
#line 47 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 47 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_relevancy (self);
#line 47 "../src/Backend/App.vala"
	if (old_value != value) {
#line 47 "../src/Backend/App.vala"
		self->priv->_relevancy = value;
#line 47 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_RELEVANCY_PROPERTY]);
#line 3447 "App.c"
	}
}

const gchar*
launcher_backend_app_get_desktop_path (LauncherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 48 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_desktop_path;
#line 48 "../src/Backend/App.vala"
	result = _tmp0_;
#line 48 "../src/Backend/App.vala"
	return result;
#line 3464 "App.c"
}

static void
launcher_backend_app_set_desktop_path (LauncherBackendApp* self,
                                       const gchar* value)
{
	gchar* old_value;
#line 48 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 48 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_desktop_path (self);
#line 48 "../src/Backend/App.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3478 "App.c"
		gchar* _tmp0_;
#line 48 "../src/Backend/App.vala"
		_tmp0_ = g_strdup (value);
#line 48 "../src/Backend/App.vala"
		_g_free0 (self->priv->_desktop_path);
#line 48 "../src/Backend/App.vala"
		self->priv->_desktop_path = _tmp0_;
#line 48 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_DESKTOP_PATH_PROPERTY]);
#line 3488 "App.c"
	}
}

const gchar*
launcher_backend_app_get_categories (LauncherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 49 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 49 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_categories;
#line 49 "../src/Backend/App.vala"
	result = _tmp0_;
#line 49 "../src/Backend/App.vala"
	return result;
#line 3505 "App.c"
}

static void
launcher_backend_app_set_categories (LauncherBackendApp* self,
                                     const gchar* value)
{
	gchar* old_value;
#line 49 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 49 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_categories (self);
#line 49 "../src/Backend/App.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3519 "App.c"
		gchar* _tmp0_;
#line 49 "../src/Backend/App.vala"
		_tmp0_ = g_strdup (value);
#line 49 "../src/Backend/App.vala"
		_g_free0 (self->priv->_categories);
#line 49 "../src/Backend/App.vala"
		self->priv->_categories = _tmp0_;
#line 49 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_CATEGORIES_PROPERTY]);
#line 3529 "App.c"
	}
}

const gchar*
launcher_backend_app_get_generic_name (LauncherBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 50 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_generic_name;
#line 50 "../src/Backend/App.vala"
	result = _tmp0_;
#line 50 "../src/Backend/App.vala"
	return result;
#line 3546 "App.c"
}

static void
launcher_backend_app_set_generic_name (LauncherBackendApp* self,
                                       const gchar* value)
{
	gchar* old_value;
#line 50 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 50 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_generic_name (self);
#line 50 "../src/Backend/App.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3560 "App.c"
		gchar* _tmp0_;
#line 50 "../src/Backend/App.vala"
		_tmp0_ = g_strdup (value);
#line 50 "../src/Backend/App.vala"
		_g_free0 (self->priv->_generic_name);
#line 50 "../src/Backend/App.vala"
		self->priv->_generic_name = _tmp0_;
#line 50 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_GENERIC_NAME_PROPERTY]);
#line 3570 "App.c"
	}
}

LauncherBackendAppAppType
launcher_backend_app_get_app_type (LauncherBackendApp* self)
{
	LauncherBackendAppAppType result;
	LauncherBackendAppAppType _tmp0_;
#line 51 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 51 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_app_type;
#line 51 "../src/Backend/App.vala"
	result = _tmp0_;
#line 51 "../src/Backend/App.vala"
	return result;
#line 3587 "App.c"
}

static void
launcher_backend_app_set_app_type (LauncherBackendApp* self,
                                   LauncherBackendAppAppType value)
{
	LauncherBackendAppAppType old_value;
#line 51 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 51 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_app_type (self);
#line 51 "../src/Backend/App.vala"
	if (old_value != value) {
#line 51 "../src/Backend/App.vala"
		self->priv->_app_type = value;
#line 51 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_APP_TYPE_PROPERTY]);
#line 3605 "App.c"
	}
}

SynapseMatch*
launcher_backend_app_get_match (LauncherBackendApp* self)
{
	SynapseMatch* result;
	SynapseMatch* _tmp0_;
#line 53 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_match;
#line 53 "../src/Backend/App.vala"
	result = _tmp0_;
#line 53 "../src/Backend/App.vala"
	return result;
#line 3622 "App.c"
}

static void
launcher_backend_app_set_match (LauncherBackendApp* self,
                                SynapseMatch* value)
{
	SynapseMatch* old_value;
#line 53 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 53 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_match (self);
#line 53 "../src/Backend/App.vala"
	if (old_value != value) {
#line 3636 "App.c"
		SynapseMatch* _tmp0_;
#line 53 "../src/Backend/App.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 53 "../src/Backend/App.vala"
		_g_object_unref0 (self->priv->_match);
#line 53 "../src/Backend/App.vala"
		self->priv->_match = _tmp0_;
#line 53 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_MATCH_PROPERTY]);
#line 3646 "App.c"
	}
}

SynapseMatch*
launcher_backend_app_get_target (LauncherBackendApp* self)
{
	SynapseMatch* result;
	SynapseMatch* _tmp0_;
#line 54 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 54 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_target;
#line 54 "../src/Backend/App.vala"
	result = _tmp0_;
#line 54 "../src/Backend/App.vala"
	return result;
#line 3663 "App.c"
}

static void
launcher_backend_app_set_target (LauncherBackendApp* self,
                                 SynapseMatch* value)
{
	SynapseMatch* old_value;
#line 54 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 54 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_target (self);
#line 54 "../src/Backend/App.vala"
	if (old_value != value) {
#line 3677 "App.c"
		SynapseMatch* _tmp0_;
#line 54 "../src/Backend/App.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 54 "../src/Backend/App.vala"
		_g_object_unref0 (self->priv->_target);
#line 54 "../src/Backend/App.vala"
		self->priv->_target = _tmp0_;
#line 54 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_TARGET_PROPERTY]);
#line 3687 "App.c"
	}
}

GeeArrayList*
launcher_backend_app_get_actions (LauncherBackendApp* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
#line 55 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 55 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_actions;
#line 55 "../src/Backend/App.vala"
	result = _tmp0_;
#line 55 "../src/Backend/App.vala"
	return result;
#line 3704 "App.c"
}

static void
launcher_backend_app_set_actions (LauncherBackendApp* self,
                                  GeeArrayList* value)
{
	GeeArrayList* old_value;
#line 55 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 55 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_actions (self);
#line 55 "../src/Backend/App.vala"
	if (old_value != value) {
#line 3718 "App.c"
		GeeArrayList* _tmp0_;
#line 55 "../src/Backend/App.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 55 "../src/Backend/App.vala"
		_g_object_unref0 (self->priv->_actions);
#line 55 "../src/Backend/App.vala"
		self->priv->_actions = _tmp0_;
#line 55 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_ACTIONS_PROPERTY]);
#line 3728 "App.c"
	}
}

GeeHashMap*
launcher_backend_app_get_actions_map (LauncherBackendApp* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
#line 56 "../src/Backend/App.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "../src/Backend/App.vala"
	_tmp0_ = self->priv->_actions_map;
#line 56 "../src/Backend/App.vala"
	result = _tmp0_;
#line 56 "../src/Backend/App.vala"
	return result;
#line 3745 "App.c"
}

static void
launcher_backend_app_set_actions_map (LauncherBackendApp* self,
                                      GeeHashMap* value)
{
	GeeHashMap* old_value;
#line 56 "../src/Backend/App.vala"
	g_return_if_fail (self != NULL);
#line 56 "../src/Backend/App.vala"
	old_value = launcher_backend_app_get_actions_map (self);
#line 56 "../src/Backend/App.vala"
	if (old_value != value) {
#line 3759 "App.c"
		GeeHashMap* _tmp0_;
#line 56 "../src/Backend/App.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 56 "../src/Backend/App.vala"
		_g_object_unref0 (self->priv->_actions_map);
#line 56 "../src/Backend/App.vala"
		self->priv->_actions_map = _tmp0_;
#line 56 "../src/Backend/App.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_ACTIONS_MAP_PROPERTY]);
#line 3769 "App.c"
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 29 "../src/Backend/App.vala"
	g_return_if_fail (n_param_values == 3);
#line 29 "../src/Backend/App.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 29 "../src/Backend/App.vala"
		data1 = closure->data;
#line 29 "../src/Backend/App.vala"
		data2 = param_values->data[0].v_pointer;
#line 3795 "App.c"
	} else {
#line 29 "../src/Backend/App.vala"
		data1 = param_values->data[0].v_pointer;
#line 29 "../src/Backend/App.vala"
		data2 = closure->data;
#line 3801 "App.c"
	}
#line 29 "../src/Backend/App.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 29 "../src/Backend/App.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 3807 "App.c"
}

static LauncherBackendAppIconLoadFallbackMethod*
launcher_backend_app_icon_load_fallback_method_construct (GType object_type,
                                                          LauncherBackendAppIconLoadFallback fallback,
                                                          gpointer fallback_target)
{
	LauncherBackendAppIconLoadFallbackMethod* self = NULL;
#line 159 "../src/Backend/App.vala"
	self = (LauncherBackendAppIconLoadFallbackMethod*) g_type_create_instance (object_type);
#line 160 "../src/Backend/App.vala"
	self->load_icon = fallback;
#line 160 "../src/Backend/App.vala"
	self->load_icon_target = fallback_target;
#line 159 "../src/Backend/App.vala"
	return self;
#line 3824 "App.c"
}

static LauncherBackendAppIconLoadFallbackMethod*
launcher_backend_app_icon_load_fallback_method_new (LauncherBackendAppIconLoadFallback fallback,
                                                    gpointer fallback_target)
{
#line 159 "../src/Backend/App.vala"
	return launcher_backend_app_icon_load_fallback_method_construct (LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD, fallback, fallback_target);
#line 3833 "App.c"
}

static void
launcher_backend_app_value_icon_load_fallback_method_init (GValue* value)
{
#line 156 "../src/Backend/App.vala"
	value->data[0].v_pointer = NULL;
#line 3841 "App.c"
}

static void
launcher_backend_app_value_icon_load_fallback_method_free_value (GValue* value)
{
#line 156 "../src/Backend/App.vala"
	if (value->data[0].v_pointer) {
#line 156 "../src/Backend/App.vala"
		launcher_backend_app_icon_load_fallback_method_unref (value->data[0].v_pointer);
#line 3851 "App.c"
	}
}

static void
launcher_backend_app_value_icon_load_fallback_method_copy_value (const GValue* src_value,
                                                                 GValue* dest_value)
{
#line 156 "../src/Backend/App.vala"
	if (src_value->data[0].v_pointer) {
#line 156 "../src/Backend/App.vala"
		dest_value->data[0].v_pointer = launcher_backend_app_icon_load_fallback_method_ref (src_value->data[0].v_pointer);
#line 3863 "App.c"
	} else {
#line 156 "../src/Backend/App.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3867 "App.c"
	}
}

static gpointer
launcher_backend_app_value_icon_load_fallback_method_peek_pointer (const GValue* value)
{
#line 156 "../src/Backend/App.vala"
	return value->data[0].v_pointer;
#line 3876 "App.c"
}

static gchar*
launcher_backend_app_value_icon_load_fallback_method_collect_value (GValue* value,
                                                                    guint n_collect_values,
                                                                    GTypeCValue* collect_values,
                                                                    guint collect_flags)
{
#line 156 "../src/Backend/App.vala"
	if (collect_values[0].v_pointer) {
#line 3887 "App.c"
		LauncherBackendAppIconLoadFallbackMethod * object;
		object = collect_values[0].v_pointer;
#line 156 "../src/Backend/App.vala"
		if (object->parent_instance.g_class == NULL) {
#line 156 "../src/Backend/App.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3894 "App.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 156 "../src/Backend/App.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3898 "App.c"
		}
#line 156 "../src/Backend/App.vala"
		value->data[0].v_pointer = launcher_backend_app_icon_load_fallback_method_ref (object);
#line 3902 "App.c"
	} else {
#line 156 "../src/Backend/App.vala"
		value->data[0].v_pointer = NULL;
#line 3906 "App.c"
	}
#line 156 "../src/Backend/App.vala"
	return NULL;
#line 3910 "App.c"
}

static gchar*
launcher_backend_app_value_icon_load_fallback_method_lcopy_value (const GValue* value,
                                                                  guint n_collect_values,
                                                                  GTypeCValue* collect_values,
                                                                  guint collect_flags)
{
	LauncherBackendAppIconLoadFallbackMethod ** object_p;
	object_p = collect_values[0].v_pointer;
#line 156 "../src/Backend/App.vala"
	if (!object_p) {
#line 156 "../src/Backend/App.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3925 "App.c"
	}
#line 156 "../src/Backend/App.vala"
	if (!value->data[0].v_pointer) {
#line 156 "../src/Backend/App.vala"
		*object_p = NULL;
#line 3931 "App.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 156 "../src/Backend/App.vala"
		*object_p = value->data[0].v_pointer;
#line 3935 "App.c"
	} else {
#line 156 "../src/Backend/App.vala"
		*object_p = launcher_backend_app_icon_load_fallback_method_ref (value->data[0].v_pointer);
#line 3939 "App.c"
	}
#line 156 "../src/Backend/App.vala"
	return NULL;
#line 3943 "App.c"
}

static GParamSpec*
launcher_backend_app_param_spec_icon_load_fallback_method (const gchar* name,
                                                           const gchar* nick,
                                                           const gchar* blurb,
                                                           GType object_type,
                                                           GParamFlags flags)
{
	LauncherBackendAppParamSpecIconLoadFallbackMethod* spec;
#line 156 "../src/Backend/App.vala"
	g_return_val_if_fail (g_type_is_a (object_type, LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD), NULL);
#line 156 "../src/Backend/App.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 156 "../src/Backend/App.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 156 "../src/Backend/App.vala"
	return G_PARAM_SPEC (spec);
#line 3962 "App.c"
}

static gpointer
launcher_backend_app_value_get_icon_load_fallback_method (const GValue* value)
{
#line 156 "../src/Backend/App.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD), NULL);
#line 156 "../src/Backend/App.vala"
	return value->data[0].v_pointer;
#line 3972 "App.c"
}

static void
launcher_backend_app_value_set_icon_load_fallback_method (GValue* value,
                                                          gpointer v_object)
{
	LauncherBackendAppIconLoadFallbackMethod * old;
#line 156 "../src/Backend/App.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD));
#line 156 "../src/Backend/App.vala"
	old = value->data[0].v_pointer;
#line 156 "../src/Backend/App.vala"
	if (v_object) {
#line 156 "../src/Backend/App.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD));
#line 156 "../src/Backend/App.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 156 "../src/Backend/App.vala"
		value->data[0].v_pointer = v_object;
#line 156 "../src/Backend/App.vala"
		launcher_backend_app_icon_load_fallback_method_ref (value->data[0].v_pointer);
#line 3994 "App.c"
	} else {
#line 156 "../src/Backend/App.vala"
		value->data[0].v_pointer = NULL;
#line 3998 "App.c"
	}
#line 156 "../src/Backend/App.vala"
	if (old) {
#line 156 "../src/Backend/App.vala"
		launcher_backend_app_icon_load_fallback_method_unref (old);
#line 4004 "App.c"
	}
}

static void
launcher_backend_app_value_take_icon_load_fallback_method (GValue* value,
                                                           gpointer v_object)
{
	LauncherBackendAppIconLoadFallbackMethod * old;
#line 156 "../src/Backend/App.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD));
#line 156 "../src/Backend/App.vala"
	old = value->data[0].v_pointer;
#line 156 "../src/Backend/App.vala"
	if (v_object) {
#line 156 "../src/Backend/App.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD));
#line 156 "../src/Backend/App.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 156 "../src/Backend/App.vala"
		value->data[0].v_pointer = v_object;
#line 4025 "App.c"
	} else {
#line 156 "../src/Backend/App.vala"
		value->data[0].v_pointer = NULL;
#line 4029 "App.c"
	}
#line 156 "../src/Backend/App.vala"
	if (old) {
#line 156 "../src/Backend/App.vala"
		launcher_backend_app_icon_load_fallback_method_unref (old);
#line 4035 "App.c"
	}
}

static void
launcher_backend_app_icon_load_fallback_method_class_init (LauncherBackendAppIconLoadFallbackMethodClass * klass,
                                                           gpointer klass_data)
{
#line 156 "../src/Backend/App.vala"
	launcher_backend_app_icon_load_fallback_method_parent_class = g_type_class_peek_parent (klass);
#line 156 "../src/Backend/App.vala"
	((LauncherBackendAppIconLoadFallbackMethodClass *) klass)->finalize = launcher_backend_app_icon_load_fallback_method_finalize;
#line 4047 "App.c"
}

static void
launcher_backend_app_icon_load_fallback_method_instance_init (LauncherBackendAppIconLoadFallbackMethod * self,
                                                              gpointer klass)
{
#line 156 "../src/Backend/App.vala"
	self->ref_count = 1;
#line 4056 "App.c"
}

static void
launcher_backend_app_icon_load_fallback_method_finalize (LauncherBackendAppIconLoadFallbackMethod * obj)
{
	LauncherBackendAppIconLoadFallbackMethod * self;
#line 156 "../src/Backend/App.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LAUNCHER_BACKEND_APP_TYPE_ICON_LOAD_FALLBACK_METHOD, LauncherBackendAppIconLoadFallbackMethod);
#line 156 "../src/Backend/App.vala"
	g_signal_handlers_destroy (self);
#line 4067 "App.c"
}

static GType
launcher_backend_app_icon_load_fallback_method_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { launcher_backend_app_value_icon_load_fallback_method_init, launcher_backend_app_value_icon_load_fallback_method_free_value, launcher_backend_app_value_icon_load_fallback_method_copy_value, launcher_backend_app_value_icon_load_fallback_method_peek_pointer, "p", launcher_backend_app_value_icon_load_fallback_method_collect_value, "p", launcher_backend_app_value_icon_load_fallback_method_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (LauncherBackendAppIconLoadFallbackMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) launcher_backend_app_icon_load_fallback_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LauncherBackendAppIconLoadFallbackMethod), 0, (GInstanceInitFunc) launcher_backend_app_icon_load_fallback_method_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType launcher_backend_app_icon_load_fallback_method_type_id;
	launcher_backend_app_icon_load_fallback_method_type_id = g_type_register_fundamental (g_type_fundamental_next (), "LauncherBackendAppIconLoadFallbackMethod", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return launcher_backend_app_icon_load_fallback_method_type_id;
}

static GType
launcher_backend_app_icon_load_fallback_method_get_type (void)
{
	static volatile gsize launcher_backend_app_icon_load_fallback_method_type_id__volatile = 0;
	if (g_once_init_enter (&launcher_backend_app_icon_load_fallback_method_type_id__volatile)) {
		GType launcher_backend_app_icon_load_fallback_method_type_id;
		launcher_backend_app_icon_load_fallback_method_type_id = launcher_backend_app_icon_load_fallback_method_get_type_once ();
		g_once_init_leave (&launcher_backend_app_icon_load_fallback_method_type_id__volatile, launcher_backend_app_icon_load_fallback_method_type_id);
	}
	return launcher_backend_app_icon_load_fallback_method_type_id__volatile;
}

static gpointer
launcher_backend_app_icon_load_fallback_method_ref (gpointer instance)
{
	LauncherBackendAppIconLoadFallbackMethod * self;
	self = instance;
#line 156 "../src/Backend/App.vala"
	g_atomic_int_inc (&self->ref_count);
#line 156 "../src/Backend/App.vala"
	return instance;
#line 4102 "App.c"
}

static void
launcher_backend_app_icon_load_fallback_method_unref (gpointer instance)
{
	LauncherBackendAppIconLoadFallbackMethod * self;
	self = instance;
#line 156 "../src/Backend/App.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 156 "../src/Backend/App.vala"
		LAUNCHER_BACKEND_APP_ICON_LOAD_FALLBACK_METHOD_GET_CLASS (self)->finalize (self);
#line 156 "../src/Backend/App.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4116 "App.c"
	}
}

static void
launcher_backend_app_class_init (LauncherBackendAppClass * klass,
                                 gpointer klass_data)
{
#line 29 "../src/Backend/App.vala"
	launcher_backend_app_parent_class = g_type_class_peek_parent (klass);
#line 29 "../src/Backend/App.vala"
	g_type_class_adjust_private_offset (klass, &LauncherBackendApp_private_offset);
#line 29 "../src/Backend/App.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_launcher_backend_app_get_property;
#line 29 "../src/Backend/App.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_launcher_backend_app_set_property;
#line 29 "../src/Backend/App.vala"
	G_OBJECT_CLASS (klass)->finalize = launcher_backend_app_finalize;
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_NAME_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_DESCRIPTION_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_DESKTOP_ID_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_EXEC_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_ICON_NAME_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_KEYWORDS_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_KEYWORDS_PROPERTY] = g_param_spec_boxed ("keywords", "keywords", "keywords", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_ICON_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_POPULARITY_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_POPULARITY_PROPERTY] = g_param_spec_double ("popularity", "popularity", "popularity", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_RELEVANCY_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_RELEVANCY_PROPERTY] = g_param_spec_double ("relevancy", "relevancy", "relevancy", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_DESKTOP_PATH_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_DESKTOP_PATH_PROPERTY] = g_param_spec_string ("desktop-path", "desktop-path", "desktop-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_CATEGORIES_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_CATEGORIES_PROPERTY] = g_param_spec_string ("categories", "categories", "categories", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_GENERIC_NAME_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_GENERIC_NAME_PROPERTY] = g_param_spec_string ("generic-name", "generic-name", "generic-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_APP_TYPE_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_APP_TYPE_PROPERTY] = g_param_spec_enum ("app-type", "app-type", "app-type", LAUNCHER_BACKEND_APP_TYPE_APP_TYPE, LAUNCHER_BACKEND_APP_APP_TYPE_APP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_MATCH_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_MATCH_PROPERTY] = g_param_spec_object ("match", "match", "match", SYNAPSE_TYPE_MATCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_TARGET_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_TARGET_PROPERTY] = g_param_spec_object ("target", "target", "target", SYNAPSE_TYPE_MATCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_ACTIONS_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../src/Backend/App.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_BACKEND_APP_ACTIONS_MAP_PROPERTY, launcher_backend_app_properties[LAUNCHER_BACKEND_APP_ACTIONS_MAP_PROPERTY] = g_param_spec_object ("actions-map", "actions-map", "actions-map", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../src/Backend/App.vala"
	launcher_backend_app_signals[LAUNCHER_BACKEND_APP_START_SEARCH_SIGNAL] = g_signal_new ("start-search", LAUNCHER_BACKEND_TYPE_APP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, SYNAPSE_TYPE_SEARCH_MATCH, SYNAPSE_TYPE_MATCH);
#line 29 "../src/Backend/App.vala"
	launcher_backend_app_signals[LAUNCHER_BACKEND_APP_ICON_CHANGED_SIGNAL] = g_signal_new ("icon-changed", LAUNCHER_BACKEND_TYPE_APP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 29 "../src/Backend/App.vala"
	launcher_backend_app_signals[LAUNCHER_BACKEND_APP_LAUNCHED_SIGNAL] = g_signal_new ("launched", LAUNCHER_BACKEND_TYPE_APP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, LAUNCHER_BACKEND_TYPE_APP);
#line 4174 "App.c"
}

static void
launcher_backend_app_instance_init (LauncherBackendApp * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 29 "../src/Backend/App.vala"
	self->priv = launcher_backend_app_get_instance_private (self);
#line 40 "../src/Backend/App.vala"
	_tmp0_ = g_strdup ("");
#line 40 "../src/Backend/App.vala"
	self->priv->_description = _tmp0_;
#line 43 "../src/Backend/App.vala"
	_tmp1_ = g_strdup ("");
#line 43 "../src/Backend/App.vala"
	self->priv->_icon_name = _tmp1_;
#line 45 "../src/Backend/App.vala"
	self->priv->_icon = NULL;
#line 50 "../src/Backend/App.vala"
	_tmp2_ = g_strdup ("");
#line 50 "../src/Backend/App.vala"
	self->priv->_generic_name = _tmp2_;
#line 51 "../src/Backend/App.vala"
	self->priv->_app_type = LAUNCHER_BACKEND_APP_APP_TYPE_APP;
#line 53 "../src/Backend/App.vala"
	self->priv->_match = NULL;
#line 54 "../src/Backend/App.vala"
	self->priv->_target = NULL;
#line 55 "../src/Backend/App.vala"
	self->priv->_actions = NULL;
#line 56 "../src/Backend/App.vala"
	self->priv->_actions_map = NULL;
#line 63 "../src/Backend/App.vala"
	self->priv->check_icon_again = TRUE;
#line 64 "../src/Backend/App.vala"
	self->priv->loadable_icon = NULL;
#line 4214 "App.c"
}

static void
launcher_backend_app_finalize (GObject * obj)
{
	LauncherBackendApp * self;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	guint _tmp2_;
#line 29 "../src/Backend/App.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LAUNCHER_BACKEND_TYPE_APP, LauncherBackendApp);
#line 134 "../src/Backend/App.vala"
	_tmp0_ = launcher_launchy_get_icon_theme ();
#line 134 "../src/Backend/App.vala"
	_tmp1_ = _tmp0_;
#line 134 "../src/Backend/App.vala"
	g_signal_parse_name ("changed", gtk_icon_theme_get_type (), &_tmp2_, NULL, FALSE);
#line 134 "../src/Backend/App.vala"
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _launcher_backend_app_update_icon_gtk_icon_theme_changed, self);
#line 39 "../src/Backend/App.vala"
	_g_free0 (self->priv->_name);
#line 40 "../src/Backend/App.vala"
	_g_free0 (self->priv->_description);
#line 41 "../src/Backend/App.vala"
	_g_free0 (self->priv->_desktop_id);
#line 42 "../src/Backend/App.vala"
	_g_free0 (self->priv->_exec);
#line 43 "../src/Backend/App.vala"
	_g_free0 (self->priv->_icon_name);
#line 44 "../src/Backend/App.vala"
	self->priv->_keywords = (_vala_array_free (self->priv->_keywords, self->priv->_keywords_length1, (GDestroyNotify) g_free), NULL);
#line 45 "../src/Backend/App.vala"
	_g_object_unref0 (self->priv->_icon);
#line 48 "../src/Backend/App.vala"
	_g_free0 (self->priv->_desktop_path);
#line 49 "../src/Backend/App.vala"
	_g_free0 (self->priv->_categories);
#line 50 "../src/Backend/App.vala"
	_g_free0 (self->priv->_generic_name);
#line 53 "../src/Backend/App.vala"
	_g_object_unref0 (self->priv->_match);
#line 54 "../src/Backend/App.vala"
	_g_object_unref0 (self->priv->_target);
#line 55 "../src/Backend/App.vala"
	_g_object_unref0 (self->priv->_actions);
#line 56 "../src/Backend/App.vala"
	_g_object_unref0 (self->priv->_actions_map);
#line 64 "../src/Backend/App.vala"
	_g_object_unref0 (self->priv->loadable_icon);
#line 29 "../src/Backend/App.vala"
	G_OBJECT_CLASS (launcher_backend_app_parent_class)->finalize (obj);
#line 4266 "App.c"
}

static GType
launcher_backend_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LauncherBackendAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) launcher_backend_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LauncherBackendApp), 0, (GInstanceInitFunc) launcher_backend_app_instance_init, NULL };
	GType launcher_backend_app_type_id;
	launcher_backend_app_type_id = g_type_register_static (G_TYPE_OBJECT, "LauncherBackendApp", &g_define_type_info, 0);
	LauncherBackendApp_private_offset = g_type_add_instance_private (launcher_backend_app_type_id, sizeof (LauncherBackendAppPrivate));
	return launcher_backend_app_type_id;
}

GType
launcher_backend_app_get_type (void)
{
	static volatile gsize launcher_backend_app_type_id__volatile = 0;
	if (g_once_init_enter (&launcher_backend_app_type_id__volatile)) {
		GType launcher_backend_app_type_id;
		launcher_backend_app_type_id = launcher_backend_app_get_type_once ();
		g_once_init_leave (&launcher_backend_app_type_id__volatile, launcher_backend_app_type_id);
	}
	return launcher_backend_app_type_id__volatile;
}

static void
_vala_launcher_backend_app_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	LauncherBackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LAUNCHER_BACKEND_TYPE_APP, LauncherBackendApp);
#line 29 "../src/Backend/App.vala"
	switch (property_id) {
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_NAME_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_string (value, launcher_backend_app_get_name (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_DESCRIPTION_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_string (value, launcher_backend_app_get_description (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_DESKTOP_ID_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_string (value, launcher_backend_app_get_desktop_id (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_EXEC_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_string (value, launcher_backend_app_get_exec (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_ICON_NAME_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_string (value, launcher_backend_app_get_icon_name (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_KEYWORDS_PROPERTY:
#line 4333 "App.c"
		{
			int length;
#line 29 "../src/Backend/App.vala"
			g_value_set_boxed (value, launcher_backend_app_get_keywords (self, &length));
#line 4338 "App.c"
		}
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_ICON_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_object (value, launcher_backend_app_get_icon (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_POPULARITY_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_double (value, launcher_backend_app_get_popularity (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_RELEVANCY_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_double (value, launcher_backend_app_get_relevancy (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_DESKTOP_PATH_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_string (value, launcher_backend_app_get_desktop_path (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_CATEGORIES_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_string (value, launcher_backend_app_get_categories (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_GENERIC_NAME_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_string (value, launcher_backend_app_get_generic_name (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_APP_TYPE_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_enum (value, launcher_backend_app_get_app_type (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_MATCH_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_object (value, launcher_backend_app_get_match (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_TARGET_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_object (value, launcher_backend_app_get_target (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_ACTIONS_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_object (value, launcher_backend_app_get_actions (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_ACTIONS_MAP_PROPERTY:
#line 29 "../src/Backend/App.vala"
		g_value_set_object (value, launcher_backend_app_get_actions_map (self));
#line 29 "../src/Backend/App.vala"
		break;
#line 4408 "App.c"
		default:
#line 29 "../src/Backend/App.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "../src/Backend/App.vala"
		break;
#line 4414 "App.c"
	}
}

static void
_vala_launcher_backend_app_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	LauncherBackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LAUNCHER_BACKEND_TYPE_APP, LauncherBackendApp);
#line 29 "../src/Backend/App.vala"
	switch (property_id) {
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_NAME_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_name (self, g_value_get_string (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_DESCRIPTION_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_description (self, g_value_get_string (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_DESKTOP_ID_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_desktop_id (self, g_value_get_string (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_EXEC_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_exec (self, g_value_get_string (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_ICON_NAME_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_icon_name (self, g_value_get_string (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_KEYWORDS_PROPERTY:
#line 4460 "App.c"
		{
			gpointer boxed;
#line 29 "../src/Backend/App.vala"
			boxed = g_value_get_boxed (value);
#line 29 "../src/Backend/App.vala"
			launcher_backend_app_set_keywords (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
#line 4467 "App.c"
		}
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_ICON_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_icon (self, g_value_get_object (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_POPULARITY_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_popularity (self, g_value_get_double (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_RELEVANCY_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_relevancy (self, g_value_get_double (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_DESKTOP_PATH_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_desktop_path (self, g_value_get_string (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_CATEGORIES_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_categories (self, g_value_get_string (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_GENERIC_NAME_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_generic_name (self, g_value_get_string (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_APP_TYPE_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_app_type (self, g_value_get_enum (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_MATCH_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_match (self, g_value_get_object (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_TARGET_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_target (self, g_value_get_object (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_ACTIONS_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_actions (self, g_value_get_object (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 29 "../src/Backend/App.vala"
		case LAUNCHER_BACKEND_APP_ACTIONS_MAP_PROPERTY:
#line 29 "../src/Backend/App.vala"
		launcher_backend_app_set_actions_map (self, g_value_get_object (value));
#line 29 "../src/Backend/App.vala"
		break;
#line 4537 "App.c"
		default:
#line 29 "../src/Backend/App.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "../src/Backend/App.vala"
		break;
#line 4543 "App.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

