/* utils.c generated by valac 0.42.5, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <stdarg.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseUtilsQueryExistsAsyncData SynapseUtilsQueryExistsAsyncData;

#define SYNAPSE_UTILS_TYPE_LOGGER (synapse_utils_logger_get_type ())
#define SYNAPSE_UTILS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLogger))
#define SYNAPSE_UTILS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLoggerClass))
#define SYNAPSE_UTILS_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_LOGGER))
#define SYNAPSE_UTILS_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_LOGGER))
#define SYNAPSE_UTILS_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLoggerClass))

typedef struct _SynapseUtilsLogger SynapseUtilsLogger;
typedef struct _SynapseUtilsLoggerClass SynapseUtilsLoggerClass;
typedef struct _SynapseUtilsLoggerPrivate SynapseUtilsLoggerPrivate;
typedef struct _SynapseUtilsParamSpecLogger SynapseUtilsParamSpecLogger;
typedef struct _SynapseUtilsDelegateWrapper SynapseUtilsDelegateWrapper;

#define SYNAPSE_UTILS_TYPE_ASYNC_ONCE (synapse_utils_async_once_get_type ())
#define SYNAPSE_UTILS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnce))
#define SYNAPSE_UTILS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_ASYNC_ONCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))

typedef struct _SynapseUtilsAsyncOnce SynapseUtilsAsyncOnce;
typedef struct _SynapseUtilsAsyncOnceClass SynapseUtilsAsyncOnceClass;
typedef struct _SynapseUtilsAsyncOncePrivate SynapseUtilsAsyncOncePrivate;
typedef enum  {
	SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED,
	SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS,
	SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE
} SynapseUtilsAsyncOnceOperationState;


#define SYNAPSE_UTILS_ASYNC_ONCE_TYPE_OPERATION_STATE (synapse_utils_async_once_operation_state_get_type ())
#define _synapse_utils_async_once_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_async_once_unref (var), NULL)))
typedef struct _SynapseUtilsAsyncOnceEnterData SynapseUtilsAsyncOnceEnterData;
typedef struct _SynapseUtilsAsyncOnceWaitAsyncData SynapseUtilsAsyncOnceWaitAsyncData;
typedef struct _SynapseUtilsParamSpecAsyncOnce SynapseUtilsParamSpecAsyncOnce;

#define SYNAPSE_UTILS_TYPE_FILE_INFO (synapse_utils_file_info_get_type ())
#define SYNAPSE_UTILS_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfo))
#define SYNAPSE_UTILS_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoClass))
#define SYNAPSE_UTILS_IS_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO))
#define SYNAPSE_UTILS_IS_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_FILE_INFO))
#define SYNAPSE_UTILS_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoClass))

typedef struct _SynapseUtilsFileInfo SynapseUtilsFileInfo;
typedef struct _SynapseUtilsFileInfoClass SynapseUtilsFileInfoClass;
typedef struct _SynapseUtilsFileInfoPrivate SynapseUtilsFileInfoPrivate;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;


#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT
} SynapseMatchType;


#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())
#define _synapse_utils_file_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_file_info_unref (var), NULL)))
typedef struct _SynapseUtilsFileInfoInitializeData SynapseUtilsFileInfoInitializeData;
typedef struct _SynapseUtilsFileInfoExistsData SynapseUtilsFileInfoExistsData;
typedef struct _SynapseUtilsParamSpecFileInfo SynapseUtilsParamSpecFileInfo;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SynapseUtilsQueryExistsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GFile* f;
	gboolean result;
	gboolean exists;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	GError* err;
	GError * _inner_error_;
};

struct _SynapseUtilsLogger {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsLoggerPrivate * priv;
};

struct _SynapseUtilsLoggerClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsLogger *self);
};

struct _SynapseUtilsParamSpecLogger {
	GParamSpec parent_instance;
};

struct _SynapseUtilsDelegateWrapper {
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _SynapseUtilsAsyncOnce {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsAsyncOncePrivate * priv;
};

struct _SynapseUtilsAsyncOnceClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsAsyncOnce *self);
};

struct _SynapseUtilsAsyncOncePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gpointer inner;
	SynapseUtilsAsyncOnceOperationState state;
	SynapseUtilsDelegateWrapper** callbacks;
	gint callbacks_length1;
	gint _callbacks_size_;
};

struct _SynapseUtilsAsyncOnceEnterData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseUtilsAsyncOnce* self;
	gboolean result;
	SynapseUtilsAsyncOnceOperationState _tmp0_;
	SynapseUtilsAsyncOnceOperationState _tmp1_;
};

struct _SynapseUtilsAsyncOnceWaitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseUtilsAsyncOnce* self;
	SynapseUtilsDelegateWrapper** _tmp0_;
	gint _tmp0__length1;
	SynapseUtilsDelegateWrapper* _tmp1_;
};

struct _SynapseUtilsParamSpecAsyncOnce {
	GParamSpec parent_instance;
};

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _SynapseUtilsFileInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsFileInfoPrivate * priv;
	gchar* uri;
	gchar* parse_name;
	SynapseQueryFlags file_type;
	SynapseUriMatch* match_obj;
};

struct _SynapseUtilsFileInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsFileInfo *self);
};

struct _SynapseUtilsFileInfoPrivate {
	gboolean initialized;
	GType match_obj_type;
};

struct _SynapseUtilsFileInfoInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseUtilsFileInfo* self;
	GFile* f;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* fi;
	const gchar* _tmp2_;
	GFileInfo* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GType _tmp6_;
	const gchar* _tmp7_;
	GIcon* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GObject* _tmp15_;
	GObject* _tmp16_;
	const gchar* mime_type;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	SynapseUriMatch* _tmp24_;
	SynapseQueryFlags _tmp25_;
	SynapseUriMatch* _tmp26_;
	const gchar* _tmp27_;
	GError* err;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GError * _inner_error_;
};

struct _SynapseUtilsFileInfoExistsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseUtilsFileInfo* self;
	gboolean result;
	GFile* f;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gboolean _result_;
};

struct _SynapseUtilsParamSpecFileInfo {
	GParamSpec parent_instance;
};


static gpointer synapse_utils_logger_parent_class = NULL;
static gboolean synapse_utils_logger_initialized;
static gboolean synapse_utils_logger_initialized = FALSE;
static gboolean synapse_utils_logger_show_debug;
static gboolean synapse_utils_logger_show_debug = FALSE;
static gint SynapseUtilsAsyncOnce_private_offset;
static gpointer synapse_utils_async_once_parent_class = NULL;
static gint SynapseUtilsFileInfo_private_offset;
static gpointer synapse_utils_file_info_parent_class = NULL;
static gchar* synapse_utils_file_info_interesting_attributes;
static gchar* synapse_utils_file_info_interesting_attributes = NULL;

gchar* synapse_utils_remove_accents (const gchar* input);
gchar* synapse_utils_remove_last_unichar (const gchar* input);
static void synapse_utils_query_exists_async_data_free (gpointer _data);
static void synapse_utils_query_exists_async_async_ready_wrapper (GObject *source_object,
                                                           GAsyncResult *res,
                                                           void *user_data);
void synapse_utils_query_exists_async (GFile* f,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
gboolean synapse_utils_query_exists_finish (GAsyncResult* _res_);
static gboolean synapse_utils_query_exists_async_co (SynapseUtilsQueryExistsAsyncData* _data_);
static void synapse_utils_query_exists_async_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
gchar* synapse_utils_extract_type_name (GType obj_type);
gpointer synapse_utils_logger_ref (gpointer instance);
void synapse_utils_logger_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_logger (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
void synapse_utils_value_set_logger (GValue* value,
                                     gpointer v_object);
void synapse_utils_value_take_logger (GValue* value,
                                      gpointer v_object);
gpointer synapse_utils_value_get_logger (const GValue* value);
GType synapse_utils_logger_get_type (void) G_GNUC_CONST;
#define SYNAPSE_UTILS_LOGGER_RED "\x1b[31m"
#define SYNAPSE_UTILS_LOGGER_GREEN "\x1b[32m"
#define SYNAPSE_UTILS_LOGGER_YELLOW "\x1b[33m"
#define SYNAPSE_UTILS_LOGGER_BLUE "\x1b[34m"
#define SYNAPSE_UTILS_LOGGER_MAGENTA "\x1b[35m"
#define SYNAPSE_UTILS_LOGGER_CYAN "\x1b[36m"
#define SYNAPSE_UTILS_LOGGER_RESET "\x1b[0m"
static void synapse_utils_logger_log_internal (GObject* obj,
                                        GLogLevelFlags level,
                                        const gchar* format,
                                        va_list args);
static void synapse_utils_logger_initialize (void);
void synapse_utils_logger_handler (const gchar* domain,
                                   GLogLevelFlags level,
                                   const gchar* msg);
static void _synapse_utils_logger_handler_glog_func (const gchar* log_domain,
                                              GLogLevelFlags log_levels,
                                              const gchar* message,
                                              gpointer self);
gboolean synapse_utils_logger_debug_enabled (void);
void synapse_utils_logger_log (GObject* obj,
                               const gchar* format,
                               ...);
void synapse_utils_logger_debug (GObject* obj,
                                 const gchar* format,
                                 ...);
void synapse_utils_logger_warning (GObject* obj,
                                   const gchar* format,
                                   ...);
void synapse_utils_logger_error (GObject* obj,
                                 const gchar* format,
                                 ...);
SynapseUtilsLogger* synapse_utils_logger_new (void);
SynapseUtilsLogger* synapse_utils_logger_construct (GType object_type);
static void synapse_utils_logger_finalize (SynapseUtilsLogger * obj);
void synapse_utils_delegate_wrapper_free (SynapseUtilsDelegateWrapper * self);
static void synapse_utils_delegate_wrapper_instance_init (SynapseUtilsDelegateWrapper * self);
SynapseUtilsDelegateWrapper* synapse_utils_delegate_wrapper_new (GSourceFunc cb,
                                                                 gpointer cb_target,
                                                                 GDestroyNotify cb_target_destroy_notify);
gpointer synapse_utils_async_once_ref (gpointer instance);
void synapse_utils_async_once_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_async_once (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
void synapse_utils_value_set_async_once (GValue* value,
                                         gpointer v_object);
void synapse_utils_value_take_async_once (GValue* value,
                                          gpointer v_object);
gpointer synapse_utils_value_get_async_once (const GValue* value);
GType synapse_utils_async_once_get_type (void) G_GNUC_CONST;
static GType synapse_utils_async_once_operation_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
SynapseUtilsAsyncOnce* synapse_utils_async_once_new (GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func);
SynapseUtilsAsyncOnce* synapse_utils_async_once_construct (GType object_type,
                                                           GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func);
gconstpointer synapse_utils_async_once_get_data (SynapseUtilsAsyncOnce* self);
gboolean synapse_utils_async_once_is_initialized (SynapseUtilsAsyncOnce* self);
static void synapse_utils_async_once_enter_data_free (gpointer _data);
static void synapse_utils_async_once_enter_async_ready_wrapper (GObject *source_object,
                                                         GAsyncResult *res,
                                                         void *user_data);
void synapse_utils_async_once_enter (SynapseUtilsAsyncOnce* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
gboolean synapse_utils_async_once_enter_finish (SynapseUtilsAsyncOnce* self,
                                                GAsyncResult* _res_);
static gboolean synapse_utils_async_once_enter_co (SynapseUtilsAsyncOnceEnterData* _data_);
static void synapse_utils_async_once_wait_async (SynapseUtilsAsyncOnce* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void synapse_utils_async_once_wait_finish (SynapseUtilsAsyncOnce* self,
                                           GAsyncResult* _res_);
static void synapse_utils_async_once_enter_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
void synapse_utils_async_once_leave (SynapseUtilsAsyncOnce* self,
                                     gconstpointer _result_);
static void synapse_utils_async_once_notify_all (SynapseUtilsAsyncOnce* self);
void synapse_utils_async_once_reset (SynapseUtilsAsyncOnce* self);
static void synapse_utils_async_once_wait_async_data_free (gpointer _data);
static void synapse_utils_async_once_wait_async_async_ready_wrapper (GObject *source_object,
                                                              GAsyncResult *res,
                                                              void *user_data);
static gboolean synapse_utils_async_once_wait_async_co (SynapseUtilsAsyncOnceWaitAsyncData* _data_);
static gboolean _synapse_utils_async_once_wait_async_co_gsource_func (gpointer self);
static void _vala_array_add9 (SynapseUtilsDelegateWrapper** * array,
                       int* length,
                       int* size,
                       SynapseUtilsDelegateWrapper* value);
static void synapse_utils_async_once_finalize (SynapseUtilsAsyncOnce * obj);
gpointer synapse_utils_file_info_ref (gpointer instance);
void synapse_utils_file_info_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_file_info (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
void synapse_utils_value_set_file_info (GValue* value,
                                        gpointer v_object);
void synapse_utils_value_take_file_info (GValue* value,
                                         gpointer v_object);
gpointer synapse_utils_value_get_file_info (const GValue* value);
GType synapse_utils_file_info_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
SynapseUtilsFileInfo* synapse_utils_file_info_new (const gchar* uri,
                                                   GType obj_type);
SynapseUtilsFileInfo* synapse_utils_file_info_construct (GType object_type,
                                                         const gchar* uri,
                                                         GType obj_type);
gboolean synapse_utils_file_info_is_initialized (SynapseUtilsFileInfo* self);
static void synapse_utils_file_info_initialize_data_free (gpointer _data);
static void synapse_utils_file_info_initialize_async_ready_wrapper (GObject *source_object,
                                                             GAsyncResult *res,
                                                             void *user_data);
void synapse_utils_file_info_initialize (SynapseUtilsFileInfo* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
void synapse_utils_file_info_initialize_finish (SynapseUtilsFileInfo* self,
                                                GAsyncResult* _res_);
static gboolean synapse_utils_file_info_initialize_co (SynapseUtilsFileInfoInitializeData* _data_);
static void synapse_utils_file_info_initialize_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
void synapse_uri_match_set_file_type (SynapseUriMatch* self,
                                      SynapseQueryFlags value);
void synapse_uri_match_set_mime_type (SynapseUriMatch* self,
                                      const gchar* value);
static void synapse_utils_file_info_exists_data_free (gpointer _data);
static void synapse_utils_file_info_exists_async_ready_wrapper (GObject *source_object,
                                                         GAsyncResult *res,
                                                         void *user_data);
void synapse_utils_file_info_exists (SynapseUtilsFileInfo* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
gboolean synapse_utils_file_info_exists_finish (SynapseUtilsFileInfo* self,
                                                GAsyncResult* _res_);
static gboolean synapse_utils_file_info_exists_co (SynapseUtilsFileInfoExistsData* _data_);
static void synapse_utils_file_info_exists_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void synapse_utils_file_info_finalize (SynapseUtilsFileInfo * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


gchar*
synapse_utils_remove_accents (const gchar* input)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	const gchar* charset = NULL;
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	g_get_charset (&_tmp0_);
	charset = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		gint _tmp2_;
		gint _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp2_ = strlen (input);
		_tmp3_ = _tmp2_;
		_tmp4_ = charset;
		_tmp5_ = g_convert (input, (gssize) _tmp3_, "US-ASCII//TRANSLIT", _tmp4_, NULL, NULL, &_inner_error_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch46_g_convert_error;
			}
			_g_free0 (_result_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (_result_);
		_result_ = _tmp6_;
		_tmp7_ = _result_;
		if (g_strcmp0 (input, _tmp7_) == 0) {
			result = NULL;
			_g_free0 (_tmp1_);
			_g_free0 (_result_);
			return result;
		}
		_g_free0 (_tmp1_);
	}
	goto __finally46;
	__catch46_g_convert_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_free0 (_result_);
		_result_ = NULL;
		_g_error_free0 (err);
	}
	__finally46:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (_result_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _result_;
	return result;
}


static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gint result = 0;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


gchar*
synapse_utils_remove_last_unichar (const gchar* input)
{
	gchar* result = NULL;
	glong char_count = 0L;
	gint len = 0;
	gchar* _tmp0_;
	g_return_val_if_fail (input != NULL, NULL);
	char_count = (glong) g_utf8_strlen (input, (gssize) -1);
	len = string_index_of_nth_char (input, char_count - 1);
	_tmp0_ = string_substring (input, (glong) 0, (glong) len);
	result = _tmp0_;
	return result;
}


static void
synapse_utils_query_exists_async_data_free (gpointer _data)
{
	SynapseUtilsQueryExistsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->f);
	g_slice_free (SynapseUtilsQueryExistsAsyncData, _data_);
}


static void
synapse_utils_query_exists_async_async_ready_wrapper (GObject *source_object,
                                                      GAsyncResult *res,
                                                      void *user_data)
{
	SynapseUtilsQueryExistsAsyncData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
synapse_utils_query_exists_async (GFile* f,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	SynapseUtilsQueryExistsAsyncData* _data_;
	GFile* _tmp0_;
	_data_ = g_slice_new0 (SynapseUtilsQueryExistsAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, NULL, synapse_utils_query_exists_async_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_query_exists_async_data_free);
	_tmp0_ = _g_object_ref0 (f);
	_g_object_unref0 (_data_->f);
	_data_->f = _tmp0_;
	synapse_utils_query_exists_async_co (_data_);
}


gboolean
synapse_utils_query_exists_finish (GAsyncResult* _res_)
{
	gboolean result;
	SynapseUtilsQueryExistsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}


static void
synapse_utils_query_exists_async_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	SynapseUtilsQueryExistsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	synapse_utils_query_exists_async_co (_data_);
}


static gboolean
synapse_utils_query_exists_async_co (SynapseUtilsQueryExistsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->f, G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_utils_query_exists_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = g_file_query_info_finish (_data_->f, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp1_ = _data_->_tmp0_;
		_g_object_unref0 (_data_->_tmp1_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch47_g_error;
		}
		_data_->exists = TRUE;
	}
	goto __finally47;
	__catch47_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->exists = FALSE;
		_g_error_free0 (_data_->err);
	}
	__finally47:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->exists;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gchar*
synapse_utils_extract_type_name (GType obj_type)
{
	gchar* result = NULL;
	gchar* obj_class = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = g_type_name (obj_type);
	_tmp1_ = g_strdup (_tmp0_);
	obj_class = _tmp1_;
	_tmp2_ = obj_class;
	if (g_str_has_prefix (_tmp2_, "Synapse")) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = obj_class;
		_tmp4_ = string_substring (_tmp3_, (glong) 7, (glong) -1);
		result = _tmp4_;
		_g_free0 (obj_class);
		return result;
	}
	result = obj_class;
	return result;
}


static void
synapse_utils_logger_log_internal (GObject* obj,
                                   GLogLevelFlags level,
                                   const gchar* format,
                                   va_list args)
{
	gboolean _tmp0_;
	gchar* desc = NULL;
	gchar* _tmp1_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (format != NULL);
	_tmp0_ = synapse_utils_logger_initialized;
	if (!_tmp0_) {
		synapse_utils_logger_initialize ();
	}
	_tmp1_ = g_strdup ("");
	desc = _tmp1_;
	if (obj != NULL) {
		gchar* obj_class = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = synapse_utils_extract_type_name (G_TYPE_FROM_INSTANCE (obj));
		obj_class = _tmp2_;
		_tmp3_ = obj_class;
		_tmp4_ = g_strdup_printf ("%s[%s]%s ", SYNAPSE_UTILS_LOGGER_MAGENTA, _tmp3_, SYNAPSE_UTILS_LOGGER_RESET);
		_g_free0 (desc);
		desc = _tmp4_;
		_g_free0 (obj_class);
	}
	_tmp5_ = desc;
	_tmp6_ = g_strconcat (_tmp5_, format, NULL);
	_tmp7_ = _tmp6_;
	g_logv ("Synapse", level, _tmp7_, args);
	_g_free0 (_tmp7_);
	_g_free0 (desc);
}


static void
_synapse_utils_logger_handler_glog_func (const gchar* log_domain,
                                         GLogLevelFlags log_levels,
                                         const gchar* message,
                                         gpointer self)
{
	synapse_utils_logger_handler (log_domain, log_levels, message);
}


static void
synapse_utils_logger_initialize (void)
{
	GLogLevelFlags levels = 0;
	gchar** domains = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gint domains_length1;
	gint _domains_size_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GLogLevelFlags _tmp13_;
	const gchar* _tmp14_;
	levels = (((G_LOG_LEVEL_DEBUG | G_LOG_LEVEL_INFO) | G_LOG_LEVEL_WARNING) | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR;
	_tmp0_ = g_strdup ("Synapse");
	_tmp1_ = g_strdup ("Gtk");
	_tmp2_ = g_strdup ("Gdk");
	_tmp3_ = g_strdup ("GLib");
	_tmp4_ = g_strdup ("GLib-GObject");
	_tmp5_ = g_strdup ("Pango");
	_tmp6_ = g_strdup ("GdkPixbuf");
	_tmp7_ = g_strdup ("GLib-GIO");
	_tmp8_ = g_strdup ("GtkHotkey");
	_tmp9_ = g_new0 (gchar*, 9 + 1);
	_tmp9_[0] = _tmp0_;
	_tmp9_[1] = _tmp1_;
	_tmp9_[2] = _tmp2_;
	_tmp9_[3] = _tmp3_;
	_tmp9_[4] = _tmp4_;
	_tmp9_[5] = _tmp5_;
	_tmp9_[6] = _tmp6_;
	_tmp9_[7] = _tmp7_;
	_tmp9_[8] = _tmp8_;
	domains = _tmp9_;
	domains_length1 = 9;
	_domains_size_ = domains_length1;
	_tmp10_ = domains;
	_tmp10__length1 = domains_length1;
	{
		gchar** domain_collection = NULL;
		gint domain_collection_length1 = 0;
		gint _domain_collection_size_ = 0;
		gint domain_it = 0;
		domain_collection = _tmp10_;
		domain_collection_length1 = _tmp10__length1;
		for (domain_it = 0; domain_it < _tmp10__length1; domain_it = domain_it + 1) {
			const gchar* domain = NULL;
			domain = domain_collection[domain_it];
			{
				const gchar* _tmp11_;
				GLogLevelFlags _tmp12_;
				_tmp11_ = domain;
				_tmp12_ = levels;
				g_log_set_handler (_tmp11_, _tmp12_, _synapse_utils_logger_handler_glog_func, NULL);
			}
		}
	}
	_tmp13_ = levels;
	g_log_set_handler (NULL, _tmp13_, _synapse_utils_logger_handler_glog_func, NULL);
	_tmp14_ = g_getenv ("SYNAPSE_DEBUG");
	synapse_utils_logger_show_debug = _tmp14_ != NULL;
	synapse_utils_logger_initialized = TRUE;
	domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
}


gboolean
synapse_utils_logger_debug_enabled (void)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = synapse_utils_logger_initialized;
	if (!_tmp0_) {
		synapse_utils_logger_initialize ();
	}
	_tmp1_ = synapse_utils_logger_show_debug;
	result = _tmp1_;
	return result;
}


void
synapse_utils_logger_log (GObject* obj,
                          const gchar* format,
                          ...)
{
	va_list args = {0};
	g_return_if_fail (format != NULL);
	va_start (args, format);
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_INFO, format, args);
	va_end (args);
}


void
synapse_utils_logger_debug (GObject* obj,
                            const gchar* format,
                            ...)
{
	va_list args = {0};
	g_return_if_fail (format != NULL);
	va_start (args, format);
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_DEBUG, format, args);
	va_end (args);
}


void
synapse_utils_logger_warning (GObject* obj,
                              const gchar* format,
                              ...)
{
	va_list args = {0};
	g_return_if_fail (format != NULL);
	va_start (args, format);
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_WARNING, format, args);
	va_end (args);
}


void
synapse_utils_logger_error (GObject* obj,
                            const gchar* format,
                            ...)
{
	va_list args = {0};
	g_return_if_fail (format != NULL);
	va_start (args, format);
	synapse_utils_logger_log_internal (obj, G_LOG_LEVEL_ERROR, format, args);
	va_end (args);
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void
synapse_utils_logger_handler (const gchar* domain,
                              GLogLevelFlags level,
                              const gchar* msg)
{
	gchar* header = NULL;
	gchar* domain_str = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GTimeVal time_val = {0};
	gint _tmp3_ = 0;
	GTimeVal _tmp4_;
	glong _tmp5_;
	glong time_str_len = 0L;
	gchar* cur_time = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	glong _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	FILE* _tmp48_;
	const gchar* _tmp49_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = g_strdup ("");
	domain_str = _tmp0_;
	if (domain != NULL) {
		_tmp1_ = g_strcmp0 (domain, "Synapse") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strconcat (domain, "-", NULL);
		_g_free0 (domain_str);
		domain_str = _tmp2_;
	}
	g_get_current_time (&time_val);
	_tmp4_ = time_val;
	_tmp5_ = _tmp4_.tv_usec;
	if (_tmp5_ != ((glong) 0)) {
		_tmp3_ = 15;
	} else {
		_tmp3_ = 8;
	}
	time_str_len = (glong) _tmp3_;
	_tmp6_ = g_time_val_to_iso8601 (&time_val);
	_tmp7_ = _tmp6_;
	_tmp8_ = time_str_len;
	_tmp9_ = string_substring (_tmp7_, (glong) 11, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp7_);
	cur_time = _tmp10_;
	if (level == G_LOG_LEVEL_DEBUG) {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp12_ = synapse_utils_logger_show_debug;
		if (!_tmp12_) {
			const gchar* _tmp13_;
			_tmp13_ = domain_str;
			_tmp11_ = g_strcmp0 (_tmp13_, "") == 0;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			_g_free0 (cur_time);
			_g_free0 (domain_str);
			_g_free0 (header);
			return;
		}
		_tmp14_ = string_to_string (SYNAPSE_UTILS_LOGGER_GREEN);
		_tmp15_ = cur_time;
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = domain_str;
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
		_tmp20_ = g_strconcat (_tmp14_, "[", _tmp16_, " ", _tmp18_, "Debug]", _tmp19_, NULL);
		_g_free0 (header);
		header = _tmp20_;
	} else {
		if (level == G_LOG_LEVEL_INFO) {
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp21_ = string_to_string (SYNAPSE_UTILS_LOGGER_BLUE);
			_tmp22_ = cur_time;
			_tmp23_ = string_to_string (_tmp22_);
			_tmp24_ = domain_str;
			_tmp25_ = string_to_string (_tmp24_);
			_tmp26_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
			_tmp27_ = g_strconcat (_tmp21_, "[", _tmp23_, " ", _tmp25_, "Info]", _tmp26_, NULL);
			_g_free0 (header);
			header = _tmp27_;
		} else {
			if (level == G_LOG_LEVEL_WARNING) {
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp28_ = string_to_string (SYNAPSE_UTILS_LOGGER_RED);
				_tmp29_ = cur_time;
				_tmp30_ = string_to_string (_tmp29_);
				_tmp31_ = domain_str;
				_tmp32_ = string_to_string (_tmp31_);
				_tmp33_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
				_tmp34_ = g_strconcat (_tmp28_, "[", _tmp30_, " ", _tmp32_, "Warning]", _tmp33_, NULL);
				_g_free0 (header);
				header = _tmp34_;
			} else {
				gboolean _tmp35_ = FALSE;
				if (level == G_LOG_LEVEL_CRITICAL) {
					_tmp35_ = TRUE;
				} else {
					_tmp35_ = level == G_LOG_LEVEL_ERROR;
				}
				if (_tmp35_) {
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp36_ = string_to_string (SYNAPSE_UTILS_LOGGER_RED);
					_tmp37_ = cur_time;
					_tmp38_ = string_to_string (_tmp37_);
					_tmp39_ = domain_str;
					_tmp40_ = string_to_string (_tmp39_);
					_tmp41_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
					_tmp42_ = g_strconcat (_tmp36_, "[", _tmp38_, " ", _tmp40_, "Critical]", _tmp41_, NULL);
					_g_free0 (header);
					header = _tmp42_;
				} else {
					const gchar* _tmp43_;
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					gchar* _tmp47_;
					_tmp43_ = string_to_string (SYNAPSE_UTILS_LOGGER_YELLOW);
					_tmp44_ = cur_time;
					_tmp45_ = string_to_string (_tmp44_);
					_tmp46_ = string_to_string (SYNAPSE_UTILS_LOGGER_RESET);
					_tmp47_ = g_strconcat (_tmp43_, "[", _tmp45_, "]", _tmp46_, NULL);
					_g_free0 (header);
					header = _tmp47_;
				}
			}
		}
	}
	_tmp48_ = stdout;
	_tmp49_ = header;
	fprintf (_tmp48_, "%s %s\n", _tmp49_, msg);
	_g_free0 (cur_time);
	_g_free0 (domain_str);
	_g_free0 (header);
}


SynapseUtilsLogger*
synapse_utils_logger_construct (GType object_type)
{
	SynapseUtilsLogger* self = NULL;
	self = (SynapseUtilsLogger*) g_type_create_instance (object_type);
	return self;
}


SynapseUtilsLogger*
synapse_utils_logger_new (void)
{
	return synapse_utils_logger_construct (SYNAPSE_UTILS_TYPE_LOGGER);
}


static void
synapse_utils_value_logger_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
synapse_utils_value_logger_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		synapse_utils_logger_unref (value->data[0].v_pointer);
	}
}


static void
synapse_utils_value_logger_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = synapse_utils_logger_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
synapse_utils_value_logger_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
synapse_utils_value_logger_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SynapseUtilsLogger * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = synapse_utils_logger_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
synapse_utils_value_logger_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	SynapseUtilsLogger ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = synapse_utils_logger_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
synapse_utils_param_spec_logger (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	SynapseUtilsParamSpecLogger* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_UTILS_TYPE_LOGGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
synapse_utils_value_get_logger (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER), NULL);
	return value->data[0].v_pointer;
}


void
synapse_utils_value_set_logger (GValue* value,
                                gpointer v_object)
{
	SynapseUtilsLogger * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_LOGGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		synapse_utils_logger_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_logger_unref (old);
	}
}


void
synapse_utils_value_take_logger (GValue* value,
                                 gpointer v_object)
{
	SynapseUtilsLogger * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_LOGGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_logger_unref (old);
	}
}


static void
synapse_utils_logger_class_init (SynapseUtilsLoggerClass * klass)
{
	synapse_utils_logger_parent_class = g_type_class_peek_parent (klass);
	((SynapseUtilsLoggerClass *) klass)->finalize = synapse_utils_logger_finalize;
}


static void
synapse_utils_logger_instance_init (SynapseUtilsLogger * self)
{
	self->ref_count = 1;
}


static void
synapse_utils_logger_finalize (SynapseUtilsLogger * obj)
{
	SynapseUtilsLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLogger);
	g_signal_handlers_destroy (self);
}


GType
synapse_utils_logger_get_type (void)
{
	static volatile gsize synapse_utils_logger_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_utils_logger_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { synapse_utils_value_logger_init, synapse_utils_value_logger_free_value, synapse_utils_value_logger_copy_value, synapse_utils_value_logger_peek_pointer, "p", synapse_utils_value_logger_collect_value, "p", synapse_utils_value_logger_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsLogger), 0, (GInstanceInitFunc) synapse_utils_logger_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType synapse_utils_logger_type_id;
		synapse_utils_logger_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseUtilsLogger", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&synapse_utils_logger_type_id__volatile, synapse_utils_logger_type_id);
	}
	return synapse_utils_logger_type_id__volatile;
}


gpointer
synapse_utils_logger_ref (gpointer instance)
{
	SynapseUtilsLogger * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
synapse_utils_logger_unref (gpointer instance)
{
	SynapseUtilsLogger * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SYNAPSE_UTILS_LOGGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


SynapseUtilsDelegateWrapper*
synapse_utils_delegate_wrapper_new (GSourceFunc cb,
                                    gpointer cb_target,
                                    GDestroyNotify cb_target_destroy_notify)
{
	SynapseUtilsDelegateWrapper* self;
	GSourceFunc _tmp0_;
	void* _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	self = g_slice_new0 (SynapseUtilsDelegateWrapper);
	synapse_utils_delegate_wrapper_instance_init (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_tmp0__target_destroy_notify = cb_target_destroy_notify;
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
	self->callback = NULL;
	self->callback_target = NULL;
	self->callback_target_destroy_notify = NULL;
	self->callback = _tmp0_;
	self->callback_target = _tmp0__target;
	self->callback_target_destroy_notify = _tmp0__target_destroy_notify;
	(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	return self;
}


static void
synapse_utils_delegate_wrapper_instance_init (SynapseUtilsDelegateWrapper * self)
{
}


void
synapse_utils_delegate_wrapper_free (SynapseUtilsDelegateWrapper * self)
{
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
	self->callback = NULL;
	self->callback_target = NULL;
	self->callback_target_destroy_notify = NULL;
	g_slice_free (SynapseUtilsDelegateWrapper, self);
}


static inline gpointer
synapse_utils_async_once_get_instance_private (SynapseUtilsAsyncOnce* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseUtilsAsyncOnce_private_offset);
}


static GType
synapse_utils_async_once_operation_state_get_type (void)
{
	static volatile gsize synapse_utils_async_once_operation_state_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_utils_async_once_operation_state_type_id__volatile)) {
		static const GEnumValue values[] = {{SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED, "SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED", "not-started"}, {SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS, "SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS", "in-progress"}, {SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE, "SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE", "done"}, {0, NULL, NULL}};
		GType synapse_utils_async_once_operation_state_type_id;
		synapse_utils_async_once_operation_state_type_id = g_enum_register_static ("SynapseUtilsAsyncOnceOperationState", values);
		g_once_init_leave (&synapse_utils_async_once_operation_state_type_id__volatile, synapse_utils_async_once_operation_state_type_id);
	}
	return synapse_utils_async_once_operation_state_type_id__volatile;
}


SynapseUtilsAsyncOnce*
synapse_utils_async_once_construct (GType object_type,
                                    GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func)
{
	SynapseUtilsAsyncOnce* self = NULL;
	self = (SynapseUtilsAsyncOnce*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->state = SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED;
	return self;
}


SynapseUtilsAsyncOnce*
synapse_utils_async_once_new (GType g_type,
                              GBoxedCopyFunc g_dup_func,
                              GDestroyNotify g_destroy_func)
{
	return synapse_utils_async_once_construct (SYNAPSE_UTILS_TYPE_ASYNC_ONCE, g_type, g_dup_func, g_destroy_func);
}


gconstpointer
synapse_utils_async_once_get_data (SynapseUtilsAsyncOnce* self)
{
	gconstpointer result = NULL;
	gconstpointer _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->inner;
	result = _tmp0_;
	return result;
}


gboolean
synapse_utils_async_once_is_initialized (SynapseUtilsAsyncOnce* self)
{
	gboolean result = FALSE;
	SynapseUtilsAsyncOnceOperationState _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->state;
	result = _tmp0_ == SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE;
	return result;
}


static void
synapse_utils_async_once_enter_data_free (gpointer _data)
{
	SynapseUtilsAsyncOnceEnterData* _data_;
	_data_ = _data;
	_synapse_utils_async_once_unref0 (_data_->self);
	g_slice_free (SynapseUtilsAsyncOnceEnterData, _data_);
}


static void
synapse_utils_async_once_enter_async_ready_wrapper (GObject *source_object,
                                                    GAsyncResult *res,
                                                    void *user_data)
{
	SynapseUtilsAsyncOnceEnterData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_synapse_utils_async_once_ref0 (gpointer self)
{
	return self ? synapse_utils_async_once_ref (self) : NULL;
}


void
synapse_utils_async_once_enter (SynapseUtilsAsyncOnce* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SynapseUtilsAsyncOnceEnterData* _data_;
	SynapseUtilsAsyncOnce* _tmp0_;
	_data_ = g_slice_new0 (SynapseUtilsAsyncOnceEnterData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, NULL, synapse_utils_async_once_enter_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_async_once_enter_data_free);
	_tmp0_ = _synapse_utils_async_once_ref0 (self);
	_data_->self = _tmp0_;
	synapse_utils_async_once_enter_co (_data_);
}


gboolean
synapse_utils_async_once_enter_finish (SynapseUtilsAsyncOnce* self,
                                       GAsyncResult* _res_)
{
	gboolean result;
	SynapseUtilsAsyncOnceEnterData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}


static void
synapse_utils_async_once_enter_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	SynapseUtilsAsyncOnceEnterData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	synapse_utils_async_once_enter_co (_data_);
}


static gboolean
synapse_utils_async_once_enter_co (SynapseUtilsAsyncOnceEnterData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->state;
	if (_data_->_tmp0_ == SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED) {
		_data_->self->priv->state = SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS;
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!_data_->_task_complete_) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp1_ = _data_->self->priv->state;
		if (_data_->_tmp1_ == SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS) {
			_data_->_state_ = 1;
			synapse_utils_async_once_wait_async (_data_->self, synapse_utils_async_once_enter_ready, _data_);
			return FALSE;
			_state_1:
			synapse_utils_async_once_wait_finish (_data_->self, _data_->_res_);
		}
	}
	_data_->result = FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void
synapse_utils_async_once_leave (SynapseUtilsAsyncOnce* self,
                                gconstpointer _result_)
{
	SynapseUtilsAsyncOnceOperationState _tmp0_;
	gpointer _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	if (_tmp0_ != SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS) {
		g_warning ("utils.vala:289: Incorrect usage of AsyncOnce");
		return;
	}
	self->priv->state = SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE;
	_tmp1_ = ((_result_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _result_) : ((gpointer) _result_);
	((self->priv->inner == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->inner = (self->priv->g_destroy_func (self->priv->inner), NULL));
	self->priv->inner = _tmp1_;
	synapse_utils_async_once_notify_all (self);
}


void
synapse_utils_async_once_reset (SynapseUtilsAsyncOnce* self)
{
	SynapseUtilsAsyncOnceOperationState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	if (_tmp0_ == SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS) {
		g_warning ("utils.vala:302: AsyncOnce.reset() cannot be called in the middle of in" \
"itialization.");
	} else {
		self->priv->state = SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED;
		((self->priv->inner == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->inner = (self->priv->g_destroy_func (self->priv->inner), NULL));
		self->priv->inner = NULL;
	}
}


static void
synapse_utils_async_once_notify_all (SynapseUtilsAsyncOnce* self)
{
	SynapseUtilsDelegateWrapper** _tmp0_;
	gint _tmp0__length1;
	SynapseUtilsDelegateWrapper** _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->callbacks;
	_tmp0__length1 = self->priv->callbacks_length1;
	{
		SynapseUtilsDelegateWrapper** wrapper_collection = NULL;
		gint wrapper_collection_length1 = 0;
		gint _wrapper_collection_size_ = 0;
		gint wrapper_it = 0;
		wrapper_collection = _tmp0_;
		wrapper_collection_length1 = _tmp0__length1;
		for (wrapper_it = 0; wrapper_it < _tmp0__length1; wrapper_it = wrapper_it + 1) {
			SynapseUtilsDelegateWrapper* wrapper = NULL;
			wrapper = wrapper_collection[wrapper_it];
			{
				SynapseUtilsDelegateWrapper* _tmp1_;
				GSourceFunc _tmp2_;
				void* _tmp2__target;
				_tmp1_ = wrapper;
				_tmp2_ = _tmp1_->callback;
				_tmp2__target = _tmp1_->callback_target;
				_tmp2_ (_tmp2__target);
			}
		}
	}
	_tmp3_ = g_new0 (SynapseUtilsDelegateWrapper*, 0 + 1);
	self->priv->callbacks = (_vala_array_free (self->priv->callbacks, self->priv->callbacks_length1, (GDestroyNotify) synapse_utils_delegate_wrapper_free), NULL);
	self->priv->callbacks = _tmp3_;
	self->priv->callbacks_length1 = 0;
	self->priv->_callbacks_size_ = self->priv->callbacks_length1;
}


static void
synapse_utils_async_once_wait_async_data_free (gpointer _data)
{
	SynapseUtilsAsyncOnceWaitAsyncData* _data_;
	_data_ = _data;
	_synapse_utils_async_once_unref0 (_data_->self);
	g_slice_free (SynapseUtilsAsyncOnceWaitAsyncData, _data_);
}


static void
synapse_utils_async_once_wait_async_async_ready_wrapper (GObject *source_object,
                                                         GAsyncResult *res,
                                                         void *user_data)
{
	SynapseUtilsAsyncOnceWaitAsyncData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
synapse_utils_async_once_wait_async (SynapseUtilsAsyncOnce* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	SynapseUtilsAsyncOnceWaitAsyncData* _data_;
	SynapseUtilsAsyncOnce* _tmp0_;
	_data_ = g_slice_new0 (SynapseUtilsAsyncOnceWaitAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, NULL, synapse_utils_async_once_wait_async_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_async_once_wait_async_data_free);
	_tmp0_ = _synapse_utils_async_once_ref0 (self);
	_data_->self = _tmp0_;
	synapse_utils_async_once_wait_async_co (_data_);
}


static void
synapse_utils_async_once_wait_finish (SynapseUtilsAsyncOnce* self,
                                      GAsyncResult* _res_)
{
	SynapseUtilsAsyncOnceWaitAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static gboolean
_synapse_utils_async_once_wait_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_utils_async_once_wait_async_co (self);
	return result;
}


static void
_vala_array_add9 (SynapseUtilsDelegateWrapper** * array,
                  int* length,
                  int* size,
                  SynapseUtilsDelegateWrapper* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (SynapseUtilsDelegateWrapper*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean
synapse_utils_async_once_wait_async_co (SynapseUtilsAsyncOnceWaitAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->callbacks;
	_data_->_tmp0__length1 = _data_->self->priv->callbacks_length1;
	_data_->_tmp1_ = synapse_utils_delegate_wrapper_new (_synapse_utils_async_once_wait_async_co_gsource_func, _data_, NULL);
	_vala_array_add9 (&_data_->self->priv->callbacks, &_data_->self->priv->callbacks_length1, &_data_->self->priv->_callbacks_size_, _data_->_tmp1_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
synapse_utils_value_async_once_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
synapse_utils_value_async_once_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		synapse_utils_async_once_unref (value->data[0].v_pointer);
	}
}


static void
synapse_utils_value_async_once_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = synapse_utils_async_once_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
synapse_utils_value_async_once_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
synapse_utils_value_async_once_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SynapseUtilsAsyncOnce * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = synapse_utils_async_once_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
synapse_utils_value_async_once_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	SynapseUtilsAsyncOnce ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = synapse_utils_async_once_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
synapse_utils_param_spec_async_once (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	SynapseUtilsParamSpecAsyncOnce* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_UTILS_TYPE_ASYNC_ONCE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
synapse_utils_value_get_async_once (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_ASYNC_ONCE), NULL);
	return value->data[0].v_pointer;
}


void
synapse_utils_value_set_async_once (GValue* value,
                                    gpointer v_object)
{
	SynapseUtilsAsyncOnce * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_ASYNC_ONCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_ASYNC_ONCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		synapse_utils_async_once_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_async_once_unref (old);
	}
}


void
synapse_utils_value_take_async_once (GValue* value,
                                     gpointer v_object)
{
	SynapseUtilsAsyncOnce * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_ASYNC_ONCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_ASYNC_ONCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_async_once_unref (old);
	}
}


static void
synapse_utils_async_once_class_init (SynapseUtilsAsyncOnceClass * klass)
{
	synapse_utils_async_once_parent_class = g_type_class_peek_parent (klass);
	((SynapseUtilsAsyncOnceClass *) klass)->finalize = synapse_utils_async_once_finalize;
	g_type_class_adjust_private_offset (klass, &SynapseUtilsAsyncOnce_private_offset);
}


static void
synapse_utils_async_once_instance_init (SynapseUtilsAsyncOnce * self)
{
	SynapseUtilsDelegateWrapper** _tmp0_;
	self->priv = synapse_utils_async_once_get_instance_private (self);
	_tmp0_ = g_new0 (SynapseUtilsDelegateWrapper*, 0 + 1);
	self->priv->callbacks = _tmp0_;
	self->priv->callbacks_length1 = 0;
	self->priv->_callbacks_size_ = self->priv->callbacks_length1;
	self->ref_count = 1;
}


static void
synapse_utils_async_once_finalize (SynapseUtilsAsyncOnce * obj)
{
	SynapseUtilsAsyncOnce * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnce);
	g_signal_handlers_destroy (self);
	((self->priv->inner == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->inner = (self->priv->g_destroy_func (self->priv->inner), NULL));
	self->priv->callbacks = (_vala_array_free (self->priv->callbacks, self->priv->callbacks_length1, (GDestroyNotify) synapse_utils_delegate_wrapper_free), NULL);
}


GType
synapse_utils_async_once_get_type (void)
{
	static volatile gsize synapse_utils_async_once_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_utils_async_once_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { synapse_utils_value_async_once_init, synapse_utils_value_async_once_free_value, synapse_utils_value_async_once_copy_value, synapse_utils_value_async_once_peek_pointer, "p", synapse_utils_value_async_once_collect_value, "p", synapse_utils_value_async_once_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsAsyncOnceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_async_once_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsAsyncOnce), 0, (GInstanceInitFunc) synapse_utils_async_once_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType synapse_utils_async_once_type_id;
		synapse_utils_async_once_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseUtilsAsyncOnce", &g_define_type_info, &g_define_type_fundamental_info, 0);
		SynapseUtilsAsyncOnce_private_offset = g_type_add_instance_private (synapse_utils_async_once_type_id, sizeof (SynapseUtilsAsyncOncePrivate));
		g_once_init_leave (&synapse_utils_async_once_type_id__volatile, synapse_utils_async_once_type_id);
	}
	return synapse_utils_async_once_type_id__volatile;
}


gpointer
synapse_utils_async_once_ref (gpointer instance)
{
	SynapseUtilsAsyncOnce * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
synapse_utils_async_once_unref (gpointer instance)
{
	SynapseUtilsAsyncOnce * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SYNAPSE_UTILS_ASYNC_ONCE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static inline gpointer
synapse_utils_file_info_get_instance_private (SynapseUtilsFileInfo* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseUtilsFileInfo_private_offset);
}


SynapseUtilsFileInfo*
synapse_utils_file_info_construct (GType object_type,
                                   const gchar* uri,
                                   GType obj_type)
{
	SynapseUtilsFileInfo* self = NULL;
	gchar* _tmp0_;
	GFile* f = NULL;
	GFile* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (SynapseUtilsFileInfo*) g_type_create_instance (object_type);
	_vala_assert (g_type_is_a (obj_type, SYNAPSE_TYPE_URI_MATCH), "obj_type.is_a (typeof (UriMatch))");
	_tmp0_ = g_strdup (uri);
	_g_free0 (self->uri);
	self->uri = _tmp0_;
	_g_object_unref0 (self->match_obj);
	self->match_obj = NULL;
	self->priv->match_obj_type = obj_type;
	self->priv->initialized = FALSE;
	self->file_type = SYNAPSE_QUERY_FLAGS_UNCATEGORIZED;
	_tmp1_ = g_file_new_for_uri (uri);
	f = _tmp1_;
	_tmp2_ = g_file_get_parse_name (f);
	_g_free0 (self->parse_name);
	self->parse_name = _tmp2_;
	_g_object_unref0 (f);
	return self;
}


SynapseUtilsFileInfo*
synapse_utils_file_info_new (const gchar* uri,
                             GType obj_type)
{
	return synapse_utils_file_info_construct (SYNAPSE_UTILS_TYPE_FILE_INFO, uri, obj_type);
}


gboolean
synapse_utils_file_info_is_initialized (SynapseUtilsFileInfo* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->initialized;
	result = _tmp0_;
	return result;
}


static void
synapse_utils_file_info_initialize_data_free (gpointer _data)
{
	SynapseUtilsFileInfoInitializeData* _data_;
	_data_ = _data;
	_synapse_utils_file_info_unref0 (_data_->self);
	g_slice_free (SynapseUtilsFileInfoInitializeData, _data_);
}


static void
synapse_utils_file_info_initialize_async_ready_wrapper (GObject *source_object,
                                                        GAsyncResult *res,
                                                        void *user_data)
{
	SynapseUtilsFileInfoInitializeData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_synapse_utils_file_info_ref0 (gpointer self)
{
	return self ? synapse_utils_file_info_ref (self) : NULL;
}


void
synapse_utils_file_info_initialize (SynapseUtilsFileInfo* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	SynapseUtilsFileInfoInitializeData* _data_;
	SynapseUtilsFileInfo* _tmp0_;
	_data_ = g_slice_new0 (SynapseUtilsFileInfoInitializeData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, NULL, synapse_utils_file_info_initialize_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_file_info_initialize_data_free);
	_tmp0_ = _synapse_utils_file_info_ref0 (self);
	_data_->self = _tmp0_;
	synapse_utils_file_info_initialize_co (_data_);
}


void
synapse_utils_file_info_initialize_finish (SynapseUtilsFileInfo* self,
                                           GAsyncResult* _res_)
{
	SynapseUtilsFileInfoInitializeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void
synapse_utils_file_info_initialize_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	SynapseUtilsFileInfoInitializeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	synapse_utils_file_info_initialize_co (_data_);
}


static gboolean
synapse_utils_file_info_initialize_co (SynapseUtilsFileInfoInitializeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->initialized = TRUE;
	_data_->_tmp0_ = _data_->self->uri;
	_data_->_tmp1_ = g_file_new_for_uri (_data_->_tmp0_);
	_data_->f = _data_->_tmp1_;
	{
		_data_->_tmp2_ = synapse_utils_file_info_interesting_attributes;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->f, _data_->_tmp2_, 0, 0, NULL, synapse_utils_file_info_initialize_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = g_file_query_info_finish (_data_->f, _data_->_res_, &_data_->_inner_error_);
		_data_->fi = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch48_g_error;
		}
		if (g_file_info_get_file_type (_data_->fi) == G_FILE_TYPE_REGULAR) {
			_data_->_tmp5_ = !g_file_info_get_is_hidden (_data_->fi);
		} else {
			_data_->_tmp5_ = FALSE;
		}
		if (_data_->_tmp5_) {
			_data_->_tmp4_ = !g_file_info_get_is_backup (_data_->fi);
		} else {
			_data_->_tmp4_ = FALSE;
		}
		if (_data_->_tmp4_) {
			_data_->_tmp6_ = _data_->self->priv->match_obj_type;
			_data_->_tmp7_ = g_file_info_get_attribute_byte_string (_data_->fi, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
			_data_->_tmp8_ = g_file_info_get_icon (_data_->fi);
			_data_->_tmp9_ = g_icon_to_string (_data_->_tmp8_);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_tmp11_ = _data_->self->uri;
			_data_->_tmp12_ = g_file_info_get_display_name (_data_->fi);
			_data_->_tmp13_ = g_file_get_parse_name (_data_->f);
			_data_->_tmp14_ = _data_->_tmp13_;
			_data_->_tmp15_ = g_object_new (_data_->_tmp6_, "thumbnail-path", _data_->_tmp7_, "icon-name", _data_->_tmp10_, "uri", _data_->_tmp11_, "title", _data_->_tmp12_, "description", _data_->_tmp14_, "match-type", SYNAPSE_MATCH_TYPE_GENERIC_URI, NULL, NULL);
			_data_->_tmp16_ = G_IS_INITIALLY_UNOWNED (_data_->_tmp15_) ? g_object_ref_sink (_data_->_tmp15_) : _data_->_tmp15_;
			_g_object_unref0 (_data_->self->match_obj);
			_data_->self->match_obj = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch);
			_g_free0 (_data_->_tmp14_);
			_g_free0 (_data_->_tmp10_);
			_data_->_tmp17_ = g_file_info_get_attribute_string (_data_->fi, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE);
			_data_->mime_type = _data_->_tmp17_;
			_data_->_tmp18_ = _data_->mime_type;
			if (g_content_type_is_unknown (_data_->_tmp18_)) {
				_data_->self->file_type = SYNAPSE_QUERY_FLAGS_UNCATEGORIZED;
			} else {
				_data_->_tmp19_ = _data_->mime_type;
				if (g_content_type_is_a (_data_->_tmp19_, "audio/*")) {
					_data_->self->file_type = SYNAPSE_QUERY_FLAGS_AUDIO;
				} else {
					_data_->_tmp20_ = _data_->mime_type;
					if (g_content_type_is_a (_data_->_tmp20_, "video/*")) {
						_data_->self->file_type = SYNAPSE_QUERY_FLAGS_VIDEO;
					} else {
						_data_->_tmp21_ = _data_->mime_type;
						if (g_content_type_is_a (_data_->_tmp21_, "image/*")) {
							_data_->self->file_type = SYNAPSE_QUERY_FLAGS_IMAGES;
						} else {
							_data_->_tmp22_ = _data_->mime_type;
							if (g_content_type_is_a (_data_->_tmp22_, "text/*")) {
								_data_->self->file_type = SYNAPSE_QUERY_FLAGS_DOCUMENTS;
							} else {
								_data_->_tmp23_ = _data_->mime_type;
								if (g_content_type_is_a (_data_->_tmp23_, "application/*")) {
									_data_->self->file_type = SYNAPSE_QUERY_FLAGS_DOCUMENTS;
								}
							}
						}
					}
				}
			}
			_data_->_tmp24_ = _data_->self->match_obj;
			_data_->_tmp25_ = _data_->self->file_type;
			synapse_uri_match_set_file_type (_data_->_tmp24_, _data_->_tmp25_);
			_data_->_tmp26_ = _data_->self->match_obj;
			_data_->_tmp27_ = _data_->mime_type;
			synapse_uri_match_set_mime_type (_data_->_tmp26_, _data_->_tmp27_);
		}
		_g_object_unref0 (_data_->fi);
	}
	goto __finally48;
	__catch48_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp28_ = _data_->err;
		_data_->_tmp29_ = _data_->_tmp28_->message;
		g_warning ("utils.vala:425: %s", _data_->_tmp29_);
		_g_error_free0 (_data_->err);
	}
	__finally48:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->f);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
synapse_utils_file_info_exists_data_free (gpointer _data)
{
	SynapseUtilsFileInfoExistsData* _data_;
	_data_ = _data;
	_synapse_utils_file_info_unref0 (_data_->self);
	g_slice_free (SynapseUtilsFileInfoExistsData, _data_);
}


static void
synapse_utils_file_info_exists_async_ready_wrapper (GObject *source_object,
                                                    GAsyncResult *res,
                                                    void *user_data)
{
	SynapseUtilsFileInfoExistsData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void
synapse_utils_file_info_exists (SynapseUtilsFileInfo* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SynapseUtilsFileInfoExistsData* _data_;
	SynapseUtilsFileInfo* _tmp0_;
	_data_ = g_slice_new0 (SynapseUtilsFileInfoExistsData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, NULL, synapse_utils_file_info_exists_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_file_info_exists_data_free);
	_tmp0_ = _synapse_utils_file_info_ref0 (self);
	_data_->self = _tmp0_;
	synapse_utils_file_info_exists_co (_data_);
}


gboolean
synapse_utils_file_info_exists_finish (SynapseUtilsFileInfo* self,
                                       GAsyncResult* _res_)
{
	gboolean result;
	SynapseUtilsFileInfoExistsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}


static void
synapse_utils_file_info_exists_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	SynapseUtilsFileInfoExistsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	synapse_utils_file_info_exists_co (_data_);
}


static gboolean
synapse_utils_file_info_exists_co (SynapseUtilsFileInfoExistsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->uri;
	_data_->_tmp1_ = g_file_new_for_uri (_data_->_tmp0_);
	_data_->f = _data_->_tmp1_;
	_data_->_state_ = 1;
	synapse_utils_query_exists_async (_data_->f, synapse_utils_file_info_exists_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_result_ = synapse_utils_query_exists_finish (_data_->_res_);
	_data_->result = _data_->_result_;
	_g_object_unref0 (_data_->f);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
synapse_utils_value_file_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
synapse_utils_value_file_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		synapse_utils_file_info_unref (value->data[0].v_pointer);
	}
}


static void
synapse_utils_value_file_info_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = synapse_utils_file_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
synapse_utils_value_file_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
synapse_utils_value_file_info_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SynapseUtilsFileInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = synapse_utils_file_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
synapse_utils_value_file_info_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	SynapseUtilsFileInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = synapse_utils_file_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
synapse_utils_param_spec_file_info (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	SynapseUtilsParamSpecFileInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_UTILS_TYPE_FILE_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
synapse_utils_value_get_file_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO), NULL);
	return value->data[0].v_pointer;
}


void
synapse_utils_value_set_file_info (GValue* value,
                                   gpointer v_object)
{
	SynapseUtilsFileInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_FILE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		synapse_utils_file_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_file_info_unref (old);
	}
}


void
synapse_utils_value_take_file_info (GValue* value,
                                    gpointer v_object)
{
	SynapseUtilsFileInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_FILE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_utils_file_info_unref (old);
	}
}


static void
synapse_utils_file_info_class_init (SynapseUtilsFileInfoClass * klass)
{
	gchar* _tmp0_;
	synapse_utils_file_info_parent_class = g_type_class_peek_parent (klass);
	((SynapseUtilsFileInfoClass *) klass)->finalize = synapse_utils_file_info_finalize;
	g_type_class_adjust_private_offset (klass, &SynapseUtilsFileInfo_private_offset);
	_tmp0_ = g_strjoin (",", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE, G_FILE_ATTRIBUTE_THUMBNAIL_PATH, NULL, NULL);
	_g_free0 (synapse_utils_file_info_interesting_attributes);
	synapse_utils_file_info_interesting_attributes = _tmp0_;
}


static void
synapse_utils_file_info_instance_init (SynapseUtilsFileInfo * self)
{
	self->priv = synapse_utils_file_info_get_instance_private (self);
	self->ref_count = 1;
}


static void
synapse_utils_file_info_finalize (SynapseUtilsFileInfo * obj)
{
	SynapseUtilsFileInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfo);
	g_signal_handlers_destroy (self);
	_g_free0 (self->uri);
	_g_free0 (self->parse_name);
	_g_object_unref0 (self->match_obj);
}


GType
synapse_utils_file_info_get_type (void)
{
	static volatile gsize synapse_utils_file_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_utils_file_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { synapse_utils_value_file_info_init, synapse_utils_value_file_info_free_value, synapse_utils_value_file_info_copy_value, synapse_utils_value_file_info_peek_pointer, "p", synapse_utils_value_file_info_collect_value, "p", synapse_utils_value_file_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsFileInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_file_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsFileInfo), 0, (GInstanceInitFunc) synapse_utils_file_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType synapse_utils_file_info_type_id;
		synapse_utils_file_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseUtilsFileInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		SynapseUtilsFileInfo_private_offset = g_type_add_instance_private (synapse_utils_file_info_type_id, sizeof (SynapseUtilsFileInfoPrivate));
		g_once_init_leave (&synapse_utils_file_info_type_id__volatile, synapse_utils_file_info_type_id);
	}
	return synapse_utils_file_info_type_id__volatile;
}


gpointer
synapse_utils_file_info_ref (gpointer instance)
{
	SynapseUtilsFileInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
synapse_utils_file_info_unref (gpointer instance)
{
	SynapseUtilsFileInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SYNAPSE_UTILS_FILE_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



