/* calculator-plugin.c generated by valac 0.42.5, the Vala compiler
 * generated from calculator-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Magnus Kulke <mkulke@gmail.com>
 *
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>
#include <float.h>
#include <math.h>


#define SYNAPSE_TYPE_ACTIVATABLE (synapse_activatable_get_type ())
#define SYNAPSE_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable))
#define SYNAPSE_IS_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTIVATABLE))
#define SYNAPSE_ACTIVATABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatableIface))

typedef struct _SynapseActivatable SynapseActivatable;
typedef struct _SynapseActivatableIface SynapseActivatableIface;

#define SYNAPSE_TYPE_ITEM_PROVIDER (synapse_item_provider_get_type ())
#define SYNAPSE_ITEM_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ITEM_PROVIDER, SynapseItemProvider))
#define SYNAPSE_IS_ITEM_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ITEM_PROVIDER))
#define SYNAPSE_ITEM_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ITEM_PROVIDER, SynapseItemProviderIface))

typedef struct _SynapseItemProvider SynapseItemProvider;
typedef struct _SynapseItemProviderIface SynapseItemProviderIface;

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())
typedef struct _SynapseQuery SynapseQuery;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;


#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_CALCULATOR_PLUGIN (synapse_calculator_plugin_get_type ())
#define SYNAPSE_CALCULATOR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin))
#define SYNAPSE_CALCULATOR_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPluginClass))
#define SYNAPSE_IS_CALCULATOR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CALCULATOR_PLUGIN))
#define SYNAPSE_IS_CALCULATOR_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CALCULATOR_PLUGIN))
#define SYNAPSE_CALCULATOR_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPluginClass))

typedef struct _SynapseCalculatorPlugin SynapseCalculatorPlugin;
typedef struct _SynapseCalculatorPluginClass SynapseCalculatorPluginClass;
typedef struct _SynapseCalculatorPluginPrivate SynapseCalculatorPluginPrivate;
enum  {
	SYNAPSE_CALCULATOR_PLUGIN_0_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_calculator_plugin_properties[SYNAPSE_CALCULATOR_PLUGIN_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY (synapse_data_sink_plugin_registry_get_type ())
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistry))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistryClass))
#define SYNAPSE_DATA_SINK_IS_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_DATA_SINK_IS_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistryClass))

typedef struct _SynapseDataSinkPluginRegistry SynapseDataSinkPluginRegistry;
typedef struct _SynapseDataSinkPluginRegistryClass SynapseDataSinkPluginRegistryClass;
typedef void (*SynapsePluginRegisterFunc) (void);
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT (synapse_calculator_plugin_result_get_type ())
#define SYNAPSE_CALCULATOR_PLUGIN_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResult))
#define SYNAPSE_CALCULATOR_PLUGIN_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResultClass))
#define SYNAPSE_CALCULATOR_PLUGIN_IS_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT))
#define SYNAPSE_CALCULATOR_PLUGIN_IS_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT))
#define SYNAPSE_CALCULATOR_PLUGIN_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResultClass))

typedef struct _SynapseCalculatorPluginResult SynapseCalculatorPluginResult;
typedef struct _SynapseCalculatorPluginResultClass SynapseCalculatorPluginResultClass;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT
} SynapseMatchType;


#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())
typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;


#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())
typedef struct _SynapseCalculatorPluginSearchData SynapseCalculatorPluginSearchData;
typedef struct _SynapseCalculatorPluginResultPrivate SynapseCalculatorPluginResultPrivate;
enum  {
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_0_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_TITLE_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_DESCRIPTION_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_ICON_NAME_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_MATCH_TYPE_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_NUM_PROPERTIES
};
static GParamSpec* synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_NUM_PROPERTIES];

struct _SynapseActivatableIface {
	GTypeInterface parent_iface;
	void (*activate) (SynapseActivatable* self);
	void (*deactivate) (SynapseActivatable* self);
	gboolean (*get_enabled) (SynapseActivatable* self);
	void (*set_enabled) (SynapseActivatable* self, gboolean value);
};

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseItemProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseItemProvider* self, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	SynapseResultSet* (*search_finish) (SynapseItemProvider* self, GAsyncResult* _res_, GError** error);
	gboolean (*handles_query) (SynapseItemProvider* self, SynapseQuery* query);
	gboolean (*handles_empty_query) (SynapseItemProvider* self);
};

struct _SynapseCalculatorPlugin {
	GObject parent_instance;
	SynapseCalculatorPluginPrivate * priv;
};

struct _SynapseCalculatorPluginClass {
	GObjectClass parent_class;
};

struct _SynapseCalculatorPluginPrivate {
	gboolean _enabled;
	GRegex* regex;
};

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseCalculatorPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseCalculatorPlugin* self;
	SynapseQuery query;
	SynapseResultSet* result;
	gchar* input;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean matched;
	GRegex* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gchar* _tmp17_;
	GRegex* _tmp18_;
	const gchar* _tmp19_;
	gboolean _tmp20_;
	GPid pid;
	gint read_fd;
	gint write_fd;
	gchar** argv;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gint argv_length1;
	gint _argv_size_;
	gchar* solution;
	gchar** _tmp24_;
	gint _tmp24__length1;
	GPid _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GUnixInputStream* read_stream;
	gint _tmp28_;
	GUnixInputStream* _tmp29_;
	GDataInputStream* bc_output;
	GUnixInputStream* _tmp30_;
	GDataInputStream* _tmp31_;
	GUnixOutputStream* write_stream;
	gint _tmp32_;
	GUnixOutputStream* _tmp33_;
	GDataOutputStream* bc_input;
	GUnixOutputStream* _tmp34_;
	GDataOutputStream* _tmp35_;
	GDataOutputStream* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	SynapseQuery _tmp40_;
	GCancellable* _tmp41_;
	GDataOutputStream* _tmp42_;
	SynapseQuery _tmp43_;
	GCancellable* _tmp44_;
	gchar* _tmp45_;
	GDataInputStream* _tmp46_;
	SynapseQuery _tmp47_;
	GCancellable* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	gdouble d;
	const gchar* _tmp52_;
	SynapseCalculatorPluginResult* _result_;
	gdouble _tmp53_;
	SynapseQuery _tmp54_;
	const gchar* _tmp55_;
	SynapseCalculatorPluginResult* _tmp56_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp57_;
	SynapseResultSet* _tmp58_;
	SynapseCalculatorPluginResult* _tmp59_;
	GError* err;
	GError* _tmp60_;
	const gchar* _tmp61_;
	GError * _inner_error_;
};

struct _SynapseCalculatorPluginResult {
	GObject parent_instance;
	SynapseCalculatorPluginResultPrivate * priv;
};

struct _SynapseCalculatorPluginResultClass {
	GObjectClass parent_class;
};

struct _SynapseCalculatorPluginResultPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gint _default_relevancy;
};


static gint SynapseCalculatorPlugin_private_offset;
static gpointer synapse_calculator_plugin_parent_class = NULL;
static gint SynapseCalculatorPluginResult_private_offset;
static gpointer synapse_calculator_plugin_result_parent_class = NULL;
static SynapseMatchIface * synapse_calculator_plugin_result_synapse_match_parent_iface = NULL;
static SynapseActivatableIface * synapse_calculator_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_calculator_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_activatable_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self,
                         SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
GQuark synapse_search_error_quark (void);
GType synapse_item_provider_get_type (void) G_GNUC_CONST;
GType synapse_calculator_plugin_get_type (void) G_GNUC_CONST;
static void synapse_calculator_plugin_real_activate (SynapseActivatable* base);
static void synapse_calculator_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_calculator_plugin_register_plugin (void);
GType synapse_data_sink_plugin_registry_get_type (void) G_GNUC_CONST;
SynapseDataSinkPluginRegistry* synapse_data_sink_plugin_registry_get_default (void);
void synapse_data_sink_plugin_registry_register_plugin (SynapseDataSinkPluginRegistry* self,
                                                        GType plugin_type,
                                                        const gchar* title,
                                                        const gchar* description,
                                                        const gchar* icon_name,
                                                        SynapsePluginRegisterFunc reg_func,
                                                        gboolean runnable,
                                                        const gchar* runnable_error);
static void _synapse_calculator_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_calculator_plugin_real_handles_query (SynapseItemProvider* base,
                                                       SynapseQuery* query);
static void synapse_calculator_plugin_real_search_data_free (gpointer _data);
static void synapse_calculator_plugin_real_search_async_ready_wrapper (GObject *source_object,
                                                                GAsyncResult *res,
                                                                void *user_data);
static void synapse_calculator_plugin_real_search (SynapseItemProvider* base,
                                            SynapseQuery* query,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean synapse_calculator_plugin_real_search_co (SynapseCalculatorPluginSearchData* _data_);
static void synapse_calculator_plugin_search_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static GType synapse_calculator_plugin_result_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCalculatorPluginResult* synapse_calculator_plugin_result_new (gdouble _result_,
                                                                     const gchar* match_string);
static SynapseCalculatorPluginResult* synapse_calculator_plugin_result_construct (GType object_type,
                                                                           gdouble _result_,
                                                                           const gchar* match_string);
SynapseResultSet* synapse_result_set_new (void);
SynapseResultSet* synapse_result_set_construct (GType object_type);
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
void synapse_result_set_add (SynapseResultSet* self,
                             SynapseMatch* match,
                             gint relevancy);
GType synapse_match_score_get_type (void) G_GNUC_CONST;
void synapse_query_check_cancellable (SynapseQuery *self,
                                      GError** error);
gboolean synapse_query_is_cancelled (SynapseQuery *self);
SynapseCalculatorPlugin* synapse_calculator_plugin_new (void);
SynapseCalculatorPlugin* synapse_calculator_plugin_construct (GType object_type);
static GObject * synapse_calculator_plugin_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
void synapse_utils_logger_error (GObject* obj,
                                 const gchar* format,
                                 ...);
static gint synapse_calculator_plugin_result_get_default_relevancy (SynapseCalculatorPluginResult* self);
static void synapse_calculator_plugin_result_set_default_relevancy (SynapseCalculatorPluginResult* self,
                                                             gint value);
static void synapse_calculator_plugin_result_finalize (GObject * obj);
const gchar* synapse_match_get_title (SynapseMatch* self);
const gchar* synapse_match_get_description (SynapseMatch* self);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
static void _vala_synapse_calculator_plugin_result_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
void synapse_match_set_title (SynapseMatch* self,
                              const gchar* value);
void synapse_match_set_description (SynapseMatch* self,
                                    const gchar* value);
void synapse_match_set_icon_name (SynapseMatch* self,
                                  const gchar* value);
void synapse_match_set_has_thumbnail (SynapseMatch* self,
                                      gboolean value);
void synapse_match_set_thumbnail_path (SynapseMatch* self,
                                       const gchar* value);
void synapse_match_set_match_type (SynapseMatch* self,
                                   SynapseMatchType value);
static void _vala_synapse_calculator_plugin_result_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static void synapse_calculator_plugin_finalize (GObject * obj);
gboolean synapse_activatable_get_enabled (SynapseActivatable* self);
static void _vala_synapse_calculator_plugin_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
void synapse_activatable_set_enabled (SynapseActivatable* self,
                                      gboolean value);
static void _vala_synapse_calculator_plugin_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static inline gpointer
synapse_calculator_plugin_get_instance_private (SynapseCalculatorPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCalculatorPlugin_private_offset);
}


static void
synapse_calculator_plugin_real_activate (SynapseActivatable* base)
{
	SynapseCalculatorPlugin * self;
	self = (SynapseCalculatorPlugin*) base;
}


static void
synapse_calculator_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseCalculatorPlugin * self;
	self = (SynapseCalculatorPlugin*) base;
}


static void
_synapse_calculator_plugin_register_plugin_synapse_plugin_register_func (void)
{
	synapse_calculator_plugin_register_plugin ();
}


static void
synapse_calculator_plugin_register_plugin (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDataSinkPluginRegistry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_find_program_in_path ("bc");
	_tmp3_ = _tmp2_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_CALCULATOR_PLUGIN, _ ("Calculator"), _ ("Calculate basic expressions."), "accessories-calculator", _synapse_calculator_plugin_register_plugin_synapse_plugin_register_func, _tmp3_ != NULL, _ ("bc is not installed"));
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
}


static gboolean
synapse_calculator_plugin_real_handles_query (SynapseItemProvider* base,
                                              SynapseQuery* query)
{
	SynapseCalculatorPlugin * self;
	gboolean result = FALSE;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	self = (SynapseCalculatorPlugin*) base;
	g_return_val_if_fail (query != NULL, FALSE);
	_tmp0_ = *query;
	_tmp1_ = _tmp0_.query_type;
	result = (_tmp1_ & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS;
	return result;
}


static void
synapse_calculator_plugin_real_search_data_free (gpointer _data)
{
	SynapseCalculatorPluginSearchData* _data_;
	_data_ = _data;
	synapse_query_destroy (&_data_->query);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseCalculatorPluginSearchData, _data_);
}


static void
synapse_calculator_plugin_real_search_async_ready_wrapper (GObject *source_object,
                                                           GAsyncResult *res,
                                                           void *user_data)
{
	SynapseCalculatorPluginSearchData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
synapse_calculator_plugin_real_search (SynapseItemProvider* base,
                                       SynapseQuery* query,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	SynapseCalculatorPlugin * self;
	SynapseCalculatorPluginSearchData* _data_;
	SynapseCalculatorPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_ = {0};
	self = (SynapseCalculatorPlugin*) base;
	_data_ = g_slice_new0 (SynapseCalculatorPluginSearchData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, synapse_calculator_plugin_real_search_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_calculator_plugin_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = *query;
	synapse_query_copy (&_tmp1_, &_tmp2_);
	synapse_query_destroy (&_data_->query);
	_data_->query = _tmp2_;
	synapse_calculator_plugin_real_search_co (_data_);
}


static SynapseResultSet*
synapse_calculator_plugin_real_search_finish (SynapseItemProvider* base,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	SynapseResultSet* result;
	SynapseCalculatorPluginSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch49_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch49_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally49;
	__catch49_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally49:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


static void
synapse_calculator_plugin_search_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	SynapseCalculatorPluginSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	synapse_calculator_plugin_real_search_co (_data_);
}


static gdouble
double_parse (const gchar* str)
{
	gdouble result = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}


static gboolean
synapse_calculator_plugin_real_search_co (SynapseCalculatorPluginSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->query;
	_data_->_tmp1_ = _data_->_tmp0_.query_string;
	_data_->_tmp2_ = string_replace (_data_->_tmp1_, " ", "");
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = string_replace (_data_->_tmp3_, ",", ".");
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_free0 (_data_->_tmp3_);
	_data_->input = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->self->priv->regex;
	_data_->_tmp7_ = _data_->input;
	_data_->matched = g_regex_match (_data_->_tmp6_, _data_->_tmp7_, 0, NULL);
	_data_->_tmp9_ = _data_->matched;
	if (!_data_->_tmp9_) {
		_data_->_tmp10_ = _data_->input;
		_data_->_tmp11_ = strlen (_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp8_ = _data_->_tmp12_ > 1;
	} else {
		_data_->_tmp8_ = FALSE;
	}
	if (_data_->_tmp8_) {
		_data_->_tmp13_ = _data_->input;
		_data_->_tmp14_ = _data_->input;
		_data_->_tmp15_ = strlen (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = string_slice (_data_->_tmp13_, (glong) 0, (glong) (_data_->_tmp16_ - 1));
		_g_free0 (_data_->input);
		_data_->input = _data_->_tmp17_;
		_data_->_tmp18_ = _data_->self->priv->regex;
		_data_->_tmp19_ = _data_->input;
		_data_->matched = g_regex_match (_data_->_tmp18_, _data_->_tmp19_, 0, NULL);
	}
	_data_->_tmp20_ = _data_->matched;
	if (_data_->_tmp20_) {
		_data_->_tmp21_ = g_strdup ("bc");
		_data_->_tmp22_ = g_strdup ("-l");
		_data_->_tmp23_ = g_new0 (gchar*, 2 + 1);
		_data_->_tmp23_[0] = _data_->_tmp21_;
		_data_->_tmp23_[1] = _data_->_tmp22_;
		_data_->argv = _data_->_tmp23_;
		_data_->argv_length1 = 2;
		_data_->_argv_size_ = _data_->argv_length1;
		_data_->solution = NULL;
		{
			_data_->_tmp24_ = _data_->argv;
			_data_->_tmp24__length1 = _data_->argv_length1;
			_data_->_tmp25_ = 0;
			_data_->_tmp26_ = 0;
			_data_->_tmp27_ = 0;
			g_spawn_async_with_pipes (NULL, _data_->_tmp24_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_data_->_tmp25_, &_data_->_tmp26_, &_data_->_tmp27_, NULL, &_data_->_inner_error_);
			_data_->pid = _data_->_tmp25_;
			_data_->write_fd = _data_->_tmp26_;
			_data_->read_fd = _data_->_tmp27_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch50_g_error;
			}
			_data_->_tmp28_ = _data_->read_fd;
			_data_->_tmp29_ = (GUnixInputStream*) g_unix_input_stream_new (_data_->_tmp28_, TRUE);
			_data_->read_stream = _data_->_tmp29_;
			_data_->_tmp30_ = _data_->read_stream;
			_data_->_tmp31_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp30_);
			_data_->bc_output = _data_->_tmp31_;
			_data_->_tmp32_ = _data_->write_fd;
			_data_->_tmp33_ = (GUnixOutputStream*) g_unix_output_stream_new (_data_->_tmp32_, TRUE);
			_data_->write_stream = _data_->_tmp33_;
			_data_->_tmp34_ = _data_->write_stream;
			_data_->_tmp35_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp34_);
			_data_->bc_input = _data_->_tmp35_;
			_data_->_tmp36_ = _data_->bc_input;
			_data_->_tmp37_ = _data_->input;
			_data_->_tmp38_ = g_strconcat (_data_->_tmp37_, "\n", NULL);
			_data_->_tmp39_ = _data_->_tmp38_;
			_data_->_tmp40_ = _data_->query;
			_data_->_tmp41_ = _data_->_tmp40_.cancellable;
			g_data_output_stream_put_string (_data_->_tmp36_, _data_->_tmp39_, _data_->_tmp41_, &_data_->_inner_error_);
			_g_free0 (_data_->_tmp39_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->bc_input);
				_g_object_unref0 (_data_->write_stream);
				_g_object_unref0 (_data_->bc_output);
				_g_object_unref0 (_data_->read_stream);
				goto __catch50_g_error;
			}
			_data_->_tmp42_ = _data_->bc_input;
			_data_->_tmp43_ = _data_->query;
			_data_->_tmp44_ = _data_->_tmp43_.cancellable;
			_data_->_state_ = 1;
			g_output_stream_close_async ((GOutputStream*) _data_->_tmp42_, G_PRIORITY_DEFAULT, _data_->_tmp44_, synapse_calculator_plugin_search_ready, _data_);
			return FALSE;
			_state_1:
			g_output_stream_close_finish ((GOutputStream*) _data_->_tmp42_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->bc_input);
				_g_object_unref0 (_data_->write_stream);
				_g_object_unref0 (_data_->bc_output);
				_g_object_unref0 (_data_->read_stream);
				goto __catch50_g_error;
			}
			_data_->_tmp46_ = _data_->bc_output;
			_data_->_tmp47_ = _data_->query;
			_data_->_tmp48_ = _data_->_tmp47_.cancellable;
			_data_->_state_ = 2;
			g_data_input_stream_read_line_async (_data_->_tmp46_, G_PRIORITY_DEFAULT_IDLE, _data_->_tmp48_, synapse_calculator_plugin_search_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp49_ = g_data_input_stream_read_line_finish (_data_->_tmp46_, _data_->_res_, NULL, &_data_->_inner_error_);
			_data_->_tmp45_ = _data_->_tmp49_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->bc_input);
				_g_object_unref0 (_data_->write_stream);
				_g_object_unref0 (_data_->bc_output);
				_g_object_unref0 (_data_->read_stream);
				goto __catch50_g_error;
			}
			_data_->_tmp50_ = _data_->_tmp45_;
			_data_->_tmp45_ = NULL;
			_g_free0 (_data_->solution);
			_data_->solution = _data_->_tmp50_;
			_data_->_tmp51_ = _data_->solution;
			if (_data_->_tmp51_ != NULL) {
				_data_->_tmp52_ = _data_->solution;
				_data_->d = double_parse (_data_->_tmp52_);
				_data_->_tmp53_ = _data_->d;
				_data_->_tmp54_ = _data_->query;
				_data_->_tmp55_ = _data_->_tmp54_.query_string;
				_data_->_tmp56_ = synapse_calculator_plugin_result_new (_data_->_tmp53_, _data_->_tmp55_);
				_data_->_result_ = _data_->_tmp56_;
				_data_->_tmp57_ = synapse_result_set_new ();
				_data_->results = _data_->_tmp57_;
				_data_->_tmp58_ = _data_->results;
				_data_->_tmp59_ = _data_->_result_;
				synapse_result_set_add (_data_->_tmp58_, (SynapseMatch*) _data_->_tmp59_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
				synapse_query_check_cancellable (&_data_->query, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->results);
					_g_object_unref0 (_data_->_result_);
					_g_free0 (_data_->_tmp45_);
					_g_object_unref0 (_data_->bc_input);
					_g_object_unref0 (_data_->write_stream);
					_g_object_unref0 (_data_->bc_output);
					_g_object_unref0 (_data_->read_stream);
					goto __catch50_g_error;
				}
				_data_->result = _data_->results;
				_g_object_unref0 (_data_->_result_);
				_g_free0 (_data_->_tmp45_);
				_g_object_unref0 (_data_->bc_input);
				_g_object_unref0 (_data_->write_stream);
				_g_object_unref0 (_data_->bc_output);
				_g_object_unref0 (_data_->read_stream);
				_g_free0 (_data_->solution);
				_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->input);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!_data_->_task_complete_) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_free0 (_data_->_tmp45_);
			_g_object_unref0 (_data_->bc_input);
			_g_object_unref0 (_data_->write_stream);
			_g_object_unref0 (_data_->bc_output);
			_g_object_unref0 (_data_->read_stream);
		}
		goto __finally50;
		__catch50_g_error:
		{
			_data_->err = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			if (!synapse_query_is_cancelled (&_data_->query)) {
				_data_->_tmp60_ = _data_->err;
				_data_->_tmp61_ = _data_->_tmp60_->message;
				g_warning ("calculator-plugin.vala:143: %s", _data_->_tmp61_);
			}
			_g_error_free0 (_data_->err);
		}
		__finally50:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				_g_free0 (_data_->solution);
				_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->input);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_free0 (_data_->solution);
				_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->input);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_free0 (_data_->solution);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
	}
	synapse_query_check_cancellable (&_data_->query, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_free0 (_data_->input);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->input);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = NULL;
	_g_free0 (_data_->input);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


SynapseCalculatorPlugin*
synapse_calculator_plugin_construct (GType object_type)
{
	SynapseCalculatorPlugin * self = NULL;
	self = (SynapseCalculatorPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseCalculatorPlugin*
synapse_calculator_plugin_new (void)
{
	return synapse_calculator_plugin_construct (SYNAPSE_TYPE_CALCULATOR_PLUGIN);
}


static gboolean
synapse_calculator_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseCalculatorPlugin* self;
	gboolean _tmp0_;
	self = (SynapseCalculatorPlugin*) base;
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


static void
synapse_calculator_plugin_real_set_enabled (SynapseActivatable* base,
                                            gboolean value)
{
	SynapseCalculatorPlugin* self;
	self = (SynapseCalculatorPlugin*) base;
	if (synapse_calculator_plugin_real_get_enabled (base) != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_properties[SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY]);
	}
}


static GObject *
synapse_calculator_plugin_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCalculatorPlugin * self;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_calculator_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("^\\(*(-?\\d+([.,]\\d+)?)([*/+-^]\\(*(-?\\d+([.,]\\d+)?)\\)*)+$", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch51_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (self->priv->regex);
		self->priv->regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally51;
	__catch51_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		synapse_utils_logger_error ((GObject*) self, "Error creating regexp.", NULL);
		_g_error_free0 (e);
	}
	__finally51:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static inline gpointer
synapse_calculator_plugin_result_get_instance_private (SynapseCalculatorPluginResult* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCalculatorPluginResult_private_offset);
}


static SynapseCalculatorPluginResult*
synapse_calculator_plugin_result_construct (GType object_type,
                                            gdouble _result_,
                                            const gchar* match_string)
{
	SynapseCalculatorPluginResult * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (match_string != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%g", _result_);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s = %g", match_string, _result_);
	_tmp3_ = _tmp2_;
	self = (SynapseCalculatorPluginResult*) g_object_new (object_type, "match-type", SYNAPSE_MATCH_TYPE_TEXT, "title", _tmp1_, "description", _tmp3_, "has-thumbnail", FALSE, "icon-name", "accessories-calculator", NULL);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}


static SynapseCalculatorPluginResult*
synapse_calculator_plugin_result_new (gdouble _result_,
                                      const gchar* match_string)
{
	return synapse_calculator_plugin_result_construct (SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, _result_, match_string);
}


static const gchar*
synapse_calculator_plugin_result_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseCalculatorPluginResult* self;
	const gchar* _tmp0_;
	self = (SynapseCalculatorPluginResult*) base;
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


static void
synapse_calculator_plugin_result_real_set_title (SynapseMatch* base,
                                                 const gchar* value)
{
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	if (g_strcmp0 (value, synapse_calculator_plugin_result_real_get_title (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_TITLE_PROPERTY]);
	}
}


static const gchar*
synapse_calculator_plugin_result_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseCalculatorPluginResult* self;
	const gchar* _tmp0_;
	self = (SynapseCalculatorPluginResult*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void
synapse_calculator_plugin_result_real_set_description (SynapseMatch* base,
                                                       const gchar* value)
{
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	if (g_strcmp0 (value, synapse_calculator_plugin_result_real_get_description (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_DESCRIPTION_PROPERTY]);
	}
}


static const gchar*
synapse_calculator_plugin_result_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseCalculatorPluginResult* self;
	const gchar* _tmp0_;
	self = (SynapseCalculatorPluginResult*) base;
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}


static void
synapse_calculator_plugin_result_real_set_icon_name (SynapseMatch* base,
                                                     const gchar* value)
{
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	if (g_strcmp0 (value, synapse_calculator_plugin_result_real_get_icon_name (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_ICON_NAME_PROPERTY]);
	}
}


static gboolean
synapse_calculator_plugin_result_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseCalculatorPluginResult* self;
	gboolean _tmp0_;
	self = (SynapseCalculatorPluginResult*) base;
	_tmp0_ = self->priv->_has_thumbnail;
	result = _tmp0_;
	return result;
}


static void
synapse_calculator_plugin_result_real_set_has_thumbnail (SynapseMatch* base,
                                                         gboolean value)
{
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	if (synapse_calculator_plugin_result_real_get_has_thumbnail (base) != value) {
		self->priv->_has_thumbnail = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY]);
	}
}


static const gchar*
synapse_calculator_plugin_result_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseCalculatorPluginResult* self;
	const gchar* _tmp0_;
	self = (SynapseCalculatorPluginResult*) base;
	_tmp0_ = self->priv->_thumbnail_path;
	result = _tmp0_;
	return result;
}


static void
synapse_calculator_plugin_result_real_set_thumbnail_path (SynapseMatch* base,
                                                          const gchar* value)
{
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	if (g_strcmp0 (value, synapse_calculator_plugin_result_real_get_thumbnail_path (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_thumbnail_path);
		self->priv->_thumbnail_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY]);
	}
}


static SynapseMatchType
synapse_calculator_plugin_result_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseCalculatorPluginResult* self;
	SynapseMatchType _tmp0_;
	self = (SynapseCalculatorPluginResult*) base;
	_tmp0_ = self->priv->_match_type;
	result = _tmp0_;
	return result;
}


static void
synapse_calculator_plugin_result_real_set_match_type (SynapseMatch* base,
                                                      SynapseMatchType value)
{
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	if (synapse_calculator_plugin_result_real_get_match_type (base) != value) {
		self->priv->_match_type = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_MATCH_TYPE_PROPERTY]);
	}
}


static gint
synapse_calculator_plugin_result_get_default_relevancy (SynapseCalculatorPluginResult* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_default_relevancy;
	result = _tmp0_;
	return result;
}


static void
synapse_calculator_plugin_result_set_default_relevancy (SynapseCalculatorPluginResult* self,
                                                        gint value)
{
	g_return_if_fail (self != NULL);
	if (synapse_calculator_plugin_result_get_default_relevancy (self) != value) {
		self->priv->_default_relevancy = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY]);
	}
}


static void
synapse_calculator_plugin_result_class_init (SynapseCalculatorPluginResultClass * klass)
{
	synapse_calculator_plugin_result_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseCalculatorPluginResult_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_calculator_plugin_result_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_calculator_plugin_result_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_calculator_plugin_result_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_TITLE_PROPERTY, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_DESCRIPTION_PROPERTY, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_ICON_NAME_PROPERTY, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_MATCH_TYPE_PROPERTY, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
synapse_calculator_plugin_result_synapse_match_interface_init (SynapseMatchIface * iface)
{
	synapse_calculator_plugin_result_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_calculator_plugin_result_real_get_title;
	iface->set_title = synapse_calculator_plugin_result_real_set_title;
	iface->get_description = synapse_calculator_plugin_result_real_get_description;
	iface->set_description = synapse_calculator_plugin_result_real_set_description;
	iface->get_icon_name = synapse_calculator_plugin_result_real_get_icon_name;
	iface->set_icon_name = synapse_calculator_plugin_result_real_set_icon_name;
	iface->get_has_thumbnail = synapse_calculator_plugin_result_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_calculator_plugin_result_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_calculator_plugin_result_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_calculator_plugin_result_real_set_thumbnail_path;
	iface->get_match_type = synapse_calculator_plugin_result_real_get_match_type;
	iface->set_match_type = synapse_calculator_plugin_result_real_set_match_type;
}


static void
synapse_calculator_plugin_result_instance_init (SynapseCalculatorPluginResult * self)
{
	self->priv = synapse_calculator_plugin_result_get_instance_private (self);
	self->priv->_default_relevancy = 0;
}


static void
synapse_calculator_plugin_result_finalize (GObject * obj)
{
	SynapseCalculatorPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResult);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	G_OBJECT_CLASS (synapse_calculator_plugin_result_parent_class)->finalize (obj);
}


static GType
synapse_calculator_plugin_result_get_type (void)
{
	static volatile gsize synapse_calculator_plugin_result_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_calculator_plugin_result_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCalculatorPluginResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_calculator_plugin_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCalculatorPluginResult), 0, (GInstanceInitFunc) synapse_calculator_plugin_result_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_calculator_plugin_result_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_calculator_plugin_result_type_id;
		synapse_calculator_plugin_result_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCalculatorPluginResult", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_calculator_plugin_result_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		SynapseCalculatorPluginResult_private_offset = g_type_add_instance_private (synapse_calculator_plugin_result_type_id, sizeof (SynapseCalculatorPluginResultPrivate));
		g_once_init_leave (&synapse_calculator_plugin_result_type_id__volatile, synapse_calculator_plugin_result_type_id);
	}
	return synapse_calculator_plugin_result_type_id__volatile;
}


static void
_vala_synapse_calculator_plugin_result_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	SynapseCalculatorPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResult);
	switch (property_id) {
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_TITLE_PROPERTY:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_DESCRIPTION_PROPERTY:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_ICON_NAME_PROPERTY:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_MATCH_TYPE_PROPERTY:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
		g_value_set_int (value, synapse_calculator_plugin_result_get_default_relevancy (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_synapse_calculator_plugin_result_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	SynapseCalculatorPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResult);
	switch (property_id) {
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_TITLE_PROPERTY:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_DESCRIPTION_PROPERTY:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_ICON_NAME_PROPERTY:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_HAS_THUMBNAIL_PROPERTY:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_THUMBNAIL_PATH_PROPERTY:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_MATCH_TYPE_PROPERTY:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
		synapse_calculator_plugin_result_set_default_relevancy (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
synapse_calculator_plugin_class_init (SynapseCalculatorPluginClass * klass)
{
	synapse_calculator_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseCalculatorPlugin_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_calculator_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_calculator_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_calculator_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_calculator_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY, synapse_calculator_plugin_properties[SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	synapse_calculator_plugin_register_plugin ();
}


static void
synapse_calculator_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface)
{
	synapse_calculator_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (SynapseActivatable*)) synapse_calculator_plugin_real_activate;
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_calculator_plugin_real_deactivate;
	iface->get_enabled = synapse_calculator_plugin_real_get_enabled;
	iface->set_enabled = synapse_calculator_plugin_real_set_enabled;
}


static void
synapse_calculator_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface)
{
	synapse_calculator_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_calculator_plugin_real_handles_query;
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_calculator_plugin_real_search;
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_calculator_plugin_real_search_finish;
}


static void
synapse_calculator_plugin_instance_init (SynapseCalculatorPlugin * self)
{
	self->priv = synapse_calculator_plugin_get_instance_private (self);
	self->priv->_enabled = TRUE;
}


static void
synapse_calculator_plugin_finalize (GObject * obj)
{
	SynapseCalculatorPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin);
	_g_regex_unref0 (self->priv->regex);
	G_OBJECT_CLASS (synapse_calculator_plugin_parent_class)->finalize (obj);
}


GType
synapse_calculator_plugin_get_type (void)
{
	static volatile gsize synapse_calculator_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_calculator_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCalculatorPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_calculator_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCalculatorPlugin), 0, (GInstanceInitFunc) synapse_calculator_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_calculator_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_calculator_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_calculator_plugin_type_id;
		synapse_calculator_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCalculatorPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_calculator_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_calculator_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
		SynapseCalculatorPlugin_private_offset = g_type_add_instance_private (synapse_calculator_plugin_type_id, sizeof (SynapseCalculatorPluginPrivate));
		g_once_init_leave (&synapse_calculator_plugin_type_id__volatile, synapse_calculator_plugin_type_id);
	}
	return synapse_calculator_plugin_type_id__volatile;
}


static void
_vala_synapse_calculator_plugin_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SynapseCalculatorPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin);
	switch (property_id) {
		case SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_synapse_calculator_plugin_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SynapseCalculatorPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin);
	switch (property_id) {
		case SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



