/* command-plugin.c generated by valac 0.42.5, the Vala compiler
 * generated from command-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define SYNAPSE_TYPE_ACTIVATABLE (synapse_activatable_get_type ())
#define SYNAPSE_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable))
#define SYNAPSE_IS_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTIVATABLE))
#define SYNAPSE_ACTIVATABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatableIface))

typedef struct _SynapseActivatable SynapseActivatable;
typedef struct _SynapseActivatableIface SynapseActivatableIface;

#define SYNAPSE_TYPE_ITEM_PROVIDER (synapse_item_provider_get_type ())
#define SYNAPSE_ITEM_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ITEM_PROVIDER, SynapseItemProvider))
#define SYNAPSE_IS_ITEM_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ITEM_PROVIDER))
#define SYNAPSE_ITEM_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ITEM_PROVIDER, SynapseItemProviderIface))

typedef struct _SynapseItemProvider SynapseItemProvider;
typedef struct _SynapseItemProviderIface SynapseItemProviderIface;

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())
typedef struct _SynapseQuery SynapseQuery;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;


#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_COMMAND_PLUGIN (synapse_command_plugin_get_type ())
#define SYNAPSE_COMMAND_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin))
#define SYNAPSE_COMMAND_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPluginClass))
#define SYNAPSE_IS_COMMAND_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN))
#define SYNAPSE_IS_COMMAND_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_COMMAND_PLUGIN))
#define SYNAPSE_COMMAND_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPluginClass))

typedef struct _SynapseCommandPlugin SynapseCommandPlugin;
typedef struct _SynapseCommandPluginClass SynapseCommandPluginClass;
typedef struct _SynapseCommandPluginPrivate SynapseCommandPluginPrivate;
enum  {
	SYNAPSE_COMMAND_PLUGIN_0_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY (synapse_data_sink_plugin_registry_get_type ())
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistry))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistryClass))
#define SYNAPSE_DATA_SINK_IS_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_DATA_SINK_IS_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistryClass))

typedef struct _SynapseDataSinkPluginRegistry SynapseDataSinkPluginRegistry;
typedef struct _SynapseDataSinkPluginRegistryClass SynapseDataSinkPluginRegistryClass;
typedef void (*SynapsePluginRegisterFunc) (void);

#define SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT (synapse_command_plugin_command_object_get_type ())
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject))
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObjectClass))
#define SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT))
#define SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT))
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObjectClass))

typedef struct _SynapseCommandPluginCommandObject SynapseCommandPluginCommandObject;
typedef struct _SynapseCommandPluginCommandObjectClass SynapseCommandPluginCommandObjectClass;

#define SYNAPSE_TYPE_DESKTOP_FILE_SERVICE (synapse_desktop_file_service_get_type ())
#define SYNAPSE_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService))
#define SYNAPSE_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_DESKTOP_FILE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))

typedef struct _SynapseDesktopFileService SynapseDesktopFileService;
typedef struct _SynapseDesktopFileServiceClass SynapseDesktopFileServiceClass;

#define SYNAPSE_TYPE_DESKTOP_FILE_INFO (synapse_desktop_file_info_get_type ())
#define SYNAPSE_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo))
#define SYNAPSE_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))
#define SYNAPSE_IS_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_IS_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_DESKTOP_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))

typedef struct _SynapseDesktopFileInfo SynapseDesktopFileInfo;
typedef struct _SynapseDesktopFileInfoClass SynapseDesktopFileInfoClass;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT
} SynapseMatchType;


#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;


#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())
typedef struct _SynapseCommandPluginSearchData SynapseCommandPluginSearchData;

#define SYNAPSE_TYPE_APPLICATION_MATCH (synapse_application_match_get_type ())
#define SYNAPSE_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch))
#define SYNAPSE_IS_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_APPLICATION_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchIface))

typedef struct _SynapseApplicationMatch SynapseApplicationMatch;
typedef struct _SynapseApplicationMatchIface SynapseApplicationMatchIface;
typedef struct _SynapseCommandPluginCommandObjectPrivate SynapseCommandPluginCommandObjectPrivate;
enum  {
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_0_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NUM_PROPERTIES
};
static GParamSpec* synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NUM_PROPERTIES];

struct _SynapseActivatableIface {
	GTypeInterface parent_iface;
	void (*activate) (SynapseActivatable* self);
	void (*deactivate) (SynapseActivatable* self);
	gboolean (*get_enabled) (SynapseActivatable* self);
	void (*set_enabled) (SynapseActivatable* self, gboolean value);
};

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseItemProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseItemProvider* self, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	SynapseResultSet* (*search_finish) (SynapseItemProvider* self, GAsyncResult* _res_, GError** error);
	gboolean (*handles_query) (SynapseItemProvider* self, SynapseQuery* query);
	gboolean (*handles_empty_query) (SynapseItemProvider* self);
};

struct _SynapseCommandPlugin {
	GObject parent_instance;
	SynapseCommandPluginPrivate * priv;
};

struct _SynapseCommandPluginClass {
	GObjectClass parent_class;
};

struct _SynapseCommandPluginPrivate {
	gboolean _enabled;
	GeeSet* past_commands;
	GRegex* split_regex;
};

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseCommandPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseCommandPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp2_;
	gchar* stripped;
	SynapseQuery _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GeeSet* _tmp11_;
	const gchar* _tmp12_;
	GeeIterator* _command_it;
	GeeSet* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	gchar* command;
	GeeIterator* _tmp16_;
	gpointer _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	SynapseResultSet* _tmp20_;
	const gchar* _tmp21_;
	SynapseCommandPluginCommandObject* _tmp22_;
	SynapseCommandPluginCommandObject* _tmp23_;
	gchar** args;
	GRegex* _tmp24_;
	const gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint args_length1;
	gint _args_size_;
	gchar* valid_cmd;
	gchar** _tmp28_;
	gint _tmp28__length1;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	const gchar* _tmp33_;
	SynapseCommandPluginCommandObject* co;
	const gchar* _tmp34_;
	SynapseCommandPluginCommandObject* _tmp35_;
	SynapseCommandPluginCommandObject* _tmp36_;
	SynapseResultSet* _tmp37_;
	SynapseCommandPluginCommandObject* _tmp38_;
	SynapseCommandPluginCommandObject* _tmp39_;
	SynapseResultSet* _tmp40_;
	const gchar* _tmp41_;
	SynapseCommandPluginCommandObject* _tmp42_;
	SynapseCommandPluginCommandObject* _tmp43_;
	GError * _inner_error_;
};

struct _SynapseApplicationMatchIface {
	GTypeInterface parent_iface;
	GAppInfo* (*get_app_info) (SynapseApplicationMatch* self);
	void (*set_app_info) (SynapseApplicationMatch* self, GAppInfo* value);
	gboolean (*get_needs_terminal) (SynapseApplicationMatch* self);
	void (*set_needs_terminal) (SynapseApplicationMatch* self, gboolean value);
	const gchar* (*get_filename) (SynapseApplicationMatch* self);
	void (*set_filename) (SynapseApplicationMatch* self, const gchar* value);
};

struct _SynapseCommandPluginCommandObject {
	GObject parent_instance;
	SynapseCommandPluginCommandObjectPrivate * priv;
};

struct _SynapseCommandPluginCommandObjectClass {
	GObjectClass parent_class;
};

struct _SynapseCommandPluginCommandObjectPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _command;
};


static gint SynapseCommandPlugin_private_offset;
static gpointer synapse_command_plugin_parent_class = NULL;
static gint SynapseCommandPluginCommandObject_private_offset;
static gpointer synapse_command_plugin_command_object_parent_class = NULL;
static SynapseMatchIface * synapse_command_plugin_command_object_synapse_match_parent_iface = NULL;
static SynapseApplicationMatchIface * synapse_command_plugin_command_object_synapse_application_match_parent_iface = NULL;
static SynapseActivatableIface * synapse_command_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_command_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_activatable_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self,
                         SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
GQuark synapse_search_error_quark (void);
GType synapse_item_provider_get_type (void) G_GNUC_CONST;
GType synapse_command_plugin_get_type (void) G_GNUC_CONST;
static void synapse_command_plugin_real_activate (SynapseActivatable* base);
static void synapse_command_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_command_plugin_register_plugin (void);
GType synapse_data_sink_plugin_registry_get_type (void) G_GNUC_CONST;
SynapseDataSinkPluginRegistry* synapse_data_sink_plugin_registry_get_default (void);
void synapse_data_sink_plugin_registry_register_plugin (SynapseDataSinkPluginRegistry* self,
                                                        GType plugin_type,
                                                        const gchar* title,
                                                        const gchar* description,
                                                        const gchar* icon_name,
                                                        SynapsePluginRegisterFunc reg_func,
                                                        gboolean runnable,
                                                        const gchar* runnable_error);
static void _synapse_command_plugin_register_plugin_synapse_plugin_register_func (void);
static GType synapse_command_plugin_command_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCommandPluginCommandObject* synapse_command_plugin_create_co (SynapseCommandPlugin* self,
                                                                     const gchar* exec);
GType synapse_desktop_file_service_get_type (void) G_GNUC_CONST;
SynapseDesktopFileService* synapse_desktop_file_service_get_default (void);
GType synapse_desktop_file_info_get_type (void) G_GNUC_CONST;
GeeList* synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self,
                                                                  const gchar* exec);
gboolean synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self);
static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_new (const gchar* cmd);
static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_construct (GType object_type,
                                                                                    const gchar* cmd);
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
const gchar* synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self);
void synapse_match_set_title (SynapseMatch* self,
                              const gchar* value);
const gchar* synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self);
void synapse_match_set_description (SynapseMatch* self,
                                    const gchar* value);
const gchar* synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self);
void synapse_match_set_icon_name (SynapseMatch* self,
                                  const gchar* value);
static void synapse_command_plugin_command_executed (SynapseCommandPlugin* self,
                                              SynapseMatch* match);
static const gchar* synapse_command_plugin_command_object_get_command (SynapseCommandPluginCommandObject* self);
static void synapse_command_plugin_real_search_data_free (gpointer _data);
static void synapse_command_plugin_real_search_async_ready_wrapper (GObject *source_object,
                                                             GAsyncResult *res,
                                                             void *user_data);
static void synapse_command_plugin_real_search (SynapseItemProvider* base,
                                         SynapseQuery* q,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean synapse_command_plugin_real_search_co (SynapseCommandPluginSearchData* _data_);
void synapse_item_provider_search (SynapseItemProvider* self,
                                   SynapseQuery* query,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
SynapseResultSet* synapse_item_provider_search_finish (SynapseItemProvider* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static gboolean _synapse_command_plugin_real_search_co_gsource_func (gpointer self);
SynapseResultSet* synapse_result_set_new (void);
SynapseResultSet* synapse_result_set_construct (GType object_type);
void synapse_result_set_add (SynapseResultSet* self,
                             SynapseMatch* match,
                             gint relevancy);
GType synapse_match_score_get_type (void) G_GNUC_CONST;
static void _synapse_command_plugin_command_executed_synapse_match_executed (SynapseMatch* _sender,
                                                                      gpointer self);
void synapse_query_check_cancellable (SynapseQuery *self,
                                      GError** error);
SynapseCommandPlugin* synapse_command_plugin_new (void);
SynapseCommandPlugin* synapse_command_plugin_construct (GType object_type);
static GObject * synapse_command_plugin_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
GType synapse_application_match_get_type (void) G_GNUC_CONST;
void synapse_application_match_set_app_info (SynapseApplicationMatch* self,
                                             GAppInfo* value);
static void synapse_command_plugin_command_object_set_command (SynapseCommandPluginCommandObject* self,
                                                        const gchar* value);
static void synapse_command_plugin_command_object_finalize (GObject * obj);
const gchar* synapse_match_get_title (SynapseMatch* self);
const gchar* synapse_match_get_description (SynapseMatch* self);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self);
gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self);
const gchar* synapse_application_match_get_filename (SynapseApplicationMatch* self);
static void _vala_synapse_command_plugin_command_object_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
void synapse_match_set_has_thumbnail (SynapseMatch* self,
                                      gboolean value);
void synapse_match_set_thumbnail_path (SynapseMatch* self,
                                       const gchar* value);
void synapse_match_set_match_type (SynapseMatch* self,
                                   SynapseMatchType value);
void synapse_application_match_set_needs_terminal (SynapseApplicationMatch* self,
                                                   gboolean value);
void synapse_application_match_set_filename (SynapseApplicationMatch* self,
                                             const gchar* value);
static void _vala_synapse_command_plugin_command_object_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);
static void synapse_command_plugin_finalize (GObject * obj);
gboolean synapse_activatable_get_enabled (SynapseActivatable* self);
static void _vala_synapse_command_plugin_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
void synapse_activatable_set_enabled (SynapseActivatable* self,
                                      gboolean value);
static void _vala_synapse_command_plugin_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static inline gpointer
synapse_command_plugin_get_instance_private (SynapseCommandPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommandPlugin_private_offset);
}


static void
synapse_command_plugin_real_activate (SynapseActivatable* base)
{
	SynapseCommandPlugin * self;
	self = (SynapseCommandPlugin*) base;
}


static void
synapse_command_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseCommandPlugin * self;
	self = (SynapseCommandPlugin*) base;
}


static void
_synapse_command_plugin_register_plugin_synapse_plugin_register_func (void)
{
	synapse_command_plugin_register_plugin ();
}


static void
synapse_command_plugin_register_plugin (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDataSinkPluginRegistry* _tmp1_;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_COMMAND_PLUGIN, "Command Search", _ ("Find and execute arbitrary commands."), "system-run", _synapse_command_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp1_);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static SynapseCommandPluginCommandObject*
synapse_command_plugin_create_co (SynapseCommandPlugin* self,
                                  const gchar* exec)
{
	SynapseCommandPluginCommandObject* result = NULL;
	SynapseDesktopFileService* dfs = NULL;
	SynapseDesktopFileService* _tmp0_;
	GeeList* df_list = NULL;
	SynapseDesktopFileService* _tmp1_;
	GeeList* _tmp2_;
	SynapseDesktopFileInfo* dfi = NULL;
	SynapseCommandPluginCommandObject* co = NULL;
	SynapseCommandPluginCommandObject* _tmp19_;
	SynapseDesktopFileInfo* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exec != NULL, NULL);
	_tmp0_ = synapse_desktop_file_service_get_default ();
	dfs = _tmp0_;
	_tmp1_ = dfs;
	_tmp2_ = synapse_desktop_file_service_get_desktop_files_for_exec (_tmp1_, exec);
	df_list = _tmp2_;
	dfi = NULL;
	{
		GeeList* _df_list = NULL;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _df_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _df_index = 0;
		_tmp3_ = df_list;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_df_list = _tmp4_;
		_tmp5_ = _df_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_df_size = _tmp7_;
		_df_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			SynapseDesktopFileInfo* df = NULL;
			GeeList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			SynapseDesktopFileInfo* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			SynapseDesktopFileInfo* _tmp17_;
			SynapseDesktopFileInfo* _tmp18_;
			_tmp8_ = _df_index;
			_df_index = _tmp8_ + 1;
			_tmp9_ = _df_index;
			_tmp10_ = _df_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _df_list;
			_tmp12_ = _df_index;
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
			df = (SynapseDesktopFileInfo*) _tmp13_;
			_tmp14_ = df;
			_tmp15_ = synapse_desktop_file_info_get_is_hidden (_tmp14_);
			_tmp16_ = _tmp15_;
			if (!_tmp16_) {
				result = NULL;
				_g_object_unref0 (df);
				_g_object_unref0 (_df_list);
				_g_object_unref0 (dfi);
				_g_object_unref0 (df_list);
				_g_object_unref0 (dfs);
				return result;
			}
			_tmp17_ = df;
			_tmp18_ = _g_object_ref0 (_tmp17_);
			_g_object_unref0 (dfi);
			dfi = _tmp18_;
			_g_object_unref0 (df);
		}
		_g_object_unref0 (_df_list);
	}
	_tmp19_ = synapse_command_plugin_command_object_new (exec);
	co = _tmp19_;
	_tmp20_ = dfi;
	if (_tmp20_ != NULL) {
		SynapseCommandPluginCommandObject* _tmp21_;
		SynapseDesktopFileInfo* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		SynapseDesktopFileInfo* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gboolean _tmp32_ = FALSE;
		SynapseDesktopFileInfo* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp21_ = co;
		_tmp22_ = dfi;
		_tmp23_ = synapse_desktop_file_info_get_name (_tmp22_);
		_tmp24_ = _tmp23_;
		synapse_match_set_title ((SynapseMatch*) _tmp21_, _tmp24_);
		_tmp25_ = dfi;
		_tmp26_ = synapse_desktop_file_info_get_comment (_tmp25_);
		_tmp27_ = _tmp26_;
		if (g_strcmp0 (_tmp27_, "") != 0) {
			SynapseCommandPluginCommandObject* _tmp28_;
			SynapseDesktopFileInfo* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			_tmp28_ = co;
			_tmp29_ = dfi;
			_tmp30_ = synapse_desktop_file_info_get_comment (_tmp29_);
			_tmp31_ = _tmp30_;
			synapse_match_set_description ((SynapseMatch*) _tmp28_, _tmp31_);
		}
		_tmp33_ = dfi;
		_tmp34_ = synapse_desktop_file_info_get_icon_name (_tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ != NULL) {
			SynapseDesktopFileInfo* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			_tmp36_ = dfi;
			_tmp37_ = synapse_desktop_file_info_get_icon_name (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp32_ = g_strcmp0 (_tmp38_, "") != 0;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			SynapseCommandPluginCommandObject* _tmp39_;
			SynapseDesktopFileInfo* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			_tmp39_ = co;
			_tmp40_ = dfi;
			_tmp41_ = synapse_desktop_file_info_get_icon_name (_tmp40_);
			_tmp42_ = _tmp41_;
			synapse_match_set_icon_name ((SynapseMatch*) _tmp39_, _tmp42_);
		}
	}
	result = co;
	_g_object_unref0 (dfi);
	_g_object_unref0 (df_list);
	_g_object_unref0 (dfs);
	return result;
}


static void
synapse_command_plugin_command_executed (SynapseCommandPlugin* self,
                                         SynapseMatch* match)
{
	SynapseCommandPluginCommandObject* co = NULL;
	SynapseCommandPluginCommandObject* _tmp0_;
	SynapseCommandPluginCommandObject* _tmp1_;
	GeeSet* _tmp2_;
	SynapseCommandPluginCommandObject* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (match != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT) ? ((SynapseCommandPluginCommandObject*) match) : NULL);
	co = _tmp0_;
	_tmp1_ = co;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (co);
		return;
	}
	_tmp2_ = self->priv->past_commands;
	_tmp3_ = co;
	_tmp4_ = synapse_command_plugin_command_object_get_command (_tmp3_);
	_tmp5_ = _tmp4_;
	gee_collection_add ((GeeCollection*) _tmp2_, _tmp5_);
	_g_object_unref0 (co);
}


static void
synapse_command_plugin_real_search_data_free (gpointer _data)
{
	SynapseCommandPluginSearchData* _data_;
	_data_ = _data;
	synapse_query_destroy (&_data_->q);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseCommandPluginSearchData, _data_);
}


static void
synapse_command_plugin_real_search_async_ready_wrapper (GObject *source_object,
                                                        GAsyncResult *res,
                                                        void *user_data)
{
	SynapseCommandPluginSearchData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
synapse_command_plugin_real_search (SynapseItemProvider* base,
                                    SynapseQuery* q,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	SynapseCommandPlugin * self;
	SynapseCommandPluginSearchData* _data_;
	SynapseCommandPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_ = {0};
	self = (SynapseCommandPlugin*) base;
	_data_ = g_slice_new0 (SynapseCommandPluginSearchData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, synapse_command_plugin_real_search_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_command_plugin_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = *q;
	synapse_query_copy (&_tmp1_, &_tmp2_);
	synapse_query_destroy (&_data_->q);
	_data_->q = _tmp2_;
	synapse_command_plugin_real_search_co (_data_);
}


static SynapseResultSet*
synapse_command_plugin_real_search_finish (SynapseItemProvider* base,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	SynapseResultSet* result;
	SynapseCommandPluginSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean
_synapse_command_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_command_plugin_real_search_co (self);
	return result;
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch52_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch52_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally52;
	__catch52_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally52:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void
_synapse_command_plugin_command_executed_synapse_match_executed (SynapseMatch* _sender,
                                                                 gpointer self)
{
	synapse_command_plugin_command_executed ((SynapseCommandPlugin*) self, _sender);
}


static gboolean
synapse_command_plugin_real_search_co (SynapseCommandPluginSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->q;
	_data_->_tmp1_ = _data_->_tmp0_.query_type;
	if (!((_data_->_tmp1_ & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS)) {
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!_data_->_task_complete_) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_command_plugin_real_search_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp2_ = synapse_result_set_new ();
	_data_->_result_ = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->q;
	_data_->_tmp4_ = _data_->_tmp3_.query_string;
	_data_->_tmp5_ = string_strip (_data_->_tmp4_);
	_data_->stripped = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->stripped;
	if (g_strcmp0 (_data_->_tmp6_, "") == 0) {
		_data_->result = NULL;
		_g_free0 (_data_->stripped);
		_g_object_unref0 (_data_->_result_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!_data_->_task_complete_) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->stripped;
	if (g_str_has_prefix (_data_->_tmp7_, "~/")) {
		_data_->_tmp8_ = _data_->stripped;
		_data_->_tmp9_ = g_get_home_dir ();
		_data_->_tmp10_ = string_replace (_data_->_tmp8_, "~", _data_->_tmp9_);
		_g_free0 (_data_->stripped);
		_data_->stripped = _data_->_tmp10_;
	}
	_data_->_tmp11_ = _data_->self->priv->past_commands;
	_data_->_tmp12_ = _data_->stripped;
	if (!gee_collection_contains ((GeeCollection*) _data_->_tmp11_, _data_->_tmp12_)) {
		{
			_data_->_tmp13_ = _data_->self->priv->past_commands;
			_data_->_tmp14_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp13_);
			_data_->_command_it = _data_->_tmp14_;
			while (TRUE) {
				_data_->_tmp15_ = _data_->_command_it;
				if (!gee_iterator_next (_data_->_tmp15_)) {
					break;
				}
				_data_->_tmp16_ = _data_->_command_it;
				_data_->_tmp17_ = gee_iterator_get (_data_->_tmp16_);
				_data_->command = (gchar*) _data_->_tmp17_;
				_data_->_tmp18_ = _data_->command;
				_data_->_tmp19_ = _data_->stripped;
				if (g_str_has_prefix (_data_->_tmp18_, _data_->_tmp19_)) {
					_data_->_tmp20_ = _data_->_result_;
					_data_->_tmp21_ = _data_->command;
					_data_->_tmp22_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp21_);
					_data_->_tmp23_ = _data_->_tmp22_;
					synapse_result_set_add (_data_->_tmp20_, (SynapseMatch*) _data_->_tmp23_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
					_g_object_unref0 (_data_->_tmp23_);
				}
				_g_free0 (_data_->command);
			}
			_g_object_unref0 (_data_->_command_it);
		}
		_data_->_tmp24_ = _data_->self->priv->split_regex;
		_data_->_tmp25_ = _data_->stripped;
		_data_->_tmp27_ = _data_->_tmp26_ = g_regex_split (_data_->_tmp24_, _data_->_tmp25_, 0);
		_data_->args = _data_->_tmp27_;
		_data_->args_length1 = _vala_array_length (_data_->_tmp26_);
		_data_->_args_size_ = _data_->args_length1;
		_data_->_tmp28_ = _data_->args;
		_data_->_tmp28__length1 = _data_->args_length1;
		_data_->_tmp29_ = _data_->_tmp28_[0];
		_data_->_tmp30_ = g_find_program_in_path (_data_->_tmp29_);
		_data_->valid_cmd = _data_->_tmp30_;
		_data_->_tmp31_ = _data_->valid_cmd;
		if (_data_->_tmp31_ != NULL) {
			_data_->_tmp32_ = _data_->args;
			_data_->_tmp32__length1 = _data_->args_length1;
			_data_->_tmp33_ = _data_->_tmp32_[0];
			if (g_strcmp0 (_data_->_tmp33_, "rm") == 0) {
				_data_->result = NULL;
				_g_free0 (_data_->valid_cmd);
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->stripped);
				_g_object_unref0 (_data_->_result_);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!_data_->_task_complete_) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp34_ = _data_->stripped;
			_data_->_tmp35_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp34_);
			_data_->co = _data_->_tmp35_;
			_data_->_tmp36_ = _data_->co;
			if (_data_->_tmp36_ == NULL) {
				_data_->result = NULL;
				_g_object_unref0 (_data_->co);
				_g_free0 (_data_->valid_cmd);
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->stripped);
				_g_object_unref0 (_data_->_result_);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!_data_->_task_complete_) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp37_ = _data_->_result_;
			_data_->_tmp38_ = _data_->co;
			synapse_result_set_add (_data_->_tmp37_, (SynapseMatch*) _data_->_tmp38_, (gint) SYNAPSE_MATCH_SCORE_POOR);
			_data_->_tmp39_ = _data_->co;
			g_signal_connect_object ((SynapseMatch*) _data_->_tmp39_, "executed", (GCallback) _synapse_command_plugin_command_executed_synapse_match_executed, _data_->self, 0);
			_g_object_unref0 (_data_->co);
		}
		_g_free0 (_data_->valid_cmd);
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
	} else {
		_data_->_tmp40_ = _data_->_result_;
		_data_->_tmp41_ = _data_->stripped;
		_data_->_tmp42_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp41_);
		_data_->_tmp43_ = _data_->_tmp42_;
		synapse_result_set_add (_data_->_tmp40_, (SynapseMatch*) _data_->_tmp43_, (gint) SYNAPSE_MATCH_SCORE_VERY_GOOD);
		_g_object_unref0 (_data_->_tmp43_);
	}
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_free0 (_data_->stripped);
			_g_object_unref0 (_data_->_result_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->stripped);
			_g_object_unref0 (_data_->_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->_result_;
	_g_free0 (_data_->stripped);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


SynapseCommandPlugin*
synapse_command_plugin_construct (GType object_type)
{
	SynapseCommandPlugin * self = NULL;
	self = (SynapseCommandPlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseCommandPlugin*
synapse_command_plugin_new (void)
{
	return synapse_command_plugin_construct (SYNAPSE_TYPE_COMMAND_PLUGIN);
}


static gboolean
synapse_command_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseCommandPlugin* self;
	gboolean _tmp0_;
	self = (SynapseCommandPlugin*) base;
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


static void
synapse_command_plugin_real_set_enabled (SynapseActivatable* base,
                                         gboolean value)
{
	SynapseCommandPlugin* self;
	self = (SynapseCommandPlugin*) base;
	if (synapse_command_plugin_real_get_enabled (base) != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY]);
	}
}


static GObject *
synapse_command_plugin_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommandPlugin * self;
	GeeHashSet* _tmp0_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_command_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->past_commands);
	self->priv->past_commands = (GeeSet*) _tmp0_;
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		_tmp2_ = g_regex_new ("\\s+", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch53_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_regex_unref0 (self->priv->split_regex);
		self->priv->split_regex = _tmp3_;
		_g_regex_unref0 (_tmp1_);
	}
	goto __finally53;
	__catch53_g_regex_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_critical ("command-plugin.vala:101: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally53:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static inline gpointer
synapse_command_plugin_command_object_get_instance_private (SynapseCommandPluginCommandObject* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommandPluginCommandObject_private_offset);
}


static SynapseCommandPluginCommandObject*
synapse_command_plugin_command_object_construct (GType object_type,
                                                 const gchar* cmd)
{
	SynapseCommandPluginCommandObject * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (cmd != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Execute '%s'"), cmd);
	_tmp1_ = _tmp0_;
	self = (SynapseCommandPluginCommandObject*) g_object_new (object_type, "title", _tmp1_, "description", _ ("Run command"), "command", cmd, "icon-name", "application-x-executable", "match-type", SYNAPSE_MATCH_TYPE_APPLICATION, "needs-terminal", g_str_has_prefix (cmd, "sudo "), NULL);
	_g_free0 (_tmp1_);
	{
		GAppInfo* _tmp2_ = NULL;
		GAppInfo* _tmp3_;
		_tmp3_ = g_app_info_create_from_commandline (cmd, NULL, 0, &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch54_g_error;
		}
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, _tmp2_);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally54;
	__catch54_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_warning ("command-plugin.vala:67: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally54:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static SynapseCommandPluginCommandObject*
synapse_command_plugin_command_object_new (const gchar* cmd)
{
	return synapse_command_plugin_command_object_construct (SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, cmd);
}


static const gchar*
synapse_command_plugin_command_object_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	const gchar* _tmp0_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


static void
synapse_command_plugin_command_object_real_set_title (SynapseMatch* base,
                                                      const gchar* value)
{
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	if (g_strcmp0 (value, synapse_command_plugin_command_object_real_get_title (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE_PROPERTY]);
	}
}


static const gchar*
synapse_command_plugin_command_object_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	const gchar* _tmp0_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void
synapse_command_plugin_command_object_real_set_description (SynapseMatch* base,
                                                            const gchar* value)
{
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	if (g_strcmp0 (value, synapse_command_plugin_command_object_real_get_description (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION_PROPERTY]);
	}
}


static const gchar*
synapse_command_plugin_command_object_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	const gchar* _tmp0_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}


static void
synapse_command_plugin_command_object_real_set_icon_name (SynapseMatch* base,
                                                          const gchar* value)
{
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	if (g_strcmp0 (value, synapse_command_plugin_command_object_real_get_icon_name (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME_PROPERTY]);
	}
}


static gboolean
synapse_command_plugin_command_object_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseCommandPluginCommandObject* self;
	gboolean _tmp0_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = self->priv->_has_thumbnail;
	result = _tmp0_;
	return result;
}


static void
synapse_command_plugin_command_object_real_set_has_thumbnail (SynapseMatch* base,
                                                              gboolean value)
{
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	if (synapse_command_plugin_command_object_real_get_has_thumbnail (base) != value) {
		self->priv->_has_thumbnail = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL_PROPERTY]);
	}
}


static const gchar*
synapse_command_plugin_command_object_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	const gchar* _tmp0_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = self->priv->_thumbnail_path;
	result = _tmp0_;
	return result;
}


static void
synapse_command_plugin_command_object_real_set_thumbnail_path (SynapseMatch* base,
                                                               const gchar* value)
{
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	if (g_strcmp0 (value, synapse_command_plugin_command_object_real_get_thumbnail_path (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_thumbnail_path);
		self->priv->_thumbnail_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH_PROPERTY]);
	}
}


static SynapseMatchType
synapse_command_plugin_command_object_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseCommandPluginCommandObject* self;
	SynapseMatchType _tmp0_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = self->priv->_match_type;
	result = _tmp0_;
	return result;
}


static void
synapse_command_plugin_command_object_real_set_match_type (SynapseMatch* base,
                                                           SynapseMatchType value)
{
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	if (synapse_command_plugin_command_object_real_get_match_type (base) != value) {
		self->priv->_match_type = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE_PROPERTY]);
	}
}


static GAppInfo*
synapse_command_plugin_command_object_real_get_app_info (SynapseApplicationMatch* base)
{
	GAppInfo* result;
	SynapseCommandPluginCommandObject* self;
	GAppInfo* _tmp0_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}


static void
synapse_command_plugin_command_object_real_set_app_info (SynapseApplicationMatch* base,
                                                         GAppInfo* value)
{
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	if (synapse_command_plugin_command_object_real_get_app_info (base) != value) {
		GAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY]);
	}
}


static gboolean
synapse_command_plugin_command_object_real_get_needs_terminal (SynapseApplicationMatch* base)
{
	gboolean result;
	SynapseCommandPluginCommandObject* self;
	gboolean _tmp0_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = self->priv->_needs_terminal;
	result = _tmp0_;
	return result;
}


static void
synapse_command_plugin_command_object_real_set_needs_terminal (SynapseApplicationMatch* base,
                                                               gboolean value)
{
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	if (synapse_command_plugin_command_object_real_get_needs_terminal (base) != value) {
		self->priv->_needs_terminal = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY]);
	}
}


static const gchar*
synapse_command_plugin_command_object_real_get_filename (SynapseApplicationMatch* base)
{
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	const gchar* _tmp0_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}


static void
synapse_command_plugin_command_object_real_set_filename (SynapseApplicationMatch* base,
                                                         const gchar* value)
{
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	if (g_strcmp0 (value, synapse_command_plugin_command_object_real_get_filename (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY]);
	}
}


static const gchar*
synapse_command_plugin_command_object_get_command (SynapseCommandPluginCommandObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_command;
	result = _tmp0_;
	return result;
}


static void
synapse_command_plugin_command_object_set_command (SynapseCommandPluginCommandObject* self,
                                                   const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, synapse_command_plugin_command_object_get_command (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_command);
		self->priv->_command = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY]);
	}
}


static void
synapse_command_plugin_command_object_class_init (SynapseCommandPluginCommandObjectClass * klass)
{
	synapse_command_plugin_command_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseCommandPluginCommandObject_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_command_plugin_command_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_command_plugin_command_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_command_plugin_command_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY] = g_param_spec_string ("command", "command", "command", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void
synapse_command_plugin_command_object_synapse_match_interface_init (SynapseMatchIface * iface)
{
	synapse_command_plugin_command_object_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_command_plugin_command_object_real_get_title;
	iface->set_title = synapse_command_plugin_command_object_real_set_title;
	iface->get_description = synapse_command_plugin_command_object_real_get_description;
	iface->set_description = synapse_command_plugin_command_object_real_set_description;
	iface->get_icon_name = synapse_command_plugin_command_object_real_get_icon_name;
	iface->set_icon_name = synapse_command_plugin_command_object_real_set_icon_name;
	iface->get_has_thumbnail = synapse_command_plugin_command_object_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_command_plugin_command_object_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_command_plugin_command_object_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_command_plugin_command_object_real_set_thumbnail_path;
	iface->get_match_type = synapse_command_plugin_command_object_real_get_match_type;
	iface->set_match_type = synapse_command_plugin_command_object_real_set_match_type;
}


static void
synapse_command_plugin_command_object_synapse_application_match_interface_init (SynapseApplicationMatchIface * iface)
{
	synapse_command_plugin_command_object_synapse_application_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_app_info = synapse_command_plugin_command_object_real_get_app_info;
	iface->set_app_info = synapse_command_plugin_command_object_real_set_app_info;
	iface->get_needs_terminal = synapse_command_plugin_command_object_real_get_needs_terminal;
	iface->set_needs_terminal = synapse_command_plugin_command_object_real_set_needs_terminal;
	iface->get_filename = synapse_command_plugin_command_object_real_get_filename;
	iface->set_filename = synapse_command_plugin_command_object_real_set_filename;
}


static void
synapse_command_plugin_command_object_instance_init (SynapseCommandPluginCommandObject * self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = synapse_command_plugin_command_object_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_has_thumbnail = FALSE;
	self->priv->_app_info = NULL;
	self->priv->_needs_terminal = FALSE;
	self->priv->_filename = NULL;
}


static void
synapse_command_plugin_command_object_finalize (GObject * obj)
{
	SynapseCommandPluginCommandObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_command);
	G_OBJECT_CLASS (synapse_command_plugin_command_object_parent_class)->finalize (obj);
}


static GType
synapse_command_plugin_command_object_get_type (void)
{
	static volatile gsize synapse_command_plugin_command_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_command_plugin_command_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommandPluginCommandObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_command_plugin_command_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommandPluginCommandObject), 0, (GInstanceInitFunc) synapse_command_plugin_command_object_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_command_plugin_command_object_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_application_match_info = { (GInterfaceInitFunc) synapse_command_plugin_command_object_synapse_application_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_command_plugin_command_object_type_id;
		synapse_command_plugin_command_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommandPluginCommandObject", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_command_plugin_command_object_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_command_plugin_command_object_type_id, SYNAPSE_TYPE_APPLICATION_MATCH, &synapse_application_match_info);
		SynapseCommandPluginCommandObject_private_offset = g_type_add_instance_private (synapse_command_plugin_command_object_type_id, sizeof (SynapseCommandPluginCommandObjectPrivate));
		g_once_init_leave (&synapse_command_plugin_command_object_type_id__volatile, synapse_command_plugin_command_object_type_id);
	}
	return synapse_command_plugin_command_object_type_id__volatile;
}


static void
_vala_synapse_command_plugin_command_object_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	SynapseCommandPluginCommandObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
	switch (property_id) {
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE_PROPERTY:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION_PROPERTY:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME_PROPERTY:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL_PROPERTY:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH_PROPERTY:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE_PROPERTY:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY:
		g_value_set_object (value, synapse_application_match_get_app_info ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY:
		g_value_set_boolean (value, synapse_application_match_get_needs_terminal ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY:
		g_value_set_string (value, synapse_application_match_get_filename ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY:
		g_value_set_string (value, synapse_command_plugin_command_object_get_command (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_synapse_command_plugin_command_object_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	SynapseCommandPluginCommandObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
	switch (property_id) {
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE_PROPERTY:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION_PROPERTY:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME_PROPERTY:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL_PROPERTY:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH_PROPERTY:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE_PROPERTY:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY:
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, g_value_get_object (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY:
		synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY:
		synapse_application_match_set_filename ((SynapseApplicationMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY:
		synapse_command_plugin_command_object_set_command (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
synapse_command_plugin_class_init (SynapseCommandPluginClass * klass)
{
	synapse_command_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseCommandPlugin_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_command_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_command_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_command_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_command_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY, synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	synapse_command_plugin_register_plugin ();
}


static void
synapse_command_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface)
{
	synapse_command_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (SynapseActivatable*)) synapse_command_plugin_real_activate;
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_command_plugin_real_deactivate;
	iface->get_enabled = synapse_command_plugin_real_get_enabled;
	iface->set_enabled = synapse_command_plugin_real_set_enabled;
}


static void
synapse_command_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface)
{
	synapse_command_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_command_plugin_real_search;
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_command_plugin_real_search_finish;
}


static void
synapse_command_plugin_instance_init (SynapseCommandPlugin * self)
{
	self->priv = synapse_command_plugin_get_instance_private (self);
	self->priv->_enabled = TRUE;
}


static void
synapse_command_plugin_finalize (GObject * obj)
{
	SynapseCommandPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
	_g_object_unref0 (self->priv->past_commands);
	_g_regex_unref0 (self->priv->split_regex);
	G_OBJECT_CLASS (synapse_command_plugin_parent_class)->finalize (obj);
}


GType
synapse_command_plugin_get_type (void)
{
	static volatile gsize synapse_command_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_command_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommandPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_command_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommandPlugin), 0, (GInstanceInitFunc) synapse_command_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_command_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_command_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_command_plugin_type_id;
		synapse_command_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommandPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_command_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_command_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
		SynapseCommandPlugin_private_offset = g_type_add_instance_private (synapse_command_plugin_type_id, sizeof (SynapseCommandPluginPrivate));
		g_once_init_leave (&synapse_command_plugin_type_id__volatile, synapse_command_plugin_type_id);
	}
	return synapse_command_plugin_type_id__volatile;
}


static void
_vala_synapse_command_plugin_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommandPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
	switch (property_id) {
		case SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_synapse_command_plugin_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommandPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
	switch (property_id) {
		case SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



