import os

class Report():

    def __init__(self, environment):
        self.environment = environment

    def is_pertinent(self):
        # Defines whether this report should show up
        if os.path.exists("/usr/share/applications/pearl-meta-codecs.desktop"):
            return True
        else:
            return False

    def parse_content(self, content):
        codecs = "pearl-meta-codecs"
        if self.environment.is_lmde:
            codecs = "pearl-meta-debian-codecs"
        elif self.environment.desktop == "KDE":
            codecs = "pearl-meta-codecs-kde"
        content = content.replace("$codecs", codecs)
        return content